/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class FileTreeTraverserTest
extends TestCase {
    private File dir;

    public void setUp() throws IOException {
        this.dir = Files.createTempDir();
    }

    public void tearDown() throws IOException {
        File[] files = this.dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
        this.dir.delete();
    }

    public void testFileTreeViewer_emptyDir() throws IOException {
        this.assertDirChildren(new File[0]);
    }

    public void testFileTreeViewer_singleFile() throws IOException {
        File file = this.newFile("test");
        this.assertDirChildren(file);
    }

    public void testFileTreeViewer_singleDir() throws IOException {
        File file = this.newDir("test");
        this.assertDirChildren(file);
    }

    public void testFileTreeViewer_multipleFiles() throws IOException {
        File a = this.newFile("a");
        File b = this.newDir("b");
        File c = this.newFile("c");
        File d = this.newDir("d");
        this.assertDirChildren(a, b, c, d);
    }

    private File newDir(String name) throws IOException {
        File file = new File(this.dir, name);
        file.mkdir();
        return file;
    }

    private File newFile(String name) throws IOException {
        File file = new File(this.dir, name);
        file.createNewFile();
        return file;
    }

    private void assertDirChildren(File ... files) {
        FileTreeTraverserTest.assertEquals((Object)ImmutableSet.copyOf((Object[])files), (Object)ImmutableSet.copyOf((Iterable)Files.fileTreeTraverser().children((Object)this.dir)));
    }
}

