/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.TestByteSource;
import com.google.common.io.TestOption;
import com.google.common.io.TestStreamSupplier;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class TestCharSource
extends CharSource
implements TestStreamSupplier {
    private final TestByteSource byteSource;

    public TestCharSource(String content, TestOption ... options) {
        this.byteSource = new TestByteSource(content.getBytes(Charsets.UTF_8), options);
    }

    @Override
    public boolean wasStreamOpened() {
        return this.byteSource.wasStreamOpened();
    }

    @Override
    public boolean wasStreamClosed() {
        return this.byteSource.wasStreamClosed();
    }

    public Reader openStream() throws IOException {
        return new InputStreamReader(this.byteSource.openStream(), Charsets.UTF_8);
    }
}

