/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.common.math.MathBenchmarking;

public class ApacheBenchmark {
    private final int[] factorials = new int[65536];
    private final int[][] binomials = new int[65536][2];
    private final int[][] nonnegInt = new int[65536][2];
    private final long[][] nonnegLong = new long[65536][2];
    private final int[][] intsToAdd = new int[65536][2];
    private final int[][] intsToMul = new int[65536][2];
    private final long[][] longsToAdd = new long[65536][2];
    private final long[][] longsToMul = new long[65536][2];
    @Param(value={"APACHE", "GUAVA"})
    Impl impl;

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            int j;
            this.factorials[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(200);
            for (j = 0; j < 2; ++j) {
                this.nonnegInt[i][j] = MathBenchmarking.randomNonNegativeBigInteger(30).intValue();
                this.nonnegLong[i][j] = MathBenchmarking.randomNonNegativeBigInteger(62).longValue();
            }
            do {
                for (j = 0; j < 2; ++j) {
                    this.intsToAdd[i][j] = MathBenchmarking.randomBigInteger(30).intValue();
                }
            } while (!Impl.GUAVA.noAddOverflow(this.intsToAdd[i][0], this.intsToAdd[i][1]));
            do {
                for (j = 0; j < 2; ++j) {
                    this.longsToAdd[i][j] = MathBenchmarking.randomBigInteger(62).longValue();
                }
            } while (!Impl.GUAVA.noAddOverflow(this.longsToAdd[i][0], this.longsToAdd[i][1]));
            do {
                for (j = 0; j < 2; ++j) {
                    this.intsToMul[i][j] = MathBenchmarking.randomBigInteger(30).intValue();
                }
            } while (!Impl.GUAVA.noMulOverflow(this.intsToMul[i][0], this.intsToMul[i][1]));
            do {
                for (j = 0; j < 2; ++j) {
                    this.longsToMul[i][j] = MathBenchmarking.randomBigInteger(62).longValue();
                }
            } while (!Impl.GUAVA.noMulOverflow(this.longsToMul[i][0], this.longsToMul[i][1]));
            int n = MathBenchmarking.RANDOM_SOURCE.nextInt(MathBenchmarking.biggestBinomials.length);
            this.binomials[i][1] = n;
            int k = n;
            this.binomials[i][0] = MathBenchmarking.RANDOM_SOURCE.nextInt(MathBenchmarking.biggestBinomials[k] - k) + k;
        }
    }

    @Benchmark
    long factorialDouble(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += Double.doubleToRawLongBits(this.impl.factorialDouble(this.factorials[j]));
        }
        return tmp;
    }

    @Benchmark
    int intGCD(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += this.impl.gcdInt(this.nonnegInt[j][0], this.nonnegInt[j][1]);
        }
        return tmp;
    }

    @Benchmark
    long longGCD(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += this.impl.gcdLong(this.nonnegLong[j][0], this.nonnegLong[j][1]);
        }
        return tmp;
    }

    @Benchmark
    long binomialCoefficient(int reps) {
        long tmp = 0L;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += this.impl.binomialCoefficient(this.binomials[j][0], this.binomials[j][1]);
        }
        return tmp;
    }

    @Benchmark
    int intAddOverflow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!this.impl.noAddOverflow(this.intsToAdd[j][0], this.intsToAdd[j][1])) continue;
            ++tmp;
        }
        return tmp;
    }

    @Benchmark
    int longAddOverflow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!this.impl.noAddOverflow(this.longsToAdd[j][0], this.longsToAdd[j][1])) continue;
            ++tmp;
        }
        return tmp;
    }

    @Benchmark
    int intMulOverflow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!this.impl.noMulOverflow(this.intsToMul[j][0], this.intsToMul[j][1])) continue;
            ++tmp;
        }
        return tmp;
    }

    @Benchmark
    int longMulOverflow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!this.impl.noMulOverflow(this.longsToMul[j][0], this.longsToMul[j][1])) continue;
            ++tmp;
        }
        return tmp;
    }

    private static enum Impl {
        GUAVA{

            @Override
            public double factorialDouble(int n) {
                return DoubleMath.factorial((int)n);
            }

            @Override
            public int gcdInt(int a, int b) {
                return IntMath.gcd((int)a, (int)b);
            }

            @Override
            public long gcdLong(long a, long b) {
                return LongMath.gcd((long)a, (long)b);
            }

            @Override
            public long binomialCoefficient(int n, int k) {
                return LongMath.binomial((int)n, (int)k);
            }

            @Override
            public boolean noAddOverflow(int a, int b) {
                try {
                    int unused = IntMath.checkedAdd((int)a, (int)b);
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }

            @Override
            public boolean noAddOverflow(long a, long b) {
                try {
                    long unused = LongMath.checkedAdd((long)a, (long)b);
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }

            @Override
            public boolean noMulOverflow(int a, int b) {
                try {
                    int unused = IntMath.checkedMultiply((int)a, (int)b);
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }

            @Override
            public boolean noMulOverflow(long a, long b) {
                try {
                    long unused = LongMath.checkedMultiply((long)a, (long)b);
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
        };


        public abstract double factorialDouble(int var1);

        public abstract long binomialCoefficient(int var1, int var2);

        public abstract int gcdInt(int var1, int var2);

        public abstract long gcdLong(long var1, long var3);

        public abstract boolean noAddOverflow(int var1, int var2);

        public abstract boolean noAddOverflow(long var1, long var3);

        public abstract boolean noMulOverflow(int var1, int var2);

        public abstract boolean noMulOverflow(long var1, long var3);
    }
}

