/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.math.AndroidIncompatible;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.MathTesting;
import com.google.common.testing.NullPointerTester;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class BigIntegerMathTest
extends TestCase {
    private static final BigInteger BAD_FOR_ANDROID_P = new BigInteger("-9223372036854775808");
    private static final BigInteger BAD_FOR_ANDROID_Q = new BigInteger("-1");
    private static final BigInteger BAD_FOR_GINGERBREAD_P = new BigInteger("-9223372036854775808");
    private static final BigInteger BAD_FOR_GINGERBREAD_Q = new BigInteger("-4294967296");

    public void testCeilingPowerOfTwo() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger result = BigIntegerMath.ceilingPowerOfTwo((BigInteger)x);
            BigIntegerMathTest.assertTrue((boolean)BigIntegerMath.isPowerOfTwo((BigInteger)result));
            BigIntegerMathTest.assertTrue((result.compareTo(x) >= 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result.compareTo(x.add(x)) < 0 ? 1 : 0) != 0);
        }
    }

    public void testFloorPowerOfTwo() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger result = BigIntegerMath.floorPowerOfTwo((BigInteger)x);
            BigIntegerMathTest.assertTrue((boolean)BigIntegerMath.isPowerOfTwo((BigInteger)result));
            BigIntegerMathTest.assertTrue((result.compareTo(x) <= 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result.add(result).compareTo(x) > 0 ? 1 : 0) != 0);
        }
    }

    public void testCeilingPowerOfTwoNegative() {
        for (BigInteger x : MathTesting.NEGATIVE_BIGINTEGER_CANDIDATES) {
            try {
                BigIntegerMath.ceilingPowerOfTwo((BigInteger)x);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testFloorPowerOfTwoNegative() {
        for (BigInteger x : MathTesting.NEGATIVE_BIGINTEGER_CANDIDATES) {
            try {
                BigIntegerMath.floorPowerOfTwo((BigInteger)x);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testCeilingPowerOfTwoZero() {
        try {
            BigIntegerMath.ceilingPowerOfTwo((BigInteger)BigInteger.ZERO);
            BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFloorPowerOfTwoZero() {
        try {
            BigIntegerMath.floorPowerOfTwo((BigInteger)BigInteger.ZERO);
            BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConstantSqrt2PrecomputedBits() {
        BigIntegerMathTest.assertEquals((Object)BigIntegerMath.sqrt((BigInteger)BigInteger.ZERO.setBit(513), (RoundingMode)RoundingMode.FLOOR), (Object)BigIntegerMath.SQRT2_PRECOMPUTED_BITS);
    }

    public void testIsPowerOfTwo() {
        for (BigInteger x : MathTesting.ALL_BIGINTEGER_CANDIDATES) {
            boolean expected = x.signum() > 0 & x.and(x.subtract(BigInteger.ONE)).equals(BigInteger.ZERO);
            BigIntegerMathTest.assertEquals((boolean)expected, (boolean)BigIntegerMath.isPowerOfTwo((BigInteger)x));
        }
    }

    public void testLog2ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                BigIntegerMath.log2((BigInteger)BigInteger.ZERO, (RoundingMode)mode);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testLog2NegativeAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                BigIntegerMath.log2((BigInteger)BigInteger.valueOf(-1L), (RoundingMode)mode);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testLog2Floor() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.FLOOR, RoundingMode.DOWN)) {
                int result = BigIntegerMath.log2((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((BigInteger.ZERO.setBit(result).compareTo(x) <= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((BigInteger.ZERO.setBit(result + 1).compareTo(x) > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testLog2Ceiling() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.CEILING, RoundingMode.UP)) {
                int result = BigIntegerMath.log2((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((BigInteger.ZERO.setBit(result).compareTo(x) >= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result == 0 || BigInteger.ZERO.setBit(result - 1).compareTo(x) < 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testLog2Exact() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            boolean isPowerOf2 = BigIntegerMath.isPowerOfTwo((BigInteger)x);
            try {
                BigIntegerMathTest.assertEquals((Object)x, (Object)BigInteger.ZERO.setBit(BigIntegerMath.log2((BigInteger)x, (RoundingMode)RoundingMode.UNNECESSARY)));
                BigIntegerMathTest.assertTrue((boolean)isPowerOf2);
            }
            catch (ArithmeticException e) {
                BigIntegerMathTest.assertFalse((boolean)isPowerOf2);
            }
        }
    }

    public void testLog2HalfUp() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int result = BigIntegerMath.log2((BigInteger)x, (RoundingMode)RoundingMode.HALF_UP);
            BigInteger x2 = x.pow(2);
            BigIntegerMathTest.assertTrue((BigInteger.ZERO.setBit(2 * result + 1).compareTo(x2) > 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result == 0 || BigInteger.ZERO.setBit(2 * result - 1).compareTo(x2) <= 0 ? 1 : 0) != 0);
        }
    }

    public void testLog2HalfDown() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int result = BigIntegerMath.log2((BigInteger)x, (RoundingMode)RoundingMode.HALF_DOWN);
            BigInteger x2 = x.pow(2);
            BigIntegerMathTest.assertTrue((BigInteger.ZERO.setBit(2 * result + 1).compareTo(x2) >= 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result == 0 || BigInteger.ZERO.setBit(2 * result - 1).compareTo(x2) < 0 ? 1 : 0) != 0);
        }
    }

    public void testLog2HalfEven() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int halfEven = BigIntegerMath.log2((BigInteger)x, (RoundingMode)RoundingMode.HALF_EVEN);
            boolean floorWasEven = (BigIntegerMath.log2((BigInteger)x, (RoundingMode)RoundingMode.FLOOR) & 1) == 0;
            BigIntegerMathTest.assertEquals((int)BigIntegerMath.log2((BigInteger)x, (RoundingMode)(floorWasEven ? RoundingMode.HALF_DOWN : RoundingMode.HALF_UP)), (int)halfEven);
        }
    }

    @GwtIncompatible
    public void testLog10ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                BigIntegerMath.log10((BigInteger)BigInteger.ZERO, (RoundingMode)mode);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testLog10NegativeAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                BigIntegerMath.log10((BigInteger)BigInteger.valueOf(-1L), (RoundingMode)mode);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testLog10Floor() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.FLOOR, RoundingMode.DOWN)) {
                int result = BigIntegerMath.log10((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((BigInteger.TEN.pow(result).compareTo(x) <= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((BigInteger.TEN.pow(result + 1).compareTo(x) > 0 ? 1 : 0) != 0);
            }
        }
    }

    @GwtIncompatible
    public void testLog10Ceiling() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.CEILING, RoundingMode.UP)) {
                int result = BigIntegerMath.log10((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((BigInteger.TEN.pow(result).compareTo(x) >= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result == 0 || BigInteger.TEN.pow(result - 1).compareTo(x) < 0 ? 1 : 0) != 0);
            }
        }
    }

    @GwtIncompatible
    public void testLog10Exact() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int logFloor = BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.FLOOR);
            boolean expectSuccess = BigInteger.TEN.pow(logFloor).equals(x);
            try {
                BigIntegerMathTest.assertEquals((int)logFloor, (int)BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.UNNECESSARY));
                BigIntegerMathTest.assertTrue((boolean)expectSuccess);
            }
            catch (ArithmeticException e) {
                BigIntegerMathTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    @GwtIncompatible
    public void testLog10HalfUp() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int result = BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.HALF_UP);
            BigInteger x2 = x.pow(2);
            BigIntegerMathTest.assertTrue((BigInteger.TEN.pow(2 * result + 1).compareTo(x2) > 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result == 0 || BigInteger.TEN.pow(2 * result - 1).compareTo(x2) <= 0 ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testLog10HalfDown() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int result = BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.HALF_DOWN);
            BigInteger x2 = x.pow(2);
            BigIntegerMathTest.assertTrue((BigInteger.TEN.pow(2 * result + 1).compareTo(x2) >= 0 ? 1 : 0) != 0);
            BigIntegerMathTest.assertTrue((result == 0 || BigInteger.TEN.pow(2 * result - 1).compareTo(x2) < 0 ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testLog10HalfEven() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            int halfEven = BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.HALF_EVEN);
            boolean floorWasEven = (BigIntegerMath.log10((BigInteger)x, (RoundingMode)RoundingMode.FLOOR) & 1) == 0;
            BigIntegerMathTest.assertEquals((int)BigIntegerMath.log10((BigInteger)x, (RoundingMode)(floorWasEven ? RoundingMode.HALF_DOWN : RoundingMode.HALF_UP)), (int)halfEven);
        }
    }

    @GwtIncompatible
    public void testLog10TrivialOnPowerOf10() {
        BigInteger x = BigInteger.TEN.pow(100);
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            BigIntegerMathTest.assertEquals((int)100, (int)BigIntegerMath.log10((BigInteger)x, (RoundingMode)mode));
        }
    }

    @GwtIncompatible
    public void testSqrtZeroAlwaysZero() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            BigIntegerMathTest.assertEquals((Object)BigInteger.ZERO, (Object)BigIntegerMath.sqrt((BigInteger)BigInteger.ZERO, (RoundingMode)mode));
        }
    }

    @GwtIncompatible
    public void testSqrtNegativeAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(-1L), (RoundingMode)mode);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testSqrtFloor() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.FLOOR, RoundingMode.DOWN)) {
                BigInteger result = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((result.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result.pow(2).compareTo(x) <= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result.add(BigInteger.ONE).pow(2).compareTo(x) > 0 ? 1 : 0) != 0);
            }
        }
    }

    @GwtIncompatible
    public void testSqrtCeiling() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.CEILING, RoundingMode.UP)) {
                BigInteger result = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)mode);
                BigIntegerMathTest.assertTrue((result.compareTo(BigInteger.ZERO) > 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result.pow(2).compareTo(x) >= 0 ? 1 : 0) != 0);
                BigIntegerMathTest.assertTrue((result.signum() == 0 || result.subtract(BigInteger.ONE).pow(2).compareTo(x) < 0 ? 1 : 0) != 0);
            }
        }
    }

    @GwtIncompatible
    public void testSqrtExact() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger floor = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.FLOOR);
            boolean isPerfectSquare = floor.pow(2).equals(x);
            try {
                BigIntegerMathTest.assertEquals((Object)floor, (Object)BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.UNNECESSARY));
                BigIntegerMathTest.assertTrue((boolean)isPerfectSquare);
            }
            catch (ArithmeticException e) {
                BigIntegerMathTest.assertFalse((boolean)isPerfectSquare);
            }
        }
    }

    @GwtIncompatible
    public void testSqrtHalfUp() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger result = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.HALF_UP);
            BigInteger plusHalfSquared = result.pow(2).add(result).shiftLeft(2).add(BigInteger.ONE);
            BigInteger x4 = x.shiftLeft(2);
            BigIntegerMathTest.assertTrue((x4.compareTo(plusHalfSquared) < 0 ? 1 : 0) != 0);
            BigInteger minusHalfSquared = result.pow(2).subtract(result).shiftLeft(2).add(BigInteger.ONE);
            BigIntegerMathTest.assertTrue((result.equals(BigInteger.ZERO) || x4.compareTo(minusHalfSquared) >= 0 ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testSqrtHalfDown() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger result = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.HALF_DOWN);
            BigInteger plusHalfSquared = result.pow(2).add(result).shiftLeft(2).add(BigInteger.ONE);
            BigInteger x4 = x.shiftLeft(2);
            BigIntegerMathTest.assertTrue((x4.compareTo(plusHalfSquared) <= 0 ? 1 : 0) != 0);
            BigInteger minusHalfSquared = result.pow(2).subtract(result).shiftLeft(2).add(BigInteger.ONE);
            BigIntegerMathTest.assertTrue((result.equals(BigInteger.ZERO) || x4.compareTo(minusHalfSquared) > 0 ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testSqrtHalfEven() {
        for (BigInteger x : MathTesting.POSITIVE_BIGINTEGER_CANDIDATES) {
            BigInteger halfEven = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.HALF_EVEN);
            boolean floorWasOdd = BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)RoundingMode.FLOOR).testBit(0);
            BigIntegerMathTest.assertEquals((Object)BigIntegerMath.sqrt((BigInteger)x, (RoundingMode)(floorWasOdd ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN)), (Object)halfEven);
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testDivNonZero() {
        for (BigInteger p : MathTesting.NONZERO_BIGINTEGER_CANDIDATES) {
            for (BigInteger q : MathTesting.NONZERO_BIGINTEGER_CANDIDATES) {
                for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                    BigInteger expected = new BigDecimal(p).divide(new BigDecimal(q), 0, mode).toBigIntegerExact();
                    BigIntegerMathTest.assertEquals((Object)expected, (Object)BigIntegerMath.divide((BigInteger)p, (BigInteger)q, (RoundingMode)mode));
                }
            }
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testDivNonZeroExact() {
        boolean isAndroid = System.getProperties().getProperty("java.runtime.name").contains("Android");
        for (BigInteger p : MathTesting.NONZERO_BIGINTEGER_CANDIDATES) {
            for (BigInteger q : MathTesting.NONZERO_BIGINTEGER_CANDIDATES) {
                if (isAndroid && p.equals(BAD_FOR_ANDROID_P) && q.equals(BAD_FOR_ANDROID_Q) || isAndroid && p.equals(BAD_FOR_GINGERBREAD_P) && q.equals(BAD_FOR_GINGERBREAD_Q)) continue;
                boolean dividesEvenly = p.remainder(q).equals(BigInteger.ZERO);
                try {
                    BigInteger quotient = BigIntegerMath.divide((BigInteger)p, (BigInteger)q, (RoundingMode)RoundingMode.UNNECESSARY);
                    BigInteger undone = quotient.multiply(q);
                    if (!p.equals(undone)) {
                        BigIntegerMathTest.failFormat("expected %s.multiply(%s) = %s; got %s", quotient, q, p, undone);
                    }
                    BigIntegerMathTest.assertTrue((boolean)dividesEvenly);
                }
                catch (ArithmeticException e) {
                    BigIntegerMathTest.assertFalse((boolean)dividesEvenly);
                }
            }
        }
    }

    @GwtIncompatible
    public void testZeroDivIsAlwaysZero() {
        for (BigInteger q : MathTesting.NONZERO_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                BigIntegerMathTest.assertEquals((Object)BigInteger.ZERO, (Object)BigIntegerMath.divide((BigInteger)BigInteger.ZERO, (BigInteger)q, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testDivByZeroAlwaysFails() {
        for (BigInteger p : MathTesting.ALL_BIGINTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    BigIntegerMath.divide((BigInteger)p, (BigInteger)BigInteger.ZERO, (RoundingMode)mode);
                    BigIntegerMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException expected) {}
            }
        }
    }

    public void testFactorial() {
        BigInteger expected = BigInteger.ONE;
        for (int i = 1; i <= 200; ++i) {
            expected = expected.multiply(BigInteger.valueOf(i));
            BigIntegerMathTest.assertEquals((Object)expected, (Object)BigIntegerMath.factorial((int)i));
        }
    }

    public void testFactorial0() {
        BigIntegerMathTest.assertEquals((Object)BigInteger.ONE, (Object)BigIntegerMath.factorial((int)0));
    }

    public void testFactorialNegative() {
        try {
            BigIntegerMath.factorial((int)-1);
            BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBinomialSmall() {
        BigIntegerMathTest.runBinomialTest(0, 30);
    }

    @GwtIncompatible
    public void testBinomialLarge() {
        BigIntegerMathTest.runBinomialTest(31, 100);
    }

    private static void runBinomialTest(int firstN, int lastN) {
        for (int n = firstN; n <= lastN; ++n) {
            for (int k = 0; k <= n; ++k) {
                BigInteger expected = BigIntegerMath.factorial((int)n).divide(BigIntegerMath.factorial((int)k)).divide(BigIntegerMath.factorial((int)(n - k)));
                BigIntegerMathTest.assertEquals((Object)expected, (Object)BigIntegerMath.binomial((int)n, (int)k));
            }
        }
    }

    public void testBinomialOutside() {
        for (int n = 0; n <= 50; ++n) {
            try {
                BigIntegerMath.binomial((int)n, (int)-1);
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                BigIntegerMath.binomial((int)n, (int)(n + 1));
                BigIntegerMathTest.fail((String)"Expected IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.setDefault(BigInteger.class, (Object)BigInteger.ONE);
        tester.setDefault(Integer.TYPE, (Object)1);
        tester.setDefault(Long.TYPE, (Object)1L);
        tester.testAllPublicStaticMethods(BigIntegerMath.class);
    }

    @GwtIncompatible
    private static void failFormat(String template, Object ... args) {
        BigIntegerMathTest.fail((String)String.format(template, args));
    }
}

