/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.util.Random;

public class LessThanBenchmark {
    static final int SAMPLE_SIZE = 4096;
    static final int SAMPLE_MASK = 4095;
    @Param(value={"1234"})
    int randomSeed;
    int[] xInts;
    int[] yInts;
    long[] xLongs;
    long[] yLongs;
    int[] constant;
    private static final long NONNEGATIVE_LONG_MASK = Long.MAX_VALUE;

    @BeforeExperiment
    void setUp() {
        Random random = new Random(this.randomSeed);
        this.xInts = new int[4096];
        this.yInts = new int[4096];
        this.xLongs = new long[4096];
        this.yLongs = new long[4096];
        this.constant = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            this.xInts[i] = random.nextInt(Integer.MAX_VALUE);
            this.yInts[i] = random.nextInt(Integer.MAX_VALUE);
            this.xLongs[i] = random.nextLong() & Long.MAX_VALUE;
            this.yLongs[i] = random.nextLong() & Long.MAX_VALUE;
            this.constant[i] = random.nextInt();
        }
    }

    @Benchmark
    int branchFreeLtIntInlined(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            int x = this.xInts[j];
            int y = this.yInts[j];
            int z = this.constant[j];
            tmp += z + (x - y >>> 31);
        }
        return tmp;
    }

    @Benchmark
    int branchFreeLtInt(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            int x = this.xInts[j];
            int y = this.yInts[j];
            int z = this.constant[j];
            tmp += z + IntMath.lessThanBranchFree((int)x, (int)y);
        }
        return tmp;
    }

    @Benchmark
    int ternaryLtIntAddOutsideTernary(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            int x = this.xInts[j];
            int y = this.yInts[j];
            int z = this.constant[j];
            tmp += z + (x < y ? 1 : 0);
        }
        return tmp;
    }

    @Benchmark
    int ternaryLtIntAddInsideTernary(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            int x = this.xInts[j];
            int y = this.yInts[j];
            int z = this.constant[j];
            tmp += x < y ? z + 1 : z;
        }
        return tmp;
    }

    @Benchmark
    int branchFreeLtLongInlined(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            long x = this.xLongs[j];
            long y = this.yLongs[j];
            int z = this.constant[j];
            tmp += z + (int)(x - y >>> 63);
        }
        return tmp;
    }

    @Benchmark
    int branchFreeLtLong(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            long x = this.xLongs[j];
            long y = this.yLongs[j];
            int z = this.constant[j];
            tmp += z + LongMath.lessThanBranchFree((long)x, (long)y);
        }
        return tmp;
    }

    @Benchmark
    int ternaryLtLongAddOutsideTernary(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            long x = this.xLongs[j];
            long y = this.yLongs[j];
            int z = this.constant[j];
            tmp += z + (x < y ? 1 : 0);
        }
        return tmp;
    }

    @Benchmark
    int ternaryLtLongAddInsideTernary(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            long x = this.xLongs[j];
            long y = this.yLongs[j];
            int z = this.constant[j];
            tmp += x < y ? z + 1 : z;
        }
        return tmp;
    }
}

