/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.LongMath;
import com.google.common.math.MathBenchmarking;
import java.math.RoundingMode;

public class LongMathRoundingBenchmark {
    @Param(value={"DOWN", "UP", "FLOOR", "CEILING", "HALF_EVEN", "HALF_UP", "HALF_DOWN"})
    RoundingMode mode;
    private static final long[] positive = new long[65536];
    private static final long[] nonzero = new long[65536];
    private static final long[] longs = new long[65536];

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            LongMathRoundingBenchmark.positive[i] = MathBenchmarking.randomPositiveBigInteger(62).longValue();
            LongMathRoundingBenchmark.nonzero[i] = MathBenchmarking.randomNonZeroBigInteger(62).longValue();
            LongMathRoundingBenchmark.longs[i] = MathBenchmarking.RANDOM_SOURCE.nextLong();
        }
    }

    @Benchmark
    int log2(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += LongMath.log2((long)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int log10(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += LongMath.log10((long)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int sqrt(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.sqrt((long)positive[j], (RoundingMode)this.mode));
        }
        return tmp;
    }

    @Benchmark
    int divide(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.divide((long)longs[j], (long)nonzero[j], (RoundingMode)this.mode));
        }
        return tmp;
    }
}

