/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.math.MathPreconditions;
import java.math.BigInteger;
import junit.framework.TestCase;

@GwtCompatible
public class MathPreconditionsTest
extends TestCase {
    public void testCheckPositive_zeroInt() {
        try {
            MathPreconditions.checkPositive((String)"int", (int)0);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_maxInt() {
        MathPreconditions.checkPositive((String)"int", (int)Integer.MAX_VALUE);
    }

    public void testCheckPositive_minInt() {
        try {
            MathPreconditions.checkPositive((String)"int", (int)Integer.MIN_VALUE);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_positiveInt() {
        MathPreconditions.checkPositive((String)"int", (int)1);
    }

    public void testCheckPositive_negativeInt() {
        try {
            MathPreconditions.checkPositive((String)"int", (int)-1);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_zeroLong() {
        try {
            MathPreconditions.checkPositive((String)"long", (long)0L);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_maxLong() {
        MathPreconditions.checkPositive((String)"long", (long)Long.MAX_VALUE);
    }

    public void testCheckPositive_minLong() {
        try {
            MathPreconditions.checkPositive((String)"long", (long)Long.MIN_VALUE);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_positiveLong() {
        MathPreconditions.checkPositive((String)"long", (int)1);
    }

    public void testCheckPositive_negativeLong() {
        try {
            MathPreconditions.checkPositive((String)"long", (long)-1L);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_zeroBigInteger() {
        try {
            MathPreconditions.checkPositive((String)"BigInteger", (BigInteger)BigInteger.ZERO);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositive_postiveBigInteger() {
        MathPreconditions.checkPositive((String)"BigInteger", (BigInteger)BigInteger.ONE);
    }

    public void testCheckPositive_negativeBigInteger() {
        try {
            MathPreconditions.checkPositive((String)"BigInteger", (BigInteger)BigInteger.ZERO.negate());
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_zeroInt() {
        MathPreconditions.checkNonNegative((String)"int", (int)0);
    }

    public void testCheckNonNegative_maxInt() {
        MathPreconditions.checkNonNegative((String)"int", (int)Integer.MAX_VALUE);
    }

    public void testCheckNonNegative_minInt() {
        try {
            MathPreconditions.checkNonNegative((String)"int", (int)Integer.MIN_VALUE);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_positiveInt() {
        MathPreconditions.checkNonNegative((String)"int", (int)1);
    }

    public void testCheckNonNegative_negativeInt() {
        try {
            MathPreconditions.checkNonNegative((String)"int", (int)-1);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_zeroLong() {
        MathPreconditions.checkNonNegative((String)"long", (long)0L);
    }

    public void testCheckNonNegative_maxLong() {
        MathPreconditions.checkNonNegative((String)"long", (long)Long.MAX_VALUE);
    }

    public void testCheckNonNegative_minLong() {
        try {
            MathPreconditions.checkNonNegative((String)"long", (long)Long.MIN_VALUE);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_positiveLong() {
        MathPreconditions.checkNonNegative((String)"long", (long)1L);
    }

    public void testCheckNonNegative_negativeLong() {
        try {
            MathPreconditions.checkNonNegative((String)"int", (long)-1L);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_zeroBigInteger() {
        MathPreconditions.checkNonNegative((String)"BigInteger", (BigInteger)BigInteger.ZERO);
    }

    public void testCheckNonNegative_positiveBigInteger() {
        MathPreconditions.checkNonNegative((String)"BigInteger", (BigInteger)BigInteger.ONE);
    }

    public void testCheckNonNegative_negativeBigInteger() {
        try {
            MathPreconditions.checkNonNegative((String)"int", (BigInteger)BigInteger.ONE.negate());
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_zeroFloat() {
        MathPreconditions.checkNonNegative((String)"float", (double)0.0);
    }

    public void testCheckNonNegative_maxFloat() {
        MathPreconditions.checkNonNegative((String)"float", (double)3.4028234663852886E38);
    }

    public void testCheckNonNegative_minFloat() {
        MathPreconditions.checkNonNegative((String)"float", (double)1.4E-45f);
    }

    public void testCheckNonNegative_positiveFloat() {
        MathPreconditions.checkNonNegative((String)"float", (double)1.0);
    }

    public void testCheckNonNegative_negativeFloat() {
        try {
            MathPreconditions.checkNonNegative((String)"float", (double)-1.0);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_nanFloat() {
        try {
            MathPreconditions.checkNonNegative((String)"float", (double)Double.NaN);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_zeroDouble() {
        MathPreconditions.checkNonNegative((String)"double", (double)0.0);
    }

    public void testCheckNonNegative_maxDouble() {
        MathPreconditions.checkNonNegative((String)"double", (double)Double.MAX_VALUE);
    }

    public void testCheckNonNegative_minDouble() {
        MathPreconditions.checkNonNegative((String)"double", (double)Double.MIN_VALUE);
    }

    public void testCheckNonNegative_positiveDouble() {
        MathPreconditions.checkNonNegative((String)"double", (double)1.0);
    }

    public void testCheckNonNegative_negativeDouble() {
        try {
            MathPreconditions.checkNonNegative((String)"double", (double)-1.0);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckNonNegative_nanDouble() {
        try {
            MathPreconditions.checkNonNegative((String)"double", (double)Double.NaN);
            MathPreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckRoundingUnnnecessary_success() {
        MathPreconditions.checkRoundingUnnecessary((boolean)true);
    }

    public void testCheckRoundingUnnecessary_failure() {
        try {
            MathPreconditions.checkRoundingUnnecessary((boolean)false);
            MathPreconditionsTest.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testCheckInRange_success() {
        MathPreconditions.checkInRange((boolean)true);
    }

    public void testCheckInRange_failure() {
        try {
            MathPreconditions.checkInRange((boolean)false);
            MathPreconditionsTest.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testCheckNoOverflow_success() {
        MathPreconditions.checkNoOverflow((boolean)true);
    }

    public void testCheckNoOverflow_failure() {
        try {
            MathPreconditions.checkNoOverflow((boolean)false);
            MathPreconditionsTest.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }
}

