/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.math.QuantilesAlgorithm;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;

public class QuantilesAlgorithmTest
extends TestCase {
    private static final Random RNG = new Random(82674067L);
    private static final int DATASET_SIZE = 1000;
    private static final double ALLOWED_ERROR = 1.0E-10;
    private static final QuantilesAlgorithm REFERENCE_ALGORITHM = QuantilesAlgorithm.SORTING;
    private static final Set<QuantilesAlgorithm> NON_REFERENCE_ALGORITHMS = Sets.difference((Set)ImmutableSet.copyOf((Object[])QuantilesAlgorithm.values()), (Set)ImmutableSet.of((Object)((Object)REFERENCE_ALGORITHM)));
    private double[] dataset;

    protected void setUp() {
        this.dataset = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            this.dataset[i] = RNG.nextDouble();
        }
    }

    public void testSingleQuantile_median() {
        double referenceValue = REFERENCE_ALGORITHM.singleQuantile(1, 2, (double[])this.dataset.clone());
        for (QuantilesAlgorithm algorithm : NON_REFERENCE_ALGORITHMS) {
            Truth.assertWithMessage((String)"Mismatch between %s and %s", (Object[])new Object[]{algorithm, REFERENCE_ALGORITHM}).that(Double.valueOf(algorithm.singleQuantile(1, 2, (double[])this.dataset.clone()))).isWithin(1.0E-10).of(referenceValue);
        }
    }

    public void testSingleQuantile_percentile99() {
        double referenceValue = REFERENCE_ALGORITHM.singleQuantile(99, 100, (double[])this.dataset.clone());
        for (QuantilesAlgorithm algorithm : NON_REFERENCE_ALGORITHMS) {
            Truth.assertWithMessage((String)"Mismatch between %s and %s", (Object[])new Object[]{algorithm, REFERENCE_ALGORITHM}).that(Double.valueOf(algorithm.singleQuantile(99, 100, (double[])this.dataset.clone()))).isWithin(1.0E-10).of(referenceValue);
        }
    }

    public void testMultipleQuantile() {
        ImmutableSet indexes = ImmutableSet.of((Object)50, (Object)90, (Object)99);
        Map<Integer, Double> referenceQuantiles = REFERENCE_ALGORITHM.multipleQuantiles((Collection<Integer>)indexes, 100, (double[])this.dataset.clone());
        Truth.assertThat(referenceQuantiles.keySet()).isEqualTo((Object)indexes);
        for (QuantilesAlgorithm algorithm : NON_REFERENCE_ALGORITHMS) {
            Map<Integer, Double> quantiles = algorithm.multipleQuantiles((Collection<Integer>)indexes, 100, (double[])this.dataset.clone());
            Truth.assertWithMessage((String)("Wrong keys from " + (Object)((Object)algorithm))).that(quantiles.keySet()).isEqualTo((Object)indexes);
            Iterator i$ = indexes.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Truth.assertWithMessage((String)"Mismatch between %s and %s at %s", (Object[])new Object[]{algorithm, REFERENCE_ALGORITHM, i}).that(quantiles.get(i)).isWithin(1.0E-10).of(referenceQuantiles.get(i).doubleValue());
            }
        }
    }
}

