/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.math.QuantilesAlgorithm;
import java.util.Collection;
import java.util.Random;

public class QuantilesBenchmark {
    private static final ContiguousSet<Integer> ALL_DECILE_INDEXES = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)), (DiscreteDomain)DiscreteDomain.integers());
    @Param(value={"10", "100", "1000", "10000", "100000"})
    int datasetSize;
    @Param
    QuantilesAlgorithm algorithm;
    private double[][] datasets = new double[256][];

    @BeforeExperiment
    void setUp() {
        Random rng = new Random();
        for (int i = 0; i < 256; ++i) {
            this.datasets[i] = new double[this.datasetSize];
            for (int j = 0; j < this.datasetSize; ++j) {
                this.datasets[i][j] = rng.nextDouble();
            }
        }
    }

    private double[] dataset(int i) {
        return (double[])this.datasets[i & 0xFF].clone();
    }

    @Benchmark
    double median(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.singleQuantile(1, 2, this.dataset(i));
        }
        return dummy;
    }

    @Benchmark
    double percentile90(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.singleQuantile(90, 100, this.dataset(i));
        }
        return dummy;
    }

    @Benchmark
    double percentile99(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.singleQuantile(99, 100, this.dataset(i));
        }
        return dummy;
    }

    @Benchmark
    double percentiles90And99(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.multipleQuantiles((Collection<Integer>)ImmutableSet.of((Object)90, (Object)99), 100, this.dataset(i)).get(90).doubleValue();
        }
        return dummy;
    }

    @Benchmark
    double threePercentiles(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.multipleQuantiles((Collection<Integer>)ImmutableSet.of((Object)90, (Object)95, (Object)99), 100, this.dataset(i)).get(90).doubleValue();
        }
        return dummy;
    }

    @Benchmark
    double allDeciles(int reps) {
        double dummy = 0.0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.algorithm.multipleQuantiles((Collection<Integer>)ALL_DECILE_INDEXES, 10, this.dataset(i)).get(9).doubleValue();
        }
        return dummy;
    }
}

