/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.math.AndroidIncompatible;
import com.google.common.math.IntMath;
import com.google.common.math.Quantiles;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;

public class QuantilesTest
extends TestCase {
    private static final double ALLOWED_ERROR = 1.0E-10;
    private static final ImmutableList<Double> SIXTEEN_SQUARES_DOUBLES = ImmutableList.of((Object)25.0, (Object)100.0, (Object)0.0, (Object)144.0, (Object)9.0, (Object)121.0, (Object)4.0, (Object)225.0, (Object)169.0, (Object)64.0, (Object)49.0, (Object)16.0, (Object[])new Double[]{36.0, 1.0, 81.0, 196.0});
    private static final ImmutableList<Long> SIXTEEN_SQUARES_LONGS = ImmutableList.of((Object)25L, (Object)100L, (Object)0L, (Object)144L, (Object)9L, (Object)121L, (Object)4L, (Object)225L, (Object)169L, (Object)64L, (Object)49L, (Object)16L, (Object[])new Long[]{36L, 1L, 81L, 196L});
    private static final ImmutableList<Integer> SIXTEEN_SQUARES_INTEGERS = ImmutableList.of((Object)25, (Object)100, (Object)0, (Object)144, (Object)9, (Object)121, (Object)4, (Object)225, (Object)169, (Object)64, (Object)49, (Object)16, (Object[])new Integer[]{36, 1, 81, 196});
    private static final double SIXTEEN_SQUARES_MIN = 0.0;
    private static final double SIXTEEN_SQUARES_DECILE_1 = 2.5;
    private static final double SIXTEEN_SQUARES_QUARTILE_1 = 14.25;
    private static final double SIXTEEN_SQUARES_MEDIAN = 56.5;
    private static final double SIXTEEN_SQUARES_QUARTILE_3 = 126.75;
    private static final double SIXTEEN_SQUARES_DECILE_8 = 144.0;
    private static final double SIXTEEN_SQUARES_MAX = 225.0;
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_POSITIVE_INFINITY = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.POSITIVE_INFINITY, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_NEGATIVE_INFINITY = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final ImmutableList<Double> NEGATIVE_INFINITY_AND_FIVE_POSITIVE_INFINITIES = ImmutableList.of((Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY);
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_NAN = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.NaN, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final int PSEUDORANDOM_DATASET_SIZE = 9951;
    private static final ImmutableList<Double> PSEUDORANDOM_DATASET = QuantilesTest.generatePseudorandomDataset();
    private static final ImmutableList<Double> PSEUDORANDOM_DATASET_SORTED = Ordering.natural().immutableSortedCopy(PSEUDORANDOM_DATASET);
    private static final ImmutableList<Double> EMPTY_DATASET = ImmutableList.of();

    public void testMedian_compute_doubleCollection() {
        QuantilesTest.assertQuantile(1, 56.5, Quantiles.median().compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testMedian_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        QuantilesTest.assertQuantile(1, 56.5, Quantiles.median().computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testQuartiles_index_compute_doubleCollection() {
        QuantilesTest.assertQuantile(1, 14.25, Quantiles.quartiles().index(1).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testQuartiles_index_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        QuantilesTest.assertQuantile(1, 14.25, Quantiles.quartiles().index(1).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testQuartiles_indexes_varargs_compute_doubleCollection() {
        ImmutableMap expected = ImmutableMap.of((Object)1, (Object)14.25, (Object)3, (Object)126.75);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.quartiles().indexes(new int[]{1, 3}).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testQuartiles_indexes_varargs_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        ImmutableMap expected = ImmutableMap.of((Object)1, (Object)14.25, (Object)3, (Object)126.75);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.quartiles().indexes(new int[]{1, 3}).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_index_compute_doubleCollection() {
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testScale_index_compute_longCollection() {
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_LONGS));
    }

    public void testScale_index_compute_integerCollection() {
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_INTEGERS));
    }

    public void testScale_index_compute_doubleVarargs() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_index_compute_longVarargs() {
        long[] dataset = Longs.toArray(SIXTEEN_SQUARES_LONGS);
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_LONGS, dataset);
    }

    public void testScale_index_compute_intVarargs() {
        int[] dataset = Ints.toArray(SIXTEEN_SQUARES_INTEGERS);
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_INTEGERS, dataset);
    }

    public void testScale_index_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        QuantilesTest.assertQuantile(1, 2.5, Quantiles.scale((int)10).index(1).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_index_computeInPlace_explicitVarargs() {
        QuantilesTest.assertQuantile(1, 45.6, Quantiles.scale((int)10).index(5).computeInPlace(new double[]{78.9, 12.3, 45.6}));
    }

    public void testScale_indexes_varargs_compute_doubleCollection() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testScale_indexes_varargs_compute_doubleCollection_snapshotsIndexes() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        int[] indexes = new int[]{0, 10, 5, 1, 8, 10};
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(indexes);
        indexes[0] = 3;
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, intermediate.compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testScale_indexes_largeVarargs_compute_doubleCollection() {
        int scale = Integer.MAX_VALUE;
        int otherIndex = 0x2AAAAAAA;
        double otherValue = 24.999999979045242;
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)scale, (Object)225.0, (Object)otherIndex, (Object)otherValue);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)scale).indexes(new int[]{0, scale, otherIndex}).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testScale_indexes_varargs_compute_longCollection() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_LONGS));
    }

    public void testScale_indexes_varargs_compute_integerCollection() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_INTEGERS));
    }

    public void testScale_indexes_varargs_compute_doubleVarargs() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_indexes_varargs_compute_longVarargs() {
        long[] dataset = Longs.toArray(SIXTEEN_SQUARES_LONGS);
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_LONGS, dataset);
    }

    public void testScale_indexes_varargs_compute_intVarargs() {
        int[] dataset = Ints.toArray(SIXTEEN_SQUARES_INTEGERS);
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset));
        QuantilesTest.assertDatasetInOrder(SIXTEEN_SQUARES_INTEGERS, dataset);
    }

    public void testScale_indexes_varargs_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_indexes_varargs_computeInPlace_explicitVarargs() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)12.3, (Object)10, (Object)78.9);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes(new int[]{0, 10}).computeInPlace(new double[]{78.9, 12.3, 45.6}));
    }

    public void testScale_indexes_collection_compute_doubleCollection() {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes((Collection)ImmutableList.of((Object)0, (Object)10, (Object)5, (Object)1, (Object)8, (Object)1)).compute(SIXTEEN_SQUARES_DOUBLES));
    }

    public void testScale_indexes_collection_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)0.0, (Object)10, (Object)225.0, (Object)5, (Object)56.5, (Object)1, (Object)2.5, (Object)8, (Object)144.0);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.scale((int)10).indexes((Collection)ImmutableList.of((Object)0, (Object)10, (Object)5, (Object)1, (Object)8, (Object)1)).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(SIXTEEN_SQUARES_DOUBLES, dataset);
    }

    public void testScale_indexes_varargs_compute_doubleCollection_positiveInfinity() {
        Map actual = Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_POSITIVE_INFINITY);
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)1.0).put((Object)1, (Object)1.5).put((Object)2, (Object)2.0).put((Object)8, (Object)5.0).put((Object)9, (Object)Double.POSITIVE_INFINITY).put((Object)10, (Object)Double.POSITIVE_INFINITY).build();
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, actual);
    }

    public void testScale_index_compute_doubleCollection_positiveInfinity() {
        QuantilesTest.assertQuantile(9, Double.POSITIVE_INFINITY, Quantiles.scale((int)10).index(9).compute(ONE_TO_FIVE_AND_POSITIVE_INFINITY));
    }

    public void testScale_indexes_varargs_compute_doubleCollection_negativeInfinity() {
        Map actual = Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_NEGATIVE_INFINITY);
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)Double.NEGATIVE_INFINITY).put((Object)1, (Object)Double.NEGATIVE_INFINITY).put((Object)2, (Object)1.0).put((Object)8, (Object)4.0).put((Object)9, (Object)4.5).put((Object)10, (Object)5.0).build();
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, actual);
    }

    public void testScale_index_compute_doubleCollection_negativeInfinity() {
        QuantilesTest.assertQuantile(1, Double.NEGATIVE_INFINITY, Quantiles.scale((int)10).index(1).compute(ONE_TO_FIVE_AND_NEGATIVE_INFINITY));
    }

    public void testScale_indexes_varargs_compute_doubleCollection_bothInfinities() {
        Map actual = Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(NEGATIVE_INFINITY_AND_FIVE_POSITIVE_INFINITIES);
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)Double.NEGATIVE_INFINITY).put((Object)1, (Object)Double.NaN).put((Object)2, (Object)Double.POSITIVE_INFINITY).put((Object)8, (Object)Double.POSITIVE_INFINITY).put((Object)9, (Object)Double.POSITIVE_INFINITY).put((Object)10, (Object)Double.POSITIVE_INFINITY).build();
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, actual);
    }

    public void testScale_indexes_varargs_compute_doubleCollection_nan() {
        Map actual = Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_NAN);
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)Double.NaN).put((Object)1, (Object)Double.NaN).put((Object)2, (Object)Double.NaN).put((Object)8, (Object)Double.NaN).put((Object)9, (Object)Double.NaN).put((Object)10, (Object)Double.NaN).build();
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, actual);
    }

    public void testScale_index_compute_doubleCollection_nan() {
        QuantilesTest.assertQuantile(5, Double.NaN, Quantiles.scale((int)10).index(5).compute(ONE_TO_FIVE_AND_NAN));
    }

    private static ImmutableList<Double> generatePseudorandomDataset() {
        Random random = new Random(2211275185798966364L);
        ImmutableList.Builder largeDatasetBuilder = ImmutableList.builder();
        for (int i = 0; i < 9951; ++i) {
            largeDatasetBuilder.add((Object)random.nextGaussian());
        }
        return largeDatasetBuilder.build();
    }

    private static double expectedLargeDatasetPercentile(int index) {
        if (index % 2 == 0) {
            int position = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.UNNECESSARY);
            return (Double)PSEUDORANDOM_DATASET_SORTED.get(position);
        }
        int positionFloor = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.FLOOR);
        int positionCeil = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.CEILING);
        double lowerValue = (Double)PSEUDORANDOM_DATASET_SORTED.get(positionFloor);
        double upperValue = (Double)PSEUDORANDOM_DATASET_SORTED.get(positionCeil);
        return (lowerValue + upperValue) / 2.0;
    }

    public void testPercentiles_index_compute_doubleCollection() {
        for (int index = 0; index <= 100; ++index) {
            double expected = QuantilesTest.expectedLargeDatasetPercentile(index);
            QuantilesTest.assertQuantile(index, expected, Quantiles.percentiles().index(index).compute(PSEUDORANDOM_DATASET));
        }
    }

    @AndroidIncompatible
    public void testPercentiles_index_computeInPlace() {
        for (int index = 0; index <= 100; ++index) {
            double[] dataset = Doubles.toArray(PSEUDORANDOM_DATASET);
            double expected = QuantilesTest.expectedLargeDatasetPercentile(index);
            QuantilesTest.assertQuantile(index, expected, Quantiles.percentiles().index(index).computeInPlace(dataset));
            QuantilesTest.assertDatasetAnyOrder(PSEUDORANDOM_DATASET, dataset);
        }
    }

    public void testPercentiles_indexes_varargsPairs_compute_doubleCollection() {
        for (int index1 = 0; index1 <= 100; ++index1) {
            int index2 = 0;
            while (index2 <= 100) {
                ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
                expectedBuilder.put((Object)index1, (Object)QuantilesTest.expectedLargeDatasetPercentile(index1));
                if (index2 != index1) {
                    expectedBuilder.put((Object)index2, (Object)QuantilesTest.expectedLargeDatasetPercentile(index2));
                }
                ImmutableMap expected = expectedBuilder.build();
                QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expected, Quantiles.percentiles().indexes(new int[]{index1, index2++}).compute(PSEUDORANDOM_DATASET));
            }
        }
    }

    public void testPercentiles_indexes_varargsAll_compute_doubleCollection() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
        for (int index = 0; index <= 100; ++index) {
            indexes.add(index);
            expectedBuilder.put((Object)index, (Object)QuantilesTest.expectedLargeDatasetPercentile(index));
        }
        Random random = new Random(770683168895677741L);
        Collections.shuffle(indexes, random);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expectedBuilder.build(), Quantiles.percentiles().indexes(Ints.toArray(indexes)).compute(PSEUDORANDOM_DATASET));
    }

    public void testPercentiles_indexes_varargsAll_computeInPlace() {
        double[] dataset = Doubles.toArray(PSEUDORANDOM_DATASET);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
        for (int index = 0; index <= 100; ++index) {
            indexes.add(index);
            expectedBuilder.put((Object)index, (Object)QuantilesTest.expectedLargeDatasetPercentile(index));
        }
        Random random = new Random(770683168895677741L);
        Collections.shuffle(indexes, random);
        QuantilesTest.assertQuantilesMap((Map<Integer, Double>)expectedBuilder.build(), Quantiles.percentiles().indexes(Ints.toArray(indexes)).computeInPlace(dataset));
        QuantilesTest.assertDatasetAnyOrder(PSEUDORANDOM_DATASET, dataset);
    }

    public void testScale_zero() {
        try {
            Quantiles.scale((int)0);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_negative() {
        try {
            Quantiles.scale((int)-4);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.index(-1);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.index(11);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes(new int[]{1, -1, 3});
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes(new int[]{1, 11, 3});
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_collection_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes((Collection)ImmutableList.of((Object)1, (Object)-1, (Object)3));
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_collection_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes((Collection)ImmutableList.of((Object)1, (Object)11, (Object)3));
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_doubleCollection_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(EMPTY_DATASET);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_doubleVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_longVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new long[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_intVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new int[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_computeInPlace_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.computeInPlace(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_doubleCollection_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(EMPTY_DATASET);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_doubleVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_longVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new long[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_intVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new int[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_computeInPlace_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.computeInPlace(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertQuantile(int index, double expected, double actual) {
        if (expected == Double.POSITIVE_INFINITY) {
            ((DoubleSubject)Truth.assertThat((Double)actual).named("quantile at index " + index)).isPositiveInfinity();
        } else if (expected == Double.NEGATIVE_INFINITY) {
            ((DoubleSubject)Truth.assertThat((Double)actual).named("quantile at index " + index)).isNegativeInfinity();
        } else if (Double.isNaN(expected)) {
            ((DoubleSubject)Truth.assertThat((Double)actual).named("quantile at index " + index)).isNaN();
        } else {
            ((DoubleSubject)Truth.assertThat((Double)actual).named("quantile at index " + index)).isWithin(1.0E-10).of(expected);
        }
    }

    private static void assertQuantilesMap(Map<Integer, Double> expected, Map<Integer, Double> actual) {
        Truth.assertThat(actual.keySet()).isEqualTo(expected.keySet());
        for (int index : expected.keySet()) {
            QuantilesTest.assertQuantile(index, expected.get(index), actual.get(index));
        }
    }

    private static void assertDatasetAnyOrder(Iterable<Double> expected, double[] actual) {
        Truth.assertThat((Iterable)Doubles.asList((double[])actual)).containsExactlyElementsIn(expected);
    }

    private static void assertDatasetInOrder(Collection<Double> expected, double[] actual) {
        Truth.assertThat((double[])actual).hasValuesWithin(0.0).of(Doubles.toArray(expected));
    }

    private static void assertDatasetInOrder(Iterable<Long> expected, long[] actual) {
        Truth.assertThat((long[])actual).asList().isEqualTo(expected);
    }

    private static void assertDatasetInOrder(Iterable<Integer> expected, int[] actual) {
        Truth.assertThat((int[])actual).asList().isEqualTo(expected);
    }
}

