/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.common.primitives.Doubles;
import java.util.Random;

public class StatsBenchmark {
    @Param(value={"100", "10000"})
    int n;
    @Param
    MeanAlgorithm meanAlgorithm;
    @Param
    VarianceAlgorithm varianceAlgorithm;
    private double[][] values = new double[256][];

    @BeforeExperiment
    void setUp() {
        Random rng = new Random();
        for (int i = 0; i < 256; ++i) {
            this.values[i] = new double[this.n];
            for (int j = 0; j < this.n; ++j) {
                this.values[i][j] = rng.nextDouble();
            }
        }
    }

    @Benchmark
    int meanAndVariance(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            tmp += this.varianceAlgorithm.variance(this.values[i & 0xFF], this.meanAlgorithm).hashCode();
        }
        return tmp;
    }

    static enum VarianceAlgorithm {
        DO_NOT_COMPUTE{

            @Override
            MeanAndVariance variance(double[] values, MeanAlgorithm meanAlgorithm) {
                return new MeanAndVariance(meanAlgorithm.mean(values), 0.0);
            }
        }
        ,
        SIMPLE{

            @Override
            MeanAndVariance variance(double[] values, MeanAlgorithm meanAlgorithm) {
                double mean = meanAlgorithm.mean(values);
                double sumOfSquaresOfDeltas = 0.0;
                for (double value : values) {
                    double delta = value - mean;
                    sumOfSquaresOfDeltas += delta * delta;
                }
                return new MeanAndVariance(mean, sumOfSquaresOfDeltas / (double)values.length);
            }
        }
        ,
        KAHAN{

            @Override
            MeanAndVariance variance(double[] values, MeanAlgorithm meanAlgorithm) {
                double mean = meanAlgorithm.mean(values);
                double sumOfSquaresOfDeltas = 0.0;
                double c = 0.0;
                for (double value : values) {
                    double delta = value - mean;
                    double deltaSquared = delta * delta;
                    double y = deltaSquared - c;
                    double t = sumOfSquaresOfDeltas + deltaSquared;
                    c = t - sumOfSquaresOfDeltas - y;
                    sumOfSquaresOfDeltas = t;
                }
                return new MeanAndVariance(mean, sumOfSquaresOfDeltas / (double)values.length);
            }
        }
        ,
        KNUTH{

            @Override
            MeanAndVariance variance(double[] values, MeanAlgorithm meanAlgorithm) {
                if (meanAlgorithm != MeanAlgorithm.KNUTH) {
                    throw new SkipThisScenarioException();
                }
                double mean = values[0];
                double s = 0.0;
                for (int i = 1; i < values.length; ++i) {
                    double nextMean = mean + (values[i] - mean) / (double)(i + 1);
                    s += (values[i] - mean) * (values[i] - nextMean);
                    mean = nextMean;
                }
                return new MeanAndVariance(mean, s / (double)values.length);
            }
        };


        abstract MeanAndVariance variance(double[] var1, MeanAlgorithm var2);
    }

    static class MeanAndVariance {
        private final double mean;
        private final double variance;

        MeanAndVariance(double mean, double variance) {
            this.mean = mean;
            this.variance = variance;
        }

        public int hashCode() {
            return Doubles.hashCode((double)this.mean) * 31 + Doubles.hashCode((double)this.variance);
        }
    }

    static enum MeanAlgorithm {
        SIMPLE{

            @Override
            double mean(double[] values) {
                double sum = 0.0;
                for (double value : values) {
                    sum += value;
                }
                return sum / (double)values.length;
            }
        }
        ,
        KAHAN{

            @Override
            double mean(double[] values) {
                double sum = 0.0;
                double c = 0.0;
                for (double value : values) {
                    double y = value - c;
                    double t = sum + y;
                    c = t - sum - y;
                    sum = t;
                }
                return sum / (double)values.length;
            }
        }
        ,
        KNUTH{

            @Override
            double mean(double[] values) {
                double mean = values[0];
                for (int i = 1; i < values.length; ++i) {
                    mean += (values[i] - mean) / (double)(i + 1);
                }
                return mean;
            }
        };


        abstract double mean(double[] var1);
    }
}

