/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.net.HostAndPort;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import junit.framework.TestCase;

@GwtCompatible
public class HostAndPortTest
extends TestCase {
    public void testFromStringWellFormed() {
        HostAndPortTest.checkFromStringCase("google.com", 80, "google.com", 80, false);
        HostAndPortTest.checkFromStringCase("google.com", 80, "google.com", 80, false);
        HostAndPortTest.checkFromStringCase("192.0.2.1", 82, "192.0.2.1", 82, false);
        HostAndPortTest.checkFromStringCase("[2001::1]", 84, "2001::1", 84, false);
        HostAndPortTest.checkFromStringCase("2001::3", 86, "2001::3", 86, false);
        HostAndPortTest.checkFromStringCase("host:", 80, "host", 80, false);
    }

    public void testFromStringBadDefaultPort() {
        HostAndPortTest.checkFromStringCase("gmail.com:81", -1, "gmail.com", 81, true);
        HostAndPortTest.checkFromStringCase("192.0.2.2:83", -1, "192.0.2.2", 83, true);
        HostAndPortTest.checkFromStringCase("[2001::2]:85", -1, "2001::2", 85, true);
        HostAndPortTest.checkFromStringCase("goo.gl:65535", 65536, "goo.gl", 65535, true);
        HostAndPortTest.checkFromStringCase("google.com", -1, "google.com", -1, false);
        HostAndPortTest.checkFromStringCase("192.0.2.1", 65536, "192.0.2.1", -1, false);
        HostAndPortTest.checkFromStringCase("[2001::1]", -1, "2001::1", -1, false);
        HostAndPortTest.checkFromStringCase("2001::3", 65536, "2001::3", -1, false);
    }

    public void testFromStringUnusedDefaultPort() {
        HostAndPortTest.checkFromStringCase("gmail.com:81", 77, "gmail.com", 81, true);
        HostAndPortTest.checkFromStringCase("192.0.2.2:83", 77, "192.0.2.2", 83, true);
        HostAndPortTest.checkFromStringCase("[2001::2]:85", 77, "2001::2", 85, true);
    }

    public void testFromStringBadPort() {
        HostAndPortTest.checkFromStringCase("google.com:65536", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:9999999999", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:port", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:-25", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:+25", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:25  ", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:25\t", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("google.com:0x25 ", 1, null, 99, false);
    }

    public void testFromStringUnparseableNonsense() {
        HostAndPortTest.checkFromStringCase("[goo.gl]", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("[goo.gl]:80", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("[", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("[]:", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("[]:80", 1, null, 99, false);
        HostAndPortTest.checkFromStringCase("[]bad", 1, null, 99, false);
    }

    public void testFromStringParseableNonsense() {
        HostAndPortTest.checkFromStringCase("[[:]]", 86, "[:]", 86, false);
        HostAndPortTest.checkFromStringCase("x:y:z", 87, "x:y:z", 87, false);
        HostAndPortTest.checkFromStringCase("", 88, "", 88, false);
        HostAndPortTest.checkFromStringCase(":", 99, "", 99, false);
        HostAndPortTest.checkFromStringCase(":123", -1, "", 123, true);
        HostAndPortTest.checkFromStringCase("\nOMG\t", 89, "\nOMG\t", 89, false);
    }

    private static void checkFromStringCase(String hpString, int defaultPort, String expectHost, int expectPort, boolean expectHasExplicitPort) {
        HostAndPort hp;
        try {
            hp = HostAndPort.fromString((String)hpString);
        }
        catch (IllegalArgumentException e) {
            HostAndPortTest.assertNull((Object)expectHost);
            return;
        }
        HostAndPortTest.assertNotNull((Object)expectHost);
        boolean badDefaultPort = defaultPort < 0 || defaultPort > 65535;
        HostAndPort hp2 = null;
        try {
            hp2 = hp.withDefaultPort(defaultPort);
            HostAndPortTest.assertFalse((boolean)badDefaultPort);
        }
        catch (IllegalArgumentException e) {
            HostAndPortTest.assertTrue((boolean)badDefaultPort);
        }
        if (expectHasExplicitPort) {
            HostAndPortTest.assertTrue((boolean)hp.hasPort());
            HostAndPortTest.assertEquals((int)expectPort, (int)hp.getPort());
        } else {
            HostAndPortTest.assertFalse((boolean)hp.hasPort());
            try {
                hp.getPort();
                HostAndPortTest.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException expected) {
                // empty catch block
            }
        }
        HostAndPortTest.assertEquals((String)expectHost, (String)hp.getHost());
        HostAndPortTest.assertEquals((String)expectHost, (String)hp.getHostText());
        if (!badDefaultPort) {
            try {
                int port = hp2.getPort();
                HostAndPortTest.assertTrue((expectPort != -1 ? 1 : 0) != 0);
                HostAndPortTest.assertEquals((int)expectPort, (int)port);
            }
            catch (IllegalStateException e) {
                HostAndPortTest.assertEquals((int)-1, (int)expectPort);
            }
            HostAndPortTest.assertEquals((String)expectHost, (String)hp2.getHost());
            HostAndPortTest.assertEquals((String)expectHost, (String)hp2.getHostText());
        }
    }

    public void testFromParts() {
        HostAndPort hp = HostAndPort.fromParts((String)"gmail.com", (int)81);
        HostAndPortTest.assertEquals((String)"gmail.com", (String)hp.getHost());
        HostAndPortTest.assertTrue((boolean)hp.hasPort());
        HostAndPortTest.assertEquals((int)81, (int)hp.getPort());
        try {
            HostAndPort.fromParts((String)"gmail.com:80", (int)81);
            HostAndPortTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HostAndPort.fromParts((String)"gmail.com", (int)-1);
            HostAndPortTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromHost() {
        HostAndPort hp = HostAndPort.fromHost((String)"gmail.com");
        HostAndPortTest.assertEquals((String)"gmail.com", (String)hp.getHost());
        HostAndPortTest.assertFalse((boolean)hp.hasPort());
        hp = HostAndPort.fromHost((String)"[::1]");
        HostAndPortTest.assertEquals((String)"::1", (String)hp.getHost());
        HostAndPortTest.assertFalse((boolean)hp.hasPort());
        try {
            HostAndPort.fromHost((String)"gmail.com:80");
            HostAndPortTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HostAndPort.fromHost((String)"[gmail.com]");
            HostAndPortTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetPortOrDefault() {
        HostAndPortTest.assertEquals((int)80, (int)HostAndPort.fromString((String)"host:80").getPortOrDefault(123));
        HostAndPortTest.assertEquals((int)123, (int)HostAndPort.fromString((String)"host").getPortOrDefault(123));
    }

    public void testHashCodeAndEquals() {
        HostAndPort hp1 = HostAndPort.fromString((String)"foo::123");
        HostAndPort hp2 = HostAndPort.fromString((String)"foo::123");
        HostAndPort hp3 = HostAndPort.fromString((String)"[foo::123]");
        HostAndPort hp4 = HostAndPort.fromParts((String)"[foo::123]", (int)80);
        HostAndPort hp5 = HostAndPort.fromString((String)"[foo::123]:80");
        new EqualsTester().addEqualityGroup(new Object[]{hp1, hp2}).addEqualityGroup(new Object[]{hp3}).addEqualityGroup(new Object[]{hp4, hp5}).testEquals();
    }

    public void testRequireBracketsForIPv6() {
        HostAndPortTest.assertEquals((String)"::1", (String)HostAndPort.fromString((String)"[::1]").requireBracketsForIPv6().getHost());
        HostAndPortTest.assertEquals((String)"::1", (String)HostAndPort.fromString((String)"[::1]:80").requireBracketsForIPv6().getHost());
        HostAndPortTest.assertEquals((String)"x", (String)HostAndPort.fromString((String)"x").requireBracketsForIPv6().getHost());
        HostAndPortTest.assertEquals((String)"x", (String)HostAndPort.fromString((String)"x:80").requireBracketsForIPv6().getHost());
        try {
            HostAndPort.fromString((String)"::1").requireBracketsForIPv6();
            HostAndPortTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        HostAndPortTest.assertEquals((String)"foo:101", (String)("" + HostAndPort.fromString((String)"foo:101")));
        HostAndPortTest.assertEquals((String)":102", (String)HostAndPort.fromString((String)":102").toString());
        HostAndPortTest.assertEquals((String)"[1::2]:103", (String)HostAndPort.fromParts((String)"1::2", (int)103).toString());
        HostAndPortTest.assertEquals((String)"[::1]:104", (String)HostAndPort.fromString((String)"[::1]:104").toString());
        HostAndPortTest.assertEquals((String)"foo", (String)("" + HostAndPort.fromString((String)"foo")));
        HostAndPortTest.assertEquals((String)"", (String)HostAndPort.fromString((String)"").toString());
        HostAndPortTest.assertEquals((String)"[1::2]", (String)HostAndPort.fromString((String)"1::2").toString());
        HostAndPortTest.assertEquals((String)"[::1]", (String)HostAndPort.fromString((String)"[::1]").toString());
        HostAndPortTest.assertEquals((String)"[::]]:107", (String)HostAndPort.fromParts((String)"::]", (int)107).toString());
        HostAndPortTest.assertEquals((String)"[[:]]:108", (String)HostAndPort.fromString((String)"[[:]]:108").toString());
    }

    public void testSerialization() {
        SerializableTester.reserializeAndAssert((Object)HostAndPort.fromParts((String)"host", (int)80));
        SerializableTester.reserializeAndAssert((Object)HostAndPort.fromString((String)"host"));
        SerializableTester.reserializeAndAssert((Object)HostAndPort.fromString((String)"host:80"));
        SerializableTester.reserializeAndAssert((Object)HostAndPort.fromString((String)"[::1]:104"));
        SerializableTester.reserializeAndAssert((Object)HostAndPort.fromParts((String)"1::2", (int)103));
    }
}

