/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.net.InetAddresses;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;

public class InetAddressesTest
extends TestCase {
    public void testNulls() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(InetAddresses.class);
    }

    public void testForStringBogusInput() {
        String[] bogusInputs = new String[]{"", "016.016.016.016", "016.016.016", "016.016", "016", "000.000.000.000", "000", "0x0a.0x0a.0x0a.0x0a", "0x0a.0x0a.0x0a", "0x0a.0x0a", "0x0a", "42.42.42.42.42", "42.42.42", "42.42", "42", "42..42.42", "42..42.42.42", "42.42.42.42.", "42.42.42.42...", ".42.42.42.42", "...42.42.42.42", "42.42.42.-0", "42.42.42.+0", ".", "...", "bogus", "bogus.com", "192.168.0.1.com", "12345.67899.-54321.-98765", "257.0.0.0", "42.42.42.-42", "3ffe::1.net", "3ffe::1::1", "1::2::3::4:5", "::7:6:5:4:3:2:", ":6:5:4:3:2:1::", "2001::db:::1", "FEDC:9878", "+1.+2.+3.4", "1.2.3.4e0", "::7:6:5:4:3:2:1:0", "7:6:5:4:3:2:1:0::", "9:8:7:6:5:4:3::2:1", "0:1:2:3::4:5:6:7", "3ffe:0:0:0:0:0:0:0:1", "3ffe::10000", "3ffe::goog", "3ffe::-0", "3ffe::+0", "3ffe::-1", ":", ":::", "::1.2.3", "::1.2.3.4.5", "::1.2.3.4:", "1.2.3.4::", "2001:db8::1:", ":2001:db8::1", ":1:2:3:4:5:6:7", "1:2:3:4:5:6:7:", ":1:2:3:4:5:6:"};
        for (int i = 0; i < bogusInputs.length; ++i) {
            try {
                InetAddresses.forString((String)bogusInputs[i]);
                InetAddressesTest.fail((String)("IllegalArgumentException expected for '" + bogusInputs[i] + "'"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            InetAddressesTest.assertFalse((boolean)InetAddresses.isInetAddress((String)bogusInputs[i]));
        }
    }

    public void test3ff31() {
        try {
            InetAddresses.forString((String)"3ffe:::1");
            InetAddressesTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        InetAddressesTest.assertFalse((boolean)InetAddresses.isInetAddress((String)"016.016.016.016"));
    }

    public void testForStringIPv4Input() throws UnknownHostException {
        String ipStr = "192.168.0.1";
        InetAddress ipv4Addr = null;
        ipv4Addr = InetAddress.getByName(ipStr);
        InetAddressesTest.assertEquals((Object)ipv4Addr, (Object)InetAddresses.forString((String)ipStr));
        InetAddressesTest.assertTrue((boolean)InetAddresses.isInetAddress((String)ipStr));
    }

    public void testForStringIPv6Input() throws UnknownHostException {
        String ipStr = "3ffe::1";
        InetAddress ipv6Addr = null;
        ipv6Addr = InetAddress.getByName(ipStr);
        InetAddressesTest.assertEquals((Object)ipv6Addr, (Object)InetAddresses.forString((String)ipStr));
        InetAddressesTest.assertTrue((boolean)InetAddresses.isInetAddress((String)ipStr));
    }

    public void testForStringIPv6EightColons() throws UnknownHostException {
        String[] eightColons = new String[]{"::7:6:5:4:3:2:1", "::7:6:5:4:3:2:0", "7:6:5:4:3:2:1::", "0:6:5:4:3:2:1::"};
        for (int i = 0; i < eightColons.length; ++i) {
            InetAddress ipv6Addr = null;
            ipv6Addr = InetAddress.getByName(eightColons[i]);
            InetAddressesTest.assertEquals((Object)ipv6Addr, (Object)InetAddresses.forString((String)eightColons[i]));
            InetAddressesTest.assertTrue((boolean)InetAddresses.isInetAddress((String)eightColons[i]));
        }
    }

    public void testConvertDottedQuadToHex() throws UnknownHostException {
        String[] ipStrings;
        for (String ipString : ipStrings = new String[]{"7::0.128.0.127", "7::0.128.0.128", "7::128.128.0.127", "7::0.128.128.127"}) {
            InetAddress ipv6Addr = InetAddress.getByName(ipString);
            InetAddressesTest.assertEquals((Object)ipv6Addr, (Object)InetAddresses.forString((String)ipString));
            InetAddressesTest.assertTrue((boolean)InetAddresses.isInetAddress((String)ipString));
        }
    }

    public void testToAddrStringIPv4() {
        InetAddressesTest.assertEquals((String)"1.2.3.4", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"1.2.3.4")));
    }

    public void testToAddrStringIPv6() {
        InetAddressesTest.assertEquals((String)"1:2:3:4:5:6:7:8", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"1:2:3:4:5:6:7:8")));
        InetAddressesTest.assertEquals((String)"2001:0:0:4::8", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"2001:0:0:4:0:0:0:8")));
        InetAddressesTest.assertEquals((String)"2001::4:5:6:7:8", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"2001:0:0:4:5:6:7:8")));
        InetAddressesTest.assertEquals((String)"2001:0:3:4:5:6:7:8", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"2001:0:3:4:5:6:7:8")));
        InetAddressesTest.assertEquals((String)"0:0:3::ffff", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"0:0:3:0:0:0:0:ffff")));
        InetAddressesTest.assertEquals((String)"::4:0:0:0:ffff", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"0:0:0:4:0:0:0:ffff")));
        InetAddressesTest.assertEquals((String)"::5:0:0:ffff", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"0:0:0:0:5:0:0:ffff")));
        InetAddressesTest.assertEquals((String)"1::4:0:0:7:8", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"1:0:0:4:0:0:7:8")));
        InetAddressesTest.assertEquals((String)"::", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"0:0:0:0:0:0:0:0")));
        InetAddressesTest.assertEquals((String)"::1", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"0:0:0:0:0:0:0:1")));
        InetAddressesTest.assertEquals((String)"2001:658:22a:cafe::", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"2001:0658:022a:cafe::")));
        InetAddressesTest.assertEquals((String)"::102:304", (String)InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)"::1.2.3.4")));
    }

    public void testToUriStringIPv4() {
        String ipStr = "1.2.3.4";
        InetAddress ip = InetAddresses.forString((String)ipStr);
        InetAddressesTest.assertEquals((String)"1.2.3.4", (String)InetAddresses.toUriString((InetAddress)ip));
    }

    public void testToUriStringIPv6() {
        String ipStr = "3ffe::1";
        InetAddress ip = InetAddresses.forString((String)ipStr);
        InetAddressesTest.assertEquals((String)"[3ffe::1]", (String)InetAddresses.toUriString((InetAddress)ip));
    }

    public void testForUriStringIPv4() {
        Inet4Address expected = (Inet4Address)InetAddresses.forString((String)"192.168.1.1");
        InetAddressesTest.assertEquals((Object)expected, (Object)InetAddresses.forUriString((String)"192.168.1.1"));
    }

    public void testForUriStringIPv6() {
        Inet6Address expected = (Inet6Address)InetAddresses.forString((String)"3ffe:0:0:0:0:0:0:1");
        InetAddressesTest.assertEquals((Object)expected, (Object)InetAddresses.forUriString((String)"[3ffe:0:0:0:0:0:0:1]"));
    }

    public void testForUriStringIPv4Mapped() {
        Inet4Address expected = (Inet4Address)InetAddresses.forString((String)"192.0.2.1");
        InetAddressesTest.assertEquals((Object)expected, (Object)InetAddresses.forUriString((String)"[::ffff:192.0.2.1]"));
    }

    public void testIsUriInetAddress() {
        InetAddressesTest.assertTrue((boolean)InetAddresses.isUriInetAddress((String)"192.168.1.1"));
        InetAddressesTest.assertTrue((boolean)InetAddresses.isUriInetAddress((String)"[3ffe:0:0:0:0:0:0:1]"));
        InetAddressesTest.assertTrue((boolean)InetAddresses.isUriInetAddress((String)"[::ffff:192.0.2.1]"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"[192.168.1.1"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"192.168.1.1]"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)""));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"192.168.999.888"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"www.google.com"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"1:2e"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"[3ffe:0:0:0:0:0:0:1"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"3ffe:0:0:0:0:0:0:1]"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"3ffe:0:0:0:0:0:0:1"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isUriInetAddress((String)"::ffff:192.0.2.1"));
    }

    public void testForUriStringBad() {
        try {
            InetAddresses.forUriString((String)"");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"192.168.999.888");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"www.google.com");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"[1:2e]");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"[192.168.1.1]");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"192.168.1.1]");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"[192.168.1.1");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"[3ffe:0:0:0:0:0:0:1");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"3ffe:0:0:0:0:0:0:1]");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"3ffe:0:0:0:0:0:0:1");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            InetAddresses.forUriString((String)"::ffff:192.0.2.1");
            InetAddressesTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCompatIPv4Addresses() {
        String[] nonCompatAddresses = new String[]{"3ffe::1", "::", "::1"};
        for (int i = 0; i < nonCompatAddresses.length; ++i) {
            InetAddress ip = InetAddresses.forString((String)nonCompatAddresses[i]);
            InetAddressesTest.assertFalse((boolean)InetAddresses.isCompatIPv4Address((Inet6Address)((Inet6Address)ip)));
            try {
                InetAddresses.getCompatIPv4Address((Inet6Address)((Inet6Address)ip));
                InetAddressesTest.fail((String)("IllegalArgumentException expected for '" + nonCompatAddresses[i] + "'"));
                continue;
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
        String[] validCompatAddresses = new String[]{"::1.2.3.4", "::102:304"};
        String compatStr = "1.2.3.4";
        InetAddress compat = InetAddresses.forString((String)compatStr);
        for (int i = 0; i < validCompatAddresses.length; ++i) {
            InetAddress ip = InetAddresses.forString((String)validCompatAddresses[i]);
            InetAddressesTest.assertTrue((String)("checking '" + validCompatAddresses[i] + "'"), (boolean)(ip instanceof Inet6Address));
            InetAddressesTest.assertTrue((String)("checking '" + validCompatAddresses[i] + "'"), (boolean)InetAddresses.isCompatIPv4Address((Inet6Address)((Inet6Address)ip)));
            InetAddressesTest.assertEquals((String)("checking '" + validCompatAddresses[i] + "'"), (Object)compat, (Object)InetAddresses.getCompatIPv4Address((Inet6Address)((Inet6Address)ip)));
        }
    }

    public void testMappedIPv4Addresses() throws UnknownHostException {
        String mappedStr = "::ffff:192.168.0.1";
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMappedIPv4Address((String)mappedStr));
        InetAddress mapped = InetAddresses.forString((String)mappedStr);
        Truth.assertThat((Object)mapped).isNotInstanceOf(Inet6Address.class);
        InetAddressesTest.assertEquals((Object)InetAddress.getByName("192.168.0.1"), (Object)mapped);
        mappedStr = "::FFFF:192.168.0.1";
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMappedIPv4Address((String)mappedStr));
        mapped = InetAddresses.forString((String)mappedStr);
        Truth.assertThat((Object)mapped).isNotInstanceOf(Inet6Address.class);
        InetAddressesTest.assertEquals((Object)InetAddress.getByName("192.168.0.1"), (Object)mapped);
        mappedStr = "0:00:000:0000:0:ffff:1.2.3.4";
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMappedIPv4Address((String)mappedStr));
        mapped = InetAddresses.forString((String)mappedStr);
        Truth.assertThat((Object)mapped).isNotInstanceOf(Inet6Address.class);
        InetAddressesTest.assertEquals((Object)InetAddress.getByName("1.2.3.4"), (Object)mapped);
        mappedStr = "::ffff:0102:0304";
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMappedIPv4Address((String)mappedStr));
        mapped = InetAddresses.forString((String)mappedStr);
        Truth.assertThat((Object)mapped).isNotInstanceOf(Inet6Address.class);
        InetAddressesTest.assertEquals((Object)InetAddress.getByName("1.2.3.4"), (Object)mapped);
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"::"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"::ffff"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"::ffff:0"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"::fffe:0:0"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"::1:ffff:0:0"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"foo"));
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMappedIPv4Address((String)"192.0.2.1"));
    }

    public void test6to4Addresses() {
        String[] non6to4Addresses = new String[]{"::1.2.3.4", "3ffe::1", "::", "::1"};
        for (int i = 0; i < non6to4Addresses.length; ++i) {
            InetAddress ip = InetAddresses.forString((String)non6to4Addresses[i]);
            InetAddressesTest.assertFalse((boolean)InetAddresses.is6to4Address((Inet6Address)((Inet6Address)ip)));
            try {
                InetAddresses.get6to4IPv4Address((Inet6Address)((Inet6Address)ip));
                InetAddressesTest.fail((String)("IllegalArgumentException expected for '" + non6to4Addresses[i] + "'"));
                continue;
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
        String valid6to4Address = "2002:0102:0304::1";
        String ipv4Str = "1.2.3.4";
        InetAddress ipv4 = InetAddresses.forString((String)ipv4Str);
        InetAddress ip = InetAddresses.forString((String)valid6to4Address);
        InetAddressesTest.assertTrue((boolean)InetAddresses.is6to4Address((Inet6Address)((Inet6Address)ip)));
        InetAddressesTest.assertEquals((Object)ipv4, (Object)InetAddresses.get6to4IPv4Address((Inet6Address)((Inet6Address)ip)));
    }

    public void testTeredoAddresses() {
        String[] nonTeredoAddresses = new String[]{"::1.2.3.4", "3ffe::1", "::", "::1"};
        for (int i = 0; i < nonTeredoAddresses.length; ++i) {
            InetAddress ip = InetAddresses.forString((String)nonTeredoAddresses[i]);
            InetAddressesTest.assertFalse((boolean)InetAddresses.isTeredoAddress((Inet6Address)((Inet6Address)ip)));
            try {
                InetAddresses.getTeredoInfo((Inet6Address)((Inet6Address)ip));
                InetAddressesTest.fail((String)("IllegalArgumentException expected for '" + nonTeredoAddresses[i] + "'"));
                continue;
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
        String validTeredoAddress = "2001:0000:4136:e378:8000:63bf:3fff:fdd2";
        String serverStr = "65.54.227.120";
        String clientStr = "192.0.2.45";
        int port = 40000;
        int flags = 32768;
        InetAddress ip = InetAddresses.forString((String)validTeredoAddress);
        InetAddressesTest.assertTrue((boolean)InetAddresses.isTeredoAddress((Inet6Address)((Inet6Address)ip)));
        InetAddresses.TeredoInfo teredo = InetAddresses.getTeredoInfo((Inet6Address)((Inet6Address)ip));
        InetAddress server = InetAddresses.forString((String)serverStr);
        InetAddressesTest.assertEquals((Object)server, (Object)teredo.getServer());
        InetAddress client = InetAddresses.forString((String)clientStr);
        InetAddressesTest.assertEquals((Object)client, (Object)teredo.getClient());
        InetAddressesTest.assertEquals((int)port, (int)teredo.getPort());
        InetAddressesTest.assertEquals((int)flags, (int)teredo.getFlags());
    }

    public void testTeredoAddress_nullServer() {
        InetAddresses.TeredoInfo info = new InetAddresses.TeredoInfo(null, null, 80, 1000);
        InetAddressesTest.assertEquals((Object)InetAddresses.forString((String)"0.0.0.0"), (Object)info.getServer());
        InetAddressesTest.assertEquals((Object)InetAddresses.forString((String)"0.0.0.0"), (Object)info.getClient());
        InetAddressesTest.assertEquals((int)80, (int)info.getPort());
        InetAddressesTest.assertEquals((int)1000, (int)info.getFlags());
    }

    public void testIsatapAddresses() {
        InetAddress ip;
        int i;
        InetAddress ipv4 = InetAddresses.forString((String)"1.2.3.4");
        String[] validIsatapAddresses = new String[]{"2001:db8::5efe:102:304", "2001:db8::100:5efe:102:304", "2001:db8::200:5efe:102:304", "2001:db8::300:5efe:102:304"};
        String[] nonIsatapAddresses = new String[]{"::1.2.3.4", "3ffe::1", "::", "::1", "2001:db8::0040:5efe:102:304", "2001:db8::5ffe:102:304", "2001:db8::5eff:102:304", "2001:0:102:203:200:5efe:506:708"};
        for (i = 0; i < validIsatapAddresses.length; ++i) {
            ip = InetAddresses.forString((String)validIsatapAddresses[i]);
            InetAddressesTest.assertTrue((boolean)InetAddresses.isIsatapAddress((Inet6Address)((Inet6Address)ip)));
            InetAddressesTest.assertEquals((String)("checking '" + validIsatapAddresses[i] + "'"), (Object)ipv4, (Object)InetAddresses.getIsatapIPv4Address((Inet6Address)((Inet6Address)ip)));
        }
        for (i = 0; i < nonIsatapAddresses.length; ++i) {
            ip = InetAddresses.forString((String)nonIsatapAddresses[i]);
            InetAddressesTest.assertFalse((boolean)InetAddresses.isIsatapAddress((Inet6Address)((Inet6Address)ip)));
            try {
                InetAddresses.getIsatapIPv4Address((Inet6Address)((Inet6Address)ip));
                InetAddressesTest.fail((String)("IllegalArgumentException expected for '" + nonIsatapAddresses[i] + "'"));
                continue;
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
    }

    public void testGetEmbeddedIPv4ClientAddress() {
        Inet6Address testIp = (Inet6Address)InetAddresses.forString((String)"2001:db8::1");
        InetAddressesTest.assertFalse((boolean)InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        testIp = (Inet6Address)InetAddresses.forString((String)"2001:db8::5efe:102:304");
        InetAddressesTest.assertFalse((boolean)InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        testIp = (Inet6Address)InetAddresses.forString((String)"::1.2.3.4");
        InetAddressesTest.assertTrue((boolean)InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        InetAddress ipv4 = InetAddresses.forString((String)"1.2.3.4");
        InetAddressesTest.assertEquals((Object)ipv4, (Object)InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        testIp = (Inet6Address)InetAddresses.forString((String)"2002:0102:0304::1");
        InetAddressesTest.assertTrue((boolean)InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        ipv4 = InetAddresses.forString((String)"1.2.3.4");
        InetAddressesTest.assertEquals((Object)ipv4, (Object)InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        testIp = (Inet6Address)InetAddresses.forString((String)"2001:0000:4136:e378:8000:63bf:3fff:fdd2");
        InetAddressesTest.assertTrue((boolean)InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)testIp));
        ipv4 = InetAddresses.forString((String)"192.0.2.45");
        InetAddressesTest.assertEquals((Object)ipv4, (Object)InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)testIp));
    }

    public void testGetCoercedIPv4Address() {
        InetAddress localHost4 = InetAddresses.forString((String)"127.0.0.1");
        InetAddressesTest.assertEquals((Object)localHost4, (Object)InetAddresses.getCoercedIPv4Address((InetAddress)localHost4));
        InetAddressesTest.assertEquals((Object)localHost4, (Object)InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"::1")));
        InetAddressesTest.assertEquals((Object)InetAddresses.forString((String)"0.0.0.0"), (Object)InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"::")));
        InetAddressesTest.assertTrue((InetAddresses.forString((String)"1.2.3.4") != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"::1.2.3.4")) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.forString((String)"1.2.3.4") != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2002:0102:0304::1")) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2002:0102:0304::1")) != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2002:0506:0708::1")) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2002:0102:0304::1")) != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2002:0102:0304::2")) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.forString((String)"192.0.2.45") != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:0000:4136:e378:8000:63bf:3fff:fdd2")) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:0000:4136:e378:8000:63bf:3fff:fdd2")) != InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:0000:4136:e379:8000:63bf:3fff:fdd2")) ? 1 : 0) != 0);
        InetAddressesTest.assertEquals((Object)InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:0000:4136:e378:8000:63bf:3fff:fdd2")), (Object)InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:0000:4136:e378:9000:63bf:3fff:fdd2")));
        Inet4Address coerced = InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)"2001:4860::1"));
        InetAddressesTest.assertTrue((-536870912 <= InetAddresses.coerceToInteger((InetAddress)coerced) ? 1 : 0) != 0);
        InetAddressesTest.assertTrue((InetAddresses.coerceToInteger((InetAddress)coerced) <= -2 ? 1 : 0) != 0);
    }

    public void testToInteger() {
        InetAddress ipv4Addr = InetAddresses.forString((String)"127.0.0.1");
        InetAddressesTest.assertEquals((int)2130706433, (int)InetAddresses.coerceToInteger((InetAddress)ipv4Addr));
    }

    public void testFromInteger() {
        InetAddressesTest.assertEquals((Object)InetAddresses.fromInteger((int)2130706433), (Object)InetAddresses.forString((String)"127.0.0.1"));
    }

    public void testFromLittleEndianByteArray() throws UnknownHostException {
        InetAddressesTest.assertEquals((Object)InetAddresses.fromLittleEndianByteArray((byte[])new byte[]{1, 2, 3, 4}), (Object)InetAddress.getByAddress(new byte[]{4, 3, 2, 1}));
        InetAddressesTest.assertEquals((Object)InetAddresses.fromLittleEndianByteArray((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}), (Object)InetAddress.getByAddress(new byte[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}));
        try {
            InetAddresses.fromLittleEndianByteArray((byte[])new byte[3]);
            InetAddressesTest.fail((String)"expected exception");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testIsMaximum() throws UnknownHostException {
        InetAddress address = InetAddress.getByName("255.255.255.254");
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMaximum((InetAddress)address));
        address = InetAddress.getByName("255.255.255.255");
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMaximum((InetAddress)address));
        address = InetAddress.getByName("ffff:ffff:ffff:ffff:ffff:ffff:ffff:fffe");
        InetAddressesTest.assertFalse((boolean)InetAddresses.isMaximum((InetAddress)address));
        address = InetAddress.getByName("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        InetAddressesTest.assertTrue((boolean)InetAddresses.isMaximum((InetAddress)address));
    }

    public void testIncrementIPv4() throws UnknownHostException {
        InetAddress address_ffffff;
        InetAddress address_66_0 = InetAddress.getByName("172.24.66.0");
        InetAddress address_66_255 = InetAddress.getByName("172.24.66.255");
        InetAddress address_67_0 = InetAddress.getByName("172.24.67.0");
        InetAddress address = address_66_0;
        for (int i = 0; i < 255; ++i) {
            address = InetAddresses.increment((InetAddress)address);
        }
        InetAddressesTest.assertEquals((Object)address_66_255, (Object)address);
        address = InetAddresses.increment((InetAddress)address);
        InetAddressesTest.assertEquals((Object)address_67_0, (Object)address);
        address = address_ffffff = InetAddress.getByName("255.255.255.255");
        try {
            address = InetAddresses.increment((InetAddress)address);
            InetAddressesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testIncrementIPv6() throws UnknownHostException {
        InetAddress addressV6_ffffff;
        InetAddress addressV6_66_0 = InetAddress.getByName("2001:db8::6600");
        InetAddress addressV6_66_ff = InetAddress.getByName("2001:db8::66ff");
        InetAddress addressV6_67_0 = InetAddress.getByName("2001:db8::6700");
        InetAddress address = addressV6_66_0;
        for (int i = 0; i < 255; ++i) {
            address = InetAddresses.increment((InetAddress)address);
        }
        InetAddressesTest.assertEquals((Object)addressV6_66_ff, (Object)address);
        address = InetAddresses.increment((InetAddress)address);
        InetAddressesTest.assertEquals((Object)addressV6_67_0, (Object)address);
        address = addressV6_ffffff = InetAddress.getByName("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        try {
            address = InetAddresses.increment((InetAddress)address);
            InetAddressesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testDecrementIPv4() throws UnknownHostException {
        InetAddress address0000;
        InetAddress address670;
        InetAddress address660 = InetAddress.getByName("172.24.66.0");
        InetAddress address66255 = InetAddress.getByName("172.24.66.255");
        InetAddress address = address670 = InetAddress.getByName("172.24.67.0");
        address = InetAddresses.decrement((InetAddress)address);
        InetAddressesTest.assertEquals((Object)address66255, (Object)address);
        for (int i = 0; i < 255; ++i) {
            address = InetAddresses.decrement((InetAddress)address);
        }
        InetAddressesTest.assertEquals((Object)address660, (Object)address);
        address = address0000 = InetAddress.getByName("0.0.0.0");
        try {
            address = InetAddresses.decrement((InetAddress)address);
            InetAddressesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testDecrementIPv6() throws UnknownHostException {
        InetAddress addressV6000000;
        InetAddress addressV6670;
        InetAddress addressV6660 = InetAddress.getByName("2001:db8::6600");
        InetAddress addressV666ff = InetAddress.getByName("2001:db8::66ff");
        InetAddress address = addressV6670 = InetAddress.getByName("2001:db8::6700");
        address = InetAddresses.decrement((InetAddress)address);
        InetAddressesTest.assertEquals((Object)addressV666ff, (Object)address);
        for (int i = 0; i < 255; ++i) {
            address = InetAddresses.decrement((InetAddress)address);
        }
        InetAddressesTest.assertEquals((Object)addressV6660, (Object)address);
        address = addressV6000000 = InetAddress.getByName("0:0:0:0:0:0:0:0");
        try {
            address = InetAddresses.decrement((InetAddress)address);
            InetAddressesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }
}

