/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.escape.UnicodeEscaper;
import com.google.common.escape.testing.EscaperAsserts;
import com.google.common.net.UrlEscapers;
import junit.framework.TestCase;

@GwtCompatible
public class UrlEscapersTest
extends TestCase {
    static void assertBasicUrlEscaperExceptPercent(UnicodeEscaper e) {
        try {
            e.escape((String)null);
            UrlEscapersTest.fail((String)"Escaping null string should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)97);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)122);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)65);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)90);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)48);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)57);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)45);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)95);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)46);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)42);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%00", (int)0);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%7F", (int)127);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%C2%80", (int)128);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%DF%BF", (int)2047);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%E0%A0%80", (int)2048);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%EF%BF%BF", (int)65535);
        EscaperAsserts.assertUnicodeEscaping((UnicodeEscaper)e, (String)"%F0%90%80%80", (char)'\ud800', (char)'\udc00');
        EscaperAsserts.assertUnicodeEscaping((UnicodeEscaper)e, (String)"%F4%8F%BF%BF", (char)'\udbff', (char)'\udfff');
        UrlEscapersTest.assertEquals((String)"", (String)e.escape(""));
        UrlEscapersTest.assertEquals((String)"safestring", (String)e.escape("safestring"));
        UrlEscapersTest.assertEquals((String)"embedded%00null", (String)e.escape("embedded\u0000null"));
        UrlEscapersTest.assertEquals((String)"max%EF%BF%BFchar", (String)e.escape("max\uffffchar"));
    }

    static void assertBasicUrlEscaper(UnicodeEscaper e) {
        UrlEscapersTest.assertBasicUrlEscaperExceptPercent(e);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%25", (int)37);
    }

    public void testUrlFormParameterEscaper() {
        UnicodeEscaper e = (UnicodeEscaper)UrlEscapers.urlFormParameterEscaper();
        UrlEscapersTest.assertSame((Object)e, (Object)UrlEscapers.urlFormParameterEscaper());
        UrlEscapersTest.assertBasicUrlEscaper(e);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%21", (int)33);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%28", (int)40);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%29", (int)41);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%7E", (int)126);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%27", (int)39);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"+", (int)32);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%2B", (int)43);
        UrlEscapersTest.assertEquals((String)"safe+with+spaces", (String)e.escape("safe with spaces"));
        UrlEscapersTest.assertEquals((String)"foo%40bar.com", (String)e.escape("foo@bar.com"));
    }

    public void testUrlPathSegmentEscaper() {
        UnicodeEscaper e = (UnicodeEscaper)UrlEscapers.urlPathSegmentEscaper();
        UrlEscapersTest.assertPathEscaper(e);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)43);
    }

    static void assertPathEscaper(UnicodeEscaper e) {
        UrlEscapersTest.assertBasicUrlEscaper(e);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)33);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)39);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)40);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)41);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)126);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)58);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)64);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%20", (int)32);
        UrlEscapersTest.assertEquals((String)"safe%20with%20spaces", (String)e.escape("safe with spaces"));
        UrlEscapersTest.assertEquals((String)"foo@bar.com", (String)e.escape("foo@bar.com"));
    }

    public void testUrlFragmentEscaper() {
        UnicodeEscaper e = (UnicodeEscaper)UrlEscapers.urlFragmentEscaper();
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)43);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)47);
        EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)63);
        UrlEscapersTest.assertPathEscaper(e);
    }
}

