/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Booleans;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class BooleansTest
extends TestCase {
    private static final boolean[] EMPTY = new boolean[0];
    private static final boolean[] ARRAY_FALSE = new boolean[]{false};
    private static final boolean[] ARRAY_TRUE = new boolean[]{true};
    private static final boolean[] ARRAY_FALSE_FALSE = new boolean[]{false, false};
    private static final boolean[] ARRAY_FALSE_TRUE = new boolean[]{false, true};
    private static final boolean[] VALUES = new boolean[]{false, true};

    public void testHashCode() {
        BooleansTest.assertEquals((int)Boolean.TRUE.hashCode(), (int)Booleans.hashCode((boolean)true));
        BooleansTest.assertEquals((int)Boolean.FALSE.hashCode(), (int)Booleans.hashCode((boolean)false));
    }

    public void testCompare() {
        for (boolean x : VALUES) {
            for (boolean y : VALUES) {
                BooleansTest.assertEquals((String)(x + ", " + y), (int)Boolean.valueOf(x).compareTo(y), (int)Booleans.compare((boolean)x, (boolean)y));
            }
        }
    }

    public void testContains() {
        BooleansTest.assertFalse((boolean)Booleans.contains((boolean[])EMPTY, (boolean)false));
        BooleansTest.assertFalse((boolean)Booleans.contains((boolean[])ARRAY_FALSE, (boolean)true));
        BooleansTest.assertTrue((boolean)Booleans.contains((boolean[])ARRAY_FALSE, (boolean)false));
        BooleansTest.assertTrue((boolean)Booleans.contains((boolean[])ARRAY_FALSE_TRUE, (boolean)false));
        BooleansTest.assertTrue((boolean)Booleans.contains((boolean[])ARRAY_FALSE_TRUE, (boolean)true));
    }

    public void testIndexOf() {
        BooleansTest.assertEquals((int)-1, (int)Booleans.indexOf((boolean[])EMPTY, (boolean[])ARRAY_FALSE));
        BooleansTest.assertEquals((int)-1, (int)Booleans.indexOf((boolean[])ARRAY_FALSE, (boolean[])ARRAY_FALSE_TRUE));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_FALSE, (boolean[])ARRAY_FALSE));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_FALSE, (boolean[])ARRAY_FALSE));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_TRUE, (boolean[])ARRAY_FALSE));
        BooleansTest.assertEquals((int)1, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_TRUE, (boolean[])ARRAY_TRUE));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_TRUE, (boolean[])new boolean[0]));
    }

    public void testIndexOf_arrays() {
        BooleansTest.assertEquals((int)-1, (int)Booleans.indexOf((boolean[])EMPTY, (boolean)false));
        BooleansTest.assertEquals((int)-1, (int)Booleans.indexOf((boolean[])ARRAY_FALSE, (boolean)true));
        BooleansTest.assertEquals((int)-1, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_FALSE, (boolean)true));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_FALSE, (boolean)false));
        BooleansTest.assertEquals((int)0, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_TRUE, (boolean)false));
        BooleansTest.assertEquals((int)1, (int)Booleans.indexOf((boolean[])ARRAY_FALSE_TRUE, (boolean)true));
        BooleansTest.assertEquals((int)2, (int)Booleans.indexOf((boolean[])new boolean[]{false, false, true}, (boolean)true));
    }

    public void testLastIndexOf() {
        BooleansTest.assertEquals((int)-1, (int)Booleans.lastIndexOf((boolean[])EMPTY, (boolean)false));
        BooleansTest.assertEquals((int)-1, (int)Booleans.lastIndexOf((boolean[])ARRAY_FALSE, (boolean)true));
        BooleansTest.assertEquals((int)-1, (int)Booleans.lastIndexOf((boolean[])ARRAY_FALSE_FALSE, (boolean)true));
        BooleansTest.assertEquals((int)0, (int)Booleans.lastIndexOf((boolean[])ARRAY_FALSE, (boolean)false));
        BooleansTest.assertEquals((int)0, (int)Booleans.lastIndexOf((boolean[])ARRAY_FALSE_TRUE, (boolean)false));
        BooleansTest.assertEquals((int)1, (int)Booleans.lastIndexOf((boolean[])ARRAY_FALSE_TRUE, (boolean)true));
        BooleansTest.assertEquals((int)2, (int)Booleans.lastIndexOf((boolean[])new boolean[]{false, true, true}, (boolean)true));
    }

    public void testConcat() {
        BooleansTest.assertTrue((boolean)Arrays.equals(EMPTY, Booleans.concat((boolean[][])new boolean[0][])));
        BooleansTest.assertTrue((boolean)Arrays.equals(EMPTY, Booleans.concat((boolean[][])new boolean[][]{EMPTY})));
        BooleansTest.assertTrue((boolean)Arrays.equals(EMPTY, Booleans.concat((boolean[][])new boolean[][]{EMPTY, EMPTY, EMPTY})));
        BooleansTest.assertTrue((boolean)Arrays.equals(ARRAY_FALSE, Booleans.concat((boolean[][])new boolean[][]{ARRAY_FALSE})));
        BooleansTest.assertNotSame((Object)ARRAY_FALSE, (Object)Booleans.concat((boolean[][])new boolean[][]{ARRAY_FALSE}));
        BooleansTest.assertTrue((boolean)Arrays.equals(ARRAY_FALSE, Booleans.concat((boolean[][])new boolean[][]{EMPTY, ARRAY_FALSE, EMPTY})));
        BooleansTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, false, false}, Booleans.concat((boolean[][])new boolean[][]{ARRAY_FALSE, ARRAY_FALSE, ARRAY_FALSE})));
        BooleansTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, false, true}, Booleans.concat((boolean[][])new boolean[][]{ARRAY_FALSE, ARRAY_FALSE_TRUE})));
    }

    public void testEnsureCapacity() {
        BooleansTest.assertSame((Object)EMPTY, (Object)Booleans.ensureCapacity((boolean[])EMPTY, (int)0, (int)1));
        BooleansTest.assertSame((Object)ARRAY_FALSE, (Object)Booleans.ensureCapacity((boolean[])ARRAY_FALSE, (int)0, (int)1));
        BooleansTest.assertSame((Object)ARRAY_FALSE, (Object)Booleans.ensureCapacity((boolean[])ARRAY_FALSE, (int)1, (int)1));
        BooleansTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false}, Booleans.ensureCapacity((boolean[])new boolean[]{true}, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Booleans.ensureCapacity((boolean[])ARRAY_FALSE, (int)-1, (int)1);
            BooleansTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Booleans.ensureCapacity((boolean[])ARRAY_FALSE, (int)1, (int)-1);
            BooleansTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoin() {
        BooleansTest.assertEquals((String)"", (String)Booleans.join((String)",", (boolean[])EMPTY));
        BooleansTest.assertEquals((String)"false", (String)Booleans.join((String)",", (boolean[])ARRAY_FALSE));
        BooleansTest.assertEquals((String)"false,true", (String)Booleans.join((String)",", (boolean[])new boolean[]{false, true}));
        BooleansTest.assertEquals((String)"falsetruefalse", (String)Booleans.join((String)"", (boolean[])new boolean[]{false, true, false}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new boolean[0], {false}, {false, false}, {false, true}, {true}, {true, false}, {true, true}, {true, true, true});
        Comparator comparator = Booleans.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Booleans.lexicographicalComparator();
        BooleansTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    public void testToArray() {
        List<Boolean> none = Arrays.asList(new Boolean[0]);
        BooleansTest.assertTrue((boolean)Arrays.equals(EMPTY, Booleans.toArray(none)));
        List<Boolean> one = Arrays.asList(false);
        BooleansTest.assertTrue((boolean)Arrays.equals(ARRAY_FALSE, Booleans.toArray(one)));
        boolean[] array = new boolean[]{false, false, true};
        List<Boolean> three = Arrays.asList(false, false, true);
        BooleansTest.assertTrue((boolean)Arrays.equals(array, Booleans.toArray(three)));
        BooleansTest.assertTrue((boolean)Arrays.equals(array, Booleans.toArray((Collection)Booleans.asList((boolean[])array))));
    }

    public void testToArray_threadSafe() {
        boolean[] VALUES = BooleansTest.VALUES;
        VALUES = Booleans.concat((boolean[][])new boolean[][]{VALUES, VALUES});
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Booleans.asList((boolean[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                boolean[] arr = Booleans.toArray((Collection)misleadingSize);
                BooleansTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    BooleansTest.assertEquals((boolean)VALUES[j], (boolean)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Boolean> list = Arrays.asList(false, true, null);
        try {
            Booleans.toArray(list);
            BooleansTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAsListIsEmpty() {
        BooleansTest.assertTrue((boolean)Booleans.asList((boolean[])EMPTY).isEmpty());
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE).isEmpty());
    }

    public void testAsListSize() {
        BooleansTest.assertEquals((int)0, (int)Booleans.asList((boolean[])EMPTY).size());
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])ARRAY_FALSE).size());
        BooleansTest.assertEquals((int)2, (int)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).size());
    }

    public void testAsListIndexOf() {
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])EMPTY).indexOf("wrong type"));
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])EMPTY).indexOf(true));
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])ARRAY_FALSE).indexOf(true));
        BooleansTest.assertEquals((int)0, (int)Booleans.asList((boolean[])ARRAY_FALSE).indexOf(false));
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).indexOf(true));
    }

    public void testAsListLastIndexOf() {
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])EMPTY).lastIndexOf("wrong type"));
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])EMPTY).lastIndexOf(true));
        BooleansTest.assertEquals((int)-1, (int)Booleans.asList((boolean[])ARRAY_FALSE).lastIndexOf(true));
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).lastIndexOf(true));
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])ARRAY_FALSE_FALSE).lastIndexOf(false));
    }

    public void testAsListContains() {
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])EMPTY).contains("wrong type"));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])EMPTY).contains(true));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE).contains(true));
        BooleansTest.assertTrue((boolean)Booleans.asList((boolean[])ARRAY_TRUE).contains(true));
        BooleansTest.assertTrue((boolean)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).contains(false));
        BooleansTest.assertTrue((boolean)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).contains(true));
    }

    public void testAsListEquals() {
        BooleansTest.assertEquals((Object)Booleans.asList((boolean[])EMPTY), Collections.emptyList());
        BooleansTest.assertEquals((Object)Booleans.asList((boolean[])ARRAY_FALSE), (Object)Booleans.asList((boolean[])ARRAY_FALSE));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE).equals(ARRAY_FALSE));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE).equals(null));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE).equals(Booleans.asList((boolean[])ARRAY_FALSE_TRUE)));
        BooleansTest.assertFalse((boolean)Booleans.asList((boolean[])ARRAY_FALSE_FALSE).equals(Booleans.asList((boolean[])ARRAY_FALSE_TRUE)));
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).lastIndexOf(true));
        List reference = Booleans.asList((boolean[])ARRAY_FALSE);
        BooleansTest.assertEquals((Object)Booleans.asList((boolean[])ARRAY_FALSE), (Object)reference);
        BooleansTest.assertEquals((Object)reference, (Object)reference);
    }

    public void testAsListHashcode() {
        BooleansTest.assertEquals((int)1, (int)Booleans.asList((boolean[])EMPTY).hashCode());
        BooleansTest.assertEquals((int)Booleans.asList((boolean[])ARRAY_FALSE).hashCode(), (int)Booleans.asList((boolean[])ARRAY_FALSE).hashCode());
        List reference = Booleans.asList((boolean[])ARRAY_FALSE);
        BooleansTest.assertEquals((int)Booleans.asList((boolean[])ARRAY_FALSE).hashCode(), (int)reference.hashCode());
    }

    public void testAsListToString() {
        BooleansTest.assertEquals((String)"[false]", (String)Booleans.asList((boolean[])ARRAY_FALSE).toString());
        BooleansTest.assertEquals((String)"[false, true]", (String)Booleans.asList((boolean[])ARRAY_FALSE_TRUE).toString());
    }

    public void testAsListSet() {
        List list = Booleans.asList((boolean[])ARRAY_FALSE);
        BooleansTest.assertFalse((boolean)list.set(0, true));
        BooleansTest.assertTrue((boolean)list.set(0, false));
        try {
            list.set(0, null);
            BooleansTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            list.set(1, true);
            BooleansTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testCountTrue() {
        BooleansTest.assertEquals((int)0, (int)Booleans.countTrue((boolean[])new boolean[0]));
        BooleansTest.assertEquals((int)0, (int)Booleans.countTrue((boolean[])new boolean[]{false}));
        BooleansTest.assertEquals((int)1, (int)Booleans.countTrue((boolean[])new boolean[]{true}));
        BooleansTest.assertEquals((int)3, (int)Booleans.countTrue((boolean[])new boolean[]{false, true, false, true, false, true}));
        BooleansTest.assertEquals((int)1, (int)Booleans.countTrue((boolean[])new boolean[]{false, false, true, false, false}));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Booleans.class);
    }
}

