/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.AndroidIncompatible;
import com.google.common.primitives.Doubles;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class DoublesTest
extends TestCase {
    private static final double[] EMPTY = new double[0];
    private static final double[] ARRAY1 = new double[]{1.0};
    private static final double[] ARRAY234 = new double[]{2.0, 3.0, 4.0};
    private static final double LEAST = Double.NEGATIVE_INFINITY;
    private static final double GREATEST = Double.POSITIVE_INFINITY;
    private static final double[] NUMBERS = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, -0.5, -0.1, -0.0, 0.0, 0.1, 0.5, 1.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.MIN_NORMAL, -2.2250738585072014E-308, Double.MIN_VALUE, -4.9E-324, -2.147483648E9, 2.147483647E9, -9.223372036854776E18, 9.223372036854776E18};
    private static final double[] VALUES = Doubles.concat((double[][])new double[][]{NUMBERS, {Double.NaN}});
    private static final String[] BAD_TRY_PARSE_INPUTS = new String[]{"", "+-", "+-0", " 5", "32 ", " 55 ", "infinity", "POSITIVE_INFINITY", "0x9A", "0x9A.bE-5", ".", ".e5", "NaNd", "InfinityF"};

    public void testHashCode() {
        for (double value : VALUES) {
            DoublesTest.assertEquals((int)Double.valueOf(value).hashCode(), (int)Doubles.hashCode((double)value));
        }
    }

    public void testIsFinite() {
        for (double value : NUMBERS) {
            DoublesTest.assertEquals((!Double.isNaN(value) && !Double.isInfinite(value) ? 1 : 0) != 0, (boolean)Doubles.isFinite((double)value));
        }
    }

    public void testCompare() {
        for (double x : VALUES) {
            for (double y : VALUES) {
                DoublesTest.assertEquals((String)(x + ", " + y), (int)Double.valueOf(x).compareTo(y), (int)Doubles.compare((double)x, (double)y));
            }
        }
    }

    public void testContains() {
        DoublesTest.assertFalse((boolean)Doubles.contains((double[])EMPTY, (double)1.0));
        DoublesTest.assertFalse((boolean)Doubles.contains((double[])ARRAY1, (double)2.0));
        DoublesTest.assertFalse((boolean)Doubles.contains((double[])ARRAY234, (double)1.0));
        DoublesTest.assertTrue((boolean)Doubles.contains((double[])new double[]{-1.0}, (double)-1.0));
        DoublesTest.assertTrue((boolean)Doubles.contains((double[])ARRAY234, (double)2.0));
        DoublesTest.assertTrue((boolean)Doubles.contains((double[])ARRAY234, (double)3.0));
        DoublesTest.assertTrue((boolean)Doubles.contains((double[])ARRAY234, (double)4.0));
        for (double value : NUMBERS) {
            DoublesTest.assertTrue((String)("" + value), (boolean)Doubles.contains((double[])new double[]{5.0, value}, (double)value));
        }
        DoublesTest.assertFalse((boolean)Doubles.contains((double[])new double[]{5.0, Double.NaN}, (double)Double.NaN));
    }

    public void testIndexOf() {
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])EMPTY, (double)1.0));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])ARRAY1, (double)2.0));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])ARRAY234, (double)1.0));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])new double[]{-1.0}, (double)-1.0));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])ARRAY234, (double)2.0));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])ARRAY234, (double)3.0));
        DoublesTest.assertEquals((int)2, (int)Doubles.indexOf((double[])ARRAY234, (double)4.0));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])new double[]{2.0, 3.0, 2.0, 3.0}, (double)3.0));
        for (double value : NUMBERS) {
            DoublesTest.assertEquals((String)("" + value), (int)1, (int)Doubles.indexOf((double[])new double[]{5.0, value}, (double)value));
        }
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])new double[]{5.0, Double.NaN}, (double)Double.NaN));
    }

    public void testIndexOf_arrayTarget() {
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])EMPTY, (double[])EMPTY));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])ARRAY234, (double[])EMPTY));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])EMPTY, (double[])ARRAY234));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])ARRAY234, (double[])ARRAY1));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])ARRAY1, (double[])ARRAY234));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])ARRAY1, (double[])ARRAY1));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])ARRAY234, (double[])ARRAY234));
        DoublesTest.assertEquals((int)0, (int)Doubles.indexOf((double[])ARRAY234, (double[])new double[]{2.0, 3.0}));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])ARRAY234, (double[])new double[]{3.0, 4.0}));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])ARRAY234, (double[])new double[]{3.0}));
        DoublesTest.assertEquals((int)2, (int)Doubles.indexOf((double[])ARRAY234, (double[])new double[]{4.0}));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])new double[]{2.0, 3.0, 3.0, 3.0, 3.0}, (double[])new double[]{3.0}));
        DoublesTest.assertEquals((int)2, (int)Doubles.indexOf((double[])new double[]{2.0, 3.0, 2.0, 3.0, 4.0, 2.0, 3.0}, (double[])new double[]{2.0, 3.0, 4.0}));
        DoublesTest.assertEquals((int)1, (int)Doubles.indexOf((double[])new double[]{2.0, 2.0, 3.0, 4.0, 2.0, 3.0, 4.0}, (double[])new double[]{2.0, 3.0, 4.0}));
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])new double[]{4.0, 3.0, 2.0}, (double[])new double[]{2.0, 3.0, 4.0}));
        for (double value : NUMBERS) {
            DoublesTest.assertEquals((String)("" + value), (int)1, (int)Doubles.indexOf((double[])new double[]{5.0, value, value, 5.0}, (double[])new double[]{value, value}));
        }
        DoublesTest.assertEquals((int)-1, (int)Doubles.indexOf((double[])new double[]{5.0, Double.NaN, Double.NaN, 5.0}, (double[])new double[]{Double.NaN, Double.NaN}));
    }

    public void testLastIndexOf() {
        DoublesTest.assertEquals((int)-1, (int)Doubles.lastIndexOf((double[])EMPTY, (double)1.0));
        DoublesTest.assertEquals((int)-1, (int)Doubles.lastIndexOf((double[])ARRAY1, (double)2.0));
        DoublesTest.assertEquals((int)-1, (int)Doubles.lastIndexOf((double[])ARRAY234, (double)1.0));
        DoublesTest.assertEquals((int)0, (int)Doubles.lastIndexOf((double[])new double[]{-1.0}, (double)-1.0));
        DoublesTest.assertEquals((int)0, (int)Doubles.lastIndexOf((double[])ARRAY234, (double)2.0));
        DoublesTest.assertEquals((int)1, (int)Doubles.lastIndexOf((double[])ARRAY234, (double)3.0));
        DoublesTest.assertEquals((int)2, (int)Doubles.lastIndexOf((double[])ARRAY234, (double)4.0));
        DoublesTest.assertEquals((int)3, (int)Doubles.lastIndexOf((double[])new double[]{2.0, 3.0, 2.0, 3.0}, (double)3.0));
        for (double value : NUMBERS) {
            DoublesTest.assertEquals((String)("" + value), (int)0, (int)Doubles.lastIndexOf((double[])new double[]{value, 5.0}, (double)value));
        }
        DoublesTest.assertEquals((int)-1, (int)Doubles.lastIndexOf((double[])new double[]{Double.NaN, 5.0}, (double)Double.NaN));
    }

    public void testMax_noArgs() {
        try {
            Doubles.max((double[])new double[0]);
            DoublesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        DoublesTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)Doubles.max((double[])new double[]{Double.NEGATIVE_INFINITY}));
        DoublesTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Doubles.max((double[])new double[]{Double.POSITIVE_INFINITY}));
        DoublesTest.assertEquals((Object)9.0, (Object)Doubles.max((double[])new double[]{8.0, 6.0, 7.0, 5.0, 3.0, 0.0, 9.0}));
        DoublesTest.assertEquals((Object)0.0, (Object)Doubles.max((double[])new double[]{-0.0, 0.0}));
        DoublesTest.assertEquals((Object)0.0, (Object)Doubles.max((double[])new double[]{0.0, -0.0}));
        DoublesTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Doubles.max((double[])NUMBERS));
        DoublesTest.assertTrue((boolean)Double.isNaN(Doubles.max((double[])VALUES)));
    }

    public void testMin_noArgs() {
        try {
            Doubles.min((double[])new double[0]);
            DoublesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        DoublesTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)Doubles.min((double[])new double[]{Double.NEGATIVE_INFINITY}));
        DoublesTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Doubles.min((double[])new double[]{Double.POSITIVE_INFINITY}));
        DoublesTest.assertEquals((Object)0.0, (Object)Doubles.min((double[])new double[]{8.0, 6.0, 7.0, 5.0, 3.0, 0.0, 9.0}));
        DoublesTest.assertEquals((Object)-0.0, (Object)Doubles.min((double[])new double[]{-0.0, 0.0}));
        DoublesTest.assertEquals((Object)-0.0, (Object)Doubles.min((double[])new double[]{0.0, -0.0}));
        DoublesTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)Doubles.min((double[])NUMBERS));
        DoublesTest.assertTrue((boolean)Double.isNaN(Doubles.min((double[])VALUES)));
    }

    public void testConcat() {
        DoublesTest.assertTrue((boolean)Arrays.equals(EMPTY, Doubles.concat((double[][])new double[0][])));
        DoublesTest.assertTrue((boolean)Arrays.equals(EMPTY, Doubles.concat((double[][])new double[][]{EMPTY})));
        DoublesTest.assertTrue((boolean)Arrays.equals(EMPTY, Doubles.concat((double[][])new double[][]{EMPTY, EMPTY, EMPTY})));
        DoublesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Doubles.concat((double[][])new double[][]{ARRAY1})));
        DoublesTest.assertNotSame((Object)ARRAY1, (Object)Doubles.concat((double[][])new double[][]{ARRAY1}));
        DoublesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Doubles.concat((double[][])new double[][]{EMPTY, ARRAY1, EMPTY})));
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 1.0, 1.0}, Doubles.concat((double[][])new double[][]{ARRAY1, ARRAY1, ARRAY1})));
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 3.0, 4.0}, Doubles.concat((double[][])new double[][]{ARRAY1, ARRAY234})));
    }

    public void testEnsureCapacity() {
        DoublesTest.assertSame((Object)EMPTY, (Object)Doubles.ensureCapacity((double[])EMPTY, (int)0, (int)1));
        DoublesTest.assertSame((Object)ARRAY1, (Object)Doubles.ensureCapacity((double[])ARRAY1, (int)0, (int)1));
        DoublesTest.assertSame((Object)ARRAY1, (Object)Doubles.ensureCapacity((double[])ARRAY1, (int)1, (int)1));
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 0.0, 0.0}, Doubles.ensureCapacity((double[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Doubles.ensureCapacity((double[])ARRAY1, (int)-1, (int)1);
            DoublesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Doubles.ensureCapacity((double[])ARRAY1, (int)1, (int)-1);
            DoublesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testJoin() {
        DoublesTest.assertEquals((String)"", (String)Doubles.join((String)",", (double[])EMPTY));
        DoublesTest.assertEquals((String)"1.0", (String)Doubles.join((String)",", (double[])ARRAY1));
        DoublesTest.assertEquals((String)"1.0,2.0", (String)Doubles.join((String)",", (double[])new double[]{1.0, 2.0}));
        DoublesTest.assertEquals((String)"1.02.03.0", (String)Doubles.join((String)"", (double[])new double[]{1.0, 2.0, 3.0}));
    }

    public void testJoinNonTrivialDoubles() {
        DoublesTest.assertEquals((String)"", (String)Doubles.join((String)",", (double[])EMPTY));
        DoublesTest.assertEquals((String)"1.2", (String)Doubles.join((String)",", (double[])new double[]{1.2}));
        DoublesTest.assertEquals((String)"1.3,2.4", (String)Doubles.join((String)",", (double[])new double[]{1.3, 2.4}));
        DoublesTest.assertEquals((String)"1.42.53.6", (String)Doubles.join((String)"", (double[])new double[]{1.4, 2.5, 3.6}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new double[0], {Double.NEGATIVE_INFINITY}, {Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}, {Double.NEGATIVE_INFINITY, 1.0}, {1.0}, {1.0, Double.NEGATIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.MAX_VALUE}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        Comparator comparator = Doubles.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Doubles.lexicographicalComparator();
        DoublesTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    @GwtIncompatible
    public void testStringConverterSerialization() {
        SerializableTester.reserializeAndAssert((Object)Doubles.stringConverter());
    }

    public void testToArray() {
        List<Double> none = Arrays.asList(new Double[0]);
        DoublesTest.assertTrue((boolean)Arrays.equals(EMPTY, Doubles.toArray(none)));
        List<Double> one = Arrays.asList(1.0);
        DoublesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Doubles.toArray(one)));
        double[] array = new double[]{0.0, 1.0, Math.PI};
        List<Double> three = Arrays.asList(0.0, 1.0, Math.PI);
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(three)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray((Collection)Doubles.asList((double[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Doubles.asList((double[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                double[] arr = Doubles.toArray((Collection)misleadingSize);
                DoublesTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    DoublesTest.assertEquals((Object)VALUES[j], (Object)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Double> list = Arrays.asList(0.0, 1.0, null);
        try {
            Doubles.toArray(list);
            DoublesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        double[] array = new double[]{0.0, 1.0, 2.0};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(bytes)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(shorts)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(ints)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(floats)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(longs)));
        DoublesTest.assertTrue((boolean)Arrays.equals(array, Doubles.toArray(doubles)));
    }

    public void testAsList_isAView() {
        double[] array = new double[]{0.0, 1.0};
        List list = Doubles.asList((double[])array);
        list.set(0, 2.0);
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{2.0, 1.0}, array));
        array[1] = 3.0;
        Truth.assertThat((Iterable)list).containsExactly(new Object[]{2.0, 3.0}).inOrder();
    }

    public void testAsList_toArray_roundTrip() {
        double[] array = new double[]{0.0, 1.0, 2.0};
        List list = Doubles.asList((double[])array);
        double[] newArray = Doubles.toArray((Collection)list);
        list.set(0, 4.0);
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{0.0, 1.0, 2.0}, newArray));
        newArray[1] = 5.0;
        DoublesTest.assertEquals((Object)1.0, (Object)((Double)list.get(1)));
    }

    public void testAsList_subList_toArray_roundTrip() {
        double[] array = new double[]{0.0, 1.0, 2.0, 3.0};
        List list = Doubles.asList((double[])array);
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0}, Doubles.toArray(list.subList(1, 3))));
        DoublesTest.assertTrue((boolean)Arrays.equals(new double[0], Doubles.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        DoublesTest.assertSame(Collections.emptyList(), (Object)Doubles.asList((double[])EMPTY));
    }

    private static Double referenceTryParse(String input) {
        if (input.trim().length() < input.length()) {
            return null;
        }
        try {
            return Double.valueOf(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @GwtIncompatible
    private static void checkTryParse(String input) {
        Double expected = DoublesTest.referenceTryParse(input);
        DoublesTest.assertEquals((Object)expected, (Object)Doubles.tryParse((String)input));
        if (expected != null && !Doubles.FLOATING_POINT_PATTERN.matcher(input).matches()) {
            StringBuilder escapedInput = new StringBuilder();
            for (char c : input.toCharArray()) {
                if (c >= ' ' && c <= '~') {
                    escapedInput.append(c);
                    continue;
                }
                escapedInput.append(String.format("\\u%04x", c));
            }
            DoublesTest.fail((String)("FLOATING_POINT_PATTERN should have matched valid input <" + escapedInput + ">"));
        }
    }

    @GwtIncompatible
    private static void checkTryParse(double expected, String input) {
        DoublesTest.assertEquals((Object)expected, (Object)Doubles.tryParse((String)input));
        Truth.assertThat((String)input).matches(Doubles.FLOATING_POINT_PATTERN);
    }

    @GwtIncompatible
    public void testTryParseHex() {
        for (String signChar : ImmutableList.of((Object)"", (Object)"+", (Object)"-")) {
            for (String hexPrefix : ImmutableList.of((Object)"0x", (Object)"0X")) {
                for (String iPart : ImmutableList.of((Object)"", (Object)"0", (Object)"1", (Object)"F", (Object)"f", (Object)"c4", (Object)"CE")) {
                    for (String fPart : ImmutableList.of((Object)"", (Object)".", (Object)".F", (Object)".52", (Object)".a")) {
                        for (String expMarker : ImmutableList.of((Object)"p", (Object)"P")) {
                            for (String exponent : ImmutableList.of((Object)"0", (Object)"-5", (Object)"+20", (Object)"52")) {
                                for (String typePart : ImmutableList.of((Object)"", (Object)"D", (Object)"F", (Object)"d", (Object)"f")) {
                                    DoublesTest.checkTryParse(signChar + hexPrefix + iPart + fPart + expMarker + exponent + typePart);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testTryParseAllCodePoints() {
        char[] tmp = new char[2];
        for (int i = 0; i < 0x10FFFF; ++i) {
            Character.toChars(i, tmp, 0);
            DoublesTest.checkTryParse(String.copyValueOf(tmp, 0, Character.charCount(i)));
        }
    }

    @GwtIncompatible
    public void testTryParseOfToStringIsOriginal() {
        for (double d : NUMBERS) {
            DoublesTest.checkTryParse(d, Double.toString(d));
        }
    }

    @GwtIncompatible
    public void testTryParseOfToHexStringIsOriginal() {
        for (double d : NUMBERS) {
            DoublesTest.checkTryParse(d, Double.toHexString(d));
        }
    }

    @GwtIncompatible
    public void testTryParseNaN() {
        DoublesTest.checkTryParse("NaN");
        DoublesTest.checkTryParse("+NaN");
        DoublesTest.checkTryParse("-NaN");
    }

    @GwtIncompatible
    public void testTryParseInfinity() {
        DoublesTest.checkTryParse(Double.POSITIVE_INFINITY, "Infinity");
        DoublesTest.checkTryParse(Double.POSITIVE_INFINITY, "+Infinity");
        DoublesTest.checkTryParse(Double.NEGATIVE_INFINITY, "-Infinity");
    }

    @GwtIncompatible
    public void testTryParseFailures() {
        for (String badInput : BAD_TRY_PARSE_INPUTS) {
            Truth.assertThat((String)badInput).doesNotMatch(Doubles.FLOATING_POINT_PATTERN);
            DoublesTest.assertEquals((Object)DoublesTest.referenceTryParse(badInput), (Object)Doubles.tryParse((String)badInput));
            DoublesTest.assertNull((Object)Doubles.tryParse((String)badInput));
        }
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Doubles.class);
    }

    public void testStringConverter_convert() {
        Converter converter = Doubles.stringConverter();
        DoublesTest.assertEquals((Object)1.0, (Object)converter.convert((Object)"1.0"));
        DoublesTest.assertEquals((Object)0.0, (Object)converter.convert((Object)"0.0"));
        DoublesTest.assertEquals((Object)-1.0, (Object)converter.convert((Object)"-1.0"));
        DoublesTest.assertEquals((Object)1.0, (Object)converter.convert((Object)"1"));
        DoublesTest.assertEquals((Object)0.0, (Object)converter.convert((Object)"0"));
        DoublesTest.assertEquals((Object)-1.0, (Object)converter.convert((Object)"-1"));
        DoublesTest.assertEquals((Object)1000000.0, (Object)converter.convert((Object)"1e6"));
        DoublesTest.assertEquals((Object)1.0E-6, (Object)converter.convert((Object)"1e-6"));
    }

    public void testStringConverter_convertError() {
        try {
            Doubles.stringConverter().convert((Object)"notanumber");
            DoublesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testStringConverter_nullConversions() {
        DoublesTest.assertNull((Object)Doubles.stringConverter().convert(null));
        DoublesTest.assertNull((Object)Doubles.stringConverter().reverse().convert(null));
    }

    @GwtIncompatible
    public void testStringConverter_reverse() {
        Converter converter = Doubles.stringConverter();
        DoublesTest.assertEquals((String)"1.0", (String)((String)converter.reverse().convert((Object)1.0)));
        DoublesTest.assertEquals((String)"0.0", (String)((String)converter.reverse().convert((Object)0.0)));
        DoublesTest.assertEquals((String)"-1.0", (String)((String)converter.reverse().convert((Object)-1.0)));
        DoublesTest.assertEquals((String)"1000000.0", (String)((String)converter.reverse().convert((Object)1000000.0)));
        DoublesTest.assertEquals((String)"1.0E-6", (String)((String)converter.reverse().convert((Object)1.0E-6)));
    }

    @GwtIncompatible
    public void testStringConverter_nullPointerTester() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)Doubles.stringConverter());
    }

    @GwtIncompatible
    public void testTryParse_withNullNoGwt() {
        DoublesTest.assertNull((Object)Doubles.tryParse((String)"null"));
        try {
            Doubles.tryParse(null);
            DoublesTest.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

