/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.AndroidIncompatible;
import com.google.common.primitives.Floats;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class FloatsTest
extends TestCase {
    private static final float[] EMPTY = new float[0];
    private static final float[] ARRAY1 = new float[]{1.0f};
    private static final float[] ARRAY234 = new float[]{2.0f, 3.0f, 4.0f};
    private static final float LEAST = Float.NEGATIVE_INFINITY;
    private static final float GREATEST = Float.POSITIVE_INFINITY;
    private static final float[] NUMBERS = new float[]{Float.NEGATIVE_INFINITY, -3.4028235E38f, -1.0f, -0.0f, 0.0f, 1.0f, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.MIN_NORMAL, -1.1754944E-38f, Float.MIN_VALUE, -1.4E-45f, -2.1474836E9f, 2.1474836E9f, -9.223372E18f, 9.223372E18f};
    private static final float[] VALUES = Floats.concat((float[][])new float[][]{NUMBERS, {Float.NaN}});
    private static final String[] BAD_TRY_PARSE_INPUTS = new String[]{"", "+-", "+-0", " 5", "32 ", " 55 ", "infinity", "POSITIVE_INFINITY", "0x9A", "0x9A.bE-5", ".", ".e5", "NaNd", "InfinityF"};

    public void testHashCode() {
        for (float value : VALUES) {
            FloatsTest.assertEquals((int)Float.valueOf(value).hashCode(), (int)Floats.hashCode((float)value));
        }
    }

    public void testIsFinite() {
        for (float value : NUMBERS) {
            FloatsTest.assertEquals((!Float.isInfinite(value) && !Float.isNaN(value) ? 1 : 0) != 0, (boolean)Floats.isFinite((float)value));
        }
    }

    public void testCompare() {
        for (float x : VALUES) {
            for (float y : VALUES) {
                FloatsTest.assertEquals((String)(x + ", " + y), (int)Float.valueOf(x).compareTo(Float.valueOf(y)), (int)Floats.compare((float)x, (float)y));
            }
        }
    }

    public void testContains() {
        FloatsTest.assertFalse((boolean)Floats.contains((float[])EMPTY, (float)1.0f));
        FloatsTest.assertFalse((boolean)Floats.contains((float[])ARRAY1, (float)2.0f));
        FloatsTest.assertFalse((boolean)Floats.contains((float[])ARRAY234, (float)1.0f));
        FloatsTest.assertTrue((boolean)Floats.contains((float[])new float[]{-1.0f}, (float)-1.0f));
        FloatsTest.assertTrue((boolean)Floats.contains((float[])ARRAY234, (float)2.0f));
        FloatsTest.assertTrue((boolean)Floats.contains((float[])ARRAY234, (float)3.0f));
        FloatsTest.assertTrue((boolean)Floats.contains((float[])ARRAY234, (float)4.0f));
        for (float value : NUMBERS) {
            FloatsTest.assertTrue((String)("" + value), (boolean)Floats.contains((float[])new float[]{5.0f, value}, (float)value));
        }
        FloatsTest.assertFalse((boolean)Floats.contains((float[])new float[]{5.0f, Float.NaN}, (float)Float.NaN));
    }

    public void testIndexOf() {
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])EMPTY, (float)1.0f));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])ARRAY1, (float)2.0f));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])ARRAY234, (float)1.0f));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])new float[]{-1.0f}, (float)-1.0f));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])ARRAY234, (float)2.0f));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])ARRAY234, (float)3.0f));
        FloatsTest.assertEquals((int)2, (int)Floats.indexOf((float[])ARRAY234, (float)4.0f));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])new float[]{2.0f, 3.0f, 2.0f, 3.0f}, (float)3.0f));
        for (float value : NUMBERS) {
            FloatsTest.assertEquals((String)("" + value), (int)1, (int)Floats.indexOf((float[])new float[]{5.0f, value}, (float)value));
        }
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])new float[]{5.0f, Float.NaN}, (float)Float.NaN));
    }

    public void testIndexOf_arrayTarget() {
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])EMPTY, (float[])EMPTY));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])ARRAY234, (float[])EMPTY));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])EMPTY, (float[])ARRAY234));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])ARRAY234, (float[])ARRAY1));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])ARRAY1, (float[])ARRAY234));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])ARRAY1, (float[])ARRAY1));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])ARRAY234, (float[])ARRAY234));
        FloatsTest.assertEquals((int)0, (int)Floats.indexOf((float[])ARRAY234, (float[])new float[]{2.0f, 3.0f}));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])ARRAY234, (float[])new float[]{3.0f, 4.0f}));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])ARRAY234, (float[])new float[]{3.0f}));
        FloatsTest.assertEquals((int)2, (int)Floats.indexOf((float[])ARRAY234, (float[])new float[]{4.0f}));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])new float[]{2.0f, 3.0f, 3.0f, 3.0f, 3.0f}, (float[])new float[]{3.0f}));
        FloatsTest.assertEquals((int)2, (int)Floats.indexOf((float[])new float[]{2.0f, 3.0f, 2.0f, 3.0f, 4.0f, 2.0f, 3.0f}, (float[])new float[]{2.0f, 3.0f, 4.0f}));
        FloatsTest.assertEquals((int)1, (int)Floats.indexOf((float[])new float[]{2.0f, 2.0f, 3.0f, 4.0f, 2.0f, 3.0f, 4.0f}, (float[])new float[]{2.0f, 3.0f, 4.0f}));
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])new float[]{4.0f, 3.0f, 2.0f}, (float[])new float[]{2.0f, 3.0f, 4.0f}));
        for (float value : NUMBERS) {
            FloatsTest.assertEquals((String)("" + value), (int)1, (int)Floats.indexOf((float[])new float[]{5.0f, value, value, 5.0f}, (float[])new float[]{value, value}));
        }
        FloatsTest.assertEquals((int)-1, (int)Floats.indexOf((float[])new float[]{5.0f, Float.NaN, Float.NaN, 5.0f}, (float[])new float[]{Float.NaN, Float.NaN}));
    }

    public void testLastIndexOf() {
        FloatsTest.assertEquals((int)-1, (int)Floats.lastIndexOf((float[])EMPTY, (float)1.0f));
        FloatsTest.assertEquals((int)-1, (int)Floats.lastIndexOf((float[])ARRAY1, (float)2.0f));
        FloatsTest.assertEquals((int)-1, (int)Floats.lastIndexOf((float[])ARRAY234, (float)1.0f));
        FloatsTest.assertEquals((int)0, (int)Floats.lastIndexOf((float[])new float[]{-1.0f}, (float)-1.0f));
        FloatsTest.assertEquals((int)0, (int)Floats.lastIndexOf((float[])ARRAY234, (float)2.0f));
        FloatsTest.assertEquals((int)1, (int)Floats.lastIndexOf((float[])ARRAY234, (float)3.0f));
        FloatsTest.assertEquals((int)2, (int)Floats.lastIndexOf((float[])ARRAY234, (float)4.0f));
        FloatsTest.assertEquals((int)3, (int)Floats.lastIndexOf((float[])new float[]{2.0f, 3.0f, 2.0f, 3.0f}, (float)3.0f));
        for (float value : NUMBERS) {
            FloatsTest.assertEquals((String)("" + value), (int)0, (int)Floats.lastIndexOf((float[])new float[]{value, 5.0f}, (float)value));
        }
        FloatsTest.assertEquals((int)-1, (int)Floats.lastIndexOf((float[])new float[]{Float.NaN, 5.0f}, (float)Float.NaN));
    }

    public void testMax_noArgs() {
        try {
            Floats.max((float[])new float[0]);
            FloatsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        FloatsTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(Floats.max((float[])new float[]{Float.POSITIVE_INFINITY})));
        FloatsTest.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Floats.max((float[])new float[]{Float.NEGATIVE_INFINITY})));
        FloatsTest.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf(Floats.max((float[])new float[]{8.0f, 6.0f, 7.0f, 5.0f, 3.0f, 0.0f, 9.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Floats.max((float[])new float[]{-0.0f, 0.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Floats.max((float[])new float[]{0.0f, -0.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(Floats.max((float[])NUMBERS)));
        FloatsTest.assertTrue((boolean)Float.isNaN(Floats.max((float[])VALUES)));
    }

    public void testMin_noArgs() {
        try {
            Floats.min((float[])new float[0]);
            FloatsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        FloatsTest.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Floats.min((float[])new float[]{Float.NEGATIVE_INFINITY})));
        FloatsTest.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(Floats.min((float[])new float[]{Float.POSITIVE_INFINITY})));
        FloatsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Floats.min((float[])new float[]{8.0f, 6.0f, 7.0f, 5.0f, 3.0f, 0.0f, 9.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(-0.0f), (Object)Float.valueOf(Floats.min((float[])new float[]{-0.0f, 0.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(-0.0f), (Object)Float.valueOf(Floats.min((float[])new float[]{0.0f, -0.0f})));
        FloatsTest.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Floats.min((float[])NUMBERS)));
        FloatsTest.assertTrue((boolean)Float.isNaN(Floats.min((float[])VALUES)));
    }

    public void testConcat() {
        FloatsTest.assertTrue((boolean)Arrays.equals(EMPTY, Floats.concat((float[][])new float[0][])));
        FloatsTest.assertTrue((boolean)Arrays.equals(EMPTY, Floats.concat((float[][])new float[][]{EMPTY})));
        FloatsTest.assertTrue((boolean)Arrays.equals(EMPTY, Floats.concat((float[][])new float[][]{EMPTY, EMPTY, EMPTY})));
        FloatsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Floats.concat((float[][])new float[][]{ARRAY1})));
        FloatsTest.assertNotSame((Object)ARRAY1, (Object)Floats.concat((float[][])new float[][]{ARRAY1}));
        FloatsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Floats.concat((float[][])new float[][]{EMPTY, ARRAY1, EMPTY})));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 1.0f, 1.0f}, Floats.concat((float[][])new float[][]{ARRAY1, ARRAY1, ARRAY1})));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, Floats.concat((float[][])new float[][]{ARRAY1, ARRAY234})));
    }

    public void testEnsureCapacity() {
        FloatsTest.assertSame((Object)EMPTY, (Object)Floats.ensureCapacity((float[])EMPTY, (int)0, (int)1));
        FloatsTest.assertSame((Object)ARRAY1, (Object)Floats.ensureCapacity((float[])ARRAY1, (int)0, (int)1));
        FloatsTest.assertSame((Object)ARRAY1, (Object)Floats.ensureCapacity((float[])ARRAY1, (int)1, (int)1));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 0.0f, 0.0f}, Floats.ensureCapacity((float[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Floats.ensureCapacity((float[])ARRAY1, (int)-1, (int)1);
            FloatsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Floats.ensureCapacity((float[])ARRAY1, (int)1, (int)-1);
            FloatsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testJoin() {
        FloatsTest.assertEquals((String)"", (String)Floats.join((String)",", (float[])EMPTY));
        FloatsTest.assertEquals((String)"1.0", (String)Floats.join((String)",", (float[])ARRAY1));
        FloatsTest.assertEquals((String)"1.0,2.0", (String)Floats.join((String)",", (float[])new float[]{1.0f, 2.0f}));
        FloatsTest.assertEquals((String)"1.02.03.0", (String)Floats.join((String)"", (float[])new float[]{1.0f, 2.0f, 3.0f}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new float[0], {Float.NEGATIVE_INFINITY}, {Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY}, {Float.NEGATIVE_INFINITY, 1.0f}, {1.0f}, {1.0f, Float.NEGATIVE_INFINITY}, {Float.POSITIVE_INFINITY, Float.MAX_VALUE}, {Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY}, {Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY});
        Comparator comparator = Floats.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Floats.lexicographicalComparator();
        FloatsTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    @GwtIncompatible
    public void testStringConverterSerialization() {
        SerializableTester.reserializeAndAssert((Object)Floats.stringConverter());
    }

    public void testToArray() {
        List<Float> none = Arrays.asList(new Float[0]);
        FloatsTest.assertTrue((boolean)Arrays.equals(EMPTY, Floats.toArray(none)));
        List<Float> one = Arrays.asList(Float.valueOf(1.0f));
        FloatsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Floats.toArray(one)));
        float[] array = new float[]{0.0f, 1.0f, 3.0f};
        List<Float> three = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(3.0f));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(three)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray((Collection)Floats.asList((float[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Floats.asList((float[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                float[] arr = Floats.toArray((Collection)misleadingSize);
                FloatsTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    FloatsTest.assertEquals((Object)Float.valueOf(VALUES[j]), (Object)Float.valueOf(arr[j]));
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Float> list = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), null);
        try {
            Floats.toArray(list);
            FloatsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        float[] array = new float[]{0.0f, 1.0f, 2.0f};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(bytes)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(shorts)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(ints)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(floats)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(longs)));
        FloatsTest.assertTrue((boolean)Arrays.equals(array, Floats.toArray(doubles)));
    }

    public void testAsList_isAView() {
        float[] array = new float[]{0.0f, 1.0f};
        List list = Floats.asList((float[])array);
        list.set(0, Float.valueOf(2.0f));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 1.0f}, array));
        array[1] = 3.0f;
        Truth.assertThat((Iterable)list).containsExactly(new Object[]{Float.valueOf(2.0f), Float.valueOf(3.0f)}).inOrder();
    }

    public void testAsList_toArray_roundTrip() {
        float[] array = new float[]{0.0f, 1.0f, 2.0f};
        List list = Floats.asList((float[])array);
        float[] newArray = Floats.toArray((Collection)list);
        list.set(0, Float.valueOf(4.0f));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{0.0f, 1.0f, 2.0f}, newArray));
        newArray[1] = 5.0f;
        FloatsTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((Float)list.get(1)).floatValue()));
    }

    public void testAsList_subList_toArray_roundTrip() {
        float[] array = new float[]{0.0f, 1.0f, 2.0f, 3.0f};
        List list = Floats.asList((float[])array);
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f}, Floats.toArray(list.subList(1, 3))));
        FloatsTest.assertTrue((boolean)Arrays.equals(new float[0], Floats.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        FloatsTest.assertSame(Collections.emptyList(), (Object)Floats.asList((float[])EMPTY));
    }

    private static Float referenceTryParse(String input) {
        if (input.trim().length() < input.length()) {
            return null;
        }
        try {
            return Float.valueOf(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @GwtIncompatible
    private static void checkTryParse(String input) {
        FloatsTest.assertEquals((Object)FloatsTest.referenceTryParse(input), (Object)Floats.tryParse((String)input));
    }

    @GwtIncompatible
    private static void checkTryParse(float expected, String input) {
        FloatsTest.assertEquals((Object)Float.valueOf(expected), (Object)Floats.tryParse((String)input));
    }

    @GwtIncompatible
    public void testTryParseHex() {
        for (String signChar : ImmutableList.of((Object)"", (Object)"+", (Object)"-")) {
            for (String hexPrefix : ImmutableList.of((Object)"0x", (Object)"0X")) {
                for (String iPart : ImmutableList.of((Object)"", (Object)"0", (Object)"1", (Object)"F", (Object)"f", (Object)"c4", (Object)"CE")) {
                    for (String fPart : ImmutableList.of((Object)"", (Object)".", (Object)".F", (Object)".52", (Object)".a")) {
                        for (String expMarker : ImmutableList.of((Object)"p", (Object)"P")) {
                            for (String exponent : ImmutableList.of((Object)"0", (Object)"-5", (Object)"+20", (Object)"52")) {
                                for (String typePart : ImmutableList.of((Object)"", (Object)"D", (Object)"F", (Object)"d", (Object)"f")) {
                                    FloatsTest.checkTryParse(signChar + hexPrefix + iPart + fPart + expMarker + exponent + typePart);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testTryParseAllCodePoints() {
        char[] tmp = new char[2];
        for (int i = 0; i < 0x10FFFF; ++i) {
            Character.toChars(i, tmp, 0);
            FloatsTest.checkTryParse(String.copyValueOf(tmp, 0, Character.charCount(i)));
        }
    }

    @GwtIncompatible
    public void testTryParseOfToStringIsOriginal() {
        for (float f : NUMBERS) {
            FloatsTest.checkTryParse(f, Float.toString(f));
        }
    }

    @GwtIncompatible
    public void testTryParseOfToHexStringIsOriginal() {
        for (float f : NUMBERS) {
            FloatsTest.checkTryParse(f, Float.toHexString(f));
        }
    }

    @GwtIncompatible
    public void testTryParseNaN() {
        FloatsTest.checkTryParse("NaN");
        FloatsTest.checkTryParse("+NaN");
        FloatsTest.checkTryParse("-NaN");
    }

    @GwtIncompatible
    public void testTryParseInfinity() {
        FloatsTest.checkTryParse(Float.POSITIVE_INFINITY, "Infinity");
        FloatsTest.checkTryParse(Float.POSITIVE_INFINITY, "+Infinity");
        FloatsTest.checkTryParse(Float.NEGATIVE_INFINITY, "-Infinity");
    }

    @GwtIncompatible
    public void testTryParseFailures() {
        for (String badInput : BAD_TRY_PARSE_INPUTS) {
            FloatsTest.assertEquals((Object)FloatsTest.referenceTryParse(badInput), (Object)Floats.tryParse((String)badInput));
            FloatsTest.assertNull((Object)Floats.tryParse((String)badInput));
        }
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Floats.class);
    }

    @GwtIncompatible
    public void testStringConverter_convert() {
        Converter converter = Floats.stringConverter();
        FloatsTest.assertEquals((Object)Float.valueOf(1.0f), (Object)converter.convert((Object)"1.0"));
        FloatsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)converter.convert((Object)"0.0"));
        FloatsTest.assertEquals((Object)Float.valueOf(-1.0f), (Object)converter.convert((Object)"-1.0"));
        FloatsTest.assertEquals((Object)Float.valueOf(1.0f), (Object)converter.convert((Object)"1"));
        FloatsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)converter.convert((Object)"0"));
        FloatsTest.assertEquals((Object)Float.valueOf(-1.0f), (Object)converter.convert((Object)"-1"));
        FloatsTest.assertEquals((Object)Float.valueOf(1000000.0f), (Object)converter.convert((Object)"1e6"));
        FloatsTest.assertEquals((Object)Float.valueOf(1.0E-6f), (Object)converter.convert((Object)"1e-6"));
    }

    public void testStringConverter_convertError() {
        try {
            Floats.stringConverter().convert((Object)"notanumber");
            FloatsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testStringConverter_nullConversions() {
        FloatsTest.assertNull((Object)Floats.stringConverter().convert(null));
        FloatsTest.assertNull((Object)Floats.stringConverter().reverse().convert(null));
    }

    @GwtIncompatible
    public void testStringConverter_reverse() {
        Converter converter = Floats.stringConverter();
        FloatsTest.assertEquals((String)"1.0", (String)((String)converter.reverse().convert((Object)Float.valueOf(1.0f))));
        FloatsTest.assertEquals((String)"0.0", (String)((String)converter.reverse().convert((Object)Float.valueOf(0.0f))));
        FloatsTest.assertEquals((String)"-1.0", (String)((String)converter.reverse().convert((Object)Float.valueOf(-1.0f))));
        FloatsTest.assertEquals((String)"1000000.0", (String)((String)converter.reverse().convert((Object)Float.valueOf(1000000.0f))));
        FloatsTest.assertEquals((String)"1.0E-6", (String)((String)converter.reverse().convert((Object)Float.valueOf(1.0E-6f))));
    }

    @GwtIncompatible
    public void testStringConverter_nullPointerTester() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)Floats.stringConverter());
    }

    @GwtIncompatible
    public void testTryParse_withNullNoGwt() {
        FloatsTest.assertNull((Object)Floats.tryParse((String)"null"));
        try {
            Floats.tryParse(null);
            FloatsTest.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

