/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class UnsignedBytesBenchmark {
    private byte[] ba1;
    private byte[] ba2;
    private byte[] ba3;
    private byte[] ba4;
    private Comparator<byte[]> javaImpl;
    private Comparator<byte[]> unsafeImpl;
    @Param(value={"4", "8", "64", "1024"})
    private int length;

    @BeforeExperiment
    void setUp() throws Exception {
        Random r = new Random();
        this.ba1 = new byte[this.length];
        r.nextBytes(this.ba1);
        this.ba2 = Arrays.copyOf(this.ba1, this.ba1.length);
        this.ba3 = Arrays.copyOf(this.ba1, this.ba1.length);
        this.ba4 = Arrays.copyOf(this.ba1, this.ba1.length);
        this.ba3[this.ba1.length - 1] = 43;
        this.ba4[this.ba1.length - 1] = 42;
        this.javaImpl = UnsignedBytes.lexicographicalComparatorJavaImpl();
        this.unsafeImpl = UnsignedBytes.LexicographicalComparatorHolder.UnsafeComparator.INSTANCE;
    }

    @Benchmark
    void longEqualJava(int reps) {
        for (int i = 0; i < reps; ++i) {
            if (this.javaImpl.compare(this.ba1, this.ba2) == 0) continue;
            throw new Error();
        }
    }

    @Benchmark
    void longEqualUnsafe(int reps) {
        for (int i = 0; i < reps; ++i) {
            if (this.unsafeImpl.compare(this.ba1, this.ba2) == 0) continue;
            throw new Error();
        }
    }

    @Benchmark
    void diffLastJava(int reps) {
        for (int i = 0; i < reps; ++i) {
            if (this.javaImpl.compare(this.ba3, this.ba4) != 0) continue;
            throw new Error();
        }
    }

    @Benchmark
    void diffLastUnsafe(int reps) {
        for (int i = 0; i < reps; ++i) {
            if (this.unsafeImpl.compare(this.ba3, this.ba4) != 0) continue;
            throw new Error();
        }
    }
}

