/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.math.BigInteger;
import java.util.Iterator;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class UnsignedLongTest
extends TestCase {
    private static final ImmutableSet<Long> TEST_LONGS;
    private static final ImmutableSet<BigInteger> TEST_BIG_INTEGERS;

    public void testAsUnsignedAndLongValueAreInverses() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            UnsignedLongTest.assertEquals((String)UnsignedLongs.toString((long)value), (long)value, (long)UnsignedLong.fromLongBits((long)value).longValue());
        }
    }

    public void testAsUnsignedBigIntegerValue() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            BigInteger expected = value >= 0L ? BigInteger.valueOf(value) : BigInteger.valueOf(value).add(BigInteger.ZERO.setBit(64));
            UnsignedLongTest.assertEquals((String)UnsignedLongs.toString((long)value), (Object)expected, (Object)UnsignedLong.fromLongBits((long)value).bigIntegerValue());
        }
    }

    public void testValueOfLong() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            boolean expectSuccess = value >= 0L;
            try {
                UnsignedLongTest.assertEquals((long)value, (long)UnsignedLong.valueOf((long)value).longValue());
                UnsignedLongTest.assertTrue((boolean)expectSuccess);
            }
            catch (IllegalArgumentException e) {
                UnsignedLongTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    public void testValueOfBigInteger() {
        BigInteger min = BigInteger.ZERO;
        BigInteger max = UnsignedLong.MAX_VALUE.bigIntegerValue();
        for (BigInteger big : TEST_BIG_INTEGERS) {
            boolean expectSuccess = big.compareTo(min) >= 0 && big.compareTo(max) <= 0;
            try {
                UnsignedLongTest.assertEquals((Object)big, (Object)UnsignedLong.valueOf((BigInteger)big).bigIntegerValue());
                UnsignedLongTest.assertTrue((boolean)expectSuccess);
            }
            catch (IllegalArgumentException e) {
                UnsignedLongTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    public void testToString() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            UnsignedLong unsignedValue = UnsignedLong.fromLongBits((long)value);
            UnsignedLongTest.assertEquals((String)unsignedValue.bigIntegerValue().toString(), (String)unsignedValue.toString());
        }
    }

    @GwtIncompatible
    public void testToStringRadix() {
        for (int radix = 2; radix <= 36; ++radix) {
            Iterator i$ = TEST_LONGS.iterator();
            while (i$.hasNext()) {
                long l = (Long)i$.next();
                UnsignedLong value = UnsignedLong.fromLongBits((long)l);
                UnsignedLongTest.assertEquals((String)value.bigIntegerValue().toString(radix), (String)value.toString(radix));
            }
        }
    }

    public void testToStringRadixQuick() {
        int[] radices;
        for (int radix : radices = new int[]{2, 3, 5, 7, 10, 12, 16, 21, 31, 36}) {
            Iterator i$ = TEST_LONGS.iterator();
            while (i$.hasNext()) {
                long l = (Long)i$.next();
                UnsignedLong value = UnsignedLong.fromLongBits((long)l);
                UnsignedLongTest.assertEquals((String)value.bigIntegerValue().toString(radix), (String)value.toString(radix));
            }
        }
    }

    public void testFloatValue() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            UnsignedLong unsignedValue = UnsignedLong.fromLongBits((long)value);
            UnsignedLongTest.assertEquals((Object)Float.valueOf(unsignedValue.bigIntegerValue().floatValue()), (Object)Float.valueOf(unsignedValue.floatValue()));
        }
    }

    public void testDoubleValue() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long value = (Long)i$.next();
            UnsignedLong unsignedValue = UnsignedLong.fromLongBits((long)value);
            UnsignedLongTest.assertEquals((Object)unsignedValue.bigIntegerValue().doubleValue(), (Object)unsignedValue.doubleValue());
        }
    }

    public void testPlus() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                long expected = aUnsigned.bigIntegerValue().add(bUnsigned.bigIntegerValue()).longValue();
                UnsignedLong unsignedSum = aUnsigned.plus(bUnsigned);
                UnsignedLongTest.assertEquals((long)expected, (long)unsignedSum.longValue());
            }
        }
    }

    public void testMinus() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                long expected = aUnsigned.bigIntegerValue().subtract(bUnsigned.bigIntegerValue()).longValue();
                UnsignedLong unsignedSub = aUnsigned.minus(bUnsigned);
                UnsignedLongTest.assertEquals((long)expected, (long)unsignedSub.longValue());
            }
        }
    }

    public void testTimes() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                long expected = aUnsigned.bigIntegerValue().multiply(bUnsigned.bigIntegerValue()).longValue();
                UnsignedLong unsignedMul = aUnsigned.times(bUnsigned);
                UnsignedLongTest.assertEquals((long)expected, (long)unsignedMul.longValue());
            }
        }
    }

    public void testDividedBy() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                if (b == 0L) continue;
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                long expected = aUnsigned.bigIntegerValue().divide(bUnsigned.bigIntegerValue()).longValue();
                UnsignedLong unsignedDiv = aUnsigned.dividedBy(bUnsigned);
                UnsignedLongTest.assertEquals((long)expected, (long)unsignedDiv.longValue());
            }
        }
    }

    public void testDivideByZeroThrows() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            try {
                UnsignedLong.fromLongBits((long)a).dividedBy(UnsignedLong.ZERO);
                UnsignedLongTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException expected) {}
        }
    }

    public void testMod() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                if (b == 0L) continue;
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                long expected = aUnsigned.bigIntegerValue().remainder(bUnsigned.bigIntegerValue()).longValue();
                UnsignedLong unsignedRem = aUnsigned.mod(bUnsigned);
                UnsignedLongTest.assertEquals((long)expected, (long)unsignedRem.longValue());
            }
        }
    }

    public void testModByZero() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            try {
                UnsignedLong.fromLongBits((long)a).mod(UnsignedLong.ZERO);
                UnsignedLongTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException expected) {}
        }
    }

    public void testCompare() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            Iterator i$2 = TEST_LONGS.iterator();
            while (i$2.hasNext()) {
                long b = (Long)i$2.next();
                UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
                UnsignedLong bUnsigned = UnsignedLong.fromLongBits((long)b);
                UnsignedLongTest.assertEquals((int)aUnsigned.bigIntegerValue().compareTo(bUnsigned.bigIntegerValue()), (int)aUnsigned.compareTo(bUnsigned));
            }
        }
    }

    @GwtIncompatible
    public void testEquals() {
        EqualsTester equalsTester = new EqualsTester();
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            BigInteger big = a >= 0L ? BigInteger.valueOf(a) : BigInteger.valueOf(a).add(BigInteger.ZERO.setBit(64));
            equalsTester.addEqualityGroup(new Object[]{UnsignedLong.fromLongBits((long)a), UnsignedLong.valueOf((BigInteger)big), UnsignedLong.valueOf((String)big.toString()), UnsignedLong.valueOf((String)big.toString(16), (int)16)});
        }
        equalsTester.testEquals();
    }

    public void testIntValue() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            UnsignedLong aUnsigned = UnsignedLong.fromLongBits((long)a);
            int intValue = aUnsigned.bigIntegerValue().intValue();
            UnsignedLongTest.assertEquals((int)intValue, (int)aUnsigned.intValue());
        }
    }

    @GwtIncompatible
    public void testSerialization() {
        Iterator i$ = TEST_LONGS.iterator();
        while (i$.hasNext()) {
            long a = (Long)i$.next();
            SerializableTester.reserializeAndAssert((Object)UnsignedLong.fromLongBits((long)a));
        }
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedLong.class);
    }

    static {
        ImmutableSet.Builder testLongsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder testBigIntegersBuilder = ImmutableSet.builder();
        for (long i = -3L; i <= 3L; ++i) {
            testLongsBuilder.add((Object)i).add((Object)(Long.MAX_VALUE + i)).add((Object)(Long.MIN_VALUE + i)).add((Object)(Integer.MIN_VALUE + i)).add((Object)(Integer.MAX_VALUE + i));
            BigInteger bigI = BigInteger.valueOf(i);
            testBigIntegersBuilder.add((Object)bigI).add((Object)BigInteger.valueOf(Long.MAX_VALUE).add(bigI)).add((Object)BigInteger.valueOf(Long.MIN_VALUE).add(bigI)).add((Object)BigInteger.valueOf(Integer.MAX_VALUE).add(bigI)).add((Object)BigInteger.valueOf(Integer.MIN_VALUE).add(bigI)).add((Object)BigInteger.ONE.shiftLeft(63).add(bigI)).add((Object)BigInteger.ONE.shiftLeft(64).add(bigI));
        }
        TEST_LONGS = testLongsBuilder.build();
        TEST_BIG_INTEGERS = testBigIntegersBuilder.build();
    }
}

