/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import com.google.common.truth.Truth;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

@AndroidIncompatible
public class TypeTokenResolutionTest
extends TestCase {
    public void testSimpleTypeToken() {
        Foo<String, Integer> foo = new Foo<String, Integer>(){};
        TypeTokenResolutionTest.assertEquals(String.class, foo.getClassA());
        TypeTokenResolutionTest.assertEquals(Integer.class, foo.getClassB());
        TypeTokenResolutionTest.assertEquals(String[].class, foo.getArrayClassA());
        TypeTokenResolutionTest.assertEquals(Integer[].class, foo.getArrayClassB());
    }

    public void testCompositeTypeToken() {
        Foo<String[], List<int[]>> foo = new Foo<String[], List<int[]>>(){};
        TypeTokenResolutionTest.assertEquals(String[].class, foo.getClassA());
        TypeTokenResolutionTest.assertEquals(List.class, foo.getClassB());
        TypeTokenResolutionTest.assertEquals(String[][].class, foo.getArrayClassA());
        TypeTokenResolutionTest.assertEquals(List[].class, foo.getArrayClassB());
    }

    public void testPartialSpecialization() {
        StringFoo<Integer> foo = new StringFoo<Integer>(){};
        TypeTokenResolutionTest.assertEquals(String.class, foo.getClassA());
        TypeTokenResolutionTest.assertEquals(Integer.class, foo.getClassB());
        TypeTokenResolutionTest.assertEquals(String[].class, foo.getArrayClassA());
        TypeTokenResolutionTest.assertEquals(Integer[].class, foo.getArrayClassB());
        TypeTokenResolutionTest.assertEquals((Object)new TypeToken<String[]>(){}.getType(), (Object)foo.getArrayTypeA());
    }

    public void testTypeArgNotFound() {
        StringFoo foo = new StringFoo();
        TypeTokenResolutionTest.assertEquals(String.class, foo.getClassA());
        TypeTokenResolutionTest.assertEquals(String[].class, foo.getArrayClassA());
        TypeTokenResolutionTest.assertEquals(Object.class, foo.getClassB());
        TypeTokenResolutionTest.assertEquals(Object[].class, foo.getArrayClassB());
    }

    public void testResolveType_parameterizedType() {
        Parameterized<TypeTokenResolutionTest, Bar, String> parameterized = new Parameterized<TypeTokenResolutionTest, Bar, String>(){};
        TypeResolver typeResolver = TypeResolver.accordingTo(parameterized.getClass());
        ParameterizedType resolved = (ParameterizedType)typeResolver.resolveType((Type)parameterized.parameterizedType());
        TypeTokenResolutionTest.assertEquals(TypeTokenResolutionTest.class, (Object)resolved.getOwnerType());
        TypeTokenResolutionTest.assertEquals(Bar.class, (Object)resolved.getRawType());
        Truth.assertThat((Object[])resolved.getActualTypeArguments()).asList().contains(String.class);
    }

    public void testGenericInterface() {
        TypeVariable fType = Supplier.class.getTypeParameters()[0];
        TypeTokenResolutionTest.assertEquals(Integer.class, (Object)TypeToken.of(IntegerStringFunction.class).resolveType(fType).getRawType());
        TypeVariable predicateParameterType = Predicate.class.getTypeParameters()[0];
        TypeTokenResolutionTest.assertEquals((Object)new TypeToken<List<String>>(){}.getType(), (Object)TypeToken.of(IntegerStringFunction.class).resolveType(predicateParameterType).getType());
    }

    public void testConstructor_typeArgsResolvedFromAncestorClass() {
        TypeTokenResolutionTest.assertEquals(String.class, new StringIntegerFoo(){}.getClassA());
        TypeTokenResolutionTest.assertEquals(Integer.class, new StringIntegerFoo(){}.getClassB());
    }

    public void testResolveNestedClass() {
        TypeTokenResolutionTest.assertEquals(String.class, new Owner.Nested<String>(){}.getTypeArgument());
    }

    public void testResolveInnerClass() {
        TypeTokenResolutionTest.assertEquals(String.class, new Owner.Inner<String>(new Owner()){
            {
                Owner owner = x0;
                owner.getClass();
            }
        }.getTypeArgument());
    }

    public void testResolveOwnerClass() {
        TypeTokenResolutionTest.assertEquals(Integer.class, new Owner.Inner<String>(new Owner()){
            {
                Owner owner = x0;
                owner.getClass();
            }
        }.getOwnerType());
    }

    public void testCyclicMapping() {
        Mapping mapping = new Mapping();
        TypeTokenResolutionTest.assertEquals((Object)mapping.f, (Object)mapping.getFromType());
        TypeTokenResolutionTest.assertEquals((Object)mapping.t, (Object)mapping.getToType());
        TypeTokenResolutionTest.assertEquals((Object)mapping.f, (Object)mapping.flip().getFromType());
        TypeTokenResolutionTest.assertEquals((Object)mapping.t, (Object)mapping.flip().getToType());
        TypeTokenResolutionTest.assertEquals((Object)mapping.f, (Object)mapping.selfMapping().getFromType());
        TypeTokenResolutionTest.assertEquals((Object)mapping.t, (Object)mapping.selfMapping().getToType());
    }

    public void testInnerClassWithParameterizedOwner() throws Exception {
        Type fieldType = ParameterizedOuter.class.getField("field").getGenericType();
        TypeTokenResolutionTest.assertEquals((Object)fieldType, (Object)TypeToken.of(ParameterizedOuter.class).resolveType(fieldType).getType());
    }

    public void testResolveType() {
        TypeTokenResolutionTest.assertEquals(String.class, (Object)TypeToken.of(((Object)((Object)this)).getClass()).resolveType(String.class).getType());
        TypeTokenResolutionTest.assertEquals(String.class, (Object)TypeToken.of(StringIterable.class).resolveType(Iterable.class.getTypeParameters()[0]).getType());
        TypeTokenResolutionTest.assertEquals(String.class, (Object)TypeToken.of(StringIterable.class).resolveType(Iterable.class.getTypeParameters()[0]).getType());
        try {
            TypeToken.of(((Object)((Object)this)).getClass()).resolveType(null);
            TypeTokenResolutionTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConextIsParameterizedType() throws Exception {
        class Context {
            Context() {
            }

            Map<String, Integer> returningMap() {
                throw new AssertionError();
            }
        }
        Type context = Context.class.getDeclaredMethod("returningMap", new Class[0]).getGenericReturnType();
        TypeVariable keyType = Map.class.getTypeParameters()[0];
        TypeVariable valueType = Map.class.getTypeParameters()[1];
        TypeTokenResolutionTest.assertEquals(String.class, (Object)TypeToken.of((Type)context).resolveType(keyType).getType());
        TypeTokenResolutionTest.assertEquals(Integer.class, (Object)TypeToken.of((Type)context).resolveType(valueType).getType());
        TypeTokenResolutionTest.assertEquals(keyType, (Object)TypeToken.of(keyType).resolveType(keyType).getType());
        TypeTokenResolutionTest.assertEquals(valueType, (Object)TypeToken.of(valueType).resolveType(valueType).getType());
    }

    public void testGenericArrayType() {
        GenericArray genericArray = new GenericArray();
        TypeTokenResolutionTest.assertEquals(GenericArray.class.getTypeParameters()[0], (Object)genericArray.t);
        TypeTokenResolutionTest.assertEquals((Object)Types.newArrayType((Type)genericArray.t), (Object)genericArray.array);
    }

    public void testClassWrapper() {
        TypeToken typeExpression = TypeToken.of(String.class);
        TypeTokenResolutionTest.assertEquals(String.class, (Object)typeExpression.getType());
        TypeTokenResolutionTest.assertEquals(String.class, (Object)typeExpression.getRawType());
    }

    public void test1() {
        Red<String> redString = new Red<String>(){};
        Red<Integer> redInteger = new Red<Integer>(){};
        TypeTokenResolutionTest.assertEquals(String.class, redString.getClassDirect());
        TypeTokenResolutionTest.assertEquals(Integer.class, redInteger.getClassDirect());
        Red<String> red = redString;
        red.getClass();
        Red.Yellow<Integer> yellowInteger = new Red.Yellow<Integer>((Red)red, (Red)redInteger){
            {
                Red red = x0;
                red.getClass();
                super(x1);
            }
        };
        TypeTokenResolutionTest.assertEquals(Integer.class, yellowInteger.getClassA());
        TypeTokenResolutionTest.assertEquals(Integer.class, yellowInteger.getClassB());
        TypeTokenResolutionTest.assertEquals(String.class, yellowInteger.getA().getClassDirect());
        TypeTokenResolutionTest.assertEquals(Integer.class, yellowInteger.getB().getClassDirect());
    }

    public void test2() {
        Red redString = new Red();
        Red redInteger = new Red();
        Red red = redString;
        red.getClass();
        Red.Yellow<Integer> yellowInteger = new Red.Yellow<Integer>(red, redInteger){
            {
                Red red = x0;
                red.getClass();
                super(x1);
            }
        };
        TypeTokenResolutionTest.assertEquals(Integer.class, yellowInteger.getClassA());
        TypeTokenResolutionTest.assertEquals(Integer.class, yellowInteger.getClassB());
    }

    private static <T> Type staticMethodWithLocalClass() {
        class MyLocalClass {
            MyLocalClass() {
            }

            Type getType() {
                return new TypeToken<T>(this.getClass()){}.getType();
            }
        }
        return new MyLocalClass().getType();
    }

    public void testLocalClassInsideStaticMethod() {
        TypeTokenResolutionTest.assertNotNull((Object)TypeTokenResolutionTest.staticMethodWithLocalClass());
    }

    public void testLocalClassInsideNonStaticMethod() {
        class MyLocalClass<T> {
            MyLocalClass() {
            }

            Type getType() {
                return new TypeToken<T>(this.getClass()){}.getType();
            }
        }
        TypeTokenResolutionTest.assertNotNull((Object)new MyLocalClass().getType());
    }

    private static <T> Type staticMethodWithAnonymousClass() {
        return new Object(){

            Type getType() {
                return new TypeToken<T>(this.getClass()){}.getType();
            }
        }.getType();
    }

    public void testAnonymousClassInsideStaticMethod() {
        TypeTokenResolutionTest.assertNotNull((Object)TypeTokenResolutionTest.staticMethodWithAnonymousClass());
    }

    public void testAnonymousClassInsideNonStaticMethod() {
        TypeTokenResolutionTest.assertNotNull((Object)new Object(){

            Type getType() {
                return new TypeToken<Object>(){}.getType();
            }
        }.getType());
    }

    public void testStaticContext() {
        TypeTokenResolutionTest.assertEquals(Map.class, (Object)TypeTokenResolutionTest.mapType().getRawType());
    }

    public void testResolvePrimitiveArrayType() {
        TypeTokenResolutionTest.assertEquals((Object)new TypeToken<int[]>(){}.getType(), (Object)new Holder<int[]>(){}.getContentType());
        TypeTokenResolutionTest.assertEquals((Object)new TypeToken<int[][]>(){}.getType(), (Object)new Holder<int[][]>(){}.getContentType());
    }

    public void testResolveToGenericArrayType() {
        GenericArrayType arrayType = (GenericArrayType)new Holder<List<int[][]>[]>(){}.getContentType();
        ParameterizedType listType = (ParameterizedType)arrayType.getGenericComponentType();
        TypeTokenResolutionTest.assertEquals(List.class, (Object)listType.getRawType());
        TypeTokenResolutionTest.assertEquals((Object)Types.newArrayType(int[].class), (Object)listType.getActualTypeArguments()[0]);
    }

    public void testWithGenericBoundInTypeVariable() throws Exception {
        TypeVariable typeVariable = (TypeVariable)new WithGenericBound<String>(){}.getTargetType("withTypeVariable");
        TypeTokenResolutionTest.assertEquals(String.class, (Object)typeVariable.getBounds()[0]);
    }

    public void testWithRecursiveBoundInTypeVariable() throws Exception {
        TypeVariable typeVariable = (TypeVariable)new WithGenericBound<String>(){}.getTargetType("withRecursiveBound");
        TypeTokenResolutionTest.assertEquals((Object)Types.newParameterizedType(Enum.class, (Type[])new Type[]{typeVariable}), (Object)typeVariable.getBounds()[0]);
    }

    public void testWithMutualRecursiveBoundInTypeVariable() throws Exception {
        ParameterizedType paramType = (ParameterizedType)new WithGenericBound<String>(){}.getTargetType("withMutualRecursiveBound");
        TypeVariable k = (TypeVariable)paramType.getActualTypeArguments()[0];
        TypeVariable v = (TypeVariable)paramType.getActualTypeArguments()[1];
        TypeTokenResolutionTest.assertEquals((Object)Types.newParameterizedType(List.class, (Type[])new Type[]{v}), (Object)k.getBounds()[0]);
        TypeTokenResolutionTest.assertEquals((Object)Types.newParameterizedType(List.class, (Type[])new Type[]{k}), (Object)v.getBounds()[0]);
    }

    public void testWithGenericLowerBoundInWildcard() throws Exception {
        WildcardType wildcardType = (WildcardType)new WithGenericBound<String>(){}.getTargetType("withWildcardLowerBound");
        TypeTokenResolutionTest.assertEquals(String.class, (Object)wildcardType.getLowerBounds()[0]);
    }

    public void testWithGenericUpperBoundInWildcard() throws Exception {
        WildcardType wildcardType = (WildcardType)new WithGenericBound<String>(){}.getTargetType("withWildcardUpperBound");
        TypeTokenResolutionTest.assertEquals(String.class, (Object)wildcardType.getUpperBounds()[0]);
    }

    public void testInterfaceTypeParameterResolution() throws Exception {
        TypeTokenResolutionTest.assertEquals(String.class, (Object)TypeToken.of((Type)new TypeToken<ArrayList<String>>(){}.getType()).resolveType(List.class.getTypeParameters()[0]).getType());
    }

    private static TypeToken<Map<Object, Object>> mapType() {
        return new TypeToken<Map<Object, Object>>(){};
    }

    public void testFalseRecursiveType_mappingOnTheSameDeclarationNotUsed() {
        Type returnType = TypeTokenResolutionTest.genericReturnType(WithFalseRecursiveType.class, "keyShouldNotResolveToStringList");
        TypeToken keyType = TypeToken.of((Type)returnType).resolveType(WithFalseRecursiveType.class.getTypeParameters()[0]);
        TypeTokenResolutionTest.assertEquals((String)"java.util.List<V>", (String)keyType.getType().toString());
    }

    public void testFalseRecursiveType_notRealRecursiveMapping() {
        Type returnType = TypeTokenResolutionTest.genericReturnType(WithFalseRecursiveType.class, "shouldNotCauseInfiniteLoop");
        TypeToken keyType = TypeToken.of((Type)returnType).resolveType(WithFalseRecursiveType.class.getTypeParameters()[0]);
        TypeTokenResolutionTest.assertEquals((String)"java.util.List<K>", (String)keyType.getType().toString());
    }

    public void testFalseRecursiveType_referenceOfSubtypeDoesNotConfuseMe() {
        Type returnType = TypeTokenResolutionTest.genericReturnType(WithFalseRecursiveType.class, "evenSubtypeWorks");
        TypeToken keyType = TypeToken.of((Type)returnType).resolveType(WithFalseRecursiveType.class.getTypeParameters()[0]);
        TypeTokenResolutionTest.assertEquals((String)"java.util.List<java.util.List<V>>", (String)keyType.getType().toString());
    }

    public void testFalseRecursiveType_intermediaryTypeMappingDoesNotConfuseMe() {
        Type returnType = TypeTokenResolutionTest.genericReturnType(SubtypeOfWithFalseRecursiveType.class, "revertKeyAndValueTypes");
        TypeToken keyType = TypeToken.of((Type)returnType).resolveType(WithFalseRecursiveType.class.getTypeParameters()[0]);
        TypeTokenResolutionTest.assertEquals((String)"java.util.List<K1>", (String)keyType.getType().toString());
    }

    private static Type genericReturnType(Class<?> cls, String methodName) {
        try {
            return cls.getMethod(methodName, new Class[0]).getGenericReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testTwoStageResolution() {
        class ForTwoStageResolution<A extends Number> {
            ForTwoStageResolution() {
            }

            <B extends A> void verifyTwoStageResolution() {
                Type type = new TypeToken<B>(this.getClass()){}.where(new TypeParameter<B>(){}, Integer.class).getType();
                Assert.assertEquals(Integer.class, (Object)type);
            }
        }
        new ForTwoStageResolution().verifyTwoStageResolution();
        new ForTwoStageResolution<Integer>(){
            {
            }
        }.verifyTwoStageResolution();
    }

    private static interface SubtypeOfWithFalseRecursiveType<K1, V1>
    extends WithFalseRecursiveType<List<K1>, List<V1>> {
        public SubtypeOfWithFalseRecursiveType<V1, K1> revertKeyAndValueTypes();
    }

    private static interface WithFalseRecursiveType<K, V> {
        public WithFalseRecursiveType<List<V>, String> keyShouldNotResolveToStringList();

        public WithFalseRecursiveType<List<K>, List<V>> shouldNotCauseInfiniteLoop();

        public SubtypeOfWithFalseRecursiveType<List<V>, List<K>> evenSubtypeWorks();
    }

    private abstract class WithGenericBound<A> {
        private WithGenericBound() {
        }

        public <B extends A> void withTypeVariable(List<B> list) {
        }

        public <E extends Enum<E>> void withRecursiveBound(List<E> list) {
        }

        public <K extends List<V>, V extends List<K>> void withMutualRecursiveBound(List<Map<K, V>> list) {
        }

        void withWildcardLowerBound(List<? super A> list) {
        }

        void withWildcardUpperBound(List<? extends A> list) {
        }

        Type getTargetType(String methodName) throws Exception {
            ParameterizedType parameterType = (ParameterizedType)WithGenericBound.class.getDeclaredMethod(methodName, List.class).getGenericParameterTypes()[0];
            parameterType = (ParameterizedType)TypeToken.of(this.getClass()).resolveType((Type)parameterType).getType();
            return parameterType.getActualTypeArguments()[0];
        }
    }

    private static abstract class Holder<T> {
        private Holder() {
        }

        Type getContentType() {
            return new TypeToken<T>(this.getClass()){}.getType();
        }
    }

    private static class Red<A> {
        private Red() {
        }

        Red<A> getSelfA() {
            return this;
        }

        Class<?> getClassDirect() {
            return new TypeToken<A>(this.getClass()){}.getRawType();
        }

        private class Yellow<B>
        extends Orange {
            Yellow(Red<B> red2) {
                Red<B> red3 = red2;
                red3.getClass();
            }

            Class<?> getClassB() {
                return new TypeToken<B>(this.getClass()){}.getRawType();
            }

            Red<A> getA() {
                return Red.this.getSelfA();
            }

            Red<B> getB() {
                return this.getSelfB();
            }
        }

        private class Orange {
            private Orange() {
            }

            Class<?> getClassA() {
                return new TypeToken<A>(this.getClass()){}.getRawType();
            }

            Red<A> getSelfB() {
                return Red.this;
            }
        }
    }

    private static final class GenericArray<T> {
        final Type t = new TypeToken<T>(this.getClass()){}.getType();
        final Type array = new TypeToken<T[]>(this.getClass()){}.getType();

        private GenericArray() {
        }
    }

    private static interface StringIterable
    extends Iterable<String> {
    }

    private static class ParameterizedOuter<T> {
        public Inner field;

        private ParameterizedOuter() {
        }

        class Inner {
            Inner() {
            }
        }
    }

    private static class Mapping<F, T> {
        final Type f = new TypeToken<F>(this.getClass()){}.getType();
        final Type t = new TypeToken<T>(this.getClass()){}.getType();

        private Mapping() {
        }

        Type getFromType() {
            return new TypeToken<F>(this.getClass()){}.getType();
        }

        Type getToType() {
            return new TypeToken<T>(this.getClass()){}.getType();
        }

        Mapping<T, F> flip() {
            return new Mapping<T, F>(){};
        }

        Mapping<F, T> selfMapping() {
            return new Mapping<F, T>(){};
        }
    }

    private static class Owner<T> {
        private Owner() {
        }

        private abstract class Inner<Y>
        extends Nested<Y> {
            private Inner() {
            }

            Class<? super T> getOwnerType() {
                return new TypeToken<T>(this.getClass()){}.getRawType();
            }
        }

        private static abstract class Nested<X> {
            private Nested() {
            }

            Class<? super X> getTypeArgument() {
                return new TypeToken<X>(this.getClass()){}.getRawType();
            }
        }
    }

    private static abstract class StringIntegerFoo
    extends Foo<String, Integer> {
        private StringIntegerFoo() {
        }
    }

    private static interface IntegerStringFunction
    extends IntegerSupplier,
    Predicate<List<String>>,
    StringListPredicate {
    }

    private static interface IntegerSupplier
    extends Supplier<Integer> {
    }

    private static interface StringListPredicate
    extends Predicate<List<String>> {
    }

    private static abstract class Parameterized<O, T, P> {
        private Parameterized() {
        }

        ParameterizedType parameterizedType() {
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{new TypeCapture<P>(){}.capture()};
                }

                @Override
                public Type getOwnerType() {
                    return new TypeCapture<O>(){}.capture();
                }

                @Override
                public Type getRawType() {
                    return new TypeCapture<T>(){}.capture();
                }
            };
        }
    }

    private static abstract class Bar<T> {
        private Bar() {
        }
    }

    private static class StringFoo<T>
    extends Foo<String, T> {
        private StringFoo() {
        }
    }

    private static class Foo<A, B> {
        private Foo() {
        }

        Class<? super A> getClassA() {
            return new TypeToken<A>(this.getClass()){}.getRawType();
        }

        Class<? super B> getClassB() {
            return new TypeToken<B>(this.getClass()){}.getRawType();
        }

        Class<? super A[]> getArrayClassA() {
            return new TypeToken<A[]>(this.getClass()){}.getRawType();
        }

        Type getArrayTypeA() {
            return new TypeToken<A[]>(this.getClass()){}.getType();
        }

        Class<? super B[]> getArrayClassB() {
            return new TypeToken<B[]>(this.getClass()){}.getRawType();
        }
    }
}

