/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Param;
import com.google.caliper.api.Footprint;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.common.util.concurrent.AbstractFutureBenchmarks;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Runnables;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

public class AbstractFutureFootprintBenchmark {
    @Param
    State state;
    @Param
    AbstractFutureBenchmarks.Impl impl;
    @Param(value={"0", "1", "5", "10"})
    int numListeners;
    @Param(value={"0", "1", "5", "10"})
    int numThreads;
    private final Set<Thread> blockedThreads = new HashSet<Thread>();

    @BeforeExperiment
    void setUp() throws Exception {
        if (this.state != State.NOT_DONE && (this.numListeners != 0 || this.numThreads != 0)) {
            throw new SkipThisScenarioException();
        }
    }

    @Footprint(exclude={Runnable.class, Executor.class, Thread.class, Exception.class})
    public Object measureSize() {
        int i;
        for (Thread thread : this.blockedThreads) {
            thread.interrupt();
        }
        this.blockedThreads.clear();
        final AbstractFutureBenchmarks.Facade f = this.impl.newFacade();
        for (i = 0; i < this.numThreads; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        f.get();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            this.blockedThreads.add(thread);
        }
        for (i = 0; i < this.numListeners; ++i) {
            f.addListener(Runnables.doNothing(), MoreExecutors.directExecutor());
        }
        for (Thread thread : this.blockedThreads) {
            AbstractFutureBenchmarks.awaitWaiting(thread);
        }
        switch (this.state) {
            case NOT_DONE: {
                break;
            }
            case FINISHED: {
                f.set(null);
                break;
            }
            case CANCELLED: {
                f.cancel(false);
                break;
            }
            case FAILED: {
                f.setException(new Exception());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return f;
    }

    static enum State {
        NOT_DONE,
        FINISHED,
        CANCELLED,
        FAILED;

    }
}

