/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class AbstractFutureTest
extends TestCase {
    public void testSuccess() throws ExecutionException, InterruptedException {
        final Object value = new Object();
        AbstractFutureTest.assertSame((Object)value, (Object)new AbstractFuture<Object>(){
            {
                this.set(value);
            }
        }.get());
    }

    public void testException() throws InterruptedException {
        final Throwable failure = new Throwable();
        AbstractFuture<String> future = new AbstractFuture<String>(){
            {
                this.setException(failure);
            }
        };
        ExecutionException ee1 = this.getExpectingExecutionException(future);
        ExecutionException ee2 = this.getExpectingExecutionException(future);
        AbstractFutureTest.assertNotSame((Object)ee1, (Object)ee2);
        AbstractFutureTest.assertSame((Object)failure, (Object)ee1.getCause());
        AbstractFutureTest.assertSame((Object)failure, (Object)ee2.getCause());
        this.checkStackTrace(ee1);
        this.checkStackTrace(ee2);
    }

    public void testCancel_notDoneNoInterrupt() throws Exception {
        InterruptibleFuture future = new InterruptibleFuture();
        AbstractFutureTest.assertTrue((boolean)future.cancel(false));
        AbstractFutureTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
        AbstractFutureTest.assertFalse((boolean)future.wasInterrupted());
        AbstractFutureTest.assertFalse((boolean)future.interruptTaskWasCalled);
        try {
            future.get();
            AbstractFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureTest.assertNull((Object)e.getCause());
        }
    }

    public void testCancel_notDoneInterrupt() throws Exception {
        InterruptibleFuture future = new InterruptibleFuture();
        AbstractFutureTest.assertTrue((boolean)future.cancel(true));
        AbstractFutureTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
        AbstractFutureTest.assertTrue((boolean)future.wasInterrupted());
        AbstractFutureTest.assertTrue((boolean)future.interruptTaskWasCalled);
        try {
            future.get();
            AbstractFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureTest.assertNull((Object)e.getCause());
        }
    }

    public void testCancel_done() throws Exception {
        AbstractFuture<String> future = new AbstractFuture<String>(){
            {
                this.set("foo");
            }
        };
        AbstractFutureTest.assertFalse((boolean)future.cancel(true));
        AbstractFutureTest.assertFalse((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
    }

    public void testGetWithTimeoutDoneFuture() throws Exception {
        AbstractFuture<String> future = new AbstractFuture<String>(){
            {
                this.set("foo");
            }
        };
        AbstractFutureTest.assertEquals((String)"foo", (String)((String)future.get(0L, TimeUnit.SECONDS)));
    }

    public void testEvilFuture_setFuture() throws Exception {
        final RuntimeException exception = new RuntimeException("you didn't say the magic word!");
        AbstractFuture<String> evilFuture = new AbstractFuture<String>(){

            public void addListener(Runnable r, Executor e) {
                throw exception;
            }
        };
        AbstractFuture<String> normalFuture = new AbstractFuture<String>(){};
        normalFuture.setFuture((ListenableFuture)evilFuture);
        AbstractFutureTest.assertTrue((boolean)normalFuture.isDone());
        try {
            normalFuture.get();
            AbstractFutureTest.fail();
        }
        catch (ExecutionException e) {
            AbstractFutureTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    public void testRemoveWaiter_interruption() throws Exception {
        AbstractFuture<String> future = new AbstractFuture<String>(){};
        WaiterThread waiter1 = new WaiterThread((AbstractFuture)future);
        waiter1.start();
        waiter1.awaitWaiting();
        WaiterThread waiter2 = new WaiterThread((AbstractFuture)future);
        waiter2.start();
        waiter2.awaitWaiting();
        waiter1.interrupt();
        waiter1.join();
        waiter2.awaitWaiting();
        LockSupport.unpark(waiter2);
        waiter2.awaitWaiting();
        future.set(null);
        waiter2.join();
    }

    public void testRemoveWaiter_polling() throws Exception {
        AbstractFuture<String> future = new AbstractFuture<String>(){};
        WaiterThread waiter = new WaiterThread((AbstractFuture)future);
        waiter.start();
        waiter.awaitWaiting();
        PollingThread poller = new PollingThread((AbstractFuture)future);
        poller.start();
        PollingThread poller2 = new PollingThread((AbstractFuture)future);
        poller2.start();
        PollingThread poller3 = new PollingThread((AbstractFuture)future);
        poller3.start();
        poller.awaitInLoop();
        poller2.awaitInLoop();
        poller3.awaitInLoop();
        waiter.interrupt();
        waiter.join();
        future.set(null);
        poller.join();
    }

    public void testCompletionFinishesWithDone() {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 50000; ++i) {
            AbstractFuture<String> future = new AbstractFuture<String>(){};
            AtomicReference errorMessage = Atomics.newReference();
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.set((Object)"success");
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("Set call exited before future was complete.");
                    }
                }
            });
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.setException((Throwable)new IllegalArgumentException("failure"));
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("SetException call exited before future was complete.");
                    }
                }
            });
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.cancel(true);
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("Cancel call exited before future was complete.");
                    }
                }
            });
            try {
                future.get();
            }
            catch (Throwable t) {
                // empty catch block
            }
            String error = (String)errorMessage.get();
            AbstractFutureTest.assertNull((String)error, (Object)error);
        }
        executor.shutdown();
    }

    public void testFutureBash() {
        final CyclicBarrier barrier = new CyclicBarrier(107);
        final ExecutorService executor = Executors.newFixedThreadPool(barrier.getParties());
        final AtomicReference currentFuture = Atomics.newReference();
        final AtomicInteger numSuccessfulSetCalls = new AtomicInteger();
        Callable<Void> completeSucessFullyRunnable = new Callable<Void>(){

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).set((Object)"set")) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> completeExceptionallyRunnable = new Callable<Void>(){
            Exception failureCause = new Exception("setException");

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).setException((Throwable)this.failureCause)) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> cancelRunnable = new Callable<Void>(){

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).cancel(true)) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> setFutureCompleteSucessFullyRunnable = new Callable<Void>(){
            ListenableFuture<String> future = Futures.immediateFuture((Object)"setFuture");

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).setFuture(this.future)) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> setFutureCompleteExceptionallyRunnable = new Callable<Void>(){
            ListenableFuture<String> future = Futures.immediateFailedFuture((Throwable)new Exception("setFuture"));

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).setFuture(this.future)) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> setFutureCancelRunnable = new Callable<Void>(){
            ListenableFuture<String> future = Futures.immediateCancelledFuture();

            @Override
            public Void call() {
                if (((AbstractFuture)currentFuture.get()).setFuture(this.future)) {
                    numSuccessfulSetCalls.incrementAndGet();
                }
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        final Set finalResults = Collections.synchronizedSet(Sets.newIdentityHashSet());
        Runnable collectResultsRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String result = (String)Uninterruptibles.getUninterruptibly((Future)((Future)currentFuture.get()));
                    finalResults.add(result);
                }
                catch (ExecutionException e) {
                    finalResults.add(e.getCause());
                }
                catch (CancellationException e) {
                    finalResults.add(e.getCause());
                }
                finally {
                    AbstractFutureTest.awaitUnchecked(barrier);
                }
            }
        };
        Runnable collectResultsTimedGetRunnable = new Runnable(){

            @Override
            public void run() {
                Future future = (Future)currentFuture.get();
                while (true) {
                    try {
                        String result = (String)Uninterruptibles.getUninterruptibly((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS);
                        finalResults.add(result);
                    }
                    catch (ExecutionException e) {
                        finalResults.add(e.getCause());
                    }
                    catch (CancellationException e) {
                        finalResults.add(e.getCause());
                    }
                    catch (TimeoutException timeoutException) {
                        continue;
                    }
                    break;
                }
                AbstractFutureTest.awaitUnchecked(barrier);
            }
        };
        ArrayList<Callable<Object>> allTasks = new ArrayList<Callable<Object>>();
        allTasks.add(completeSucessFullyRunnable);
        allTasks.add(completeExceptionallyRunnable);
        allTasks.add(cancelRunnable);
        allTasks.add(setFutureCompleteSucessFullyRunnable);
        allTasks.add(setFutureCompleteExceptionallyRunnable);
        allTasks.add(setFutureCancelRunnable);
        for (int k = 0; k < 50; ++k) {
            final Runnable listener = k % 2 == 0 ? collectResultsRunnable : collectResultsTimedGetRunnable;
            allTasks.add(Executors.callable(listener));
            allTasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ((AbstractFuture)currentFuture.get()).addListener(listener, (Executor)executor);
                    return null;
                }
            });
        }
        AbstractFutureTest.assertEquals((int)(allTasks.size() + 1), (int)barrier.getParties());
        for (int i = 0; i < 1000; ++i) {
            Collections.shuffle(allTasks);
            AbstractFuture<String> future = new AbstractFuture<String>(){};
            currentFuture.set(future);
            for (Callable callable : allTasks) {
                executor.submit(callable);
            }
            AbstractFutureTest.awaitUnchecked(barrier);
            Truth.assertThat((Boolean)future.isDone()).isTrue();
            Object result = Iterables.getOnlyElement(finalResults);
            if (result instanceof CancellationException) {
                AbstractFutureTest.assertTrue((boolean)future.isCancelled());
                if (future.wasInterrupted()) {
                    Truth.assertThat((Integer)numSuccessfulSetCalls.get()).isIn(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)));
                } else {
                    Truth.assertThat((Integer)numSuccessfulSetCalls.get()).isEqualTo((Object)1);
                }
            } else {
                Truth.assertThat((Integer)numSuccessfulSetCalls.get()).isEqualTo((Object)1);
            }
            numSuccessfulSetCalls.set(0);
            finalResults.clear();
        }
        executor.shutdown();
    }

    public void testSetFutureCancelBash() {
        int size = 50;
        final CyclicBarrier barrier = new CyclicBarrier(103);
        final ExecutorService executor = Executors.newFixedThreadPool(barrier.getParties());
        final AtomicReference currentFuture = Atomics.newReference();
        final AtomicReference setFutureFuture = Atomics.newReference();
        final AtomicBoolean setFutureSetSucess = new AtomicBoolean();
        final AtomicBoolean setFutureCompletionSucess = new AtomicBoolean();
        final AtomicBoolean cancellationSucess = new AtomicBoolean();
        Runnable cancelRunnable = new Runnable(){

            @Override
            public void run() {
                cancellationSucess.set(((AbstractFuture)currentFuture.get()).cancel(true));
                AbstractFutureTest.awaitUnchecked(barrier);
            }
        };
        Runnable setFutureCompleteSucessFullyRunnable = new Runnable(){

            @Override
            public void run() {
                AbstractFuture future = (AbstractFuture)setFutureFuture.get();
                setFutureSetSucess.set(((AbstractFuture)currentFuture.get()).setFuture((ListenableFuture)future));
                setFutureCompletionSucess.set(future.set((Object)"hello-async-world"));
                AbstractFutureTest.awaitUnchecked(barrier);
            }
        };
        final Set finalResults = Collections.synchronizedSet(Sets.newIdentityHashSet());
        Runnable collectResultsRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String result = (String)Uninterruptibles.getUninterruptibly((Future)((Future)currentFuture.get()));
                    finalResults.add(result);
                }
                catch (ExecutionException e) {
                    finalResults.add(e.getCause());
                }
                catch (CancellationException e) {
                    finalResults.add(CancellationException.class);
                }
                finally {
                    AbstractFutureTest.awaitUnchecked(barrier);
                }
            }
        };
        Runnable collectResultsTimedGetRunnable = new Runnable(){

            @Override
            public void run() {
                Future future = (Future)currentFuture.get();
                while (true) {
                    try {
                        String result = (String)Uninterruptibles.getUninterruptibly((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS);
                        finalResults.add(result);
                    }
                    catch (ExecutionException e) {
                        finalResults.add(e.getCause());
                    }
                    catch (CancellationException e) {
                        finalResults.add(CancellationException.class);
                    }
                    catch (TimeoutException timeoutException) {
                        continue;
                    }
                    break;
                }
                AbstractFutureTest.awaitUnchecked(barrier);
            }
        };
        ArrayList<Runnable> allTasks = new ArrayList<Runnable>();
        allTasks.add(cancelRunnable);
        allTasks.add(setFutureCompleteSucessFullyRunnable);
        for (int k = 0; k < 50; ++k) {
            final Runnable listener = k % 2 == 0 ? collectResultsRunnable : collectResultsTimedGetRunnable;
            allTasks.add(listener);
            allTasks.add(new Runnable(){

                @Override
                public void run() {
                    ((AbstractFuture)currentFuture.get()).addListener(listener, (Executor)executor);
                }
            });
        }
        AbstractFutureTest.assertEquals((int)(allTasks.size() + 1), (int)barrier.getParties());
        for (int i = 0; i < 1000; ++i) {
            Collections.shuffle(allTasks);
            AbstractFuture<String> future = new AbstractFuture<String>(){};
            AbstractFuture<String> setFuture = new AbstractFuture<String>(){};
            currentFuture.set(future);
            setFutureFuture.set(setFuture);
            for (Runnable task : allTasks) {
                executor.execute(task);
            }
            AbstractFutureTest.awaitUnchecked(barrier);
            Truth.assertThat((Boolean)future.isDone()).isTrue();
            Object result = Iterables.getOnlyElement(finalResults);
            if (result == CancellationException.class) {
                AbstractFutureTest.assertTrue((boolean)future.isCancelled());
                AbstractFutureTest.assertTrue((boolean)cancellationSucess.get());
                if (!setFutureSetSucess.get() || !setFutureCompletionSucess.get()) {
                    AbstractFutureTest.assertTrue((boolean)setFuture.isCancelled());
                    AbstractFutureTest.assertTrue((boolean)setFuture.wasInterrupted());
                }
            } else {
                AbstractFutureTest.assertFalse((boolean)cancellationSucess.get());
                AbstractFutureTest.assertTrue((boolean)setFutureSetSucess.get());
                AbstractFutureTest.assertTrue((boolean)setFutureCompletionSucess.get());
            }
            setFutureSetSucess.set(false);
            setFutureCompletionSucess.set(false);
            cancellationSucess.set(false);
            finalResults.clear();
        }
        executor.shutdown();
    }

    public void testSetFutureCancelBash_withDoneFuture() {
        final CyclicBarrier barrier = new CyclicBarrier(4);
        ExecutorService executor = Executors.newFixedThreadPool(barrier.getParties());
        final AtomicReference currentFuture = Atomics.newReference();
        final AtomicBoolean setFutureSuccess = new AtomicBoolean();
        final AtomicBoolean cancellationSucess = new AtomicBoolean();
        Callable<Void> cancelRunnable = new Callable<Void>(){

            @Override
            public Void call() {
                cancellationSucess.set(((AbstractFuture)currentFuture.get()).cancel(true));
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        Callable<Void> setFutureCompleteSucessFullyRunnable = new Callable<Void>(){
            final ListenableFuture<String> future = Futures.immediateFuture((Object)"hello");

            @Override
            public Void call() {
                setFutureSuccess.set(((AbstractFuture)currentFuture.get()).setFuture(this.future));
                AbstractFutureTest.awaitUnchecked(barrier);
                return null;
            }
        };
        final Set finalResults = Collections.synchronizedSet(Sets.newIdentityHashSet());
        Runnable collectResultsRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String result = (String)Uninterruptibles.getUninterruptibly((Future)((Future)currentFuture.get()));
                    finalResults.add(result);
                }
                catch (ExecutionException e) {
                    finalResults.add(e.getCause());
                }
                catch (CancellationException e) {
                    finalResults.add(CancellationException.class);
                }
                finally {
                    AbstractFutureTest.awaitUnchecked(barrier);
                }
            }
        };
        ArrayList<Callable<Object>> allTasks = new ArrayList<Callable<Object>>();
        allTasks.add(cancelRunnable);
        allTasks.add(setFutureCompleteSucessFullyRunnable);
        allTasks.add(Executors.callable(collectResultsRunnable));
        AbstractFutureTest.assertEquals((int)(allTasks.size() + 1), (int)barrier.getParties());
        for (int i = 0; i < 1000; ++i) {
            Collections.shuffle(allTasks);
            AbstractFuture<String> future = new AbstractFuture<String>(){};
            currentFuture.set(future);
            for (Callable callable : allTasks) {
                executor.submit(callable);
            }
            AbstractFutureTest.awaitUnchecked(barrier);
            Truth.assertThat((Boolean)future.isDone()).isTrue();
            Object result = Iterables.getOnlyElement(finalResults);
            if (result == CancellationException.class) {
                AbstractFutureTest.assertTrue((boolean)future.isCancelled());
                AbstractFutureTest.assertTrue((boolean)cancellationSucess.get());
                AbstractFutureTest.assertFalse((boolean)setFutureSuccess.get());
            } else {
                AbstractFutureTest.assertTrue((boolean)setFutureSuccess.get());
                AbstractFutureTest.assertFalse((boolean)cancellationSucess.get());
            }
            setFutureSuccess.set(false);
            cancellationSucess.set(false);
            finalResults.clear();
        }
        executor.shutdown();
    }

    public void testSetFuture_stackOverflow() {
        SettableFuture orig;
        SettableFuture prev = orig = SettableFuture.create();
        for (int i = 0; i < 100000; ++i) {
            SettableFuture curr = SettableFuture.create();
            prev.setFuture((ListenableFuture)curr);
            prev = curr;
        }
        prev.set((Object)"done");
        AbstractFutureTest.assertTrue((boolean)orig.isDone());
    }

    public void testCancel_stackOverflow() {
        SettableFuture orig;
        SettableFuture prev = orig = SettableFuture.create();
        for (int i = 0; i < 100000; ++i) {
            SettableFuture curr = SettableFuture.create();
            prev.setFuture((ListenableFuture)curr);
            prev = curr;
        }
        orig.cancel(true);
        AbstractFutureTest.assertTrue((boolean)orig.isCancelled());
        AbstractFutureTest.assertTrue((boolean)prev.isCancelled());
        AbstractFutureTest.assertTrue((boolean)prev.wasInterrupted());
    }

    private static void awaitUnchecked(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkStackTrace(ExecutionException e) {
        int index = AbstractFutureTest.findStackFrame(e, ((Object)((Object)this)).getClass().getName(), "getExpectingExecutionException");
        Truth.assertThat((Integer)index).isNotEqualTo((Object)0);
        Truth.assertThat((String)e.getStackTrace()[index - 1].getMethodName()).isEqualTo((Object)"get");
    }

    private static int findStackFrame(ExecutionException e, String clazz, String method) {
        StackTraceElement[] elements = e.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            if (!element.getClassName().equals(clazz) || !element.getMethodName().equals(method)) continue;
            return i;
        }
        AssertionFailedError failure = new AssertionFailedError("Expected element " + clazz + "." + method + " not found in stack trace");
        failure.initCause((Throwable)e);
        throw failure;
    }

    private ExecutionException getExpectingExecutionException(AbstractFuture<String> future) throws InterruptedException {
        try {
            String got = (String)future.get();
            AbstractFutureTest.fail((String)("Expected exception but got " + got));
        }
        catch (ExecutionException e) {
            return e;
        }
        return null;
    }

    private static final class InterruptibleFuture
    extends AbstractFuture<String> {
        boolean interruptTaskWasCalled;

        private InterruptibleFuture() {
        }

        protected void interruptTask() {
            Assert.assertFalse((boolean)this.interruptTaskWasCalled);
            this.interruptTaskWasCalled = true;
        }
    }

    private final class PollingThread
    extends Thread {
        private final AbstractFuture<?> future;
        private final CountDownLatch completedIteration = new CountDownLatch(10);

        private PollingThread(AbstractFuture<?> future) {
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    this.future.get(0L, TimeUnit.SECONDS);
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (ExecutionException e) {
                    return;
                }
                catch (TimeoutException timeoutException) {}
                continue;
                finally {
                    this.completedIteration.countDown();
                    continue;
                }
                break;
            }
        }

        void awaitInLoop() {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.completedIteration);
        }
    }

    static final class TimedWaiterThread
    extends Thread {
        private final AbstractFuture<?> future;
        private final long timeout;
        private final TimeUnit unit;

        TimedWaiterThread(AbstractFuture<?> future, long timeout, TimeUnit unit) {
            this.future = future;
            this.timeout = timeout;
            this.unit = unit;
        }

        @Override
        public void run() {
            try {
                this.future.get(this.timeout, this.unit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void awaitWaiting() {
            while (LockSupport.getBlocker(this) != this.future) {
                if (this.getState() == Thread.State.TERMINATED) {
                    throw new RuntimeException("Thread exited");
                }
                Thread.yield();
            }
        }
    }

    private static final class WaiterThread
    extends Thread {
        private final AbstractFuture<?> future;

        private WaiterThread(AbstractFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            try {
                this.future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void awaitWaiting() {
            while (LockSupport.getBlocker(this) != this.future) {
                if (this.getState() == Thread.State.TERMINATED) {
                    throw new RuntimeException("Thread exited");
                }
                Thread.yield();
            }
        }
    }
}

