/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.AfterExperiment;
import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.Footprint;
import com.google.caliper.api.VmOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractFutureBenchmarks;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import sun.misc.Unsafe;

@VmOptions(value={"-Xms8g", "-Xmx8g"})
public class ExecutionListBenchmark {
    private static final int NUM_THREADS = 10;
    private ThreadPoolExecutor executorService;
    private CountDownLatch listenerLatch;
    private ExecutionListWrapper list;
    @Param
    Impl impl;
    @Param(value={"1", "5", "10"})
    int numListeners;
    private final Runnable listener = new Runnable(){

        @Override
        public void run() {
            ExecutionListBenchmark.this.listenerLatch.countDown();
        }
    };
    private final Runnable executeTask = new Runnable(){

        @Override
        public void run() {
            ExecutionListBenchmark.this.list.execute();
        }
    };

    @BeforeExperiment
    void setUp() throws Exception {
        this.executorService = new ThreadPoolExecutor(10, 10, Long.MAX_VALUE, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000));
        this.executorService.prestartAllCoreThreads();
        final AtomicInteger integer = new AtomicInteger();
        for (int i = 0; i < 100; ++i) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    integer.getAndIncrement();
                }
            });
        }
    }

    @AfterExperiment
    void tearDown() throws Exception {
        this.executorService.shutdown();
    }

    @Footprint(exclude={Runnable.class, Executor.class})
    public Object measureSize() {
        this.list = this.impl.newExecutionList();
        for (int i = 0; i < this.numListeners; ++i) {
            this.list.add(this.listener, MoreExecutors.directExecutor());
        }
        return this.list.getImpl();
    }

    @Benchmark
    int addThenExecute_singleThreaded(int reps) {
        int returnValue = 0;
        for (int i = 0; i < reps; ++i) {
            this.list = this.impl.newExecutionList();
            this.listenerLatch = new CountDownLatch(this.numListeners);
            for (int j = 0; j < this.numListeners; ++j) {
                this.list.add(this.listener, MoreExecutors.directExecutor());
                returnValue = (int)((long)returnValue + this.listenerLatch.getCount());
            }
            this.list.execute();
            returnValue = (int)((long)returnValue + this.listenerLatch.getCount());
        }
        return returnValue;
    }

    @Benchmark
    int executeThenAdd_singleThreaded(int reps) {
        int returnValue = 0;
        for (int i = 0; i < reps; ++i) {
            this.list = this.impl.newExecutionList();
            this.list.execute();
            this.listenerLatch = new CountDownLatch(this.numListeners);
            for (int j = 0; j < this.numListeners; ++j) {
                this.list.add(this.listener, MoreExecutors.directExecutor());
                returnValue = (int)((long)returnValue + this.listenerLatch.getCount());
            }
            returnValue = (int)((long)returnValue + this.listenerLatch.getCount());
        }
        return returnValue;
    }

    @Benchmark
    int addThenExecute_multiThreaded(int reps) throws InterruptedException {
        Runnable addTask = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ExecutionListBenchmark.this.numListeners; ++i) {
                    ExecutionListBenchmark.this.list.add(ExecutionListBenchmark.this.listener, MoreExecutors.directExecutor());
                }
            }
        };
        int returnValue = 0;
        for (int i = 0; i < reps; ++i) {
            this.list = this.impl.newExecutionList();
            this.listenerLatch = new CountDownLatch(this.numListeners * 10);
            for (int j = 0; j < 10; ++j) {
                this.executorService.submit(addTask);
            }
            this.executorService.submit(this.executeTask);
            returnValue += (int)this.listenerLatch.getCount();
            this.listenerLatch.await();
        }
        return returnValue;
    }

    @Benchmark
    int executeThenAdd_multiThreaded(int reps) throws InterruptedException {
        Runnable addTask = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ExecutionListBenchmark.this.numListeners; ++i) {
                    ExecutionListBenchmark.this.list.add(ExecutionListBenchmark.this.listener, MoreExecutors.directExecutor());
                }
            }
        };
        int returnValue = 0;
        for (int i = 0; i < reps; ++i) {
            this.list = this.impl.newExecutionList();
            this.listenerLatch = new CountDownLatch(this.numListeners * 10);
            this.executorService.submit(this.executeTask);
            for (int j = 0; j < 10; ++j) {
                this.executorService.submit(addTask);
            }
            returnValue += (int)this.listenerLatch.getCount();
            this.listenerLatch.await();
        }
        return returnValue;
    }

    private static final class ExecutionListCAS {
        static final Logger log = Logger.getLogger(ExecutionListCAS.class.getName());
        private static final Unsafe UNSAFE;
        private static final long HEAD_OFFSET;
        private static final RunnableExecutorPair NULL_PAIR;
        private volatile RunnableExecutorPair head = NULL_PAIR;

        private ExecutionListCAS() {
        }

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException tryReflectionInstead) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                }
            }
        }

        public void add(Runnable runnable, Executor executor) {
            RunnableExecutorPair oldHead;
            Preconditions.checkNotNull((Object)runnable, (Object)"Runnable was null.");
            Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
            RunnableExecutorPair newHead = new RunnableExecutorPair(runnable, executor);
            do {
                if ((oldHead = this.head) == null) {
                    newHead.execute();
                    return;
                }
                newHead.next = oldHead;
            } while (!UNSAFE.compareAndSwapObject(this, HEAD_OFFSET, oldHead, newHead));
        }

        public void execute() {
            RunnableExecutorPair stack;
            do {
                if ((stack = this.head) != null) continue;
                return;
            } while (!UNSAFE.compareAndSwapObject(this, HEAD_OFFSET, stack, null));
            RunnableExecutorPair reversedStack = null;
            while (stack != NULL_PAIR) {
                RunnableExecutorPair head = stack;
                stack = stack.next;
                head.next = reversedStack;
                reversedStack = head;
            }
            stack = reversedStack;
            while (stack != null) {
                stack.execute();
                stack = stack.next;
            }
        }

        static {
            NULL_PAIR = new RunnableExecutorPair(null, null);
            try {
                UNSAFE = ExecutionListCAS.getUnsafe();
                HEAD_OFFSET = UNSAFE.objectFieldOffset(ExecutionListCAS.class.getDeclaredField("head"));
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }

        private static class RunnableExecutorPair {
            final Runnable runnable;
            final Executor executor;
            @Nullable
            volatile RunnableExecutorPair next;

            RunnableExecutorPair(Runnable runnable, Executor executor) {
                this.runnable = runnable;
                this.executor = executor;
            }

            void execute() {
                try {
                    this.executor.execute(this.runnable);
                }
                catch (RuntimeException e) {
                    log.log(Level.SEVERE, "RuntimeException while executing runnable " + this.runnable + " with executor " + this.executor, e);
                }
            }
        }
    }

    private static final class NewExecutionListQueue {
        static final Logger log = Logger.getLogger(NewExecutionListQueue.class.getName());
        @GuardedBy(value="this")
        private RunnableExecutorPair head;
        @GuardedBy(value="this")
        private RunnableExecutorPair tail;
        @GuardedBy(value="this")
        private boolean executed;

        private NewExecutionListQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable runnable, Executor executor) {
            Preconditions.checkNotNull((Object)runnable, (Object)"Runnable was null.");
            Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
            NewExecutionListQueue newExecutionListQueue = this;
            synchronized (newExecutionListQueue) {
                if (!this.executed) {
                    RunnableExecutorPair newTail = new RunnableExecutorPair(runnable, executor);
                    if (this.head == null) {
                        this.head = newTail;
                        this.tail = newTail;
                    } else {
                        this.tail.next = newTail;
                        this.tail = newTail;
                    }
                    return;
                }
            }
            NewExecutionListQueue.executeListener(runnable, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            RunnableExecutorPair list;
            NewExecutionListQueue newExecutionListQueue = this;
            synchronized (newExecutionListQueue) {
                if (this.executed) {
                    return;
                }
                this.executed = true;
                list = this.head;
                this.head = null;
                this.tail = null;
            }
            while (list != null) {
                NewExecutionListQueue.executeListener(list.runnable, list.executor);
                list = list.next;
            }
        }

        private static void executeListener(Runnable runnable, Executor executor) {
            try {
                executor.execute(runnable);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, e);
            }
        }

        private static final class RunnableExecutorPair {
            Runnable runnable;
            Executor executor;
            @Nullable
            RunnableExecutorPair next;

            RunnableExecutorPair(Runnable runnable, Executor executor) {
                this.runnable = runnable;
                this.executor = executor;
            }
        }
    }

    private static final class NewExecutionListWithoutReverse {
        static final Logger log = Logger.getLogger(NewExecutionListWithoutReverse.class.getName());
        @GuardedBy(value="this")
        private RunnableExecutorPair runnables;
        @GuardedBy(value="this")
        private boolean executed;

        private NewExecutionListWithoutReverse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable runnable, Executor executor) {
            Preconditions.checkNotNull((Object)runnable, (Object)"Runnable was null.");
            Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
            NewExecutionListWithoutReverse newExecutionListWithoutReverse = this;
            synchronized (newExecutionListWithoutReverse) {
                if (!this.executed) {
                    this.runnables = new RunnableExecutorPair(runnable, executor, this.runnables);
                    return;
                }
            }
            NewExecutionListWithoutReverse.executeListener(runnable, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            RunnableExecutorPair list;
            NewExecutionListWithoutReverse newExecutionListWithoutReverse = this;
            synchronized (newExecutionListWithoutReverse) {
                if (this.executed) {
                    return;
                }
                this.executed = true;
                list = this.runnables;
                this.runnables = null;
            }
            while (list != null) {
                NewExecutionListWithoutReverse.executeListener(list.runnable, list.executor);
                list = list.next;
            }
        }

        private static void executeListener(Runnable runnable, Executor executor) {
            try {
                executor.execute(runnable);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, e);
            }
        }

        private static final class RunnableExecutorPair {
            final Runnable runnable;
            final Executor executor;
            @Nullable
            RunnableExecutorPair next;

            RunnableExecutorPair(Runnable runnable, Executor executor, RunnableExecutorPair next) {
                this.runnable = runnable;
                this.executor = executor;
                this.next = next;
            }
        }
    }

    private static final class OldExecutionList {
        static final Logger log = Logger.getLogger(OldExecutionList.class.getName());
        final Queue<RunnableExecutorPair> runnables = Lists.newLinkedList();
        boolean executed = false;

        private OldExecutionList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable runnable, Executor executor) {
            Preconditions.checkNotNull((Object)runnable, (Object)"Runnable was null.");
            Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
            boolean executeImmediate = false;
            Queue<RunnableExecutorPair> queue = this.runnables;
            synchronized (queue) {
                if (!this.executed) {
                    this.runnables.add(new RunnableExecutorPair(runnable, executor));
                } else {
                    executeImmediate = true;
                }
            }
            if (executeImmediate) {
                new RunnableExecutorPair(runnable, executor).execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Queue<RunnableExecutorPair> queue = this.runnables;
            synchronized (queue) {
                if (this.executed) {
                    return;
                }
                this.executed = true;
            }
            while (!this.runnables.isEmpty()) {
                this.runnables.poll().execute();
            }
        }

        private static class RunnableExecutorPair {
            final Runnable runnable;
            final Executor executor;

            RunnableExecutorPair(Runnable runnable, Executor executor) {
                this.runnable = runnable;
                this.executor = executor;
            }

            void execute() {
                try {
                    this.executor.execute(this.runnable);
                }
                catch (RuntimeException e) {
                    log.log(Level.SEVERE, "RuntimeException while executing runnable " + this.runnable + " with executor " + this.executor, e);
                }
            }
        }
    }

    static enum Impl {
        NEW{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final ExecutionList list = new ExecutionList();

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.list.add(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.list.execute();
                    }

                    @Override
                    public Object getImpl() {
                        return this.list;
                    }
                };
            }
        }
        ,
        NEW_WITH_CAS{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final ExecutionListCAS list = new ExecutionListCAS();

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.list.add(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.list.execute();
                    }

                    @Override
                    public Object getImpl() {
                        return this.list;
                    }
                };
            }
        }
        ,
        NEW_WITH_QUEUE{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final NewExecutionListQueue list = new NewExecutionListQueue();

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.list.add(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.list.execute();
                    }

                    @Override
                    public Object getImpl() {
                        return this.list;
                    }
                };
            }
        }
        ,
        NEW_WITHOUT_REVERSE{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final NewExecutionListWithoutReverse list = new NewExecutionListWithoutReverse();

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.list.add(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.list.execute();
                    }

                    @Override
                    public Object getImpl() {
                        return this.list;
                    }
                };
            }
        }
        ,
        OLD{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final OldExecutionList list = new OldExecutionList();

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.list.add(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.list.execute();
                    }

                    @Override
                    public Object getImpl() {
                        return this.list;
                    }
                };
            }
        }
        ,
        ABSTRACT_FUTURE{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final AbstractFuture<?> future = new AbstractFuture<Object>(){};

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.future.addListener(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.future.set(null);
                    }

                    @Override
                    public Object getImpl() {
                        return this.future;
                    }
                };
            }
        }
        ,
        OLD_ABSTRACT_FUTURE{

            @Override
            ExecutionListWrapper newExecutionList() {
                return new ExecutionListWrapper(){
                    final AbstractFutureBenchmarks.OldAbstractFuture<Object> future = new AbstractFutureBenchmarks.OldAbstractFuture<Object>(){};

                    @Override
                    public void add(Runnable runnable, Executor executor) {
                        this.future.addListener(runnable, executor);
                    }

                    @Override
                    public void execute() {
                        this.future.set(null);
                    }

                    @Override
                    public Object getImpl() {
                        return this.future;
                    }
                };
            }
        };


        abstract ExecutionListWrapper newExecutionList();
    }

    static interface ExecutionListWrapper {
        public void add(Runnable var1, Executor var2);

        public void execute();

        public Object getImpl();
    }
}

