/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterables;
import com.google.common.testing.ForwardingWrapperTester;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

final class ForwardingObjectTester {
    private static final Method DELEGATE_METHOD;

    ForwardingObjectTester() {
    }

    static <T extends ForwardingObject> void testForwardingObject(final Class<T> forwarderClass) {
        Class interfaceType = (Class)Iterables.getOnlyElement(Arrays.asList(forwarderClass.getInterfaces()));
        new ForwardingWrapperTester().testForwarding(interfaceType, new Function<Object, T>(){

            public T apply(Object delegate) {
                ForwardingObject mock = (ForwardingObject)Mockito.mock((Class)forwarderClass, (Answer)Answers.CALLS_REAL_METHODS.get());
                try {
                    ForwardingObject stubber = (ForwardingObject)Mockito.doReturn((Object)delegate).when((Object)mock);
                    DELEGATE_METHOD.invoke((Object)stubber, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return mock;
            }
        });
    }

    static {
        try {
            DELEGATE_METHOD = ForwardingObject.class.getDeclaredMethod("delegate", new Class[0]);
            DELEGATE_METHOD.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

