/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.AndroidIncompatible;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTester;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.TestPlatform;
import com.google.common.util.concurrent.UncheckedThrowingFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class FuturesTest
extends TestCase {
    private static final Logger aggregateFutureLogger = Logger.getLogger(AggregateFuture.class.getName());
    private final TestLogHandler aggregateFutureLogHandler = new TestLogHandler();
    private static final String DATA1 = "data";
    private static final String DATA2 = "more data";
    private static final String DATA3 = "most data";
    @GwtIncompatible
    private static final Function<Exception, TestException> mapper = new Function<Exception, TestException>(){

        public TestException apply(Exception from) {
            if (from instanceof ExecutionException) {
                return new TestException(from.getCause());
            }
            Assert.assertTrue((String)("got " + from.getClass()), (from instanceof InterruptedException || from instanceof CancellationException ? 1 : 0) != 0);
            return new TestException(from);
        }
    };
    private static final Executor REJECTING_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            throw new RejectedExecutionException();
        }
    };

    public void setUp() throws Exception {
        super.setUp();
        aggregateFutureLogger.addHandler((Handler)this.aggregateFutureLogHandler);
    }

    public void tearDown() throws Exception {
        TestPlatform.clearInterrupt();
        aggregateFutureLogger.removeHandler((Handler)this.aggregateFutureLogHandler);
        super.tearDown();
    }

    public void testImmediateFuture() throws Exception {
        ListenableFuture future = Futures.immediateFuture((Object)DATA1);
        FuturesTest.assertSame((Object)DATA1, (Object)Futures.getDone((Future)future));
        FuturesTest.assertSame((Object)DATA1, TestPlatform.getDoneFromTimeoutOverload(future));
    }

    public void testImmediateFailedFuture() throws Exception {
        Exception exception = new Exception();
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        try {
            Futures.getDone((Future)future);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            TestPlatform.getDoneFromTimeoutOverload(future);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testImmediateFailedFuture_cancellationException() throws Exception {
        CancellationException exception = new CancellationException();
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        FuturesTest.assertFalse((boolean)future.isCancelled());
        try {
            Futures.getDone((Future)future);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            TestPlatform.getDoneFromTimeoutOverload(future);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testImmediateCancelledFutureBasic() throws Exception {
        ListenableFuture<String> future = CallerClass1.makeImmediateCancelledFuture();
        FuturesTest.assertTrue((boolean)future.isCancelled());
    }

    @GwtIncompatible
    public void testImmediateCancelledFutureStack() throws Exception {
        ListenableFuture<String> future = CallerClass1.makeImmediateCancelledFuture();
        FuturesTest.assertTrue((boolean)future.isCancelled());
        try {
            CallerClass2.get(future);
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            ImmutableList stackTrace = ImmutableList.copyOf((Object[])expected.getStackTrace());
            FuturesTest.assertFalse((boolean)Iterables.any((Iterable)stackTrace, FuturesTest.hasClassName(CallerClass1.class)));
            FuturesTest.assertTrue((boolean)Iterables.any((Iterable)stackTrace, FuturesTest.hasClassName(CallerClass2.class)));
            Truth.assertThat((Throwable)expected.getCause()).isNull();
        }
    }

    @GwtIncompatible
    private static Predicate<StackTraceElement> hasClassName(final Class<?> clazz) {
        return new Predicate<StackTraceElement>(){

            public boolean apply(StackTraceElement element) {
                return element.getClassName().equals(clazz.getName());
            }
        };
    }

    @GwtIncompatible
    public void testImmediateCheckedFuture() throws Exception {
        CheckedFuture future = Futures.immediateCheckedFuture((Object)DATA1);
        FuturesTest.assertSame((Object)DATA1, (Object)future.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA1, (Object)future.checkedGet(0L, TimeUnit.MILLISECONDS));
    }

    @GwtIncompatible
    public void testMultipleImmediateCheckedFutures() throws Exception {
        CheckedFuture future1 = Futures.immediateCheckedFuture((Object)DATA1);
        CheckedFuture future2 = Futures.immediateCheckedFuture((Object)DATA2);
        FuturesTest.assertSame((Object)DATA1, (Object)future1.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA1, (Object)future1.checkedGet(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA2, (Object)future2.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA2, (Object)future2.checkedGet(0L, TimeUnit.MILLISECONDS));
    }

    @GwtIncompatible
    public void testImmediateFailedCheckedFuture() throws Exception {
        MyException exception = new MyException();
        CheckedFuture future = Futures.immediateFailedCheckedFuture((Exception)exception);
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            future.checkedGet(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail();
        }
        catch (MyException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected);
        }
    }

    public void testTransform_genericsNull() throws Exception {
        ListenableFuture nullFuture = Futures.immediateFuture(null);
        ListenableFuture transformedFuture = Futures.transform((ListenableFuture)nullFuture, (Function)Functions.constant(null));
        FuturesTest.assertNull((Object)Futures.getDone((Future)transformedFuture));
    }

    public void testTransform_genericsHierarchy() throws Exception {
        ListenableFuture future = Futures.immediateFuture(null);
        final BarChild barChild = new BarChild();
        Function<Foo, BarChild> function = new Function<Foo, BarChild>(){

            public BarChild apply(Foo unused) {
                return barChild;
            }
        };
        Bar bar = (Bar)Futures.getDone((Future)Futures.transform((ListenableFuture)future, (Function)function));
        FuturesTest.assertSame((Object)barChild, (Object)bar);
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testTransform_StackOverflow() throws Exception {
        SettableFuture root = SettableFuture.create();
        ListenableFuture unused = Futures.transform((ListenableFuture)root, (Function)Functions.identity());
        root.set((Object)"foo");
        SettableFuture output = root = SettableFuture.create();
        for (int i = 0; i < 10000; ++i) {
            output = Futures.transform((ListenableFuture)output, (Function)Functions.identity());
        }
        try {
            root.set((Object)"foo");
            FuturesTest.fail();
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    public void testTransform_ErrorAfterCancellation() throws Exception {
        ListenableFuture output;
        class Transformer
        implements Function<Object, Object> {
            ListenableFuture<Object> output;

            Transformer() {
            }

            public Object apply(Object input) {
                this.output.cancel(false);
                throw new MyError();
            }
        }
        Transformer transformer = new Transformer();
        SettableFuture input = SettableFuture.create();
        transformer.output = output = Futures.transform((ListenableFuture)input, (Function)transformer);
        input.set((Object)"foo");
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testTransform_ExceptionAfterCancellation() throws Exception {
        ListenableFuture output;
        class Transformer
        implements Function<Object, Object> {
            ListenableFuture<Object> output;

            Transformer() {
            }

            public Object apply(Object input) {
                this.output.cancel(false);
                throw new MyRuntimeException();
            }
        }
        Transformer transformer = new Transformer();
        SettableFuture input = SettableFuture.create();
        transformer.output = output = Futures.transform((ListenableFuture)input, (Function)transformer);
        input.set((Object)"foo");
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testTransform_getThrowsRuntimeException() throws Exception {
        ListenableFuture input = UncheckedThrowingFuture.throwingRuntimeException(new MyRuntimeException());
        ListenableFuture output = Futures.transform(input, (Function)Functions.identity());
        try {
            Futures.getDone((Future)output);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyRuntimeException.class);
        }
    }

    public void testTransform_getThrowsError() throws Exception {
        ListenableFuture input = UncheckedThrowingFuture.throwingError(new MyError());
        ListenableFuture output = Futures.transform(input, (Function)Functions.identity());
        try {
            Futures.getDone((Future)output);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyError.class);
        }
    }

    public void testTransform_listenerThrowsError() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture output = Futures.transform((ListenableFuture)input, (Function)Functions.identity());
        output.addListener(new Runnable(){

            @Override
            public void run() {
                throw new MyError();
            }
        }, MoreExecutors.directExecutor());
        try {
            input.set((Object)"foo");
            FuturesTest.fail();
        }
        catch (MyError myError) {
            // empty catch block
        }
    }

    public void testTransformAsync_cancelPropagatesToInput() throws Exception {
        SettableFuture input = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                throw new AssertionFailedError("Unexpeted call to apply.");
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transformAsync((ListenableFuture)input, (AsyncFunction)function).cancel(false));
        FuturesTest.assertTrue((boolean)input.isCancelled());
        FuturesTest.assertFalse((boolean)input.wasInterrupted());
    }

    public void testTransformAsync_interruptPropagatesToInput() throws Exception {
        SettableFuture input = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                throw new AssertionFailedError("Unexpeted call to apply.");
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transformAsync((ListenableFuture)input, (AsyncFunction)function).cancel(true));
        FuturesTest.assertTrue((boolean)input.isCancelled());
        FuturesTest.assertTrue((boolean)input.wasInterrupted());
    }

    @GwtIncompatible
    public void testTransformAsync_interruptPropagatesToTransformingThread() throws Exception {
        SettableFuture input = SettableFuture.create();
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch shouldCompleteFunction = new CountDownLatch(1);
        final CountDownLatch gotException = new CountDownLatch(1);
        AsyncFunction<String, String> function = new AsyncFunction<String, String>(){

            public ListenableFuture<String> apply(String s) throws Exception {
                inFunction.countDown();
                try {
                    shouldCompleteFunction.await();
                }
                catch (InterruptedException expected) {
                    gotException.countDown();
                    throw expected;
                }
                return Futures.immediateFuture((Object)"a");
            }
        };
        ListenableFuture futureResult = Futures.transformAsync((ListenableFuture)input, (AsyncFunction)function, (Executor)Executors.newSingleThreadExecutor());
        input.set((Object)"value");
        inFunction.await();
        futureResult.cancel(true);
        shouldCompleteFunction.countDown();
        try {
            futureResult.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        FuturesTest.assertEquals((long)1L, (long)gotException.getCount());
    }

    public void testTransformAsync_cancelPropagatesToAsyncOutput() throws Exception {
        ListenableFuture immediate = Futures.immediateFuture((Object)new Foo());
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                return secondary;
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transformAsync((ListenableFuture)immediate, (AsyncFunction)function).cancel(false));
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertFalse((boolean)secondary.wasInterrupted());
    }

    public void testTransformAsync_interruptPropagatesToAsyncOutput() throws Exception {
        ListenableFuture immediate = Futures.immediateFuture((Object)new Foo());
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                return secondary;
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transformAsync((ListenableFuture)immediate, (AsyncFunction)function).cancel(true));
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertTrue((boolean)secondary.wasInterrupted());
    }

    public void testTransformAsync_inputCancelButNotInterruptPropagatesToOutput() throws Exception {
        SettableFuture f1 = SettableFuture.create();
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                return secondary;
            }
        };
        ListenableFuture f2 = Futures.transformAsync((ListenableFuture)f1, (AsyncFunction)function);
        f1.cancel(true);
        FuturesTest.assertTrue((boolean)f2.isCancelled());
        FuturesTest.assertFalse((boolean)((AbstractFuture)f2).wasInterrupted());
    }

    /*
     * Exception decompiling
     */
    @AndroidIncompatible
    @GwtIncompatible
    public void testTransformAsync_StackOverflow() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testTransformAsync_ErrorAfterCancellation() throws Exception {
        ListenableFuture output;
        class Transformer
        implements AsyncFunction<Object, Object> {
            ListenableFuture<Object> output;

            Transformer() {
            }

            public ListenableFuture<Object> apply(Object input) {
                this.output.cancel(false);
                throw new MyError();
            }
        }
        Transformer transformer = new Transformer();
        SettableFuture input = SettableFuture.create();
        transformer.output = output = Futures.transformAsync((ListenableFuture)input, (AsyncFunction)transformer);
        input.set((Object)"foo");
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testTransformAsync_ExceptionAfterCancellation() throws Exception {
        ListenableFuture output;
        class Transformer
        implements AsyncFunction<Object, Object> {
            ListenableFuture<Object> output;

            Transformer() {
            }

            public ListenableFuture<Object> apply(Object input) {
                this.output.cancel(false);
                throw new MyRuntimeException();
            }
        }
        Transformer transformer = new Transformer();
        SettableFuture input = SettableFuture.create();
        transformer.output = output = Futures.transformAsync((ListenableFuture)input, (AsyncFunction)transformer);
        input.set((Object)"foo");
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    /*
     * Exception decompiling
     */
    public void testTransformAsync_getThrowsRuntimeException() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testTransformAsync_getThrowsError() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testTransformAsync_listenerThrowsError() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testTransform_rejectionPropagatesToOutput() throws Exception {
        SettableFuture input = SettableFuture.create();
        Function identity = Functions.identity();
        ListenableFuture transformed = Futures.transform((ListenableFuture)input, (Function)identity, (Executor)REJECTING_EXECUTOR);
        input.set((Object)new Foo());
        try {
            Futures.getDone((Future)transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RejectedExecutionException.class);
        }
    }

    public void testTransformAsync_rejectionPropagatesToOutput() throws Exception {
        SettableFuture input = SettableFuture.create();
        AsyncFunction asyncIdentity = FuturesTest.asyncIdentity();
        ListenableFuture transformed = Futures.transformAsync((ListenableFuture)input, asyncIdentity, (Executor)REJECTING_EXECUTOR);
        input.set((Object)new Foo());
        try {
            Futures.getDone((Future)transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RejectedExecutionException.class);
        }
    }

    public void testTransformValueRemainsMemoized() throws Exception {
        class Holder {
            int value = 2;

            Holder() {
            }
        }
        final Holder holder = new Holder();
        Function<Integer, Integer> adder = new Function<Integer, Integer>(){
            {
            }

            public Integer apply(Integer from) {
                return from + holder.value;
            }
        };
        FuturesTest.assertEquals((int)6, (int)((Integer)adder.apply((Object)4)));
        ListenableFuture immediateFuture = Futures.immediateFuture((Object)4);
        ListenableFuture transformedFuture = Futures.transform((ListenableFuture)immediateFuture, (Function)adder);
        FuturesTest.assertEquals((int)6, (int)((Integer)Futures.getDone((Future)transformedFuture)));
        holder.value = 3;
        FuturesTest.assertEquals((int)6, (int)((Integer)Futures.getDone((Future)transformedFuture)));
        FuturesTest.assertEquals((int)7, (int)((Integer)adder.apply((Object)4)));
        holder.value = 4;
        FuturesTest.assertEquals((int)6, (int)((Integer)Futures.getDone((Future)transformedFuture)));
        FuturesTest.assertEquals((int)8, (int)((Integer)adder.apply((Object)4)));
        FuturesTest.assertEquals((int)6, (int)((Integer)TestPlatform.getDoneFromTimeoutOverload(transformedFuture)));
        FuturesTest.assertEquals((int)8, (int)((Integer)Futures.getDone((Future)Futures.transform((ListenableFuture)immediateFuture, (Function)adder))));
        FuturesTest.assertEquals((int)8, (int)((Integer)TestPlatform.getDoneFromTimeoutOverload(Futures.transform((ListenableFuture)immediateFuture, (Function)adder))));
    }

    @GwtIncompatible
    public void testTransformExceptionRemainsMemoized() throws Throwable {
        SettableFuture exceptionInput = SettableFuture.create();
        ListenableFuture exceptionComposedFuture = Futures.transform((ListenableFuture)exceptionInput, FuturesTest.newOneTimeExceptionThrower());
        exceptionInput.set((Object)0);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)exceptionComposedFuture, MyRuntimeException.class);
        SettableFuture errorInput = SettableFuture.create();
        ListenableFuture errorComposedFuture = Futures.transform((ListenableFuture)errorInput, FuturesTest.newOneTimeErrorThrower());
        errorInput.set((Object)0);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)errorComposedFuture, MyError.class);
        exceptionComposedFuture = Futures.transform((ListenableFuture)exceptionInput, FuturesTest.newOneTimeExceptionThrower());
        FuturesTest.runGetIdempotencyTest((Future<Integer>)exceptionComposedFuture, MyRuntimeException.class);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)Futures.transform((ListenableFuture)errorInput, FuturesTest.newOneTimeErrorThrower()), MyError.class);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)errorComposedFuture, MyError.class);
    }

    @GwtIncompatible
    private static void runGetIdempotencyTest(Future<Integer> transformedFuture, Class<? extends Throwable> expectedExceptionClass) throws Throwable {
        for (int i = 0; i < 5; ++i) {
            try {
                Futures.getDone(transformedFuture);
                FuturesTest.fail();
                continue;
            }
            catch (ExecutionException expected) {
                if (expectedExceptionClass.isInstance(expected.getCause())) continue;
                throw expected.getCause();
            }
        }
    }

    @GwtIncompatible
    private static Function<Integer, Integer> newOneTimeExceptionThrower() {
        return new Function<Integer, Integer>(){
            int calls = 0;

            public Integer apply(Integer from) {
                if (++this.calls > 1) {
                    Assert.fail();
                }
                throw new MyRuntimeException();
            }
        };
    }

    @GwtIncompatible
    private static Function<Integer, Integer> newOneTimeErrorThrower() {
        return new Function<Integer, Integer>(){
            int calls = 0;

            public Integer apply(Integer from) {
                if (++this.calls > 1) {
                    Assert.fail();
                }
                throw new MyError();
            }
        };
    }

    public void testTransform_Executor() throws Exception {
        Object value = new Object();
        ExecutorSpy spy = new ExecutorSpy(MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)spy.wasExecuted);
        ListenableFuture future = Futures.transform((ListenableFuture)Futures.immediateFuture((Object)value), (Function)Functions.identity(), (Executor)spy);
        FuturesTest.assertSame((Object)value, (Object)Futures.getDone((Future)future));
        FuturesTest.assertTrue((boolean)spy.wasExecuted);
    }

    @GwtIncompatible
    public void testLazyTransform() throws Exception {
        FunctionSpy spy = new FunctionSpy(Functions.constant((Object)"bar"));
        ListenableFuture input = Futures.immediateFuture((Object)"foo");
        Future transformed = Futures.lazyTransform((Future)input, spy);
        spy.verifyCallCount(0);
        FuturesTest.assertEquals((String)"bar", (String)((String)Futures.getDone((Future)transformed)));
        spy.verifyCallCount(1);
        FuturesTest.assertEquals((String)"bar", (String)((String)Futures.getDone((Future)transformed)));
        spy.verifyCallCount(2);
    }

    @GwtIncompatible
    public void testLazyTransform_exception() throws Exception {
        final RuntimeException exception = new RuntimeException("deliberate");
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer input) {
                throw exception;
            }
        };
        Future transformed = Futures.lazyTransform((Future)Futures.immediateFuture((Object)1), (Function)function);
        try {
            Futures.getDone((Future)transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            TestPlatform.getDoneFromTimeoutOverload(transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    private static <I, O> FunctionSpy<I, O> spy(Function<I, O> delegate) {
        return new FunctionSpy<I, O>(delegate);
    }

    private static <X extends Throwable, V> Function<X, V> unexpectedFunction() {
        return new Function<X, V>(){

            public V apply(X t) {
                throw FuturesTest.newAssertionError("Unexpected fallback", t);
            }
        };
    }

    private static <X extends Throwable, V> AsyncFunctionSpy<X, V> spy(AsyncFunction<X, V> delegate) {
        return new AsyncFunctionSpy<X, V>(delegate);
    }

    private static <X extends Throwable, V> AsyncFunction<X, V> unexpectedAsyncFunction() {
        return new AsyncFunction<X, V>(){

            public ListenableFuture<V> apply(X t) {
                throw FuturesTest.newAssertionError("Unexpected fallback", t);
            }
        };
    }

    private static AssertionError newAssertionError(String message, Throwable cause) {
        AssertionError e = new AssertionError((Object)message);
        ((Throwable)((Object)e)).initCause(cause);
        return e;
    }

    public void testCatchingAsync_inputDoesNotRaiseException() throws Exception {
        AsyncFunction fallback = FuturesTest.unexpectedAsyncFunction();
        ListenableFuture originalFuture = Futures.immediateFuture((Object)7);
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)originalFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)7, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    public void testCatchingAsync_inputRaisesException() throws Exception {
        final RuntimeException raisedException = new RuntimeException();
        AsyncFunctionSpy<Throwable, Integer> fallback = FuturesTest.spy(new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) throws Exception {
                Truth.assertThat((Throwable)t).isSameAs((Object)raisedException);
                return Futures.immediateFuture((Object)20);
            }
        });
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)failingFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)20, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
        fallback.verifyCallCount(1);
    }

    public void testCatchingAsync_fallbackGeneratesRuntimeException() throws Exception {
        RuntimeException expectedException = new RuntimeException();
        this.runExpectedExceptionCatchingAsyncTest(expectedException, false);
    }

    public void testCatchingAsync_fallbackGeneratesCheckedException() throws Exception {
        Exception expectedException = new Exception(){};
        this.runExpectedExceptionCatchingAsyncTest(expectedException, false);
    }

    public void testCatchingAsync_fallbackGeneratesError() throws Exception {
        final Error error = new Error("deliberate");
        AsyncFunction<Throwable, Integer> fallback = new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) throws Exception {
                throw error;
            }
        };
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        try {
            Futures.getDone((Future)Futures.catchingAsync((ListenableFuture)failingFuture, Throwable.class, (AsyncFunction)fallback));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)error, (Object)expected.getCause());
        }
    }

    public void testCatchingAsync_fallbackReturnsRuntimeException() throws Exception {
        RuntimeException expectedException = new RuntimeException();
        this.runExpectedExceptionCatchingAsyncTest(expectedException, true);
    }

    public void testCatchingAsync_fallbackReturnsCheckedException() throws Exception {
        Exception expectedException = new Exception(){};
        this.runExpectedExceptionCatchingAsyncTest(expectedException, true);
    }

    private void runExpectedExceptionCatchingAsyncTest(final Exception expectedException, final boolean wrapInFuture) throws Exception {
        AsyncFunctionSpy<Throwable, Integer> fallback = FuturesTest.spy(new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) throws Exception {
                if (!wrapInFuture) {
                    throw expectedException;
                }
                return Futures.immediateFailedFuture((Throwable)expectedException);
            }
        });
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)failingFuture, Throwable.class, fallback);
        try {
            Futures.getDone((Future)faultTolerantFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)expectedException, (Object)expected.getCause());
        }
        fallback.verifyCallCount(1);
    }

    public void testCatchingAsync_fallbackNotReady() throws Exception {
        ListenableFuture primary = Futures.immediateFailedFuture((Throwable)new Exception());
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Throwable, Integer> fallback = new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) {
                return secondary;
            }
        };
        ListenableFuture derived = Futures.catchingAsync((ListenableFuture)primary, Throwable.class, (AsyncFunction)fallback);
        secondary.set((Object)1);
        FuturesTest.assertEquals((int)1, (int)((Integer)Futures.getDone((Future)derived)));
    }

    public void testCatchingAsync_resultInterruptedBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        AsyncFunction fallback = FuturesTest.unexpectedAsyncFunction();
        ListenableFuture derived = Futures.catchingAsync((ListenableFuture)primary, Throwable.class, fallback);
        derived.cancel(true);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertTrue((boolean)primary.wasInterrupted());
    }

    public void testCatchingAsync_resultCancelledBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        AsyncFunction fallback = FuturesTest.unexpectedAsyncFunction();
        ListenableFuture derived = Futures.catchingAsync((ListenableFuture)primary, Throwable.class, fallback);
        derived.cancel(false);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertFalse((boolean)primary.wasInterrupted());
    }

    @GwtIncompatible
    public void testCatchingAsync_resultCancelledAfterFallback() throws Exception {
        final SettableFuture secondary = SettableFuture.create();
        final RuntimeException raisedException = new RuntimeException();
        AsyncFunctionSpy<Throwable, Integer> fallback = FuturesTest.spy(new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) throws Exception {
                Truth.assertThat((Throwable)t).isSameAs((Object)raisedException);
                return secondary;
            }
        });
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        ListenableFuture derived = Futures.catchingAsync((ListenableFuture)failingFuture, Throwable.class, fallback);
        derived.cancel(false);
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertFalse((boolean)secondary.wasInterrupted());
        fallback.verifyCallCount(1);
    }

    public void testCatchingAsync_nullInsteadOfFuture() throws Exception {
        ListenableFuture inputFuture = Futures.immediateFailedFuture((Throwable)new Exception());
        ListenableFuture chainedFuture = Futures.catchingAsync((ListenableFuture)inputFuture, Throwable.class, (AsyncFunction)new AsyncFunction<Throwable, Integer>(){

            public ListenableFuture<Integer> apply(Throwable t) {
                return null;
            }
        });
        try {
            Futures.getDone((Future)chainedFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            NullPointerException cause = (NullPointerException)expected.getCause();
            Truth.assertThat((Throwable)cause).hasMessage("AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
        }
    }

    @GwtIncompatible
    public void testCatchingAsync_interruptPropagatesToTransformingThread() throws Exception {
        SettableFuture input = SettableFuture.create();
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch shouldCompleteFunction = new CountDownLatch(1);
        final CountDownLatch gotException = new CountDownLatch(1);
        AsyncFunction<Throwable, String> function = new AsyncFunction<Throwable, String>(){

            public ListenableFuture<String> apply(Throwable t) throws Exception {
                inFunction.countDown();
                try {
                    shouldCompleteFunction.await();
                }
                catch (InterruptedException expected) {
                    gotException.countDown();
                    throw expected;
                }
                return Futures.immediateFuture((Object)"a");
            }
        };
        ListenableFuture futureResult = Futures.catchingAsync((ListenableFuture)input, Exception.class, (AsyncFunction)function, (Executor)Executors.newSingleThreadExecutor());
        input.setException((Throwable)new Exception());
        inFunction.await();
        futureResult.cancel(true);
        shouldCompleteFunction.countDown();
        try {
            futureResult.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        FuturesTest.assertEquals((long)1L, (long)gotException.getCount());
    }

    public void testCatching_inputDoesNotRaiseException() throws Exception {
        Function fallback = FuturesTest.unexpectedFunction();
        ListenableFuture originalFuture = Futures.immediateFuture((Object)7);
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)originalFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)7, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    public void testCatching_inputRaisesException() throws Exception {
        final RuntimeException raisedException = new RuntimeException();
        FunctionSpy<Throwable, Integer> fallback = FuturesTest.spy(new Function<Throwable, Integer>(){

            public Integer apply(Throwable t) {
                Truth.assertThat((Throwable)t).isSameAs((Object)raisedException);
                return 20;
            }
        });
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)failingFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)20, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
        fallback.verifyCallCount(1);
    }

    public void testCatching_fallbackGeneratesRuntimeException() throws Exception {
        RuntimeException expectedException = new RuntimeException();
        this.runExpectedExceptionCatchingTest(expectedException);
    }

    public void testCatching_fallbackGeneratesError() throws Exception {
        final Error error = new Error("deliberate");
        Function<Throwable, Integer> fallback = new Function<Throwable, Integer>(){

            public Integer apply(Throwable t) {
                throw error;
            }
        };
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        try {
            Futures.getDone((Future)Futures.catching((ListenableFuture)failingFuture, Throwable.class, (Function)fallback));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)error, (Object)expected.getCause());
        }
    }

    private void runExpectedExceptionCatchingTest(final RuntimeException expectedException) throws Exception {
        FunctionSpy<Throwable, Integer> fallback = FuturesTest.spy(new Function<Throwable, Integer>(){

            public Integer apply(Throwable t) {
                throw expectedException;
            }
        });
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)failingFuture, Throwable.class, fallback);
        try {
            Futures.getDone((Future)faultTolerantFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)expectedException, (Object)expected.getCause());
        }
        fallback.verifyCallCount(1);
    }

    public void testCatching_resultInterruptedBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        Function fallback = FuturesTest.unexpectedFunction();
        ListenableFuture derived = Futures.catching((ListenableFuture)primary, Throwable.class, fallback);
        derived.cancel(true);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertTrue((boolean)primary.wasInterrupted());
    }

    public void testCatching_resultCancelledBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        Function fallback = FuturesTest.unexpectedFunction();
        ListenableFuture derived = Futures.catching((ListenableFuture)primary, Throwable.class, fallback);
        derived.cancel(false);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertFalse((boolean)primary.wasInterrupted());
    }

    public void testCatching_Throwable() throws Exception {
        Function fallback = this.functionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new IOException());
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)originalFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)1, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    @GwtIncompatible
    public void testCatching_customTypeMatch() throws Exception {
        Function fallback = this.functionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new FileNotFoundException());
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)originalFuture, IOException.class, fallback);
        FuturesTest.assertEquals((int)1, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    @GwtIncompatible
    public void testCatching_customTypeNoMatch() throws Exception {
        Function fallback = this.functionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        ListenableFuture faultTolerantFuture = Futures.catching((ListenableFuture)originalFuture, IOException.class, fallback);
        try {
            Futures.getDone((Future)faultTolerantFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RuntimeException.class);
        }
    }

    @GwtIncompatible
    public void testCatching_StackOverflow() throws Exception {
        SettableFuture root = SettableFuture.create();
        ListenableFuture unused = Futures.catching((ListenableFuture)root, MyException.class, (Function)Functions.identity());
        root.setException((Throwable)new MyException());
        SettableFuture output = root = SettableFuture.create();
        for (int i = 0; i < 10000; ++i) {
            output = Futures.catching((ListenableFuture)output, MyException.class, (Function)Functions.identity());
        }
        try {
            root.setException((Throwable)new MyException());
            FuturesTest.fail();
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    public void testCatching_ErrorAfterCancellation() throws Exception {
        ListenableFuture output;
        class Fallback
        implements Function<Throwable, Object> {
            ListenableFuture<Object> output;

            Fallback() {
            }

            public Object apply(Throwable input) {
                this.output.cancel(false);
                throw new MyError();
            }
        }
        Fallback fallback = new Fallback();
        SettableFuture input = SettableFuture.create();
        fallback.output = output = Futures.catching((ListenableFuture)input, Throwable.class, (Function)fallback);
        input.setException((Throwable)new MyException());
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testCatching_ExceptionAfterCancellation() throws Exception {
        ListenableFuture output;
        class Fallback
        implements Function<Throwable, Object> {
            ListenableFuture<Object> output;

            Fallback() {
            }

            public Object apply(Throwable input) {
                this.output.cancel(false);
                throw new MyRuntimeException();
            }
        }
        Fallback fallback = new Fallback();
        SettableFuture input = SettableFuture.create();
        fallback.output = output = Futures.catching((ListenableFuture)input, Throwable.class, (Function)fallback);
        input.setException((Throwable)new MyException());
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testCatching_getThrowsRuntimeException() throws Exception {
        ListenableFuture input = UncheckedThrowingFuture.throwingRuntimeException(new MyRuntimeException());
        ListenableFuture output = Futures.catching(input, Throwable.class, (Function)Functions.identity());
        Truth.assertThat((Object)Futures.getDone((Future)output)).isInstanceOf(MyRuntimeException.class);
    }

    public void testCatching_getThrowsError() throws Exception {
        ListenableFuture input = UncheckedThrowingFuture.throwingError(new MyError());
        ListenableFuture output = Futures.catching(input, Throwable.class, (Function)Functions.identity());
        Truth.assertThat((Object)Futures.getDone((Future)output)).isInstanceOf(MyError.class);
    }

    public void testCatching_listenerThrowsError() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture output = Futures.catching((ListenableFuture)input, Throwable.class, (Function)Functions.identity());
        output.addListener(new Runnable(){

            @Override
            public void run() {
                throw new MyError();
            }
        }, MoreExecutors.directExecutor());
        try {
            input.setException((Throwable)new MyException());
            FuturesTest.fail();
        }
        catch (MyError myError) {
            // empty catch block
        }
    }

    public void testCatchingAsync_Throwable() throws Exception {
        AsyncFunction fallback = this.asyncFunctionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new IOException());
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)originalFuture, Throwable.class, fallback);
        FuturesTest.assertEquals((int)1, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    @GwtIncompatible
    public void testCatchingAsync_customTypeMatch() throws Exception {
        AsyncFunction fallback = this.asyncFunctionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new FileNotFoundException());
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)originalFuture, IOException.class, fallback);
        FuturesTest.assertEquals((int)1, (int)((Integer)Futures.getDone((Future)faultTolerantFuture)));
    }

    @GwtIncompatible
    public void testCatchingAsync_customTypeNoMatch() throws Exception {
        AsyncFunction fallback = this.asyncFunctionReturningOne();
        ListenableFuture originalFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        ListenableFuture faultTolerantFuture = Futures.catchingAsync((ListenableFuture)originalFuture, IOException.class, fallback);
        try {
            Futures.getDone((Future)faultTolerantFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RuntimeException.class);
        }
    }

    /*
     * Exception decompiling
     */
    @GwtIncompatible
    public void testCatchingAsync_StackOverflow() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testCatchingAsync_ErrorAfterCancellation() throws Exception {
        ListenableFuture output;
        class Fallback
        implements AsyncFunction<Throwable, Object> {
            ListenableFuture<Object> output;

            Fallback() {
            }

            public ListenableFuture<Object> apply(Throwable input) {
                this.output.cancel(false);
                throw new MyError();
            }
        }
        Fallback fallback = new Fallback();
        SettableFuture input = SettableFuture.create();
        fallback.output = output = Futures.catchingAsync((ListenableFuture)input, Throwable.class, (AsyncFunction)fallback);
        input.setException((Throwable)new MyException());
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    public void testCatchingAsync_ExceptionAfterCancellation() throws Exception {
        ListenableFuture output;
        class Fallback
        implements AsyncFunction<Throwable, Object> {
            ListenableFuture<Object> output;

            Fallback() {
            }

            public ListenableFuture<Object> apply(Throwable input) {
                this.output.cancel(false);
                throw new MyRuntimeException();
            }
        }
        Fallback fallback = new Fallback();
        SettableFuture input = SettableFuture.create();
        fallback.output = output = Futures.catchingAsync((ListenableFuture)input, Throwable.class, (AsyncFunction)fallback);
        input.setException((Throwable)new MyException());
        FuturesTest.assertTrue((boolean)output.isCancelled());
    }

    /*
     * Exception decompiling
     */
    public void testCatchingAsync_getThrowsRuntimeException() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCatchingAsync_getThrowsError() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCatchingAsync_listenerThrowsError() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testCatching_rejectionPropagatesToOutput() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture transformed = Futures.catching((ListenableFuture)input, Throwable.class, (Function)Functions.constant((Object)"foo"), (Executor)REJECTING_EXECUTOR);
        input.setException((Throwable)new Exception());
        try {
            Futures.getDone((Future)transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RejectedExecutionException.class);
        }
    }

    public void testCatchingAsync_rejectionPropagatesToOutput() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture transformed = Futures.catchingAsync((ListenableFuture)input, Throwable.class, FuturesTest.constantAsyncFunction(Futures.immediateFuture((Object)"foo")), (Executor)REJECTING_EXECUTOR);
        input.setException((Throwable)new Exception());
        try {
            Futures.getDone((Future)transformed);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(RejectedExecutionException.class);
        }
    }

    private <X extends Throwable> Function<X, Integer> functionReturningOne() {
        return new Function<X, Integer>(){

            public Integer apply(X t) {
                return 1;
            }
        };
    }

    private <X extends Throwable> AsyncFunction<X, Integer> asyncFunctionReturningOne() {
        return new AsyncFunction<X, Integer>(){

            public ListenableFuture<Integer> apply(X t) {
                return Futures.immediateFuture((Object)1);
            }
        };
    }

    private static <I, O> AsyncFunction<I, O> constantAsyncFunction(final ListenableFuture<O> output) {
        return new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(I input) {
                return output;
            }
        };
    }

    public void testTransformAsync_genericsWildcard_AsyncFunction() throws Exception {
        ListenableFuture nullFuture = Futures.immediateFuture(null);
        ListenableFuture chainedFuture = Futures.transformAsync((ListenableFuture)nullFuture, FuturesTest.constantAsyncFunction(nullFuture));
        FuturesTest.assertNull((Object)Futures.getDone((Future)chainedFuture));
    }

    public void testTransformAsync_genericsHierarchy_AsyncFunction() throws Exception {
        ListenableFuture future = Futures.immediateFuture(null);
        final BarChild barChild = new BarChild();
        AsyncFunction<Foo, BarChild> function = new AsyncFunction<Foo, BarChild>(){

            public AbstractFuture<BarChild> apply(Foo unused) {
                AbstractFuture<BarChild> future = new AbstractFuture<BarChild>(){};
                future.set((Object)barChild);
                return future;
            }
        };
        Bar bar = (Bar)Futures.getDone((Future)Futures.transformAsync((ListenableFuture)future, (AsyncFunction)function));
        FuturesTest.assertSame((Object)barChild, (Object)bar);
    }

    @GwtIncompatible
    public void testTransformAsync_asyncFunction_timeout() throws InterruptedException, ExecutionException {
        AsyncFunction function = FuturesTest.constantAsyncFunction(Futures.immediateFuture((Object)1));
        ListenableFuture future = Futures.transformAsync((ListenableFuture)SettableFuture.create(), function);
        try {
            future.get(1L, TimeUnit.MILLISECONDS);
            FuturesTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testTransformAsync_asyncFunction_error() throws InterruptedException {
        final Error error = new Error("deliberate");
        AsyncFunction<String, Integer> function = new AsyncFunction<String, Integer>(){

            public ListenableFuture<Integer> apply(String input) {
                throw error;
            }
        };
        SettableFuture inputFuture = SettableFuture.create();
        ListenableFuture outputFuture = Futures.transformAsync((ListenableFuture)inputFuture, (AsyncFunction)function);
        inputFuture.set((Object)"value");
        try {
            Futures.getDone((Future)outputFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)error, (Object)expected.getCause());
        }
    }

    public void testTransformAsync_asyncFunction_nullInsteadOfFuture() throws Exception {
        ListenableFuture inputFuture = Futures.immediateFuture((Object)"a");
        ListenableFuture chainedFuture = Futures.transformAsync((ListenableFuture)inputFuture, FuturesTest.constantAsyncFunction(null));
        try {
            Futures.getDone((Future)chainedFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            NullPointerException cause = (NullPointerException)expected.getCause();
            Truth.assertThat((Throwable)cause).hasMessage("AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
        }
    }

    @GwtIncompatible
    public void testTransformAsync_asyncFunction_cancelledWhileApplyingFunction() throws InterruptedException, ExecutionException {
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch functionDone = new CountDownLatch(1);
        final SettableFuture resultFuture = SettableFuture.create();
        AsyncFunction<String, Integer> function = new AsyncFunction<String, Integer>(){

            public ListenableFuture<Integer> apply(String input) throws Exception {
                inFunction.countDown();
                functionDone.await();
                return resultFuture;
            }
        };
        SettableFuture inputFuture = SettableFuture.create();
        ListenableFuture future = Futures.transformAsync((ListenableFuture)inputFuture, (AsyncFunction)function, (Executor)Executors.newSingleThreadExecutor());
        inputFuture.set((Object)"value");
        inFunction.await();
        future.cancel(false);
        functionDone.countDown();
        try {
            future.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            resultFuture.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testTransformAsync_asyncFunction_cancelledBeforeApplyingFunction() throws InterruptedException {
        final AtomicBoolean functionCalled = new AtomicBoolean();
        AsyncFunction<String, Integer> function = new AsyncFunction<String, Integer>(){

            public ListenableFuture<Integer> apply(String input) throws Exception {
                functionCalled.set(true);
                return Futures.immediateFuture((Object)1);
            }
        };
        SettableFuture inputFuture = SettableFuture.create();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ListenableFuture future = Futures.transformAsync((ListenableFuture)inputFuture, (AsyncFunction)function, (Executor)executor);
        final CountDownLatch beforeFunction = new CountDownLatch(1);
        executor.submit(new Runnable(){

            @Override
            public void run() {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)beforeFunction);
            }
        });
        inputFuture.set((Object)"value");
        future.cancel(false);
        beforeFunction.countDown();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        FuturesTest.assertFalse((boolean)functionCalled.get());
    }

    public void testDereference_genericsWildcard() throws Exception {
        ListenableFuture inner = Futures.immediateFuture(null);
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        FuturesTest.assertNull((Object)Futures.getDone((Future)dereferenced));
    }

    public void testDereference_genericsHierarchy() throws Exception {
        FooChild fooChild = new FooChild();
        ListenableFuture inner = Futures.immediateFuture((Object)fooChild);
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        FuturesTest.assertSame((Object)fooChild, (Object)Futures.getDone((Future)dereferenced));
    }

    public void testDereference_resultCancelsOuter() throws Exception {
        SettableFuture outer = SettableFuture.create();
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        dereferenced.cancel(true);
        FuturesTest.assertTrue((boolean)outer.isCancelled());
    }

    public void testDereference_resultCancelsInner() throws Exception {
        SettableFuture inner = SettableFuture.create();
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        dereferenced.cancel(true);
        FuturesTest.assertTrue((boolean)inner.isCancelled());
    }

    public void testDereference_outerCancelsResult() throws Exception {
        SettableFuture outer = SettableFuture.create();
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        outer.cancel(true);
        FuturesTest.assertTrue((boolean)dereferenced.isCancelled());
    }

    public void testDereference_innerCancelsResult() throws Exception {
        SettableFuture inner = SettableFuture.create();
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        inner.cancel(true);
        FuturesTest.assertTrue((boolean)dereferenced.isCancelled());
    }

    public void testAllAsList() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.set((Object)DATA1);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{DATA1, DATA2, DATA3}).inOrder();
    }

    public void testAllAsList_emptyList() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ImmutableList futures = ImmutableList.of();
        ListenableFuture compound = Futures.allAsList((Iterable)futures);
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        Truth.assertThat((Iterable)((Iterable)Futures.getDone((Future)compound))).isEmpty();
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testAllAsList_emptyArray() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[0]);
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        Truth.assertThat((Iterable)((Iterable)Futures.getDone((Future)compound))).isEmpty();
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testAllAsList_failure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        listener.expectCall();
        Throwable exception = new Throwable("failed1");
        future1.setException(exception);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        future2.set((Object)"result2");
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testAllAsList_singleFailure() throws Exception {
        Throwable exception = new Throwable("failed");
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future));
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testAllAsList_immediateFailure() throws Exception {
        Throwable exception = new Throwable("failed");
        ListenableFuture future1 = Futures.immediateFailedFuture((Throwable)exception);
        ListenableFuture future2 = Futures.immediateFuture((Object)"results");
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testAllAsList_error() throws Exception {
        Error error = new Error("deliberate");
        SettableFuture future1 = SettableFuture.create();
        ListenableFuture future2 = Futures.immediateFuture((Object)"results");
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        future1.setException((Throwable)error);
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)error, (Object)expected.getCause());
        }
    }

    public void testAllAsList_cancelled() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        listener.expectCall();
        future1.cancel(true);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        future2.setException(new Throwable("failed2"));
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
    }

    public void testAllAsList_resultCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future1.wasInterrupted());
    }

    public void testAllAsList_resultCancelledInterrupted_withSecondaryListFuture() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        ListenableFuture otherCompound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        FuturesTest.assertTrue((boolean)compound.cancel(true));
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertTrue((boolean)future1.wasInterrupted());
        FuturesTest.assertTrue((boolean)future2.isCancelled());
        FuturesTest.assertTrue((boolean)future2.wasInterrupted());
        FuturesTest.assertTrue((boolean)otherCompound.isCancelled());
    }

    public void testAllAsList_resultCancelled_withSecondaryListFuture() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        ListenableFuture unused = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future1.wasInterrupted());
        FuturesTest.assertTrue((boolean)future2.isCancelled());
        FuturesTest.assertFalse((boolean)future2.wasInterrupted());
    }

    public void testAllAsList_resultInterrupted() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(true));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertTrue((boolean)future1.wasInterrupted());
    }

    public void testAllAsList_doneFutures() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        future1.set((Object)DATA1);
        future2.set((Object)DATA2);
        future3.set((Object)DATA3);
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{DATA1, DATA2, DATA3}).inOrder();
    }

    public void testAllAsList_logging_exception() throws Exception {
        try {
            Futures.getDone((Future)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException())}));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyException.class);
            FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.aggregateFutureLogHandler.getStoredLogRecords().size());
        }
    }

    public void testAllAsList_logging_error() throws Exception {
        try {
            Futures.getDone((Future)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyError())}));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyError.class);
            List logged = this.aggregateFutureLogHandler.getStoredLogRecords();
            Truth.assertThat((Iterable)logged).hasSize(1);
            Truth.assertThat((Throwable)((LogRecord)logged.get(0)).getThrown()).isInstanceOf(MyError.class);
        }
    }

    public void testAllAsList_logging_multipleExceptions_alreadyDone() throws Exception {
        try {
            Futures.getDone((Future)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException())}));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyException.class);
            List logged = this.aggregateFutureLogHandler.getStoredLogRecords();
            Truth.assertThat((Iterable)logged).hasSize(1);
            Truth.assertThat((Throwable)((LogRecord)logged.get(0)).getThrown()).isInstanceOf(MyException.class);
        }
    }

    public void testAllAsList_logging_multipleExceptions_doneLater() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture all = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        future1.setException((Throwable)new MyException());
        future2.setException((Throwable)new MyException());
        future3.setException((Throwable)new MyException());
        try {
            Futures.getDone((Future)all);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            List logged = this.aggregateFutureLogHandler.getStoredLogRecords();
            Truth.assertThat((Iterable)logged).hasSize(2);
            Truth.assertThat((Throwable)((LogRecord)logged.get(0)).getThrown()).isInstanceOf(MyException.class);
            Truth.assertThat((Throwable)((LogRecord)logged.get(1)).getThrown()).isInstanceOf(MyException.class);
        }
    }

    public void testAllAsList_logging_same_exception() throws Exception {
        try {
            MyException sameInstance = new MyException();
            Futures.getDone((Future)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)sameInstance), Futures.immediateFailedFuture((Throwable)sameInstance)}));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyException.class);
            FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.aggregateFutureLogHandler.getStoredLogRecords().size());
        }
    }

    public void testAllAsList_logging_seenExceptionUpdateRace() throws Exception {
        final MyException sameInstance = new MyException();
        SettableFuture firstFuture = SettableFuture.create();
        final SettableFuture secondFuture = SettableFuture.create();
        ListenableFuture bulkFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{firstFuture, secondFuture});
        bulkFuture.addListener(new Runnable(){

            @Override
            public void run() {
                secondFuture.setException((Throwable)sameInstance);
            }
        }, MoreExecutors.directExecutor());
        firstFuture.setException((Throwable)sameInstance);
        try {
            Futures.getDone((Future)bulkFuture);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyException.class);
            Truth.assertThat((Iterable)this.aggregateFutureLogHandler.getStoredLogRecords()).isEmpty();
        }
    }

    public void testAllAsList_logging_seenExceptionUpdateCancelRace() throws Exception {
        final MyException subsequentFailure = new MyException();
        SettableFuture firstFuture = SettableFuture.create();
        final SettableFuture secondFuture = SettableFuture.create();
        ListenableFuture bulkFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{firstFuture, secondFuture});
        bulkFuture.addListener(new Runnable(){

            @Override
            public void run() {
                secondFuture.setException((Throwable)subsequentFailure);
            }
        }, MoreExecutors.directExecutor());
        firstFuture.cancel(false);
        try {
            Futures.getDone((Future)bulkFuture);
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            Truth.assertThat((Throwable)((LogRecord)Iterables.getOnlyElement((Iterable)this.aggregateFutureLogHandler.getStoredLogRecords())).getThrown()).isSameAs((Object)subsequentFailure);
        }
    }

    public void testAllAsList_logging_same_cause() throws Exception {
        try {
            MyException exception1 = new MyException();
            MyException exception2 = new MyException();
            MyException exception3 = new MyException();
            MyException sameInstance = new MyException();
            exception1.initCause(sameInstance);
            exception2.initCause(sameInstance);
            exception3.initCause(exception2);
            Futures.getDone((Future)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)exception1), Futures.immediateFailedFuture((Throwable)exception3)}));
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(MyException.class);
            FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.aggregateFutureLogHandler.getStoredLogRecords().size());
        }
    }

    private static String createCombinedResult(Integer i, Boolean b) {
        return "-" + i + "-" + b;
    }

    public void testWhenAllComplete_wildcard() throws Exception {
        ListenableFuture futureA = Futures.immediateFuture((Object)"a");
        ListenableFuture futureB = Futures.immediateFuture((Object)"b");
        ListenableFuture[] futures = new ListenableFuture[]{};
        Callable<String> combiner = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "hi";
            }
        };
        ListenableFuture unused = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{futureA, futureB}).call((Callable)combiner);
        unused = Futures.whenAllComplete(Arrays.asList(futures)).call((Callable)combiner);
    }

    public void testWhenAllComplete_asyncResult() throws Exception {
        final SettableFuture futureInteger = SettableFuture.create();
        final SettableFuture futureBoolean = SettableFuture.create();
        AsyncCallable<String> combiner = new AsyncCallable<String>(){

            public ListenableFuture<String> call() throws Exception {
                return Futures.immediateFuture((Object)FuturesTest.createCombinedResult((Integer)Futures.getDone((Future)futureInteger), (Boolean)Futures.getDone((Future)futureBoolean)));
            }
        };
        ListenableFuture futureResult = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{futureInteger, futureBoolean}).callAsync((AsyncCallable)combiner);
        Integer integerPartial = 1;
        futureInteger.set((Object)integerPartial);
        Boolean booleanPartial = true;
        futureBoolean.set((Object)booleanPartial);
        FuturesTest.assertEquals((String)FuturesTest.createCombinedResult(integerPartial, booleanPartial), (String)((String)Futures.getDone((Future)futureResult)));
    }

    public void testWhenAllComplete_asyncError() throws Exception {
        final RuntimeException thrown = new RuntimeException("test");
        final SettableFuture futureInteger = SettableFuture.create();
        final SettableFuture futureBoolean = SettableFuture.create();
        AsyncCallable<String> combiner = new AsyncCallable<String>(){

            public ListenableFuture<String> call() throws Exception {
                Assert.assertTrue((boolean)futureInteger.isDone());
                Assert.assertTrue((boolean)futureBoolean.isDone());
                return Futures.immediateFailedFuture((Throwable)thrown);
            }
        };
        ListenableFuture futureResult = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{futureInteger, futureBoolean}).callAsync((AsyncCallable)combiner);
        Integer integerPartial = 1;
        futureInteger.set((Object)integerPartial);
        Boolean booleanPartial = true;
        futureBoolean.set((Object)booleanPartial);
        try {
            Futures.getDone((Future)futureResult);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)thrown, (Object)expected.getCause());
        }
    }

    @GwtIncompatible
    public void testWhenAllComplete_cancelledNotInterrupted() throws Exception {
        SettableFuture stringFuture = SettableFuture.create();
        SettableFuture booleanFuture = SettableFuture.create();
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch shouldCompleteFunction = new CountDownLatch(1);
        final SettableFuture resultFuture = SettableFuture.create();
        AsyncCallable<String> combiner = new AsyncCallable<String>(){

            public ListenableFuture<String> call() throws Exception {
                inFunction.countDown();
                shouldCompleteFunction.await();
                return resultFuture;
            }
        };
        ListenableFuture futureResult = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{stringFuture, booleanFuture}).callAsync((AsyncCallable)combiner, (Executor)Executors.newSingleThreadExecutor());
        stringFuture.set((Object)"value");
        booleanFuture.set((Object)true);
        inFunction.await();
        futureResult.cancel(false);
        shouldCompleteFunction.countDown();
        try {
            futureResult.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            resultFuture.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testWhenAllComplete_interrupted() throws Exception {
        SettableFuture stringFuture = SettableFuture.create();
        SettableFuture booleanFuture = SettableFuture.create();
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch gotException = new CountDownLatch(1);
        AsyncCallable<String> combiner = new AsyncCallable<String>(){

            public ListenableFuture<String> call() throws Exception {
                inFunction.countDown();
                try {
                    new CountDownLatch(1).await();
                }
                catch (InterruptedException expected) {
                    gotException.countDown();
                    throw expected;
                }
                return Futures.immediateFuture((Object)"a");
            }
        };
        ListenableFuture futureResult = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{stringFuture, booleanFuture}).callAsync((AsyncCallable)combiner, (Executor)Executors.newSingleThreadExecutor());
        stringFuture.set((Object)"value");
        booleanFuture.set((Object)true);
        inFunction.await();
        futureResult.cancel(true);
        try {
            futureResult.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        gotException.await();
    }

    public void testWhenAllSucceed() throws Exception {
        SettableFuture futureInteger = SettableFuture.create();
        SettableFuture futureBoolean = SettableFuture.create();
        AsyncCallable<String> combiner = new AsyncCallable<String>(){

            public ListenableFuture<String> call() throws Exception {
                throw new AssertionFailedError("AsyncCallable should not have been called.");
            }
        };
        ListenableFuture futureResult = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{futureInteger, futureBoolean}).callAsync((AsyncCallable)combiner);
        class PartialResultException
        extends Exception {
            PartialResultException() {
            }
        }
        PartialResultException partialResultException = new PartialResultException();
        futureInteger.setException((Throwable)partialResultException);
        Boolean booleanPartial = true;
        futureBoolean.set((Object)booleanPartial);
        try {
            Futures.getDone((Future)futureResult);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)partialResultException, (Object)expected.getCause());
        }
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    static <V> V pseudoTimedGetUninterruptibly(final Future<V> input, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future waiter = executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return input.get();
            }
        });
        try {
            Object object = Uninterruptibles.getUninterruptibly(waiter, (long)timeout, (TimeUnit)unit);
            return (V)object;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ExecutionException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), CancellationException.class);
            throw FuturesTest.failureWithCause(e, "Unexpected exception");
        }
        finally {
            executor.shutdownNow();
        }
    }

    @GwtIncompatible
    private static void runExtensiveMergerTest(Merger merger) throws InterruptedException {
        int inputCount = new TestFutureBatch().allFutures.size();
        for (int i = 0; i < inputCount; ++i) {
            for (int j = 0; j < inputCount; ++j) {
                for (boolean iBeforeJ : new boolean[]{true, false}) {
                    List result;
                    TestFutureBatch inputs = new TestFutureBatch();
                    ListenableFuture<String> iFuture = ((TestFuture)inputs.allFutures.get((int)i)).future;
                    ListenableFuture<String> jFuture = ((TestFuture)inputs.allFutures.get((int)j)).future;
                    ListenableFuture<List<String>> future = merger.merged(iFuture, jFuture);
                    try {
                        result = (List)future.get(0L, TimeUnit.MILLISECONDS);
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateFailure(iFuture, jFuture, e);
                    }
                    catch (TimeoutException e) {
                        inputs.assertHasDelayed(iFuture, jFuture, e);
                    }
                    try {
                        result = FuturesTest.conditionalPseudoTimedGetUninterruptibly(inputs, iFuture, jFuture, future, 20, TimeUnit.MILLISECONDS);
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateFailure(iFuture, jFuture, e);
                    }
                    catch (TimeoutException e) {
                        inputs.assertHasDelayed(iFuture, jFuture, e);
                    }
                    ((TestFuture)inputs.allFutures.get((int)(iBeforeJ ? i : j))).finisher.run();
                    ((TestFuture)inputs.allFutures.get((int)(iBeforeJ ? j : i))).finisher.run();
                    try {
                        result = (List)Futures.getDone(future);
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", "b", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasFailure(iFuture, jFuture, e);
                    }
                }
            }
        }
    }

    @GwtIncompatible
    private static List<String> conditionalPseudoTimedGetUninterruptibly(TestFutureBatch inputs, ListenableFuture<String> iFuture, ListenableFuture<String> jFuture, ListenableFuture<List<String>> future, int timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return inputs.hasDelayed(iFuture, jFuture) ? FuturesTest.pseudoTimedGetUninterruptibly(future, timeout, unit) : FuturesTest.pseudoTimedGetUninterruptibly(future, 2500L, TimeUnit.MILLISECONDS);
    }

    @GwtIncompatible
    public void testAllAsList_extensive() throws InterruptedException {
        FuturesTest.runExtensiveMergerTest(Merger.allMerger);
    }

    @GwtIncompatible
    public void testSuccessfulAsList_extensive() throws InterruptedException {
        FuturesTest.runExtensiveMergerTest(Merger.successMerger);
    }

    public void testSuccessfulAsList() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.set((Object)DATA1);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{DATA1, DATA2, DATA3}).inOrder();
    }

    public void testSuccessfulAsList_emptyList() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ImmutableList futures = ImmutableList.of();
        ListenableFuture compound = Futures.successfulAsList((Iterable)futures);
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        Truth.assertThat((Iterable)((Iterable)Futures.getDone((Future)compound))).isEmpty();
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testSuccessfulAsList_emptyArray() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[0]);
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        Truth.assertThat((Iterable)((Iterable)Futures.getDone((Future)compound))).isEmpty();
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testSuccessfulAsList_partialFailure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.setException(new Throwable("failed1"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.set((Object)DATA2);
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{null, DATA2}).inOrder();
    }

    public void testSuccessfulAsList_totalFailure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.setException(new Throwable("failed1"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.setException(new Throwable("failed2"));
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{null, null}).inOrder();
    }

    public void testSuccessfulAsList_cancelled() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.cancel(true);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.set((Object)DATA2);
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{null, DATA2}).inOrder();
    }

    public void testSuccessfulAsList_resultCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future1.wasInterrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuccessfulAsList_resultCancelledRacingInputDone() throws Exception {
        TestLogHandler listenerLoggerHandler = new TestLogHandler();
        Logger exceptionLogger = Logger.getLogger(AbstractFuture.class.getName());
        exceptionLogger.addHandler((Handler)listenerLoggerHandler);
        try {
            FuturesTest.doTestSuccessfulAsList_resultCancelledRacingInputDone();
            Truth.assertWithMessage((String)"Nothing should be logged").that((Iterable)listenerLoggerHandler.getStoredLogRecords()).isEmpty();
        }
        finally {
            exceptionLogger.removeHandler((Handler)listenerLoggerHandler);
        }
    }

    private static void doTestSuccessfulAsList_resultCancelledRacingInputDone() throws Exception {
        Futures.successfulAsList((Iterable)ImmutableList.of((Object)SettableFuture.create())).cancel(true);
        final SettableFuture future1 = SettableFuture.create();
        final SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future1.addListener(new Runnable(){

            @Override
            public void run() {
                Assert.assertTrue((boolean)future1.isCancelled());
                Assert.assertFalse((boolean)future2.isCancelled());
                future2.set((Object)FuturesTest.DATA2);
            }
        }, MoreExecutors.directExecutor());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future2.isCancelled());
        try {
            Futures.getDone((Future)compound);
            FuturesTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testSuccessfulAsList_resultInterrupted() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(true));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertTrue((boolean)future1.wasInterrupted());
    }

    public void testSuccessfulAsList_mixed() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        compound.addListener((Runnable)listener, MoreExecutors.directExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.cancel(true);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.setException(new Throwable("failed2"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)Futures.getDone((Future)compound);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{null, null, DATA3}).inOrder();
    }

    public void testSuccessfulAsList_logging_exception() throws Exception {
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null}), (Object)Futures.getDone((Future)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException())})));
        Truth.assertWithMessage((String)"Nothing should be logged").that((Iterable)this.aggregateFutureLogHandler.getStoredLogRecords()).isEmpty();
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null, null, null}), (Object)Futures.getDone((Future)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException())})));
        Truth.assertWithMessage((String)"Nothing should be logged").that((Iterable)this.aggregateFutureLogHandler.getStoredLogRecords()).isEmpty();
    }

    public void testSuccessfulAsList_logging_error() throws Exception {
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null}), (Object)Futures.getDone((Future)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyError())})));
        List logged = this.aggregateFutureLogHandler.getStoredLogRecords();
        Truth.assertThat((Iterable)logged).hasSize(1);
        Truth.assertThat((Throwable)((LogRecord)logged.get(0)).getThrown()).isInstanceOf(MyError.class);
    }

    public void testNonCancellationPropagating_successful() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        Foo foo = new Foo();
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        input.set((Object)foo);
        FuturesTest.assertTrue((boolean)wrapper.isDone());
        FuturesTest.assertSame((Object)foo, (Object)Futures.getDone((Future)wrapper));
    }

    public void testNonCancellationPropagating_failure() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        Throwable failure = new Throwable("thrown");
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        input.setException(failure);
        try {
            Futures.getDone((Future)wrapper);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)failure, (Object)expected.getCause());
        }
    }

    public void testNonCancellationPropagating_delegateCancelled() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        FuturesTest.assertTrue((boolean)input.cancel(false));
        FuturesTest.assertTrue((boolean)wrapper.isCancelled());
    }

    public void testNonCancellationPropagating_doesNotPropagate() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        FuturesTest.assertTrue((boolean)wrapper.cancel(true));
        FuturesTest.assertTrue((boolean)wrapper.isCancelled());
        FuturesTest.assertTrue((boolean)wrapper.isDone());
        FuturesTest.assertFalse((boolean)input.isCancelled());
        FuturesTest.assertFalse((boolean)input.isDone());
    }

    @GwtIncompatible
    public void testMakeChecked_mapsExecutionExceptions() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        future.setException((Throwable)new IOException("checked"));
        FuturesTest.assertTrue((boolean)checked.isDone());
        FuturesTest.assertFalse((boolean)checked.isCancelled());
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(IOException.class);
        }
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(IOException.class);
        }
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(IOException.class);
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(IOException.class);
        }
    }

    @GwtIncompatible
    public void testMakeChecked_mapsInterruption() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        Thread.currentThread().interrupt();
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (InterruptedException expected) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (InterruptedException expected) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(InterruptedException.class);
        }
        Thread.currentThread().interrupt();
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(InterruptedException.class);
        }
    }

    @GwtIncompatible
    public void testMakeChecked_mapsCancellation() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        FuturesTest.assertTrue((boolean)future.cancel(true));
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(CancellationException.class);
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(CancellationException.class);
        }
    }

    @GwtIncompatible
    public void testMakeChecked_propagatesFailedMappers() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        future.setException((Throwable)new Exception("failed"));
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMakeChecked_listenersRunOnceCompleted() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.set((Object)DATA1);
        tester.testCompletedFuture(DATA1);
        tester.tearDown();
    }

    @GwtIncompatible
    public void testMakeChecked_listenersRunOnCancel() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.cancel(true);
        tester.testCancelledFuture();
        tester.tearDown();
    }

    @GwtIncompatible
    public void testMakeChecked_listenersRunOnFailure() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.setException((Throwable)new Exception("failed"));
        tester.testFailedFuture("failed");
        tester.tearDown();
    }

    @GwtIncompatible
    public void testCompletionOrder() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.set((Object)2L);
        future1.set((Object)3L);
        future3.set((Object)4L);
        future4.set((Object)5L);
        long expectedResult = 1L;
        for (ListenableFuture future : futures) {
            FuturesTest.assertEquals((Object)expectedResult, (Object)Futures.getDone((Future)future));
            ++expectedResult;
        }
    }

    @GwtIncompatible
    public void testCompletionOrderExceptionThrown() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.setException((Throwable)new IllegalStateException("2L"));
        future1.set((Object)3L);
        future3.set((Object)4L);
        future4.set((Object)5L);
        long expectedResult = 1L;
        for (ListenableFuture future : futures) {
            if (expectedResult != 2L) {
                FuturesTest.assertEquals((Object)expectedResult, (Object)Futures.getDone((Future)future));
            } else {
                try {
                    Futures.getDone((Future)future);
                    FuturesTest.fail();
                }
                catch (ExecutionException expected) {
                    Truth.assertThat((Throwable)expected.getCause()).hasMessage("2L");
                }
            }
            ++expectedResult;
        }
    }

    @GwtIncompatible
    public void testCompletionOrderFutureCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.set((Object)2L);
        future1.set((Object)3L);
        future3.cancel(true);
        future4.set((Object)5L);
        long expectedResult = 1L;
        for (ListenableFuture future : futures) {
            if (expectedResult != 4L) {
                FuturesTest.assertEquals((Object)expectedResult, (Object)Futures.getDone((Future)future));
            } else {
                try {
                    Futures.getDone((Future)future);
                    FuturesTest.fail();
                }
                catch (CancellationException expected) {
                    // empty catch block
                }
            }
            ++expectedResult;
        }
    }

    @GwtIncompatible
    public void testCancellingADelegateDoesNotPropagate() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ImmutableList delegates = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        future1.set((Object)1L);
        FuturesTest.assertFalse((boolean)((ListenableFuture)delegates.get(0)).cancel(true));
        FuturesTest.assertTrue((boolean)((ListenableFuture)delegates.get(1)).cancel(true));
        FuturesTest.assertTrue((boolean)future2.set((Object)2L));
        FuturesTest.assertEquals((Object)2L, (Object)Futures.getDone((Future)future2));
    }

    @GwtIncompatible
    public void testCompletionOrderMixedBagOTypes() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ImmutableList inputs = ImmutableList.of((Object)future1, (Object)future2, (Object)future3);
        ImmutableList futures = Futures.inCompletionOrder((Iterable)inputs);
        future2.set((Object)"1L");
        future1.set((Object)2L);
        future3.set((Object)3);
        ImmutableList expected = ImmutableList.of((Object)"1L", (Object)2L, (Object)3);
        for (int i = 0; i < expected.size(); ++i) {
            FuturesTest.assertEquals((Object)expected.get(i), (Object)Futures.getDone((Future)((Future)futures.get(i))));
        }
    }

    @GwtIncompatible
    public void testFutures_nullChecks() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Futures.class).thatReturn(Future.class).testNulls();
    }

    static AssertionFailedError failureWithCause(Throwable cause, String message) {
        AssertionFailedError failure = new AssertionFailedError(message);
        failure.initCause(cause);
        return failure;
    }

    private static <V> AsyncFunction<V, V> asyncIdentity() {
        return new AsyncFunction<V, V>(){

            public ListenableFuture<V> apply(V input) {
                return Futures.immediateFuture(input);
            }
        };
    }

    @GwtIncompatible
    private static interface MapperFunction
    extends Function<Throwable, Exception> {
    }

    @GwtIncompatible
    private static class TestException
    extends Exception {
        TestException(@Nullable Throwable cause) {
            super(cause);
        }
    }

    @GwtIncompatible
    private static interface Merger {
        public static final Merger allMerger = new Merger(){

            @Override
            public ListenableFuture<List<String>> merged(ListenableFuture<String> a, ListenableFuture<String> b) {
                return Futures.allAsList((Iterable)ImmutableSet.of(a, b));
            }
        };
        public static final Merger successMerger = new Merger(){

            @Override
            public ListenableFuture<List<String>> merged(ListenableFuture<String> a, ListenableFuture<String> b) {
                return Futures.successfulAsList((Iterable)ImmutableSet.of(a, b));
            }
        };

        public ListenableFuture<List<String>> merged(ListenableFuture<String> var1, ListenableFuture<String> var2);
    }

    @GwtIncompatible
    private static final class TestFutureBatch {
        final ListenableFuture<String> doneSuccess = Futures.immediateFuture((Object)"a");
        final ListenableFuture<String> doneFailed = Futures.immediateFailedFuture((Throwable)new Exception());
        final SettableFuture<String> doneCancelled = SettableFuture.create();
        final ListenableFuture<String> doneRuntimeException;
        final SettableFuture<String> delayedSuccess;
        final SettableFuture<String> delayedFailed;
        final SettableFuture<String> delayedCancelled;
        final SettableFuture<String> delegateForDelayedRuntimeException;
        final ListenableFuture<String> delayedRuntimeException;
        final Runnable doNothing;
        final Runnable finishSuccess;
        final Runnable finishFailure;
        final Runnable finishCancelled;
        final Runnable finishRuntimeException;
        final ImmutableList<TestFuture> allFutures;
        final Function<ListenableFuture<String>, String> nameGetter;

        private TestFutureBatch() {
            this.doneCancelled.cancel(true);
            this.doneRuntimeException = new ForwardingListenableFuture<String>(){
                final ListenableFuture<String> delegate = Futures.immediateFuture((Object)"Should never be seen");

                protected ListenableFuture<String> delegate() {
                    return this.delegate;
                }

                public String get() {
                    throw new RuntimeException();
                }

                public String get(long timeout, TimeUnit unit) {
                    throw new RuntimeException();
                }
            };
            this.delayedSuccess = SettableFuture.create();
            this.delayedFailed = SettableFuture.create();
            this.delayedCancelled = SettableFuture.create();
            this.delegateForDelayedRuntimeException = SettableFuture.create();
            this.delayedRuntimeException = new ForwardingListenableFuture<String>(){

                protected ListenableFuture<String> delegate() {
                    return TestFutureBatch.this.delegateForDelayedRuntimeException;
                }

                public String get() throws ExecutionException, InterruptedException {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.get();
                    throw new RuntimeException();
                }

                public String get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.get(timeout, unit);
                    throw new RuntimeException();
                }
            };
            this.doNothing = new Runnable(){

                @Override
                public void run() {
                }
            };
            this.finishSuccess = new Runnable(){

                @Override
                public void run() {
                    TestFutureBatch.this.delayedSuccess.set((Object)"b");
                }
            };
            this.finishFailure = new Runnable(){

                @Override
                public void run() {
                    TestFutureBatch.this.delayedFailed.setException((Throwable)new Exception());
                }
            };
            this.finishCancelled = new Runnable(){

                @Override
                public void run() {
                    TestFutureBatch.this.delayedCancelled.cancel(true);
                }
            };
            this.finishRuntimeException = new Runnable(){

                @Override
                public void run() {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.set((Object)"Should never be seen");
                }
            };
            this.allFutures = ImmutableList.of((Object)new TestFuture(this.doneSuccess, "doneSuccess", this.doNothing), (Object)new TestFuture(this.doneFailed, "doneFailed", this.doNothing), (Object)new TestFuture((ListenableFuture<String>)this.doneCancelled, "doneCancelled", this.doNothing), (Object)new TestFuture(this.doneRuntimeException, "doneRuntimeException", this.doNothing), (Object)new TestFuture((ListenableFuture<String>)this.delayedSuccess, "delayedSuccess", this.finishSuccess), (Object)new TestFuture((ListenableFuture<String>)this.delayedFailed, "delayedFailed", this.finishFailure), (Object)new TestFuture((ListenableFuture<String>)this.delayedCancelled, "delayedCancelled", this.finishCancelled), (Object)new TestFuture(this.delayedRuntimeException, "delayedRuntimeException", this.finishRuntimeException));
            this.nameGetter = new Function<ListenableFuture<String>, String>(){

                public String apply(ListenableFuture<String> input) {
                    for (TestFuture future : TestFutureBatch.this.allFutures) {
                        if (future.future != input) continue;
                        return future.name;
                    }
                    throw new IllegalArgumentException(input.toString());
                }
            };
        }

        static boolean intersect(Set<?> a, Set<?> b) {
            return !Sets.intersection(a, b).isEmpty();
        }

        String smartToString(ImmutableSet<ListenableFuture<String>> inputs) {
            Iterable inputNames = Iterables.transform(inputs, this.nameGetter);
            return Joiner.on((String)", ").join(inputNames);
        }

        void smartAssertTrue(ImmutableSet<ListenableFuture<String>> inputs, Exception cause, boolean expression) {
            if (!expression) {
                throw FuturesTest.failureWithCause(cause, this.smartToString(inputs));
            }
        }

        boolean hasDelayed(ListenableFuture<String> a, ListenableFuture<String> b) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            return TestFutureBatch.intersect(inputs, ImmutableSet.of(this.delayedSuccess, this.delayedFailed, this.delayedCancelled, this.delayedRuntimeException));
        }

        void assertHasDelayed(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, this.hasDelayed(a, b));
        }

        void assertHasFailure(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneFailed, this.doneRuntimeException, this.delayedFailed, this.delayedRuntimeException)));
        }

        void assertHasCancel(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneCancelled, this.delayedCancelled)));
        }

        void assertHasImmediateFailure(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneFailed, this.doneRuntimeException)));
        }

        void assertHasImmediateCancel(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneCancelled)));
        }
    }

    @GwtIncompatible
    private static final class TestFuture {
        final ListenableFuture<String> future;
        final String name;
        final Runnable finisher;

        TestFuture(ListenableFuture<String> future, String name, Runnable finisher) {
            this.future = future;
            this.name = name;
            this.finisher = finisher;
        }
    }

    static class SingleCallListener
    implements Runnable {
        private boolean expectCall = false;
        private final CountDownLatch calledCountDown = new CountDownLatch(1);

        SingleCallListener() {
        }

        @Override
        public void run() {
            Assert.assertTrue((String)"Listener called before it was expected", (boolean)this.expectCall);
            Assert.assertFalse((String)"Listener called more than once", (boolean)this.wasCalled());
            this.calledCountDown.countDown();
        }

        public void expectCall() {
            Assert.assertFalse((String)"expectCall is already true", (boolean)this.expectCall);
            this.expectCall = true;
        }

        public boolean wasCalled() {
            return this.calledCountDown.getCount() == 0L;
        }

        public void waitForCall() throws InterruptedException {
            Assert.assertTrue((String)"expectCall is false", (boolean)this.expectCall);
            this.calledCountDown.await();
        }
    }

    private static class AsyncFunctionSpy<X extends Throwable, V>
    implements AsyncFunction<X, V> {
        private int count;
        private final AsyncFunction<X, V> delegate;

        public AsyncFunctionSpy(AsyncFunction<X, V> delegate) {
            this.delegate = delegate;
        }

        public final ListenableFuture<V> apply(X t) throws Exception {
            ++this.count;
            return this.delegate.apply(t);
        }

        void verifyCallCount(int expected) {
            Truth.assertThat((Integer)this.count).isEqualTo((Object)expected);
        }
    }

    private static class FunctionSpy<I, O>
    implements Function<I, O> {
        private int applyCount;
        private final Function<I, O> delegate;

        public FunctionSpy(Function<I, O> delegate) {
            this.delegate = delegate;
        }

        public O apply(I input) {
            ++this.applyCount;
            return (O)this.delegate.apply(input);
        }

        void verifyCallCount(int expected) {
            Truth.assertThat((Integer)this.applyCount).isEqualTo((Object)expected);
        }
    }

    static class ExecutorSpy
    implements Executor {
        Executor delegate;
        boolean wasExecuted;

        public ExecutorSpy(Executor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
            this.wasExecuted = true;
        }
    }

    static class MyRuntimeException
    extends RuntimeException {
        MyRuntimeException() {
        }
    }

    static class MyError
    extends Error {
        MyError() {
        }
    }

    private static class BarChild
    extends Bar {
        private BarChild() {
        }
    }

    private static class Bar {
        private Bar() {
        }
    }

    private static class FooChild
    extends Foo {
        private FooChild() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }

    private static class MyException
    extends Exception {
        private MyException() {
        }
    }

    private static final class CallerClass2 {
        private CallerClass2() {
        }

        @CanIgnoreReturnValue
        static <V> V get(ListenableFuture<V> future) throws ExecutionException, InterruptedException {
            return (V)Futures.getDone(future);
        }
    }

    private static final class CallerClass1 {
        private CallerClass1() {
        }

        static ListenableFuture<String> makeImmediateCancelledFuture() {
            return Futures.immediateCancelledFuture();
        }
    }
}

