/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownAccepter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import junit.framework.Assert;

final class InterruptionUtil {
    private static final Logger logger = Logger.getLogger(InterruptionUtil.class.getName());

    InterruptionUtil() {
    }

    static void requestInterruptIn(final long time, final TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        final Thread interruptee = Thread.currentThread();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    unit.sleep(time);
                }
                catch (InterruptedException wontHappen) {
                    throw new AssertionError((Object)wontHappen);
                }
                interruptee.interrupt();
            }
        }).start();
    }

    static void repeatedlyInterruptTestThread(long interruptPeriodMillis, TearDownAccepter tearDownAccepter) {
        final Interruptenator interruptingTask = new Interruptenator(Thread.currentThread(), interruptPeriodMillis);
        final Thread interruptingThread = new Thread(interruptingTask);
        interruptingThread.start();
        tearDownAccepter.addTearDown(new TearDown(){

            public void tearDown() throws Exception {
                interruptingTask.stopInterrupting();
                interruptingThread.interrupt();
                InterruptionUtil.joinUninterruptibly(interruptingThread, 2500L, TimeUnit.MILLISECONDS);
                Thread.interrupted();
                if (interruptingThread.isAlive()) {
                    logger.severe("InterruptenatorTask did not exit; future tests may be affected");
                    Assert.fail();
                }
            }
        });
    }

    private static void joinUninterruptibly(Thread thread, long timeout, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.timedJoin(thread, remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class Interruptenator
    implements Runnable {
        private final long everyMillis;
        private final Thread interruptee;
        private volatile boolean shouldStop = false;

        Interruptenator(Thread interruptee, long everyMillis) {
            this.everyMillis = everyMillis;
            this.interruptee = interruptee;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.everyMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.shouldStop) break;
                this.interruptee.interrupt();
            }
        }

        void stopInterrupting() {
            this.shouldStop = true;
        }
    }
}

