/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilePermission;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Arrays;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

abstract class JSR166TestCase
extends TestCase {
    private static final boolean useSecurityManager = Boolean.getBoolean("jsr166.useSecurityManager");
    protected static final boolean expensiveTests = Boolean.getBoolean("jsr166.expensiveTests");
    private static final boolean profileTests = Boolean.getBoolean("jsr166.profileTests");
    private static final long profileThreshold = Long.getLong("jsr166.profileThreshold", 100L);
    public static long SHORT_DELAY_MS;
    public static long SMALL_DELAY_MS;
    public static long MEDIUM_DELAY_MS;
    public static long LONG_DELAY_MS;
    private final AtomicReference<Throwable> threadFailure = new AtomicReference<Object>(null);
    public static final int SIZE = 20;
    public static final Integer zero;
    public static final Integer one;
    public static final Integer two;
    public static final Integer three;
    public static final Integer four;
    public static final Integer five;
    public static final Integer six;
    public static final Integer seven;
    public static final Integer eight;
    public static final Integer nine;
    public static final Integer m1;
    public static final Integer m2;
    public static final Integer m3;
    public static final Integer m4;
    public static final Integer m5;
    public static final Integer m6;
    public static final Integer m10;
    public static final String TEST_STRING = "a test string";

    JSR166TestCase() {
    }

    protected void runTest() throws Throwable {
        if (profileTests) {
            this.runTestProfiled();
        } else {
            super.runTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTestProfiled() throws Throwable {
        long t0 = System.nanoTime();
        try {
            super.runTest();
        }
        catch (Throwable throwable) {
            long elapsedMillis = (System.nanoTime() - t0) / 1000000L;
            if (elapsedMillis >= profileThreshold) {
                System.out.printf("%n%s: %d%n", this.toString(), elapsedMillis);
            }
            throw throwable;
        }
        long elapsedMillis = (System.nanoTime() - t0) / 1000000L;
        if (elapsedMillis >= profileThreshold) {
            System.out.printf("%n%s: %d%n", this.toString(), elapsedMillis);
        }
    }

    protected long getShortDelay() {
        return 50L;
    }

    protected void setDelays() {
        SHORT_DELAY_MS = this.getShortDelay();
        SMALL_DELAY_MS = SHORT_DELAY_MS * 5L;
        MEDIUM_DELAY_MS = SHORT_DELAY_MS * 10L;
        LONG_DELAY_MS = SHORT_DELAY_MS * 200L;
    }

    long timeoutMillis() {
        return SHORT_DELAY_MS / 4L;
    }

    Date delayedDate(long delayMillis) {
        return new Date(System.currentTimeMillis() + delayMillis);
    }

    public void threadRecordFailure(Throwable t) {
        this.threadFailure.compareAndSet(null, t);
    }

    public void setUp() {
        this.setDelays();
    }

    public void tearDown() throws Exception {
        Throwable t = this.threadFailure.getAndSet(null);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            AssertionFailedError afe = new AssertionFailedError(t.toString());
            afe.initCause(t);
            throw afe;
        }
        if (Thread.interrupted()) {
            throw new AssertionFailedError("interrupt status set in main thread");
        }
    }

    public void threadFail(String reason) {
        try {
            JSR166TestCase.fail((String)reason);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            JSR166TestCase.fail((String)reason);
        }
    }

    public void threadAssertTrue(boolean b) {
        try {
            JSR166TestCase.assertTrue((boolean)b);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
    }

    public void threadAssertFalse(boolean b) {
        try {
            JSR166TestCase.assertFalse((boolean)b);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
    }

    public void threadAssertNull(Object x) {
        try {
            JSR166TestCase.assertNull((Object)x);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
    }

    public void threadAssertEquals(long x, long y) {
        try {
            JSR166TestCase.assertEquals((long)x, (long)y);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
    }

    public void threadAssertEquals(Object x, Object y) {
        try {
            JSR166TestCase.assertEquals((Object)x, (Object)y);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
        catch (Throwable t) {
            this.threadUnexpectedException(t);
        }
    }

    public void threadAssertSame(Object x, Object y) {
        try {
            JSR166TestCase.assertSame((Object)x, (Object)y);
        }
        catch (AssertionFailedError t) {
            this.threadRecordFailure(t);
            throw t;
        }
    }

    public void threadShouldThrow() {
        this.threadFail("should throw exception");
    }

    public void threadShouldThrow(String exceptionName) {
        this.threadFail("should throw " + exceptionName);
    }

    public void threadUnexpectedException(Throwable t) {
        this.threadRecordFailure(t);
        t.printStackTrace();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        AssertionFailedError afe = new AssertionFailedError("unexpected exception: " + t);
        afe.initCause(t);
        throw afe;
    }

    static void delay(long millis) throws InterruptedException {
        long startTime = System.nanoTime();
        long ns = millis * 1000L * 1000L;
        while (true) {
            if (millis > 0L) {
                Thread.sleep(millis);
            } else {
                Thread.yield();
            }
            long d = ns - (System.nanoTime() - startTime);
            if (d <= 0L) break;
            millis = d / 1000000L;
        }
    }

    void joinPool(ExecutorService exec) {
        try {
            exec.shutdown();
            JSR166TestCase.assertTrue((String)"ExecutorService did not terminate in a timely manner", (boolean)exec.awaitTermination(2L * LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        catch (SecurityException ok) {
        }
        catch (InterruptedException ie) {
            JSR166TestCase.fail((String)"Unexpected InterruptedException");
        }
    }

    void assertThreadStaysAlive(Thread thread) {
        this.assertThreadStaysAlive(thread, this.timeoutMillis());
    }

    void assertThreadStaysAlive(Thread thread, long millis) {
        try {
            JSR166TestCase.delay(millis);
            JSR166TestCase.assertTrue((boolean)thread.isAlive());
        }
        catch (InterruptedException ie) {
            JSR166TestCase.fail((String)"Unexpected InterruptedException");
        }
    }

    void assertThreadsStayAlive(Thread ... threads) {
        this.assertThreadsStayAlive(this.timeoutMillis(), threads);
    }

    void assertThreadsStayAlive(long millis, Thread ... threads) {
        try {
            JSR166TestCase.delay(millis);
            for (Thread thread : threads) {
                JSR166TestCase.assertTrue((boolean)thread.isAlive());
            }
        }
        catch (InterruptedException ie) {
            JSR166TestCase.fail((String)"Unexpected InterruptedException");
        }
    }

    void assertFutureTimesOut(Future future) {
        this.assertFutureTimesOut(future, this.timeoutMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertFutureTimesOut(Future future, long timeoutMillis) {
        long startTime = System.nanoTime();
        try {
            future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException success) {
        }
        catch (Exception e) {
            this.threadUnexpectedException(e);
        }
        finally {
            future.cancel(true);
        }
        JSR166TestCase.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
    }

    public void shouldThrow() {
        JSR166TestCase.fail((String)"Should throw exception");
    }

    public void shouldThrow(String exceptionName) {
        JSR166TestCase.fail((String)("Should throw " + exceptionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithPermissions(Runnable r, Permission ... permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            r.run();
            Policy savedPolicy = Policy.getPolicy();
            try {
                Policy.setPolicy(JSR166TestCase.permissivePolicy());
                System.setSecurityManager(new SecurityManager());
                this.runWithPermissions(r, permissions);
            }
            finally {
                System.setSecurityManager(null);
                Policy.setPolicy(savedPolicy);
            }
        }
        Policy savedPolicy = Policy.getPolicy();
        AdjustablePolicy policy = new AdjustablePolicy(permissions);
        Policy.setPolicy(policy);
        try {
            r.run();
        }
        finally {
            policy.addPermission(new SecurityPermission("setPolicy"));
            Policy.setPolicy(savedPolicy);
        }
    }

    public void runWithoutPermissions(Runnable r) {
        this.runWithPermissions(r, new Permission[0]);
    }

    public static Policy permissivePolicy() {
        return new AdjustablePolicy(new RuntimePermission("modifyThread"), new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"), new SecurityPermission("getPolicy"), new SecurityPermission("setPolicy"), new RuntimePermission("setSecurityManager"), new RuntimePermission("accessDeclaredMembers"), new PropertyPermission("*", "read"), new FilePermission("<<ALL FILES>>", "read"));
    }

    void sleep(long millis) {
        try {
            JSR166TestCase.delay(millis);
        }
        catch (InterruptedException ie) {
            AssertionFailedError afe = new AssertionFailedError("Unexpected InterruptedException");
            afe.initCause((Throwable)ie);
            throw afe;
        }
    }

    void waitForThreadToEnterWaitState(Thread thread, long timeoutMillis) {
        long startTime = System.nanoTime();
        Thread.State s;
        while ((s = thread.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING) {
            if (s == Thread.State.TERMINATED) {
                JSR166TestCase.fail((String)"Unexpected thread termination");
            } else if (this.millisElapsedSince(startTime) > timeoutMillis) {
                this.threadAssertTrue(thread.isAlive());
                return;
            }
            Thread.yield();
        }
        return;
    }

    void waitForThreadToEnterWaitState(Thread thread) {
        this.waitForThreadToEnterWaitState(thread, LONG_DELAY_MS);
    }

    long millisElapsedSince(long startNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime);
    }

    Thread newStartedThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitTermination(Thread t, long timeoutMillis) {
        try {
            t.join(timeoutMillis);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
        finally {
            if (t.getState() != Thread.State.TERMINATED) {
                t.interrupt();
                JSR166TestCase.fail((String)"Test timed out");
            }
        }
    }

    void awaitTermination(Thread t) {
        this.awaitTermination(t, LONG_DELAY_MS);
    }

    public Callable<String> latchAwaitingStringTask(final CountDownLatch latch) {
        return new CheckedCallable<String>(){

            @Override
            protected String realCall() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return JSR166TestCase.TEST_STRING;
            }
        };
    }

    public Runnable awaiter(final CountDownLatch latch) {
        return new CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.this.await(latch);
            }
        };
    }

    public void await(CountDownLatch latch) {
        try {
            JSR166TestCase.assertTrue((boolean)latch.await(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        catch (Throwable t) {
            this.threadUnexpectedException(t);
        }
    }

    public void await(Semaphore semaphore) {
        try {
            JSR166TestCase.assertTrue((boolean)semaphore.tryAcquire(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        catch (Throwable t) {
            this.threadUnexpectedException(t);
        }
    }

    public Runnable possiblyInterruptedRunnable(final long timeoutMillis) {
        return new CheckedRunnable(){

            @Override
            protected void realRun() {
                try {
                    JSR166TestCase.delay(timeoutMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public static TrackedRunnable trackedRunnable(final long timeoutMillis) {
        return new TrackedRunnable(){
            private volatile boolean done = false;

            @Override
            public boolean isDone() {
                return this.done;
            }

            @Override
            public void run() {
                try {
                    JSR166TestCase.delay(timeoutMillis);
                    this.done = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    void checkEmpty(BlockingQueue q) {
        try {
            JSR166TestCase.assertTrue((boolean)q.isEmpty());
            JSR166TestCase.assertEquals((int)0, (int)q.size());
            JSR166TestCase.assertNull(q.peek());
            JSR166TestCase.assertNull(q.poll());
            JSR166TestCase.assertNull(q.poll(0L, TimeUnit.MILLISECONDS));
            JSR166TestCase.assertEquals((String)q.toString(), (String)"[]");
            JSR166TestCase.assertTrue((boolean)Arrays.equals(q.toArray(), new Object[0]));
            JSR166TestCase.assertFalse((boolean)q.iterator().hasNext());
            try {
                q.element();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                q.iterator().next();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                q.remove();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {}
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    <T> T serialClone(T o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object clone = ois.readObject();
            JSR166TestCase.assertSame(o.getClass(), clone.getClass());
            return (T)clone;
        }
        catch (Throwable t) {
            this.threadUnexpectedException(t);
            return null;
        }
    }

    static {
        zero = new Integer(0);
        one = new Integer(1);
        two = new Integer(2);
        three = new Integer(3);
        four = new Integer(4);
        five = new Integer(5);
        six = new Integer(6);
        seven = new Integer(7);
        eight = new Integer(8);
        nine = new Integer(9);
        m1 = new Integer(-1);
        m2 = new Integer(-2);
        m3 = new Integer(-3);
        m4 = new Integer(-4);
        m5 = new Integer(-5);
        m6 = new Integer(-6);
        m10 = new Integer(-10);
    }

    public class CheckedBarrier
    extends CyclicBarrier {
        public CheckedBarrier(int parties) {
            super(parties);
        }

        @Override
        public int await() {
            try {
                return super.await(2L * LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new AssertionFailedError("timed out");
            }
            catch (Exception e) {
                AssertionFailedError afe = new AssertionFailedError("Unexpected exception: " + e);
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
    }

    public static class NoOpREHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    }

    public static class TrackedCallable
    implements Callable {
        public volatile boolean done = false;

        public Object call() {
            try {
                JSR166TestCase.delay(SMALL_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
    }

    public static class TrackedNoOpRunnable
    implements Runnable {
        public volatile boolean done = false;

        @Override
        public void run() {
            this.done = true;
        }
    }

    public static class TrackedLongRunnable
    implements Runnable {
        public volatile boolean done = false;

        @Override
        public void run() {
            try {
                JSR166TestCase.delay(LONG_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class TrackedMediumRunnable
    implements Runnable {
        public volatile boolean done = false;

        @Override
        public void run() {
            try {
                JSR166TestCase.delay(MEDIUM_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class TrackedSmallRunnable
    implements Runnable {
        public volatile boolean done = false;

        @Override
        public void run() {
            try {
                JSR166TestCase.delay(SMALL_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class TrackedShortRunnable
    implements Runnable {
        public volatile boolean done = false;

        @Override
        public void run() {
            try {
                JSR166TestCase.delay(SHORT_DELAY_MS);
                this.done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface TrackedRunnable
    extends Runnable {
        public boolean isDone();
    }

    public static class SimpleThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    }

    public class LongPossiblyInterruptedRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() {
            try {
                JSR166TestCase.delay(LONG_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class MediumPossiblyInterruptedRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() {
            try {
                JSR166TestCase.delay(MEDIUM_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class MediumInterruptedRunnable
    extends CheckedInterruptedRunnable {
        @Override
        protected void realRun() throws InterruptedException {
            JSR166TestCase.delay(MEDIUM_DELAY_MS);
        }
    }

    public class MediumRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() throws Throwable {
            JSR166TestCase.delay(MEDIUM_DELAY_MS);
        }
    }

    public class SmallCallable
    extends CheckedCallable {
        protected Object realCall() throws InterruptedException {
            JSR166TestCase.delay(SMALL_DELAY_MS);
            return Boolean.TRUE;
        }
    }

    public class SmallPossiblyInterruptedRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() {
            try {
                JSR166TestCase.delay(SMALL_DELAY_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class SmallRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() throws Throwable {
            JSR166TestCase.delay(SMALL_DELAY_MS);
        }
    }

    public class ShortInterruptedRunnable
    extends CheckedInterruptedRunnable {
        @Override
        protected void realRun() throws InterruptedException {
            JSR166TestCase.delay(SHORT_DELAY_MS);
        }
    }

    public class ShortRunnable
    extends CheckedRunnable {
        @Override
        protected void realRun() throws Throwable {
            JSR166TestCase.delay(SHORT_DELAY_MS);
        }
    }

    public static class CallableOne
    implements Callable<Integer> {
        @Override
        public Integer call() {
            return one;
        }
    }

    public static class NPETask
    implements Callable<String> {
        @Override
        public String call() {
            throw new NullPointerException();
        }
    }

    public static class StringTask
    implements Callable<String> {
        @Override
        public String call() {
            return JSR166TestCase.TEST_STRING;
        }
    }

    public static class NoOpCallable
    implements Callable {
        public Object call() {
            return Boolean.TRUE;
        }
    }

    public static class NoOpRunnable
    implements Runnable {
        @Override
        public void run() {
        }
    }

    public abstract class CheckedInterruptedCallable<T>
    implements Callable<T> {
        protected abstract T realCall() throws Throwable;

        @Override
        public final T call() {
            try {
                T result = this.realCall();
                JSR166TestCase.this.threadShouldThrow("InterruptedException");
                return result;
            }
            catch (InterruptedException success) {
                JSR166TestCase.this.threadAssertFalse(Thread.interrupted());
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
            return null;
        }
    }

    public abstract class CheckedCallable<T>
    implements Callable<T> {
        protected abstract T realCall() throws Throwable;

        @Override
        public final T call() {
            try {
                return this.realCall();
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
                return null;
            }
        }
    }

    public abstract class CheckedInterruptedRunnable
    implements Runnable {
        protected abstract void realRun() throws Throwable;

        @Override
        public final void run() {
            try {
                this.realRun();
                JSR166TestCase.this.threadShouldThrow("InterruptedException");
            }
            catch (InterruptedException success) {
                JSR166TestCase.this.threadAssertFalse(Thread.interrupted());
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
        }
    }

    public abstract class ThreadShouldThrow
    extends Thread {
        final Class<?> exceptionClass;

        protected abstract void realRun() throws Throwable;

        <T extends Throwable> ThreadShouldThrow(Class<T> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this.realRun();
                    JSR166TestCase.this.threadShouldThrow(this.exceptionClass.getSimpleName());
                }
                catch (Throwable t) {
                    if (this.exceptionClass.isInstance(t)) break block2;
                    JSR166TestCase.this.threadUnexpectedException(t);
                }
            }
        }
    }

    public abstract class RunnableShouldThrow
    implements Runnable {
        final Class<?> exceptionClass;

        protected abstract void realRun() throws Throwable;

        <T extends Throwable> RunnableShouldThrow(Class<T> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this.realRun();
                    JSR166TestCase.this.threadShouldThrow(this.exceptionClass.getSimpleName());
                }
                catch (Throwable t) {
                    if (this.exceptionClass.isInstance(t)) break block2;
                    JSR166TestCase.this.threadUnexpectedException(t);
                }
            }
        }
    }

    public abstract class CheckedRunnable
    implements Runnable {
        protected abstract void realRun() throws Throwable;

        @Override
        public final void run() {
            try {
                this.realRun();
            }
            catch (Throwable t) {
                JSR166TestCase.this.threadUnexpectedException(t);
            }
        }
    }

    public static class AdjustablePolicy
    extends Policy {
        Permissions perms = new Permissions();

        AdjustablePolicy(Permission ... permissions) {
            for (Permission permission : permissions) {
                this.perms.add(permission);
            }
        }

        void addPermission(Permission perm) {
            this.perms.add(perm);
        }

        void clearPermissions() {
            this.perms = new Permissions();
        }

        @Override
        public PermissionCollection getPermissions(CodeSource cs) {
            return this.perms;
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain pd) {
            return this.perms;
        }

        @Override
        public boolean implies(ProtectionDomain pd, Permission p) {
            return this.perms.implies(p);
        }

        @Override
        public void refresh() {
        }
    }
}

