/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.AbstractIterator;
import com.google.common.testing.GcFinalization;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class AbstractIteratorTest
extends TestCase {
    public void testDefaultBehaviorOfNextAndHasNext() {
        AbstractIterator<Integer> iter = new AbstractIterator<Integer>(){
            private int rep;

            public Integer computeNext() {
                switch (this.rep++) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return (Integer)this.endOfData();
                    }
                }
                TestCase.fail((String)"Should not have been invoked again");
                return null;
            }
        };
        AbstractIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        AbstractIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractIteratorTest.assertEquals((int)1, (int)((Integer)iter.next()));
        AbstractIteratorTest.assertFalse((boolean)iter.hasNext());
        AbstractIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            AbstractIteratorTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSneakyThrow() throws Exception {
        AbstractIterator<Integer> iter;
        block4: {
            iter = new AbstractIterator<Integer>(){
                boolean haveBeenCalled;

                public Integer computeNext() {
                    if (this.haveBeenCalled) {
                        TestCase.fail((String)"Should not have been called again");
                    } else {
                        this.haveBeenCalled = true;
                        AbstractIteratorTest.sneakyThrow(new SomeCheckedException());
                    }
                    return null;
                }
            };
            try {
                iter.hasNext();
                AbstractIteratorTest.fail((String)"No exception thrown");
            }
            catch (Exception e) {
                if (e instanceof SomeCheckedException) break block4;
                throw e;
            }
        }
        try {
            iter.hasNext();
            AbstractIteratorTest.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testException() {
        final SomeUncheckedException exception = new SomeUncheckedException();
        AbstractIterator<Integer> iter = new AbstractIterator<Integer>(){

            public Integer computeNext() {
                throw exception;
            }
        };
        try {
            iter.hasNext();
            AbstractIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException e) {
            AbstractIteratorTest.assertSame((Object)exception, (Object)e);
        }
    }

    public void testExceptionAfterEndOfData() {
        AbstractIterator<Integer> iter = new AbstractIterator<Integer>(){

            public Integer computeNext() {
                this.endOfData();
                throw new SomeUncheckedException();
            }
        };
        try {
            iter.hasNext();
            AbstractIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testCantRemove() {
        AbstractIterator<Integer> iter = new AbstractIterator<Integer>(){
            boolean haveBeenCalled;

            public Integer computeNext() {
                if (this.haveBeenCalled) {
                    this.endOfData();
                }
                this.haveBeenCalled = true;
                return 0;
            }
        };
        AbstractIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        try {
            iter.remove();
            AbstractIteratorTest.fail((String)"No exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testFreesNextReference() {
        AbstractIterator<Object> itr = new AbstractIterator<Object>(){

            public Object computeNext() {
                return new Object();
            }
        };
        WeakReference ref = new WeakReference(itr.next());
        GcFinalization.awaitClear(ref);
    }

    public void testReentrantHasNext() {
        AbstractIterator<Integer> iter = new AbstractIterator<Integer>(){

            protected Integer computeNext() {
                boolean unused = this.hasNext();
                return null;
            }
        };
        try {
            iter.hasNext();
            AbstractIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void sneakyThrow(Throwable t) {
        class SneakyThrower<T extends Throwable> {
            SneakyThrower() {
            }

            void throwIt(Throwable t) throws T {
                throw t;
            }
        }
        new SneakyThrower().throwIt(t);
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }
}

