/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import junit.framework.TestCase;

@GwtCompatible
public class AsciiTest
extends TestCase {
    private static final String IGNORED = "`10-=~!@#$%^&*()_+[]\\{}|;':\",./<>?'\u00c1\u00e1\n";
    private static final String LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public void testToLowerCase() {
        AsciiTest.assertEquals((String)LOWER, (String)Ascii.toLowerCase((String)UPPER));
        AsciiTest.assertSame((Object)LOWER, (Object)Ascii.toLowerCase((String)LOWER));
        AsciiTest.assertEquals((String)IGNORED, (String)Ascii.toLowerCase((String)IGNORED));
        AsciiTest.assertEquals((String)"foobar", (String)Ascii.toLowerCase((String)"fOobaR"));
    }

    public void testToUpperCase() {
        AsciiTest.assertEquals((String)UPPER, (String)Ascii.toUpperCase((String)LOWER));
        AsciiTest.assertSame((Object)UPPER, (Object)Ascii.toUpperCase((String)UPPER));
        AsciiTest.assertEquals((String)IGNORED, (String)Ascii.toUpperCase((String)IGNORED));
        AsciiTest.assertEquals((String)"FOOBAR", (String)Ascii.toUpperCase((String)"FoOBAr"));
    }

    public void testCharsIgnored() {
        for (char c : IGNORED.toCharArray()) {
            String str = String.valueOf(c);
            AsciiTest.assertTrue((String)str, (c == Ascii.toLowerCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertTrue((String)str, (c == Ascii.toUpperCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertFalse((String)str, (boolean)Ascii.isLowerCase((char)c));
            AsciiTest.assertFalse((String)str, (boolean)Ascii.isUpperCase((char)c));
        }
    }

    public void testCharsLower() {
        for (char c : LOWER.toCharArray()) {
            String str = String.valueOf(c);
            AsciiTest.assertTrue((String)str, (c == Ascii.toLowerCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertFalse((String)str, (c == Ascii.toUpperCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertTrue((String)str, (boolean)Ascii.isLowerCase((char)c));
            AsciiTest.assertFalse((String)str, (boolean)Ascii.isUpperCase((char)c));
        }
    }

    public void testCharsUpper() {
        for (char c : UPPER.toCharArray()) {
            String str = String.valueOf(c);
            AsciiTest.assertFalse((String)str, (c == Ascii.toLowerCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertTrue((String)str, (c == Ascii.toUpperCase((char)c) ? 1 : 0) != 0);
            AsciiTest.assertFalse((String)str, (boolean)Ascii.isLowerCase((char)c));
            AsciiTest.assertTrue((String)str, (boolean)Ascii.isUpperCase((char)c));
        }
    }

    public void testTruncate() {
        AsciiTest.assertEquals((String)"foobar", (String)Ascii.truncate((CharSequence)"foobar", (int)10, (String)"..."));
        AsciiTest.assertEquals((String)"fo...", (String)Ascii.truncate((CharSequence)"foobar", (int)5, (String)"..."));
        AsciiTest.assertEquals((String)"foobar", (String)Ascii.truncate((CharSequence)"foobar", (int)6, (String)"..."));
        AsciiTest.assertEquals((String)"...", (String)Ascii.truncate((CharSequence)"foobar", (int)3, (String)"..."));
        AsciiTest.assertEquals((String)"foobar", (String)Ascii.truncate((CharSequence)"foobar", (int)10, (String)"\u2026"));
        AsciiTest.assertEquals((String)"foo\u2026", (String)Ascii.truncate((CharSequence)"foobar", (int)4, (String)"\u2026"));
        AsciiTest.assertEquals((String)"fo--", (String)Ascii.truncate((CharSequence)"foobar", (int)4, (String)"--"));
        AsciiTest.assertEquals((String)"foobar", (String)Ascii.truncate((CharSequence)"foobar", (int)6, (String)"\u2026"));
        AsciiTest.assertEquals((String)"foob\u2026", (String)Ascii.truncate((CharSequence)"foobar", (int)5, (String)"\u2026"));
        AsciiTest.assertEquals((String)"foo", (String)Ascii.truncate((CharSequence)"foobar", (int)3, (String)""));
        AsciiTest.assertEquals((String)"", (String)Ascii.truncate((CharSequence)"", (int)5, (String)""));
        AsciiTest.assertEquals((String)"", (String)Ascii.truncate((CharSequence)"", (int)5, (String)"..."));
        AsciiTest.assertEquals((String)"", (String)Ascii.truncate((CharSequence)"", (int)0, (String)""));
    }

    public void testTruncateIllegalArguments() {
        String truncated = null;
        try {
            truncated = Ascii.truncate((CharSequence)"foobar", (int)2, (String)"...");
            AsciiTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            truncated = Ascii.truncate((CharSequence)"foobar", (int)8, (String)"1234567890");
            AsciiTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            truncated = Ascii.truncate((CharSequence)"foobar", (int)-1, (String)"...");
            AsciiTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            truncated = Ascii.truncate((CharSequence)"foobar", (int)-1, (String)"");
            AsciiTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsIgnoreCase() {
        AsciiTest.assertTrue((boolean)Ascii.equalsIgnoreCase((CharSequence)"", (CharSequence)""));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"", (CharSequence)"x"));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"x", (CharSequence)""));
        AsciiTest.assertTrue((boolean)Ascii.equalsIgnoreCase((CharSequence)LOWER, (CharSequence)UPPER));
        AsciiTest.assertTrue((boolean)Ascii.equalsIgnoreCase((CharSequence)UPPER, (CharSequence)LOWER));
        AsciiTest.assertTrue((boolean)Ascii.equalsIgnoreCase((CharSequence)new String(IGNORED), (CharSequence)new String(IGNORED)));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"\u00c1", (CharSequence)"\u00e1"));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"@", (CharSequence)"`"));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"[", (CharSequence)"{"));
    }

    @GwtIncompatible
    public void testEqualsIgnoreCaseUnicodeEquivalence() {
        AsciiTest.assertEquals((String)"PASSWORD", (String)"pa\u00dfword".toUpperCase());
        AsciiTest.assertFalse((boolean)"pa\u00dfword".equalsIgnoreCase("PASSWORD"));
        AsciiTest.assertFalse((boolean)Ascii.equalsIgnoreCase((CharSequence)"pa\u00dfword", (CharSequence)"PASSWORD"));
    }
}

