/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

@GwtCompatible
public class ConverterTest
extends TestCase {
    private static final Converter<String, Long> STR_TO_LONG = new Converter<String, Long>(){

        protected Long doForward(String object) {
            return Long.valueOf(object);
        }

        protected String doBackward(Long object) {
            return String.valueOf(object);
        }

        public String toString() {
            return "string2long";
        }
    };
    private static final Long LONG_VAL = 12345L;
    private static final String STR_VAL = "12345";
    private static final ImmutableList<String> STRINGS = ImmutableList.of((Object)"123", (Object)"456");
    private static final ImmutableList<Long> LONGS = ImmutableList.of((Object)123L, (Object)456L);

    public void testConverter() {
        ConverterTest.assertEquals((Object)LONG_VAL, (Object)STR_TO_LONG.convert((Object)STR_VAL));
        ConverterTest.assertEquals((String)STR_VAL, (String)((String)STR_TO_LONG.reverse().convert((Object)LONG_VAL)));
        Iterable convertedValues = STR_TO_LONG.convertAll(STRINGS);
        ConverterTest.assertEquals(LONGS, (Object)ImmutableList.copyOf((Iterable)convertedValues));
    }

    public void testConvertAllIsView() {
        ArrayList mutableList = Lists.newArrayList((Object[])new String[]{"789", "123"});
        Iterable convertedValues = STR_TO_LONG.convertAll((Iterable)mutableList);
        ConverterTest.assertEquals((Object)ImmutableList.of((Object)789L, (Object)123L), (Object)ImmutableList.copyOf((Iterable)convertedValues));
        Iterator iterator = convertedValues.iterator();
        iterator.next();
        iterator.remove();
        ConverterTest.assertEquals((Object)ImmutableList.of((Object)"123"), (Object)mutableList);
    }

    public void testReverse() {
        Converter reverseConverter = STR_TO_LONG.reverse();
        ConverterTest.assertEquals((String)STR_VAL, (String)((String)reverseConverter.convert((Object)LONG_VAL)));
        ConverterTest.assertEquals((Object)LONG_VAL, (Object)reverseConverter.reverse().convert((Object)STR_VAL));
        Iterable convertedValues = reverseConverter.convertAll(LONGS);
        ConverterTest.assertEquals(STRINGS, (Object)ImmutableList.copyOf((Iterable)convertedValues));
        ConverterTest.assertSame(STR_TO_LONG, (Object)reverseConverter.reverse());
        ConverterTest.assertEquals((String)"string2long.reverse()", (String)reverseConverter.toString());
        new EqualsTester().addEqualityGroup(new Object[]{STR_TO_LONG, STR_TO_LONG.reverse().reverse()}).addEqualityGroup(new Object[]{STR_TO_LONG.reverse(), STR_TO_LONG.reverse()}).testEquals();
    }

    public void testReverseReverse() {
        Converter<String, Long> converter = STR_TO_LONG;
        ConverterTest.assertEquals(converter, (Object)converter.reverse().reverse());
    }

    public void testApply() {
        ConverterTest.assertEquals((Object)LONG_VAL, (Object)STR_TO_LONG.apply((Object)STR_VAL));
    }

    public void testAndThen() {
        Converter<StringWrapper, String> first = new Converter<StringWrapper, String>(){

            protected String doForward(StringWrapper object) {
                return object.value;
            }

            protected StringWrapper doBackward(String object) {
                return new StringWrapper(object);
            }

            public String toString() {
                return "StringWrapper";
            }
        };
        Converter converter = first.andThen(STR_TO_LONG);
        ConverterTest.assertEquals((Object)LONG_VAL, (Object)converter.convert((Object)new StringWrapper(STR_VAL)));
        ConverterTest.assertEquals((String)STR_VAL, (String)((StringWrapper)converter.reverse().convert((Object)LONG_VAL)).value);
        ConverterTest.assertEquals((String)"StringWrapper.andThen(string2long)", (String)converter.toString());
        ConverterTest.assertEquals((Object)first.andThen(STR_TO_LONG), (Object)first.andThen(STR_TO_LONG));
    }

    public void testIdentityConverter() {
        Converter stringIdentityConverter = Converter.identity();
        ConverterTest.assertSame((Object)stringIdentityConverter, (Object)stringIdentityConverter.reverse());
        ConverterTest.assertSame(STR_TO_LONG, (Object)stringIdentityConverter.andThen(STR_TO_LONG));
        ConverterTest.assertSame((Object)STR_VAL, (Object)stringIdentityConverter.convert((Object)STR_VAL));
        ConverterTest.assertSame((Object)STR_VAL, (Object)stringIdentityConverter.reverse().convert((Object)STR_VAL));
        ConverterTest.assertEquals((String)"Converter.identity()", (String)stringIdentityConverter.toString());
        ConverterTest.assertSame((Object)Converter.identity(), (Object)Converter.identity());
    }

    public void testFrom() {
        Function<String, Integer> forward = new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        };
        Function backward = Functions.toStringFunction();
        Converter converter = Converter.from((Function)forward, (Function)backward);
        ConverterTest.assertNull((Object)converter.convert(null));
        ConverterTest.assertNull((Object)converter.reverse().convert(null));
        ConverterTest.assertEquals((Object)5, (Object)converter.convert((Object)"5"));
        ConverterTest.assertEquals((String)"5", (String)((String)converter.reverse().convert((Object)5)));
    }

    public void testNullIsPassedThrough() {
        Converter<String, String> nullsArePassed = ConverterTest.sillyConverter(false);
        ConverterTest.assertEquals((String)"forward", (String)((String)nullsArePassed.convert((Object)"foo")));
        ConverterTest.assertEquals((String)"forward", (String)((String)nullsArePassed.convert(null)));
        ConverterTest.assertEquals((String)"backward", (String)((String)nullsArePassed.reverse().convert((Object)"foo")));
        ConverterTest.assertEquals((String)"backward", (String)((String)nullsArePassed.reverse().convert(null)));
    }

    public void testNullIsNotPassedThrough() {
        Converter<String, String> nullsAreHandled = ConverterTest.sillyConverter(true);
        ConverterTest.assertEquals((String)"forward", (String)((String)nullsAreHandled.convert((Object)"foo")));
        ConverterTest.assertEquals(null, (String)((String)nullsAreHandled.convert(null)));
        ConverterTest.assertEquals((String)"backward", (String)((String)nullsAreHandled.reverse().convert((Object)"foo")));
        ConverterTest.assertEquals(null, (String)((String)nullsAreHandled.reverse().convert(null)));
    }

    private static Converter<String, String> sillyConverter(boolean handleNullAutomatically) {
        return new Converter<String, String>(handleNullAutomatically){

            protected String doForward(String string) {
                return "forward";
            }

            protected String doBackward(String string) {
                return "backward";
            }
        };
    }

    public void testSerialization_identity() {
        Converter identityConverter = Converter.identity();
        SerializableTester.reserializeAndAssert((Object)identityConverter);
    }

    public void testSerialization_reverse() {
        Converter reverseConverter = Longs.stringConverter().reverse();
        SerializableTester.reserializeAndAssert((Object)reverseConverter);
    }

    public void testSerialization_andThen() {
        Converter converterA = Longs.stringConverter();
        Converter reverseConverter = Longs.stringConverter().reverse();
        Converter composedConverter = converterA.andThen(reverseConverter);
        SerializableTester.reserializeAndAssert((Object)composedConverter);
    }

    public void testSerialization_from() {
        Converter dumb = Converter.from((Function)Functions.toStringFunction(), (Function)Functions.toStringFunction());
        SerializableTester.reserializeAndAssert((Object)dumb);
    }

    private static class StringWrapper {
        private final String value;

        public StringWrapper(String value) {
            this.value = value;
        }
    }
}

