/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.GcFinalization;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class EnumsTest
extends TestCase {
    public void testGetIfPresent() {
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"CHEETO")).hasValue((Object)TestEnum.CHEETO);
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"HONDA")).hasValue((Object)TestEnum.HONDA);
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"POODLE")).hasValue((Object)TestEnum.POODLE);
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"CHEETO")).isPresent();
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"HONDA")).isPresent();
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"POODLE")).isPresent();
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"CHEETO")).hasValue((Object)TestEnum.CHEETO);
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"HONDA")).hasValue((Object)TestEnum.HONDA);
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"POODLE")).hasValue((Object)TestEnum.POODLE);
    }

    public void testGetIfPresent_caseSensitive() {
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"cHEETO")).isAbsent();
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"Honda")).isAbsent();
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"poodlE")).isAbsent();
    }

    public void testGetIfPresent_whenNoMatchingConstant() {
        Truth.assertThat((Optional)Enums.getIfPresent(TestEnum.class, (String)"WOMBAT")).isAbsent();
    }

    @GwtIncompatible
    public void testGetIfPresent_doesNotPreventClassUnloading() throws Exception {
        WeakReference<?> shadowLoaderReference = this.doTestClassUnloading();
        GcFinalization.awaitClear(shadowLoaderReference);
    }

    @GwtIncompatible
    private WeakReference<?> doTestClassUnloading() throws Exception {
        URLClassLoader shadowLoader = new URLClassLoader(this.getClassPathUrls(), null);
        Class<?> shadowTestEnum = Class.forName(TestEnum.class.getName(), false, shadowLoader);
        EnumsTest.assertNotSame(shadowTestEnum, TestEnum.class);
        HashSet<Object> shadowConstants = new HashSet<Object>();
        for (TestEnum constant : TestEnum.values()) {
            Optional result = Enums.getIfPresent(shadowTestEnum, (String)constant.name());
            Truth.assertThat((Optional)result).isPresent();
            shadowConstants.add(result.get());
        }
        EnumsTest.assertEquals((Object)ImmutableSet.copyOf((Object[])shadowTestEnum.getEnumConstants()), shadowConstants);
        Optional result = Enums.getIfPresent(shadowTestEnum, (String)"blibby");
        Truth.assertThat((Optional)result).isAbsent();
        return new WeakReference<URLClassLoader>(shadowLoader);
    }

    public void testStringConverter_convert() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertEquals((Object)((Object)TestEnum.CHEETO), (Object)converter.convert((Object)"CHEETO"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.HONDA), (Object)converter.convert((Object)"HONDA"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.POODLE), (Object)converter.convert((Object)"POODLE"));
        EnumsTest.assertNull((Object)converter.convert(null));
        EnumsTest.assertNull((Object)converter.reverse().convert(null));
    }

    public void testStringConverter_convertError() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        try {
            converter.convert((Object)"xxx");
            EnumsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStringConverter_reverse() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertEquals((String)"CHEETO", (String)((String)converter.reverse().convert((Object)TestEnum.CHEETO)));
        EnumsTest.assertEquals((String)"HONDA", (String)((String)converter.reverse().convert((Object)TestEnum.HONDA)));
        EnumsTest.assertEquals((String)"POODLE", (String)((String)converter.reverse().convert((Object)TestEnum.POODLE)));
    }

    @GwtIncompatible
    public void testStringConverter_nullPointerTester() throws Exception {
        Converter converter = Enums.stringConverter(TestEnum.class);
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)converter);
    }

    public void testStringConverter_nullConversions() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertNull((Object)converter.convert(null));
        EnumsTest.assertNull((Object)converter.reverse().convert(null));
    }

    @GwtIncompatible
    public void testStringConverter_toString() {
        EnumsTest.assertEquals((String)"Enums.stringConverter(com.google.common.base.EnumsTest$TestEnum.class)", (String)Enums.stringConverter(TestEnum.class).toString());
    }

    public void testStringConverter_serialization() {
        SerializableTester.reserializeAndAssert((Object)Enums.stringConverter(TestEnum.class));
    }

    @GwtIncompatible
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Enums.class);
    }

    @GwtIncompatible
    public void testGetField() {
        Field foo = Enums.getField((Enum)AnEnum.FOO);
        EnumsTest.assertEquals((String)"FOO", (String)foo.getName());
        EnumsTest.assertTrue((boolean)foo.isAnnotationPresent(ExampleAnnotation.class));
        Field bar = Enums.getField((Enum)AnEnum.BAR);
        EnumsTest.assertEquals((String)"BAR", (String)bar.getName());
        EnumsTest.assertFalse((boolean)bar.isAnnotationPresent(ExampleAnnotation.class));
    }

    @GwtIncompatible
    private URL[] getClassPathUrls() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        return classLoader instanceof URLClassLoader ? ((URLClassLoader)classLoader).getURLs() : (URL[])EnumsTest.parseJavaClassPath().toArray((Object[])new URL[0]);
    }

    @GwtIncompatible
    private static ImmutableList<URL> parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                AssertionError error = new AssertionError((Object)("malformed class path entry: " + entry));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        }
        return urls.build();
    }

    private static enum AnEnum {
        FOO,
        BAR;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ExampleAnnotation {
    }

    private static enum OtherEnum {

    }

    private static enum TestEnum {
        CHEETO,
        HONDA,
        POODLE;

    }
}

