/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.Stopwatch;
import com.google.common.testing.GcFinalization;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class FinalizableReferenceQueueClassLoaderUnloadingTest
extends TestCase {
    private WeakReference<ClassLoader> useFrqInSeparateLoader() throws Exception {
        URLClassLoader myLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] urls = myLoader.getURLs();
        URLClassLoader sepLoader = new URLClassLoader(urls, myLoader.getParent());
        Class<FinalizableReferenceQueue> frqC = FinalizableReferenceQueue.class;
        Class<?> sepFrqC = sepLoader.loadClass(frqC.getName());
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertNotSame(frqC, sepFrqC);
        Class<?> sepFrqSystemLoaderC = sepLoader.loadClass(FinalizableReferenceQueue.SystemLoader.class.getName());
        Field disabled = sepFrqSystemLoaderC.getDeclaredField("disabled");
        disabled.setAccessible(true);
        disabled.set(null, true);
        AtomicReference sepFrqA = new AtomicReference(sepFrqC.newInstance());
        Class<?> sepFwrC = sepLoader.loadClass(MyFinalizableWeakReference.class.getName());
        Constructor<?> sepFwrCons = sepFwrC.getConstructor(Object.class, sepFrqC);
        Class<?> sepStopwatchC = sepLoader.loadClass(Stopwatch.class.getName());
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertSame((Object)sepLoader, (Object)sepStopwatchC.getClassLoader());
        AtomicReference<Object> sepStopwatchA = new AtomicReference<Object>(sepStopwatchC.getMethod("createUnstarted", new Class[0]).invoke(null, new Object[0]));
        AtomicReference<WeakReference> sepStopwatchRef = new AtomicReference<WeakReference>((WeakReference)sepFwrCons.newInstance(sepStopwatchA.get(), sepFrqA.get()));
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertNotNull((Object)sepStopwatchA.get());
        sepStopwatchA.set(null);
        GcFinalization.awaitClear((WeakReference)sepStopwatchRef.get());
        return new WeakReference<ClassLoader>(sepLoader);
    }

    private void doTestUnloadable() throws Exception {
        WeakReference<ClassLoader> loaderRef = this.useFrqInSeparateLoader();
        GcFinalization.awaitClear(loaderRef);
    }

    public void testUnloadableWithoutSecurityManager() throws Exception {
        SecurityManager oldSecurityManager = System.getSecurityManager();
        try {
            System.setSecurityManager(null);
            this.doTestUnloadable();
        }
        finally {
            System.setSecurityManager(oldSecurityManager);
        }
    }

    public void testUnloadableWithSecurityManager() throws Exception {
        Policy oldPolicy = Policy.getPolicy();
        SecurityManager oldSecurityManager = System.getSecurityManager();
        try {
            Policy.setPolicy(new PermissivePolicy());
            System.setSecurityManager(new SecurityManager());
            this.doTestUnloadable();
        }
        finally {
            System.setSecurityManager(oldSecurityManager);
            Policy.setPolicy(oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnloadableInStaticFieldIfClosed() throws Exception {
        Policy oldPolicy = Policy.getPolicy();
        SecurityManager oldSecurityManager = System.getSecurityManager();
        try {
            Policy.setPolicy(new PermissivePolicy());
            System.setSecurityManager(new SecurityManager());
            WeakReference<ClassLoader> loaderRef = this.doTestUnloadableInStaticFieldIfClosed();
            GcFinalization.awaitClear(loaderRef);
        }
        finally {
            System.setSecurityManager(oldSecurityManager);
            Policy.setPolicy(oldPolicy);
        }
    }

    private WeakReference<ClassLoader> doTestUnloadableInStaticFieldIfClosed() throws Exception {
        URLClassLoader myLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] urls = myLoader.getURLs();
        URLClassLoader sepLoader = new URLClassLoader(urls, myLoader.getParent());
        Class<FinalizableReferenceQueue> frqC = FinalizableReferenceQueue.class;
        Class<?> sepFrqC = sepLoader.loadClass(frqC.getName());
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertNotSame(frqC, sepFrqC);
        Class<?> sepFrqSystemLoaderC = sepLoader.loadClass(FinalizableReferenceQueue.SystemLoader.class.getName());
        Field disabled = sepFrqSystemLoaderC.getDeclaredField("disabled");
        disabled.setAccessible(true);
        disabled.set(null, true);
        Class<FrqUser> frqUserC = FrqUser.class;
        Class<?> sepFrqUserC = sepLoader.loadClass(frqUserC.getName());
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertNotSame(frqUserC, sepFrqUserC);
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertSame((Object)sepLoader, (Object)sepFrqUserC.getClassLoader());
        Callable sepFrqUser = (Callable)sepFrqUserC.newInstance();
        WeakReference finalizableWeakReference = (WeakReference)sepFrqUser.call();
        GcFinalization.awaitClear((WeakReference)finalizableWeakReference);
        Field sepFrqUserFinalizedF = sepFrqUserC.getField("finalized");
        Semaphore finalizeCount = (Semaphore)sepFrqUserFinalizedF.get(null);
        boolean finalized = finalizeCount.tryAcquire(5L, TimeUnit.SECONDS);
        FinalizableReferenceQueueClassLoaderUnloadingTest.assertTrue((boolean)finalized);
        Field sepFrqUserFrqF = sepFrqUserC.getField("frq");
        Closeable frq = (Closeable)sepFrqUserFrqF.get(null);
        frq.close();
        return new WeakReference<ClassLoader>(sepLoader);
    }

    public static class FrqUser
    implements Callable<WeakReference<Object>> {
        public static FinalizableReferenceQueue frq = new FinalizableReferenceQueue();
        public static final Semaphore finalized = new Semaphore(0);

        @Override
        public WeakReference<Object> call() {
            FinalizableWeakReference<Object> wr = new FinalizableWeakReference<Object>((Object)new Integer(23), frq){

                public void finalizeReferent() {
                    finalized.release();
                }
            };
            return wr;
        }
    }

    private static class PermissivePolicy
    extends Policy {
        private PermissivePolicy() {
        }

        @Override
        public boolean implies(ProtectionDomain pd, Permission perm) {
            return true;
        }
    }

    public static class MyFinalizableWeakReference
    extends FinalizableWeakReference<Object> {
        public MyFinalizableWeakReference(Object x, FinalizableReferenceQueue queue) {
            super(x, queue);
        }

        public void finalizeReferent() {
        }
    }
}

