/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.AndroidIncompatible;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.internal.Finalizer;
import com.google.common.testing.GcFinalization;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;

public class FinalizableReferenceQueueTest
extends TestCase {
    private FinalizableReferenceQueue frq;
    private WeakReference<ReferenceQueue<Object>> queueReference;
    FinalizableWeakReference<Object> reference;

    protected void tearDown() throws Exception {
        this.frq = null;
    }

    public void testFinalizeReferentCalled() {
        this.frq = new FinalizableReferenceQueue();
        final MockReference reference = new MockReference(this.frq);
        GcFinalization.awaitDone((GcFinalization.FinalizationPredicate)new GcFinalization.FinalizationPredicate(){

            public boolean isDone() {
                return reference.finalizeReferentCalled;
            }
        });
    }

    public void testThatFinalizerStops() {
        this.weaklyReferenceQueue();
        GcFinalization.awaitClear(this.queueReference);
    }

    private void weaklyReferenceQueue() {
        this.frq = new FinalizableReferenceQueue();
        this.queueReference = new WeakReference<ReferenceQueue>(this.frq.queue);
        this.reference = new FinalizableWeakReference<Object>(new Object(), this.frq){

            public void finalizeReferent() {
                FinalizableReferenceQueueTest.this.reference = null;
                FinalizableReferenceQueueTest.this.frq = null;
            }
        };
    }

    @AndroidIncompatible
    public void testDecoupledLoader() {
        FinalizableReferenceQueue.DecoupledLoader decoupledLoader = new FinalizableReferenceQueue.DecoupledLoader(){

            URLClassLoader newLoader(URL base) {
                return new DecoupledClassLoader(new URL[]{base});
            }
        };
        Class finalizerCopy = decoupledLoader.loadFinalizer();
        FinalizableReferenceQueueTest.assertNotNull((Object)finalizerCopy);
        FinalizableReferenceQueueTest.assertNotSame(Finalizer.class, (Object)finalizerCopy);
        FinalizableReferenceQueueTest.assertNotNull((Object)FinalizableReferenceQueue.getStartFinalizer((Class)finalizerCopy));
    }

    @AndroidIncompatible
    public void testGetFinalizerUrl() {
        FinalizableReferenceQueueTest.assertNotNull((Object)((Object)((Object)this)).getClass().getResource("internal/Finalizer.class"));
    }

    public void testFinalizeClassHasNoNestedClasses() throws Exception {
        FinalizableReferenceQueueTest.assertEquals(Collections.emptyList(), Arrays.asList(Finalizer.class.getDeclaredClasses()));
    }

    static class DecoupledClassLoader
    extends URLClassLoader {
        public DecoupledClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.equals(Finalizer.class.getName())) {
                Class<?> clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(name, resolve);
        }
    }

    static class MockReference
    extends FinalizableWeakReference<Object> {
        volatile boolean finalizeReferentCalled;

        MockReference(FinalizableReferenceQueue frq) {
            super(new Object(), frq);
        }

        public void finalizeReferent() {
            this.finalizeReferentCalled = true;
        }
    }
}

