/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.List;

public class LazyStackTraceBenchmark {
    @Param(value={"20", "200", "2000"})
    int stackDepth;
    @Param(value={"-1", "3", "15"})
    int breakAt;
    int recursionCount;
    private static final Object duh = new Object();
    @Param
    Mode mode;

    @BeforeExperiment
    public void doBefore() {
        this.recursionCount = this.stackDepth - new Throwable().getStackTrace().length - 1;
        if (this.recursionCount < 0) {
            throw new SkipThisScenarioException();
        }
    }

    @Benchmark
    public boolean timeFindCaller(int reps) {
        return this.timeFindCaller(reps, this.recursionCount);
    }

    private boolean timeFindCaller(int reps, int recurse) {
        return recurse > 0 ? this.timeFindCaller(reps, recurse - 1) : this.mode.timeIt(reps, this.breakAt);
    }

    static enum Mode {
        LAZY_STACK_TRACE{

            @Override
            List<StackTraceElement> getStackTrace(Throwable t) {
                return Throwables.lazyStackTrace((Throwable)t);
            }
        }
        ,
        GET_STACK_TRACE{

            @Override
            List<StackTraceElement> getStackTrace(Throwable t) {
                return Arrays.asList(t.getStackTrace());
            }
        };


        boolean timeIt(int reps, int breakAt) {
            boolean dummy = false;
            block0: for (int i = 0; i < reps; ++i) {
                int f = 0;
                Throwable t = new Throwable();
                for (StackTraceElement ste : this.getStackTrace(t)) {
                    dummy |= ste == duh;
                    if (f++ != breakAt) continue;
                    continue block0;
                }
            }
            return dummy;
        }

        abstract List<StackTraceElement> getStackTrace(Throwable var1);
    }
}

