/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;

public class SplitterBenchmark {
    @Param(value={"1", "10", "100", "1000"})
    int length;
    @Param(value={"xxxx", "xxXx", "xXxX", "XXXX"})
    String text;
    private String input;
    private static final Splitter CHAR_SPLITTER = Splitter.on((char)'X');
    private static final Splitter STRING_SPLITTER = Splitter.on((String)"X");

    @BeforeExperiment
    void setUp() {
        this.input = Strings.repeat((String)this.text, (int)this.length);
    }

    @Benchmark
    void charSplitter(int reps) {
        int total = 0;
        for (int i = 0; i < reps; ++i) {
            total += Iterables.size((Iterable)CHAR_SPLITTER.split((CharSequence)this.input));
        }
    }

    @Benchmark
    void stringSplitter(int reps) {
        int total = 0;
        for (int i = 0; i < reps; ++i) {
            total += Iterables.size((Iterable)STRING_SPLITTER.split((CharSequence)this.input));
        }
    }
}

