/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.AndroidIncompatible;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class ThrowablesTest
extends TestCase {
    public void testThrowIfUnchecked_Unchecked() {
        try {
            Throwables.throwIfUnchecked((Throwable)new SomeUncheckedException());
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_Error() {
        try {
            Throwables.throwIfUnchecked((Throwable)new SomeError());
            ThrowablesTest.fail();
        }
        catch (SomeError someError) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_Checked() {
        Throwables.throwIfUnchecked((Throwable)new SomeCheckedException());
    }

    @GwtIncompatible
    public void testPropagateIfPossible_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.noneDeclared();
    }

    @GwtIncompatible
    public void testPropagateIfPossible_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_NoneDeclared_UndeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_OneDeclared_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.oneDeclared();
    }

    @GwtIncompatible
    public void testPropagateIfPossible_OneDeclared_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_OneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_OneDeclared_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_TwoDeclared_NoneThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.twoDeclared();
    }

    @GwtIncompatible
    public void testPropagateIfPossible_TwoDeclared_UncheckedThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_TwoDeclared_CheckedThrown() throws SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfPossible_TwoDeclared_OtherCheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeOtherCheckedException someOtherCheckedException) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_null() throws SomeCheckedException {
        try {
            Throwables.throwIfUnchecked(null);
            ThrowablesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropageIfPossible_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null);
    }

    @GwtIncompatible
    public void testPropageIfPossible_OneDeclared_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null, SomeCheckedException.class);
    }

    @GwtIncompatible
    public void testPropageIfPossible_TwoDeclared_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null, SomeCheckedException.class, SomeUncheckedException.class);
    }

    @GwtIncompatible
    public void testPropagate_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.noneDeclared();
    }

    @GwtIncompatible
    public void testPropagate_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagate_NoneDeclared_ErrorThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsError();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeError someError) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagate_NoneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SomeCheckedException.class);
        }
    }

    @GwtIncompatible
    public void testThrowIfInstanceOf_Unchecked() throws SomeCheckedException {
        Throwables.throwIfInstanceOf((Throwable)new SomeUncheckedException(), SomeCheckedException.class);
    }

    @GwtIncompatible
    public void testThrowIfInstanceOf_CheckedDifferent() throws SomeCheckedException {
        Throwables.throwIfInstanceOf((Throwable)new SomeOtherCheckedException(), SomeCheckedException.class);
    }

    @GwtIncompatible
    public void testThrowIfInstanceOf_CheckedSame() {
        try {
            Throwables.throwIfInstanceOf((Throwable)new SomeCheckedException(), SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testThrowIfInstanceOf_CheckedSubclass() {
        try {
            Throwables.throwIfInstanceOf((Throwable)new SomeCheckedException(){}, SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfInstanceOf_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.oneDeclared();
    }

    @GwtIncompatible
    public void testPropagateIfInstanceOf_DeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfInstanceOf_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropagateIfInstanceOf_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SomeOtherCheckedException.class);
        }
    }

    @GwtIncompatible
    public void testThrowIfInstanceOf_null() throws SomeCheckedException {
        try {
            Throwables.throwIfInstanceOf(null, SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testPropageIfInstanceOf_null() throws SomeCheckedException {
        Throwables.propagateIfInstanceOf(null, SomeCheckedException.class);
    }

    public void testGetRootCause_NoCause() {
        SomeCheckedException exception = new SomeCheckedException();
        ThrowablesTest.assertSame((Object)exception, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_SingleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(cause);
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_DoubleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(new SomeChainingException(cause));
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_Loop() {
        Exception cause = new Exception();
        Exception exception = new Exception(cause);
        cause.initCause(exception);
        try {
            Throwables.getRootCause((Throwable)cause);
            ThrowablesTest.fail((String)"Should have throw IAE");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasCauseThat().isSameAs((Object)cause);
        }
    }

    static void methodThatDoesntThrowAnything() {
    }

    static void methodThatThrowsError() {
        throw new SomeError();
    }

    static void methodThatThrowsUnchecked() {
        throw new SomeUncheckedException();
    }

    static void methodThatThrowsChecked() throws SomeCheckedException {
        throw new SomeCheckedException();
    }

    static void methodThatThrowsOtherChecked() throws SomeOtherCheckedException {
        throw new SomeOtherCheckedException();
    }

    static void methodThatThrowsUndeclaredChecked() throws SomeUndeclaredCheckedException {
        throw new SomeUndeclaredCheckedException();
    }

    @GwtIncompatible
    public void testGetStackTraceAsString() {
        class StackTraceException
        extends Exception {
            StackTraceException(String message) {
                super(message);
            }
        }
        StackTraceException e = new StackTraceException("my message");
        String firstLine = Pattern.quote(e.getClass().getName() + ": " + e.getMessage());
        String secondLine = "\\s*at " + ThrowablesTest.class.getName() + "\\..*";
        String moreLines = "(?:.*\n?)*";
        String expected = firstLine + "\n" + secondLine + "\n" + moreLines;
        Truth.assertThat((String)Throwables.getStackTraceAsString((Throwable)e)).matches(expected);
    }

    public void testGetCausalChain() {
        SomeUncheckedException sue = new SomeUncheckedException();
        IllegalArgumentException iae = new IllegalArgumentException(sue);
        RuntimeException re = new RuntimeException(iae);
        IllegalStateException ex = new IllegalStateException(re);
        ThrowablesTest.assertEquals(Arrays.asList(ex, re, iae, sue), (Object)Throwables.getCausalChain((Throwable)ex));
        ThrowablesTest.assertSame((Object)sue, (Object)Iterables.getOnlyElement((Iterable)Throwables.getCausalChain((Throwable)sue)));
        List causes = Throwables.getCausalChain((Throwable)ex);
        try {
            causes.add(new RuntimeException());
            ThrowablesTest.fail((String)"List should be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetCasualChainNull() {
        try {
            Throwables.getCausalChain(null);
            ThrowablesTest.fail((String)"Should have throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetCasualChainLoop() {
        Exception cause = new Exception();
        Exception exception = new Exception(cause);
        cause.initCause(exception);
        try {
            Throwables.getCausalChain((Throwable)cause);
            ThrowablesTest.fail((String)"Should have throw IAE");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasCauseThat().isSameAs((Object)cause);
        }
    }

    @GwtIncompatible
    public void testGetCauseAs() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException thrown = new SomeChainingException(cause);
        Truth.assertThat((Throwable)thrown.getCause()).isSameAs((Object)cause);
        Truth.assertThat((Throwable)Throwables.getCauseAs((Throwable)thrown, SomeCheckedException.class)).isSameAs((Object)cause);
        Truth.assertThat((Throwable)Throwables.getCauseAs((Throwable)thrown, Exception.class)).isSameAs((Object)cause);
        try {
            Throwables.getCauseAs((Throwable)thrown, IllegalStateException.class);
            ThrowablesTest.fail((String)"Should have thrown CCE");
        }
        catch (ClassCastException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isSameAs((Object)thrown);
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testLazyStackTraceWorksInProd() {
        if (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value().equals("9")) {
            return;
        }
        ThrowablesTest.assertTrue((boolean)Throwables.lazyStackTraceIsLazy());
    }

    @GwtIncompatible
    public void testLazyStackTrace() {
        Exception e = new Exception();
        StackTraceElement[] originalStackTrace = e.getStackTrace();
        Truth.assertThat((Iterable)Throwables.lazyStackTrace((Throwable)e)).containsExactly((Object[])originalStackTrace).inOrder();
        try {
            Throwables.lazyStackTrace((Throwable)e).set(0, null);
            ThrowablesTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (!Throwables.lazyStackTraceIsLazy()) {
            return;
        }
        e.setStackTrace(new StackTraceElement[0]);
        Truth.assertThat((Iterable)Throwables.lazyStackTrace((Throwable)e)).containsExactly((Object[])originalStackTrace).inOrder();
    }

    @GwtIncompatible
    private void doTestLazyStackTraceFallback() {
        ThrowablesTest.assertFalse((boolean)Throwables.lazyStackTraceIsLazy());
        Exception e = new Exception();
        Truth.assertThat((Iterable)Throwables.lazyStackTrace((Throwable)e)).containsExactly((Object[])e.getStackTrace()).inOrder();
        try {
            Throwables.lazyStackTrace((Throwable)e).set(0, null);
            ThrowablesTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e.setStackTrace(new StackTraceElement[0]);
        Truth.assertThat((Iterable)Throwables.lazyStackTrace((Throwable)e)).isEmpty();
    }

    @GwtIncompatible
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Throwables.class);
    }

    @GwtIncompatible
    private static class AllowSettingSecurityManagerPolicy
    extends Policy {
        private AllowSettingSecurityManagerPolicy() {
        }

        @Override
        public boolean implies(ProtectionDomain pd, Permission perm) {
            return true;
        }
    }

    static class Sample {
        Sample() {
        }

        void noneDeclared() {
        }

        void oneDeclared() throws SomeCheckedException {
        }

        void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
        }
    }

    private static class SomeChainingException
    extends RuntimeException {
        public SomeChainingException(Throwable cause) {
            super(cause);
        }
    }

    private static class SomeUndeclaredCheckedException
    extends Exception {
        private SomeUndeclaredCheckedException() {
        }
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeOtherCheckedException
    extends Exception {
        private SomeOtherCheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }

    private static class SomeError
    extends Error {
        private SomeError() {
        }
    }
}

