/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import junit.framework.TestCase;

@GwtCompatible
public class ToStringHelperTest
extends TestCase {
    @GwtIncompatible
    public void testConstructor_instance() {
        String toTest = MoreObjects.toStringHelper((Object)((Object)this)).toString();
        ToStringHelperTest.assertEquals((String)"ToStringHelperTest{}", (String)toTest);
    }

    public void testConstructorLenient_instance() {
        String toTest = MoreObjects.toStringHelper((Object)((Object)this)).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testConstructor_innerClass() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{}", (String)toTest);
    }

    public void testConstructorLenient_innerClass() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testConstructor_anonymousClass() {
        String toTest = MoreObjects.toStringHelper((Object)new Object(){}).toString();
        ToStringHelperTest.assertEquals((String)"{}", (String)toTest);
    }

    public void testConstructorLenient_anonymousClass() {
        String toTest = MoreObjects.toStringHelper((Object)new Object(){}).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testConstructor_classObject() {
        String toTest = MoreObjects.toStringHelper(TestClass.class).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{}", (String)toTest);
    }

    public void testConstructorLenient_classObject() {
        String toTest = MoreObjects.toStringHelper(TestClass.class).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    public void testConstructor_stringObject() {
        String toTest = MoreObjects.toStringHelper((String)"FooBar").toString();
        ToStringHelperTest.assertEquals((String)"FooBar{}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringHelper_localInnerClass() {
        class LocalInnerClass {
            LocalInnerClass() {
            }
        }
        String toTest = MoreObjects.toStringHelper((Object)new LocalInnerClass()).toString();
        ToStringHelperTest.assertEquals((String)"LocalInnerClass{}", (String)toTest);
    }

    public void testToStringHelperLenient_localInnerClass() {
        class LocalInnerClass {
            LocalInnerClass() {
            }
        }
        String toTest = MoreObjects.toStringHelper((Object)new LocalInnerClass()).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testToStringHelper_localInnerNestedClass() {
        class LocalInnerClass {
            LocalInnerClass() {
            }

            class 3LocalInnerClass.LocalInnerNestedClass {
                3LocalInnerClass.LocalInnerNestedClass() {
                }
            }
        }
        String toTest = MoreObjects.toStringHelper((Object)new LocalInnerClass().new 3LocalInnerClass.LocalInnerNestedClass()).toString();
        ToStringHelperTest.assertEquals((String)"LocalInnerNestedClass{}", (String)toTest);
    }

    public void testToStringHelperLenient_localInnerNestedClass() {
        class LocalInnerClass {
            LocalInnerClass() {
            }

            class 4LocalInnerClass.LocalInnerNestedClass {
                4LocalInnerClass.LocalInnerNestedClass() {
                }
            }
        }
        String toTest = MoreObjects.toStringHelper((Object)new LocalInnerClass().new 4LocalInnerClass.LocalInnerNestedClass()).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testToStringHelper_moreThanNineAnonymousClasses() {
        Object o1 = new Object(){};
        Object o2 = new Object(){};
        Object o3 = new Object(){};
        Object o4 = new Object(){};
        Object o5 = new Object(){};
        Object o6 = new Object(){};
        Object o7 = new Object(){};
        Object o8 = new Object(){};
        Object o9 = new Object(){};
        Object o10 = new Object(){};
        String toTest = MoreObjects.toStringHelper((Object)o10).toString();
        ToStringHelperTest.assertEquals((String)"{}", (String)toTest);
    }

    public void testToStringHelperLenient_moreThanNineAnonymousClasses() {
        Object o1 = new Object(){};
        Object o2 = new Object(){};
        Object o3 = new Object(){};
        Object o4 = new Object(){};
        Object o5 = new Object(){};
        Object o6 = new Object(){};
        Object o7 = new Object(){};
        Object o8 = new Object(){};
        Object o9 = new Object(){};
        Object o10 = new Object(){};
        String toTest = MoreObjects.toStringHelper((Object)o10).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{\\}"));
    }

    @GwtIncompatible
    public void testToString_oneField() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)"Hello").toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field1=Hello}", (String)toTest);
    }

    @GwtIncompatible
    public void testToString_oneIntegerField() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)new Integer(42)).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field1=42}", (String)toTest);
    }

    @GwtIncompatible
    public void testToString_nullInteger() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field1=null}", (String)toTest);
    }

    public void testToStringLenient_oneField() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)"Hello").toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{field1\\=Hello\\}"));
    }

    public void testToStringLenient_oneIntegerField() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)new Integer(42)).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{field1\\=42\\}"));
    }

    public void testToStringLenient_nullInteger() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)null).toString();
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{field1\\=null\\}"));
    }

    @GwtIncompatible
    public void testToString_complexFields() {
        ImmutableMap map = ImmutableMap.builder().put((Object)"abc", (Object)1).put((Object)"def", (Object)2).put((Object)"ghi", (Object)3).build();
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)"This is string.").add("field2", Arrays.asList("abc", "def", "ghi")).add("field3", (Object)map).toString();
        String expected = "TestClass{field1=This is string., field2=[abc, def, ghi], field3={abc=1, def=2, ghi=3}}";
        ToStringHelperTest.assertEquals((String)"TestClass{field1=This is string., field2=[abc, def, ghi], field3={abc=1, def=2, ghi=3}}", (String)toTest);
    }

    public void testToStringLenient_complexFields() {
        ImmutableMap map = ImmutableMap.builder().put((Object)"abc", (Object)1).put((Object)"def", (Object)2).put((Object)"ghi", (Object)3).build();
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)"This is string.").add("field2", Arrays.asList("abc", "def", "ghi")).add("field3", (Object)map).toString();
        String expectedRegex = ".*\\{field1\\=This is string\\., field2\\=\\[abc, def, ghi\\], field3=\\{abc\\=1, def\\=2, ghi\\=3\\}\\}";
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{field1\\=This is string\\., field2\\=\\[abc, def, ghi\\], field3=\\{abc\\=1, def\\=2, ghi\\=3\\}\\}"));
    }

    public void testToString_addWithNullName() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)new TestClass());
        try {
            helper.add(null, (Object)"Hello");
            ToStringHelperTest.fail((String)"No exception was thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testToString_addWithNullValue() {
        String result = MoreObjects.toStringHelper((Object)new TestClass()).add("Hello", null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{Hello=null}", (String)result);
    }

    public void testToStringLenient_addWithNullValue() {
        String result = MoreObjects.toStringHelper((Object)new TestClass()).add("Hello", null).toString();
        ToStringHelperTest.assertTrue((String)result, (boolean)result.matches(".*\\{Hello\\=null\\}"));
    }

    @GwtIncompatible
    public void testToString_ToStringTwice() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", 1).addValue((Object)"value1").add("field2", (Object)"value2");
        String expected = "TestClass{field1=1, value1, field2=value2}";
        ToStringHelperTest.assertEquals((String)"TestClass{field1=1, value1, field2=value2}", (String)helper.toString());
        ToStringHelperTest.assertEquals((String)"TestClass{field1=1, value1, field2=value2}", (String)helper.toString());
        String expected2 = "TestClass{field1=1, value1, field2=value2, 2}";
        helper.addValue(2);
        ToStringHelperTest.assertEquals((String)"TestClass{field1=1, value1, field2=value2, 2}", (String)helper.toString());
    }

    @GwtIncompatible
    public void testToString_addValue() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", 1).addValue((Object)"value1").add("field2", (Object)"value2").addValue(2).toString();
        String expected = "TestClass{field1=1, value1, field2=value2, 2}";
        ToStringHelperTest.assertEquals((String)"TestClass{field1=1, value1, field2=value2, 2}", (String)toTest);
    }

    public void testToStringLenient_addValue() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", 1).addValue((Object)"value1").add("field2", (Object)"value2").addValue(2).toString();
        String expected = ".*\\{field1\\=1, value1, field2\\=value2, 2\\}";
        ToStringHelperTest.assertTrue((String)toTest, (boolean)toTest.matches(".*\\{field1\\=1, value1, field2\\=value2, 2\\}"));
    }

    @GwtIncompatible
    public void testToString_addValueWithNullValue() {
        String result = MoreObjects.toStringHelper((Object)new TestClass()).addValue(null).addValue((Object)"Hello").addValue(null).toString();
        String expected = "TestClass{null, Hello, null}";
        ToStringHelperTest.assertEquals((String)"TestClass{null, Hello, null}", (String)result);
    }

    public void testToStringLenient_addValueWithNullValue() {
        String result = MoreObjects.toStringHelper((Object)new TestClass()).addValue(null).addValue((Object)"Hello").addValue(null).toString();
        String expected = ".*\\{null, Hello, null\\}";
        ToStringHelperTest.assertTrue((String)result, (boolean)result.matches(".*\\{null, Hello, null\\}"));
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_oneField() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().add("field1", null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_manyFieldsFirstNull() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().add("field1", null).add("field2", (Object)"Googley").add("field3", (Object)"World").toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field2=Googley, field3=World}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_manyFieldsOmitAfterNull() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", null).add("field2", (Object)"Googley").add("field3", (Object)"World").omitNullValues().toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field2=Googley, field3=World}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_manyFieldsLastNull() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().add("field1", (Object)"Hello").add("field2", (Object)"Googley").add("field3", null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field1=Hello, field2=Googley}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_oneValue() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().addValue(null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_manyValuesFirstNull() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().addValue(null).addValue((Object)"Googley").addValue((Object)"World").toString();
        ToStringHelperTest.assertEquals((String)"TestClass{Googley, World}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_manyValuesLastNull() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().addValue((Object)"Hello").addValue((Object)"Googley").addValue(null).toString();
        ToStringHelperTest.assertEquals((String)"TestClass{Hello, Googley}", (String)toTest);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_differentOrder() {
        String expected = "TestClass{field1=Hello, field2=Googley, field3=World}";
        String toTest1 = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().add("field1", (Object)"Hello").add("field2", (Object)"Googley").add("field3", (Object)"World").toString();
        String toTest2 = MoreObjects.toStringHelper((Object)new TestClass()).add("field1", (Object)"Hello").add("field2", (Object)"Googley").omitNullValues().add("field3", (Object)"World").toString();
        ToStringHelperTest.assertEquals((String)expected, (String)toTest1);
        ToStringHelperTest.assertEquals((String)expected, (String)toTest2);
    }

    @GwtIncompatible
    public void testToStringOmitNullValues_canBeCalledManyTimes() {
        String toTest = MoreObjects.toStringHelper((Object)new TestClass()).omitNullValues().omitNullValues().add("field1", (Object)"Hello").omitNullValues().add("field2", (Object)"Googley").omitNullValues().add("field3", (Object)"World").toString();
        ToStringHelperTest.assertEquals((String)"TestClass{field1=Hello, field2=Googley, field3=World}", (String)toTest);
    }

    private static class TestClass {
        private TestClass() {
        }
    }
}

