/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Charsets;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class Utf8Test
extends TestCase {
    private static final ImmutableList<String> ILL_FORMED_STRINGS;
    private static final long ONE_BYTE_ROUNDTRIPPABLE_CHARACTERS = 128L;
    private static final long EXPECTED_ONE_BYTE_ROUNDTRIPPABLE_COUNT = 128L;
    private static final long TWO_BYTE_ROUNDTRIPPABLE_CHARACTERS = 1920L;
    private static final long EXPECTED_TWO_BYTE_ROUNDTRIPPABLE_COUNT;
    private static final long THREE_BYTE_SURROGATES = 2048L;
    private static final long THREE_BYTE_ROUNDTRIPPABLE_CHARACTERS = 61440L;
    private static final long EXPECTED_THREE_BYTE_ROUNDTRIPPABLE_COUNT;
    private static final long FOUR_BYTE_ROUNDTRIPPABLE_CHARACTERS = 0x100000L;
    private static final long EXPECTED_FOUR_BYTE_ROUNDTRIPPABLE_COUNT;

    public void testEncodedLength_validStrings() {
        Utf8Test.assertEquals((int)0, (int)Utf8.encodedLength((CharSequence)""));
        Utf8Test.assertEquals((int)11, (int)Utf8.encodedLength((CharSequence)"Hello world"));
        Utf8Test.assertEquals((int)8, (int)Utf8.encodedLength((CharSequence)"R\u00e9sum\u00e9"));
        Utf8Test.assertEquals((int)461, (int)Utf8.encodedLength((CharSequence)"\u5a01\u5ec9\u00b7\u838e\u58eb\u6bd4\u4e9e\uff08William Shakespeare\uff0c1564\u5e744\u670826\u865f\u20141616\u5e744\u670823\u865f[1]\uff09\u4fc2\u96bb\u82f1\u570b\u55f0\u6f14\u54e1\u3001\u5287\u4f5c\u5bb6\u540c\u8a69\u4eba\uff0c\u6709\u6642\u9593\u4f62\u7c21\u7a31\u838e\u7fc1\uff1b\u4e2d\u570b\u6e05\u672b\u6c11\u521d\u54c8\u62d5\u7ffb\u8b6f\u505a\u820c\u514b\u65af\u6bd5\u3001\u6c99\u65af\u76ae\u8033\u3001\u7b5b\u65af\u6bd4\u8033\u3001\u838e\u57fa\u65af\u5e87\u5c14\u3001\u7d22\u58eb\u6bd4\u5c14\u3001\u590f\u514b\u601d\u8298\u5c14\u3001\u5e0c\u54c0\u82e6\u76ae\u963f\u3001\u53f6\u65af\u58c1\u3001\u6c99\u514b\u76ae\u5c14\u3001\u72f9\u65af\u4e15\u723e\u3002[2]\u838e\u58eb\u6bd4\u4e9e\u7de8\u5beb\u904e\u597d\u591a\u4f5c\u54c1\uff0c\u4f62\u55f0\u5287\u4f5c\u97ff\u897f\u6d0b\u6587\u5b78\u597d\u6709\u5f71\u97ff\uff0c\u54c8\u90fd\u62d5\u4eba\u7ffb\u8b6f\u505a\u597d\u591a\u8a71\u3002"));
        Utf8Test.assertEquals((int)4, (int)Utf8.encodedLength((CharSequence)Utf8Test.newString('\ud800', '\udc00')));
    }

    public void testEncodedLength_validStrings2() {
        HashMap<Integer, Integer> utf8Lengths = new HashMap<Integer, Integer>();
        utf8Lengths.put(0, 1);
        utf8Lengths.put(127, 1);
        utf8Lengths.put(128, 2);
        utf8Lengths.put(2047, 2);
        utf8Lengths.put(2048, 3);
        utf8Lengths.put(65535, 3);
        utf8Lengths.put(65536, 4);
        utf8Lengths.put(0x10FFFF, 4);
        Integer[] codePoints = utf8Lengths.keySet().toArray(new Integer[0]);
        StringBuilder sb = new StringBuilder();
        Random rnd = new Random();
        for (int trial = 0; trial < 100; ++trial) {
            sb.setLength(0);
            int utf8Length = 0;
            for (int i = 0; i < 6; ++i) {
                Integer randomCodePoint = codePoints[rnd.nextInt(codePoints.length)];
                sb.appendCodePoint(randomCodePoint);
                if ((utf8Length += ((Integer)utf8Lengths.get(randomCodePoint)).intValue()) == Utf8.encodedLength((CharSequence)sb)) continue;
                StringBuilder repro = new StringBuilder();
                for (int j = 0; j < sb.length(); ++j) {
                    repro.append(" ").append((int)sb.charAt(j));
                }
                Utf8Test.assertEquals((String)repro.toString(), (int)utf8Length, (int)Utf8.encodedLength((CharSequence)sb));
            }
        }
    }

    public void testEncodedLength_invalidStrings() {
        Utf8Test.testEncodedLengthFails(Utf8Test.newString('\ud800'), 0);
        Utf8Test.testEncodedLengthFails("foobar" + Utf8Test.newString('\ud800'), 6);
        Utf8Test.testEncodedLengthFails(Utf8Test.newString('\udc00'), 0);
        Utf8Test.testEncodedLengthFails("foobar" + Utf8Test.newString('\udc00'), 6);
        Utf8Test.testEncodedLengthFails(Utf8Test.newString('\ud800', '\ud800'), 0);
    }

    private static void testEncodedLengthFails(String invalidString, int invalidCodePointIndex) {
        try {
            Utf8.encodedLength((CharSequence)invalidString);
            Utf8Test.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("Unpaired surrogate at index " + invalidCodePointIndex);
        }
    }

    @GwtIncompatible
    public void testIsWellFormed_1Byte() {
        Utf8Test.testBytes(1, 128L);
    }

    @GwtIncompatible
    public void testIsWellFormed_2Bytes() {
        Utf8Test.testBytes(2, EXPECTED_TWO_BYTE_ROUNDTRIPPABLE_COUNT);
    }

    @GwtIncompatible
    public void testIsWellFormed_3Bytes() {
        Utf8Test.testBytes(3, EXPECTED_THREE_BYTE_ROUNDTRIPPABLE_COUNT);
    }

    public void testIsWellFormed_4BytesSamples() {
        Utf8Test.assertWellFormed(240, 164, 173, 162);
        Utf8Test.assertNotWellFormed(240, 164, 173, 127);
        Utf8Test.assertNotWellFormed(240, 164, 173, 192);
        Utf8Test.assertNotWellFormed(240, 143, 173, 162);
        Utf8Test.assertNotWellFormed(244, 144, 173, 162);
    }

    public void testSomeSequences() {
        Utf8Test.assertWellFormed(new int[0]);
        Utf8Test.assertWellFormed(0, 97, 98, 99, 127);
        Utf8Test.assertWellFormed(194, 162, 194, 162);
        Utf8Test.assertWellFormed(200, 138, 99, 200, 138, 99);
        Utf8Test.assertWellFormed(201, 139, 54, 50, 201, 139, 54, 50);
        Utf8Test.assertWellFormed(97, 200, 138, 99, 194, 162, 98, 92, 117, 48, 50, 52, 66, 54, 50, 117, 48, 50, 48, 97, 99, 99, 194, 162, 100, 101, 201, 139, 54, 50);
        Utf8Test.assertNotWellFormed(-1, 0, -1, 0);
    }

    public void testShardsHaveExpectedRoundTrippables() {
        long actual = 0L;
        for (long expected : Utf8Test.generateFourByteShardsExpectedRunnables()) {
            actual += expected;
        }
        Utf8Test.assertEquals((long)EXPECTED_FOUR_BYTE_ROUNDTRIPPABLE_COUNT, (long)actual);
    }

    private static String newString(char ... chars) {
        return new String(chars);
    }

    private static byte[] toByteArray(int ... bytes) {
        byte[] realBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            realBytes[i] = (byte)bytes[i];
        }
        return realBytes;
    }

    private static void assertWellFormed(int ... bytes) {
        Utf8Test.assertTrue((boolean)Utf8.isWellFormed((byte[])Utf8Test.toByteArray(bytes)));
    }

    private static void assertNotWellFormed(int ... bytes) {
        Utf8Test.assertFalse((boolean)Utf8.isWellFormed((byte[])Utf8Test.toByteArray(bytes)));
    }

    private static long[] generateFourByteShardsExpectedRunnables() {
        int i;
        long[] expected = new long[128];
        for (i = 0; i <= 63; ++i) {
            expected[i] = 0x50E000L;
        }
        for (i = 97; i <= 111; ++i) {
            expected[i] = 2342912L;
        }
        for (i = 113; i <= 117; ++i) {
            expected[i] = 0x100000L;
        }
        expected[112] = 786432L;
        expected[118] = 786432L;
        expected[119] = 0x100000L;
        expected[120] = 458752L;
        expected[121] = 524288L;
        expected[122] = 65536L;
        return expected;
    }

    @GwtIncompatible
    private static void testBytes(int numBytes, long expectedCount) {
        Utf8Test.testBytes(numBytes, expectedCount, 0L, -1L);
    }

    @GwtIncompatible
    private static void testBytes(int numBytes, long expectedCount, long start, long lim) {
        byte[] bytes = new byte[numBytes];
        if (lim == -1L) {
            lim = 1L << numBytes * 8;
        }
        long countRoundTripped = 0L;
        for (long byteChar = start; byteChar < lim; ++byteChar) {
            long tmpByteChar = byteChar;
            for (int i = 0; i < numBytes; ++i) {
                bytes[bytes.length - i - 1] = (byte)tmpByteChar;
                tmpByteChar >>= 8;
            }
            boolean isRoundTrippable = Utf8.isWellFormed((byte[])bytes);
            Utf8Test.assertEquals((boolean)isRoundTrippable, (boolean)Utf8.isWellFormed((byte[])bytes, (int)0, (int)numBytes));
            String s = new String(bytes, Charsets.UTF_8);
            byte[] bytesReencoded = s.getBytes(Charsets.UTF_8);
            boolean bytesEqual = Arrays.equals(bytes, bytesReencoded);
            if (bytesEqual != isRoundTrippable) {
                Utf8Test.fail();
            }
            if (!isRoundTrippable) continue;
            ++countRoundTripped;
        }
        Utf8Test.assertEquals((long)expectedCount, (long)countRoundTripped);
    }

    static {
        char[] surrogates;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (char surrogate : surrogates = new char[]{'\udfff', '\udbff', '\udc00', '\ud800'}) {
            builder.add((Object)Utf8Test.newString(surrogate));
            builder.add((Object)Utf8Test.newString(surrogate, 'n'));
            builder.add((Object)Utf8Test.newString('n', surrogate));
            builder.add((Object)Utf8Test.newString(surrogate, surrogate));
        }
        builder.add((Object)Utf8Test.newString('\udc00', '\udbff'));
        ILL_FORMED_STRINGS = builder.build();
        EXPECTED_TWO_BYTE_ROUNDTRIPPABLE_COUNT = (long)Math.pow(128.0, 2.0) + 1920L;
        EXPECTED_THREE_BYTE_ROUNDTRIPPABLE_COUNT = (long)Math.pow(128.0, 3.0) + 491520L + 61440L;
        EXPECTED_FOUR_BYTE_ROUNDTRIPPABLE_COUNT = (long)Math.pow(128.0, 4.0) + 0xF00000L + 3686400L + 0x5A00000L + 0x100000L;
    }
}

