/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.FakeTicker;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

@GwtCompatible
public class CacheBuilderGwtTest
extends TestCase {
    private FakeTicker fakeTicker;

    protected void setUp() throws Exception {
        super.setUp();
        this.fakeTicker = new FakeTicker();
    }

    public void testLoader() throws ExecutionException {
        Cache cache = CacheBuilder.newBuilder().build();
        Callable<Integer> loader = new Callable<Integer>(){
            private int i = 0;

            @Override
            public Integer call() throws Exception {
                return ++this.i;
            }
        };
        cache.put((Object)0, (Object)10);
        CacheBuilderGwtTest.assertEquals((Object)10, (Object)cache.get((Object)0, (Callable)loader));
        CacheBuilderGwtTest.assertEquals((Object)1, (Object)cache.get((Object)20, (Callable)loader));
        CacheBuilderGwtTest.assertEquals((Object)2, (Object)cache.get((Object)34, (Callable)loader));
        cache.invalidate((Object)0);
        CacheBuilderGwtTest.assertEquals((Object)3, (Object)cache.get((Object)0, (Callable)loader));
        cache.put((Object)0, (Object)10);
        cache.invalidateAll();
        CacheBuilderGwtTest.assertEquals((Object)4, (Object)cache.get((Object)0, (Callable)loader));
    }

    public void testSizeConstraint() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(4L).build();
        cache.put((Object)1, (Object)10);
        cache.put((Object)2, (Object)20);
        cache.put((Object)3, (Object)30);
        cache.put((Object)4, (Object)40);
        cache.put((Object)5, (Object)50);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)2));
        CacheBuilderGwtTest.assertEquals((Object)30, (Object)cache.getIfPresent((Object)3));
        CacheBuilderGwtTest.assertEquals((Object)40, (Object)cache.getIfPresent((Object)4));
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)5));
        cache.put((Object)1, (Object)10);
        CacheBuilderGwtTest.assertEquals((Object)10, (Object)cache.getIfPresent((Object)1));
        CacheBuilderGwtTest.assertEquals((Object)30, (Object)cache.getIfPresent((Object)3));
        CacheBuilderGwtTest.assertEquals((Object)40, (Object)cache.getIfPresent((Object)4));
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)5));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)2));
    }

    public void testLoadingCache() throws ExecutionException {
        CacheLoader<Integer, Integer> loader = new CacheLoader<Integer, Integer>(){
            int i = 0;

            public Integer load(Integer key) throws Exception {
                return this.i++;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        cache.put((Object)10, (Object)20);
        ImmutableMap map = cache.getAll((Iterable)ImmutableList.of((Object)10, (Object)20, (Object)30, (Object)54, (Object)443, (Object)1));
        CacheBuilderGwtTest.assertEquals((Object)20, map.get(10));
        CacheBuilderGwtTest.assertEquals((Object)0, map.get(20));
        CacheBuilderGwtTest.assertEquals((Object)1, map.get(30));
        CacheBuilderGwtTest.assertEquals((Object)2, map.get(54));
        CacheBuilderGwtTest.assertEquals((Object)3, map.get(443));
        CacheBuilderGwtTest.assertEquals((Object)4, map.get(1));
        CacheBuilderGwtTest.assertEquals((Object)5, (Object)cache.get((Object)6));
        CacheBuilderGwtTest.assertEquals((Object)6, (Object)cache.apply((Object)7));
    }

    public void testExpireAfterAccess() {
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)0, (Object)10);
        cache.put((Object)2, (Object)30);
        this.fakeTicker.advance(999L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals((Object)30, (Object)cache.getIfPresent((Object)2));
        this.fakeTicker.advance(1L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals((Object)30, (Object)cache.getIfPresent((Object)2));
        this.fakeTicker.advance(1000L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)0));
    }

    public void testExpireAfterWrite() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)100);
        cache.put((Object)20, (Object)200);
        cache.put((Object)4, (Object)2);
        this.fakeTicker.advance(999L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals((Object)100, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)200, (Object)cache.getIfPresent((Object)20));
        CacheBuilderGwtTest.assertEquals((Object)2, (Object)cache.getIfPresent((Object)4));
        this.fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)20));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)4));
        cache.put((Object)10, (Object)20);
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)10));
        this.fakeTicker.advance(1000L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)10));
    }

    public void testExpireAfterWriteAndAccess() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).expireAfterAccess(500L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)100);
        cache.put((Object)20, (Object)200);
        cache.put((Object)4, (Object)2);
        this.fakeTicker.advance(499L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals((Object)100, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)200, (Object)cache.getIfPresent((Object)20));
        this.fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals((Object)100, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)200, (Object)cache.getIfPresent((Object)20));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)4));
        this.fakeTicker.advance(499L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)20));
        cache.put((Object)10, (Object)20);
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)10));
        this.fakeTicker.advance(500L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)10));
    }

    public void testMapMethods() {
        Cache cache = CacheBuilder.newBuilder().build();
        ConcurrentMap asMap = cache.asMap();
        cache.put((Object)10, (Object)100);
        cache.put((Object)2, (Object)52);
        asMap.replace(2, 79);
        asMap.replace(3, 60);
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)3));
        CacheBuilderGwtTest.assertEquals(null, asMap.get(3));
        CacheBuilderGwtTest.assertEquals((Object)79, (Object)cache.getIfPresent((Object)2));
        CacheBuilderGwtTest.assertEquals((Object)79, asMap.get(2));
        asMap.replace(10, 100, 50);
        asMap.replace(2, 52, 99);
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)50, asMap.get(10));
        CacheBuilderGwtTest.assertEquals((Object)79, (Object)cache.getIfPresent((Object)2));
        CacheBuilderGwtTest.assertEquals((Object)79, asMap.get(2));
        asMap.remove(10, 100);
        asMap.remove(2, 79);
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)50, asMap.get(10));
        CacheBuilderGwtTest.assertEquals(null, (Object)cache.getIfPresent((Object)2));
        CacheBuilderGwtTest.assertEquals(null, asMap.get(2));
        asMap.putIfAbsent(2, 20);
        asMap.putIfAbsent(10, 20);
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)2));
        CacheBuilderGwtTest.assertEquals((Object)20, asMap.get(2));
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)50, asMap.get(10));
    }

    public void testRemovalListener() {
        final int[] stats = new int[4];
        RemovalListener<Integer, Integer> countingListener = new RemovalListener<Integer, Integer>(){

            public void onRemoval(RemovalNotification<Integer, Integer> notification) {
                switch (notification.getCause()) {
                    case EXPIRED: {
                        stats[0] = stats[0] + 1;
                        break;
                    }
                    case EXPLICIT: {
                        stats[1] = stats[1] + 1;
                        break;
                    }
                    case REPLACED: {
                        stats[2] = stats[2] + 1;
                        break;
                    }
                    case SIZE: {
                        stats[3] = stats[3] + 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("No collected exceptions in GWT CacheBuilder.");
                    }
                }
            }
        };
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).removalListener((RemovalListener)countingListener).ticker((Ticker)this.fakeTicker).maximumSize(2L).build();
        cache.put((Object)3, (Object)20);
        cache.put((Object)6, (Object)2);
        cache.put((Object)98, (Object)45);
        cache.put((Object)56, (Object)76);
        cache.put((Object)23, (Object)84);
        cache.put((Object)23, (Object)20);
        cache.put((Object)56, (Object)49);
        cache.put((Object)23, (Object)2);
        cache.put((Object)56, (Object)4);
        this.fakeTicker.advance(1001L, TimeUnit.MILLISECONDS);
        cache.getIfPresent((Object)23);
        cache.getIfPresent((Object)56);
        cache.put((Object)1, (Object)4);
        cache.put((Object)2, (Object)8);
        cache.invalidateAll();
        CacheBuilderGwtTest.assertEquals((int)2, (int)stats[0]);
        CacheBuilderGwtTest.assertEquals((int)2, (int)stats[1]);
        CacheBuilderGwtTest.assertEquals((int)4, (int)stats[2]);
        CacheBuilderGwtTest.assertEquals((int)3, (int)stats[3]);
    }

    public void testPutAll() {
        Cache cache = CacheBuilder.newBuilder().build();
        cache.putAll((Map)ImmutableMap.of((Object)10, (Object)20, (Object)30, (Object)50, (Object)60, (Object)90));
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)30));
        CacheBuilderGwtTest.assertEquals((Object)90, (Object)cache.getIfPresent((Object)60));
        cache.asMap().putAll(ImmutableMap.of((Object)10, (Object)50, (Object)30, (Object)20, (Object)60, (Object)70, (Object)5, (Object)5));
        CacheBuilderGwtTest.assertEquals((Object)50, (Object)cache.getIfPresent((Object)10));
        CacheBuilderGwtTest.assertEquals((Object)20, (Object)cache.getIfPresent((Object)30));
        CacheBuilderGwtTest.assertEquals((Object)70, (Object)cache.getIfPresent((Object)60));
        CacheBuilderGwtTest.assertEquals((Object)5, (Object)cache.getIfPresent((Object)5));
    }

    public void testInvalidate() {
        Cache cache = CacheBuilder.newBuilder().build();
        cache.put((Object)654, (Object)2675);
        cache.put((Object)2456, (Object)56);
        cache.put((Object)2, (Object)15);
        cache.invalidate((Object)654);
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(654));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(2456));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(2));
    }

    public void testInvalidateAll() {
        Cache cache = CacheBuilder.newBuilder().build();
        cache.put((Object)654, (Object)2675);
        cache.put((Object)2456, (Object)56);
        cache.put((Object)2, (Object)15);
        cache.invalidateAll();
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(654));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(2456));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(2));
        cache.put((Object)654, (Object)2675);
        cache.put((Object)2456, (Object)56);
        cache.put((Object)2, (Object)15);
        cache.put((Object)1, (Object)3);
        cache.invalidateAll((Iterable)ImmutableSet.of((Object)1, (Object)2));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(1));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(2));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(654));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(2456));
    }

    public void testAsMap_containsValue() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(20000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)654, (Object)2675);
        this.fakeTicker.advance(10000L, TimeUnit.MILLISECONDS);
        cache.put((Object)2456, (Object)56);
        cache.put((Object)2, (Object)15);
        this.fakeTicker.advance(10001L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsValue(15));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsValue(56));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsValue(2675));
    }

    public void testAsMap_containsKey() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(20000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)654, (Object)2675);
        this.fakeTicker.advance(10000L, TimeUnit.MILLISECONDS);
        cache.put((Object)2456, (Object)56);
        cache.put((Object)2, (Object)15);
        this.fakeTicker.advance(10001L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(2));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().containsKey(2456));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().containsKey(654));
    }

    public void testAsMapValues_contains() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)20);
        this.fakeTicker.advance(500L, TimeUnit.MILLISECONDS);
        cache.put((Object)20, (Object)22);
        cache.put((Object)5, (Object)10);
        this.fakeTicker.advance(501L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().values().contains(22));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().values().contains(10));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().values().contains(20));
    }

    public void testAsMapKeySet() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)20);
        this.fakeTicker.advance(500L, TimeUnit.MILLISECONDS);
        cache.put((Object)20, (Object)22);
        cache.put((Object)5, (Object)10);
        this.fakeTicker.advance(501L, TimeUnit.MILLISECONDS);
        HashSet foundKeys = new HashSet(cache.asMap().keySet());
        CacheBuilderGwtTest.assertEquals((Object)ImmutableSet.of((Object)20, (Object)5), foundKeys);
    }

    public void testAsMapKeySet_contains() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)20);
        this.fakeTicker.advance(500L, TimeUnit.MILLISECONDS);
        cache.put((Object)20, (Object)22);
        cache.put((Object)5, (Object)10);
        this.fakeTicker.advance(501L, TimeUnit.MILLISECONDS);
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().keySet().contains(20));
        CacheBuilderGwtTest.assertTrue((boolean)cache.asMap().keySet().contains(5));
        CacheBuilderGwtTest.assertFalse((boolean)cache.asMap().keySet().contains(10));
    }

    public void testAsMapEntrySet() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)20);
        this.fakeTicker.advance(500L, TimeUnit.MILLISECONDS);
        cache.put((Object)20, (Object)22);
        cache.put((Object)5, (Object)10);
        this.fakeTicker.advance(501L, TimeUnit.MILLISECONDS);
        int sum = 0;
        for (Map.Entry current : cache.asMap().entrySet()) {
            sum += (Integer)current.getKey() + (Integer)current.getValue();
        }
        CacheBuilderGwtTest.assertEquals((int)57, (int)sum);
    }

    public void testAsMapValues_iteratorRemove() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).ticker((Ticker)this.fakeTicker).build();
        cache.put((Object)10, (Object)20);
        Iterator iterator = cache.asMap().values().iterator();
        iterator.next();
        iterator.remove();
        CacheBuilderGwtTest.assertEquals((long)0L, (long)cache.size());
    }
}

