/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class CacheLoaderTest
extends TestCase {
    public void testAsyncReload() throws Exception {
        final AtomicInteger loadCount = new AtomicInteger();
        final AtomicInteger reloadCount = new AtomicInteger();
        final AtomicInteger loadAllCount = new AtomicInteger();
        CacheLoader<Object, Object> baseLoader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                loadCount.incrementAndGet();
                return new Object();
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                reloadCount.incrementAndGet();
                return Futures.immediateFuture((Object)new Object());
            }

            public Map<Object, Object> loadAll(Iterable<?> keys) {
                loadAllCount.incrementAndGet();
                return ImmutableMap.of();
            }
        };
        CacheLoaderTest.assertEquals((int)0, (int)loadCount.get());
        CacheLoaderTest.assertEquals((int)0, (int)reloadCount.get());
        CacheLoaderTest.assertEquals((int)0, (int)loadAllCount.get());
        baseLoader.load(new Object());
        ListenableFuture possiblyIgnoredError = baseLoader.reload(new Object(), new Object());
        baseLoader.loadAll((Iterable)ImmutableList.of((Object)new Object()));
        CacheLoaderTest.assertEquals((int)1, (int)loadCount.get());
        CacheLoaderTest.assertEquals((int)1, (int)reloadCount.get());
        CacheLoaderTest.assertEquals((int)1, (int)loadAllCount.get());
        QueuingExecutor executor = new QueuingExecutor();
        CacheLoader asyncReloader = CacheLoader.asyncReloading((CacheLoader)baseLoader, (Executor)executor);
        asyncReloader.load(new Object());
        ListenableFuture possiblyIgnoredError1 = asyncReloader.reload(new Object(), new Object());
        asyncReloader.loadAll((Iterable)ImmutableList.of((Object)new Object()));
        CacheLoaderTest.assertEquals((int)2, (int)loadCount.get());
        CacheLoaderTest.assertEquals((int)1, (int)reloadCount.get());
        CacheLoaderTest.assertEquals((int)2, (int)loadAllCount.get());
        executor.runNext();
        CacheLoaderTest.assertEquals((int)2, (int)loadCount.get());
        CacheLoaderTest.assertEquals((int)2, (int)reloadCount.get());
        CacheLoaderTest.assertEquals((int)2, (int)loadAllCount.get());
    }

    private static class QueuingExecutor
    implements Executor {
        private LinkedList<Runnable> tasks = Lists.newLinkedList();

        private QueuingExecutor() {
        }

        @Override
        public void execute(Runnable task) {
            this.tasks.add(task);
        }

        private void runNext() {
            this.tasks.removeFirst().run();
        }
    }
}

