/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderFactory;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.truth.Truth;
import java.lang.ref.WeakReference;
import java.util.Set;
import junit.framework.TestCase;

public class CacheReferencesTest
extends TestCase {
    private static final CacheLoader<Key, String> KEY_TO_STRING_LOADER = new CacheLoader<Key, String>(){

        public String load(Key key) {
            return key.toString();
        }
    };

    private CacheBuilderFactory factoryWithAllKeyStrengths() {
        return new CacheBuilderFactory().withKeyStrengths((Set<LocalCache.Strength>)ImmutableSet.of((Object)LocalCache.Strength.STRONG, (Object)LocalCache.Strength.WEAK)).withValueStrengths((Set<LocalCache.Strength>)ImmutableSet.of((Object)LocalCache.Strength.STRONG, (Object)LocalCache.Strength.WEAK, (Object)LocalCache.Strength.SOFT));
    }

    private Iterable<LoadingCache<Key, String>> caches() {
        CacheBuilderFactory factory = this.factoryWithAllKeyStrengths();
        return Iterables.transform(factory.buildAllPermutations(), (Function)new Function<CacheBuilder<Object, Object>, LoadingCache<Key, String>>(){

            public LoadingCache<Key, String> apply(CacheBuilder<Object, Object> builder) {
                return builder.build(KEY_TO_STRING_LOADER);
            }
        });
    }

    public void testContainsKeyAndValue() {
        for (LoadingCache<Key, String> cache : this.caches()) {
            Key key = new Key(1);
            String value = key.toString();
            CacheReferencesTest.assertSame((Object)value, (Object)cache.getUnchecked((Object)key));
            CacheReferencesTest.assertTrue((boolean)cache.asMap().containsKey(key));
            CacheReferencesTest.assertTrue((boolean)cache.asMap().containsValue(value));
            CacheReferencesTest.assertEquals((long)1L, (long)cache.size());
        }
    }

    public void testClear() {
        for (LoadingCache<Key, String> cache : this.caches()) {
            Key key = new Key(1);
            String value = key.toString();
            CacheReferencesTest.assertSame((Object)value, (Object)cache.getUnchecked((Object)key));
            CacheReferencesTest.assertFalse((boolean)cache.asMap().isEmpty());
            cache.invalidateAll();
            CacheReferencesTest.assertEquals((long)0L, (long)cache.size());
            CacheReferencesTest.assertTrue((boolean)cache.asMap().isEmpty());
            CacheReferencesTest.assertFalse((boolean)cache.asMap().containsKey(key));
            CacheReferencesTest.assertFalse((boolean)cache.asMap().containsValue(value));
        }
    }

    public void testKeySetEntrySetValues() {
        for (LoadingCache<Key, String> cache : this.caches()) {
            Key key1 = new Key(1);
            String value1 = key1.toString();
            Key key2 = new Key(2);
            String value2 = key2.toString();
            CacheReferencesTest.assertSame((Object)value1, (Object)cache.getUnchecked((Object)key1));
            CacheReferencesTest.assertSame((Object)value2, (Object)cache.getUnchecked((Object)key2));
            CacheReferencesTest.assertEquals((Object)ImmutableSet.of((Object)key1, (Object)key2), cache.asMap().keySet());
            Truth.assertThat(cache.asMap().values()).containsExactly(new Object[]{value1, value2});
            CacheReferencesTest.assertEquals((Object)ImmutableSet.of((Object)Maps.immutableEntry((Object)key1, (Object)value1), (Object)Maps.immutableEntry((Object)key2, (Object)value2)), cache.asMap().entrySet());
        }
    }

    public void testInvalidate() {
        for (LoadingCache<Key, String> cache : this.caches()) {
            Key key1 = new Key(1);
            String value1 = key1.toString();
            Key key2 = new Key(2);
            String value2 = key2.toString();
            CacheReferencesTest.assertSame((Object)value1, (Object)cache.getUnchecked((Object)key1));
            CacheReferencesTest.assertSame((Object)value2, (Object)cache.getUnchecked((Object)key2));
            cache.invalidate((Object)key1);
            CacheReferencesTest.assertFalse((boolean)cache.asMap().containsKey(key1));
            CacheReferencesTest.assertTrue((boolean)cache.asMap().containsKey(key2));
            CacheReferencesTest.assertEquals((long)1L, (long)cache.size());
            CacheReferencesTest.assertEquals((Object)ImmutableSet.of((Object)key2), cache.asMap().keySet());
            Truth.assertThat(cache.asMap().values()).contains((Object)value2);
            CacheReferencesTest.assertEquals((Object)ImmutableSet.of((Object)Maps.immutableEntry((Object)key2, (Object)value2)), cache.asMap().entrySet());
        }
    }

    private void assertCleanup(LoadingCache<Integer, String> cache, TestingRemovalListeners.CountingRemovalListener<Integer, String> removalListener) {
        long initialSize = cache.size();
        CacheReferencesTest.assertTrue((initialSize == 1L || initialSize == 2L ? 1 : 0) != 0);
        byte[] filler = new byte[1024];
        for (int i = 0; i < 500; ++i) {
            System.gc();
            CacheTesting.drainReferenceQueues(cache);
            if (cache.size() == 1L) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                filler = new byte[Math.max(filler.length, filler.length * 2)];
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        CacheTesting.processPendingNotifications(cache);
        CacheReferencesTest.assertEquals((long)1L, (long)cache.size());
        CacheReferencesTest.assertEquals((int)1, (int)removalListener.getCount());
    }

    static class Key {
        private final int value;
        private WeakReference<String> toString;

        Key(int value) {
            this.value = value;
        }

        public synchronized String toString() {
            String s;
            if (this.toString != null && (s = (String)this.toString.get()) != null) {
                return s;
            }
            s = Integer.toString(this.value);
            this.toString = new WeakReference<String>(s);
            return s;
        }
    }
}

