/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.CacheStats;
import junit.framework.TestCase;

public class CacheStatsTest
extends TestCase {
    public void testEmpty() {
        CacheStats stats = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
        CacheStatsTest.assertEquals((long)0L, (long)stats.requestCount());
        CacheStatsTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheStatsTest.assertEquals((Object)1.0, (Object)stats.hitRate());
        CacheStatsTest.assertEquals((long)0L, (long)stats.missCount());
        CacheStatsTest.assertEquals((Object)0.0, (Object)stats.missRate());
        CacheStatsTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheStatsTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheStatsTest.assertEquals((Object)0.0, (Object)stats.loadExceptionRate());
        CacheStatsTest.assertEquals((long)0L, (long)stats.loadCount());
        CacheStatsTest.assertEquals((long)0L, (long)stats.totalLoadTime());
        CacheStatsTest.assertEquals((Object)0.0, (Object)stats.averageLoadPenalty());
        CacheStatsTest.assertEquals((long)0L, (long)stats.evictionCount());
    }

    public void testSingle() {
        CacheStats stats = new CacheStats(11L, 13L, 17L, 19L, 23L, 27L);
        CacheStatsTest.assertEquals((long)24L, (long)stats.requestCount());
        CacheStatsTest.assertEquals((long)11L, (long)stats.hitCount());
        CacheStatsTest.assertEquals((Object)0.4583333333333333, (Object)stats.hitRate());
        CacheStatsTest.assertEquals((long)13L, (long)stats.missCount());
        CacheStatsTest.assertEquals((Object)0.5416666666666666, (Object)stats.missRate());
        CacheStatsTest.assertEquals((long)17L, (long)stats.loadSuccessCount());
        CacheStatsTest.assertEquals((long)19L, (long)stats.loadExceptionCount());
        CacheStatsTest.assertEquals((Object)0.5277777777777778, (Object)stats.loadExceptionRate());
        CacheStatsTest.assertEquals((long)36L, (long)stats.loadCount());
        CacheStatsTest.assertEquals((long)23L, (long)stats.totalLoadTime());
        CacheStatsTest.assertEquals((Object)0.6388888888888888, (Object)stats.averageLoadPenalty());
        CacheStatsTest.assertEquals((long)27L, (long)stats.evictionCount());
    }

    public void testMinus() {
        CacheStats one = new CacheStats(11L, 13L, 17L, 19L, 23L, 27L);
        CacheStats two = new CacheStats(53L, 47L, 43L, 41L, 37L, 31L);
        CacheStats diff = two.minus(one);
        CacheStatsTest.assertEquals((long)76L, (long)diff.requestCount());
        CacheStatsTest.assertEquals((long)42L, (long)diff.hitCount());
        CacheStatsTest.assertEquals((Object)0.5526315789473685, (Object)diff.hitRate());
        CacheStatsTest.assertEquals((long)34L, (long)diff.missCount());
        CacheStatsTest.assertEquals((Object)0.4473684210526316, (Object)diff.missRate());
        CacheStatsTest.assertEquals((long)26L, (long)diff.loadSuccessCount());
        CacheStatsTest.assertEquals((long)22L, (long)diff.loadExceptionCount());
        CacheStatsTest.assertEquals((Object)0.4583333333333333, (Object)diff.loadExceptionRate());
        CacheStatsTest.assertEquals((long)48L, (long)diff.loadCount());
        CacheStatsTest.assertEquals((long)14L, (long)diff.totalLoadTime());
        CacheStatsTest.assertEquals((Object)0.2916666666666667, (Object)diff.averageLoadPenalty());
        CacheStatsTest.assertEquals((long)4L, (long)diff.evictionCount());
        CacheStatsTest.assertEquals((Object)new CacheStats(0L, 0L, 0L, 0L, 0L, 0L), (Object)one.minus(two));
    }

    public void testPlus() {
        CacheStats one = new CacheStats(11L, 13L, 15L, 13L, 11L, 9L);
        CacheStats two = new CacheStats(53L, 47L, 41L, 39L, 37L, 35L);
        CacheStats sum = two.plus(one);
        CacheStatsTest.assertEquals((long)124L, (long)sum.requestCount());
        CacheStatsTest.assertEquals((long)64L, (long)sum.hitCount());
        CacheStatsTest.assertEquals((Object)0.5161290322580645, (Object)sum.hitRate());
        CacheStatsTest.assertEquals((long)60L, (long)sum.missCount());
        CacheStatsTest.assertEquals((Object)0.4838709677419355, (Object)sum.missRate());
        CacheStatsTest.assertEquals((long)56L, (long)sum.loadSuccessCount());
        CacheStatsTest.assertEquals((long)52L, (long)sum.loadExceptionCount());
        CacheStatsTest.assertEquals((Object)0.48148148148148145, (Object)sum.loadExceptionRate());
        CacheStatsTest.assertEquals((long)108L, (long)sum.loadCount());
        CacheStatsTest.assertEquals((long)48L, (long)sum.totalLoadTime());
        CacheStatsTest.assertEquals((Object)0.4444444444444444, (Object)sum.averageLoadPenalty());
        CacheStatsTest.assertEquals((long)44L, (long)sum.evictionCount());
        CacheStatsTest.assertEquals((Object)sum, (Object)one.plus(two));
    }
}

