/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.truth.Truth;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import junit.framework.TestCase;

public class LocalCacheMapComputeTest
extends TestCase {
    final int count = 10000;
    final String delimiter = "-";
    final String key = "key";
    Cache<String, String> cache;

    private static void doParallelCacheOp(int count, IntConsumer consumer) {
        IntStream.range(0, count).parallel().forEach(consumer);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(500000L, TimeUnit.MILLISECONDS).maximumSize(10000L).build();
    }

    public void testComputeIfAbsent() {
        LocalCacheMapComputeTest.doParallelCacheOp(10000, n -> this.cache.asMap().computeIfAbsent("key", k -> "value" + n));
        LocalCacheMapComputeTest.assertEquals((long)1L, (long)this.cache.size());
    }

    public void testComputeIfPresent() {
        this.cache.put((Object)"key", (Object)"1");
        LocalCacheMapComputeTest.doParallelCacheOp(10000, n -> this.cache.asMap().computeIfPresent("key", (k, v) -> v + "-" + n));
        LocalCacheMapComputeTest.assertEquals((long)1L, (long)this.cache.size());
        Truth.assertThat((Object[])((String)this.cache.getIfPresent((Object)"key")).split("-")).hasLength(10001);
    }

    public void testUpdates() {
        this.cache.put((Object)"key", (Object)"1");
        LocalCacheMapComputeTest.doParallelCacheOp(10000, n -> this.cache.asMap().compute("key", (k, v) -> n % 2 == 0 ? v + "-" + n : null));
        LocalCacheMapComputeTest.assertTrue((1L >= this.cache.size() ? 1 : 0) != 0);
    }

    public void testCompute() {
        this.cache.put((Object)"key", (Object)"1");
        LocalCacheMapComputeTest.doParallelCacheOp(10000, n -> this.cache.asMap().compute("key", (k, v) -> null));
        LocalCacheMapComputeTest.assertEquals((long)0L, (long)this.cache.size());
    }
}

