/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class LocalLoadingCacheTest
extends TestCase {
    private static <K, V> LocalCache.LocalLoadingCache<K, V> makeCache(CacheBuilder<K, V> builder, CacheLoader<? super K, V> loader) {
        return new LocalCache.LocalLoadingCache(builder, loader);
    }

    private CacheBuilder<Object, Object> createCacheBuilder() {
        return CacheBuilder.newBuilder().recordStats();
    }

    public void testComputingFunction() {
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object from) {
                return new Object();
            }
        };
        LocalCache.LocalLoadingCache<Object, Object> cache = LocalLoadingCacheTest.makeCache(this.createCacheBuilder(), loader);
        LocalLoadingCacheTest.assertSame((Object)loader, (Object)cache.localCache.defaultLoader);
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        tester.testAllPublicInstanceMethods(LocalLoadingCacheTest.makeCache(this.createCacheBuilder(), loader));
    }

    public void testStats() {
        CacheBuilder builder = this.createCacheBuilder().concurrencyLevel(1).maximumSize(2L);
        LocalCache.LocalLoadingCache cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object one = new Object();
        cache.getUnchecked(one);
        CacheStats stats = cache.stats();
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.requestCount());
        LocalLoadingCacheTest.assertEquals((long)0L, (long)stats.hitCount());
        LocalLoadingCacheTest.assertEquals((Object)0.0, (Object)stats.hitRate());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.missCount());
        LocalLoadingCacheTest.assertEquals((Object)1.0, (Object)stats.missRate());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.loadCount());
        long totalLoadTime = stats.totalLoadTime();
        LocalLoadingCacheTest.assertTrue((totalLoadTime >= 0L ? 1 : 0) != 0);
        LocalLoadingCacheTest.assertTrue((stats.averageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
        LocalLoadingCacheTest.assertEquals((long)0L, (long)stats.evictionCount());
        cache.getUnchecked(one);
        stats = cache.stats();
        LocalLoadingCacheTest.assertEquals((long)2L, (long)stats.requestCount());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.hitCount());
        LocalLoadingCacheTest.assertEquals((Object)0.5, (Object)stats.hitRate());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.missCount());
        LocalLoadingCacheTest.assertEquals((Object)0.5, (Object)stats.missRate());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.loadCount());
        LocalLoadingCacheTest.assertEquals((long)0L, (long)stats.evictionCount());
        Object two = new Object();
        cache.getUnchecked(two);
        stats = cache.stats();
        LocalLoadingCacheTest.assertEquals((long)3L, (long)stats.requestCount());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.hitCount());
        LocalLoadingCacheTest.assertEquals((Object)0.3333333333333333, (Object)stats.hitRate());
        LocalLoadingCacheTest.assertEquals((long)2L, (long)stats.missCount());
        LocalLoadingCacheTest.assertEquals((Object)0.6666666666666666, (Object)stats.missRate());
        LocalLoadingCacheTest.assertEquals((long)2L, (long)stats.loadCount());
        LocalLoadingCacheTest.assertTrue((stats.totalLoadTime() >= totalLoadTime ? 1 : 0) != 0);
        totalLoadTime = stats.totalLoadTime();
        LocalLoadingCacheTest.assertTrue((stats.averageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
        LocalLoadingCacheTest.assertEquals((long)0L, (long)stats.evictionCount());
        Object three = new Object();
        cache.getUnchecked(three);
        stats = cache.stats();
        LocalLoadingCacheTest.assertEquals((long)4L, (long)stats.requestCount());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.hitCount());
        LocalLoadingCacheTest.assertEquals((Object)0.25, (Object)stats.hitRate());
        LocalLoadingCacheTest.assertEquals((long)3L, (long)stats.missCount());
        LocalLoadingCacheTest.assertEquals((Object)0.75, (Object)stats.missRate());
        LocalLoadingCacheTest.assertEquals((long)3L, (long)stats.loadCount());
        LocalLoadingCacheTest.assertTrue((stats.totalLoadTime() >= totalLoadTime ? 1 : 0) != 0);
        totalLoadTime = stats.totalLoadTime();
        LocalLoadingCacheTest.assertTrue((stats.averageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
        LocalLoadingCacheTest.assertEquals((long)1L, (long)stats.evictionCount());
    }

    public void testStatsNoops() {
        CacheBuilder builder = this.createCacheBuilder().concurrencyLevel(1);
        LocalCache.LocalLoadingCache cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalCache map = cache.localCache;
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object one = new Object();
        LocalLoadingCacheTest.assertNull((Object)map.put(one, one));
        LocalLoadingCacheTest.assertSame((Object)one, map.get(one));
        LocalLoadingCacheTest.assertTrue((boolean)map.containsKey(one));
        LocalLoadingCacheTest.assertTrue((boolean)map.containsValue(one));
        Object two = new Object();
        LocalLoadingCacheTest.assertSame((Object)one, (Object)map.replace(one, two));
        LocalLoadingCacheTest.assertTrue((boolean)map.containsKey(one));
        LocalLoadingCacheTest.assertFalse((boolean)map.containsValue(one));
        Object three = new Object();
        LocalLoadingCacheTest.assertTrue((boolean)map.replace(one, two, three));
        LocalLoadingCacheTest.assertTrue((boolean)map.remove(one, three));
        LocalLoadingCacheTest.assertFalse((boolean)map.containsKey(one));
        LocalLoadingCacheTest.assertFalse((boolean)map.containsValue(one));
        LocalLoadingCacheTest.assertNull((Object)map.putIfAbsent(two, three));
        LocalLoadingCacheTest.assertSame((Object)three, map.remove(two));
        LocalLoadingCacheTest.assertNull((Object)map.put(three, one));
        LocalLoadingCacheTest.assertNull((Object)map.put(one, two));
        Truth.assertThat((Map)map).containsEntry(three, one);
        Truth.assertThat((Map)map).containsEntry(one, two);
        map.clear();
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
    }

    public void testNoStats() {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(2L);
        LocalCache.LocalLoadingCache cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object one = new Object();
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object two = new Object();
        cache.getUnchecked(two);
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object three = new Object();
        cache.getUnchecked(three);
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
    }

    public void testRecordStats() {
        CacheBuilder builder = this.createCacheBuilder().recordStats().concurrencyLevel(1).maximumSize(2L);
        LocalCache.LocalLoadingCache cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalLoadingCacheTest.assertEquals((long)0L, (long)cache.stats().hitCount());
        LocalLoadingCacheTest.assertEquals((long)0L, (long)cache.stats().missCount());
        Object one = new Object();
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((long)0L, (long)cache.stats().hitCount());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)cache.stats().missCount());
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((long)1L, (long)cache.stats().hitCount());
        LocalLoadingCacheTest.assertEquals((long)1L, (long)cache.stats().missCount());
        Object two = new Object();
        cache.getUnchecked(two);
        LocalLoadingCacheTest.assertEquals((long)1L, (long)cache.stats().hitCount());
        LocalLoadingCacheTest.assertEquals((long)2L, (long)cache.stats().missCount());
        Object three = new Object();
        cache.getUnchecked(three);
        LocalLoadingCacheTest.assertEquals((long)1L, (long)cache.stats().hitCount());
        LocalLoadingCacheTest.assertEquals((long)3L, (long)cache.stats().missCount());
    }

    public void testAsMap() {
        CacheBuilder<Object, Object> builder = this.createCacheBuilder();
        LocalCache.LocalLoadingCache<Object, Object> cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalLoadingCacheTest.assertEquals((Object)CacheBuilder.EMPTY_STATS, (Object)cache.stats());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        ConcurrentMap map = cache.asMap();
        LocalLoadingCacheTest.assertNull((Object)map.put(one, two));
        LocalLoadingCacheTest.assertSame((Object)two, map.get(one));
        map.putAll(ImmutableMap.of((Object)two, (Object)three));
        LocalLoadingCacheTest.assertSame((Object)three, map.get(two));
        LocalLoadingCacheTest.assertSame((Object)two, (Object)map.putIfAbsent(one, three));
        LocalLoadingCacheTest.assertSame((Object)two, map.get(one));
        LocalLoadingCacheTest.assertNull((Object)map.putIfAbsent(three, one));
        LocalLoadingCacheTest.assertSame((Object)one, map.get(three));
        LocalLoadingCacheTest.assertSame((Object)two, (Object)map.replace(one, three));
        LocalLoadingCacheTest.assertSame((Object)three, map.get(one));
        LocalLoadingCacheTest.assertFalse((boolean)map.replace(one, two, three));
        LocalLoadingCacheTest.assertSame((Object)three, map.get(one));
        LocalLoadingCacheTest.assertTrue((boolean)map.replace(one, three, two));
        LocalLoadingCacheTest.assertSame((Object)two, map.get(one));
        LocalLoadingCacheTest.assertEquals((int)3, (int)map.size());
        map.clear();
        LocalLoadingCacheTest.assertTrue((boolean)map.isEmpty());
        LocalLoadingCacheTest.assertEquals((int)0, (int)map.size());
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((int)1, (int)map.size());
        LocalLoadingCacheTest.assertSame((Object)one, map.get(one));
        LocalLoadingCacheTest.assertTrue((boolean)map.containsKey(one));
        LocalLoadingCacheTest.assertTrue((boolean)map.containsValue(one));
        LocalLoadingCacheTest.assertSame((Object)one, map.remove(one));
        LocalLoadingCacheTest.assertEquals((int)0, (int)map.size());
        cache.getUnchecked(one);
        LocalLoadingCacheTest.assertEquals((int)1, (int)map.size());
        LocalLoadingCacheTest.assertFalse((boolean)map.remove(one, two));
        LocalLoadingCacheTest.assertTrue((boolean)map.remove(one, one));
        LocalLoadingCacheTest.assertEquals((int)0, (int)map.size());
        cache.getUnchecked(one);
        ImmutableMap newMap = ImmutableMap.of((Object)one, (Object)one);
        LocalLoadingCacheTest.assertEquals((Object)newMap, (Object)map);
        LocalLoadingCacheTest.assertEquals(newMap.entrySet(), map.entrySet());
        LocalLoadingCacheTest.assertEquals(newMap.keySet(), map.keySet());
        ImmutableSet expectedValues = ImmutableSet.of((Object)one);
        ImmutableSet actualValues = ImmutableSet.copyOf(map.values());
        LocalLoadingCacheTest.assertEquals((Object)expectedValues, (Object)actualValues);
    }

    public void testAsMapRecency() {
        CacheBuilder builder = this.createCacheBuilder().concurrencyLevel(1).maximumSize(315L);
        LocalCache.LocalLoadingCache cache = LocalLoadingCacheTest.makeCache(builder, TestingCacheLoaders.identityLoader());
        LocalCache.Segment segment = cache.localCache.segments[0];
        ConcurrentMap map = cache.asMap();
        Object one = new Object();
        LocalLoadingCacheTest.assertSame((Object)one, (Object)cache.getUnchecked(one));
        LocalLoadingCacheTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
        LocalLoadingCacheTest.assertSame((Object)one, map.get(one));
        LocalLoadingCacheTest.assertSame((Object)one, (Object)((LocalCache.ReferenceEntry)segment.recencyQueue.peek()).getKey());
        LocalLoadingCacheTest.assertSame((Object)one, (Object)cache.getUnchecked(one));
        LocalLoadingCacheTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
    }

    public void testRecursiveComputation() throws InterruptedException {
        final AtomicReference<LoadingCache> cacheRef = new AtomicReference<LoadingCache>();
        CacheLoader recursiveLoader = new CacheLoader<Integer, String>(){

            public String load(Integer key) {
                if (key > 0) {
                    return key + ", " + (String)((LoadingCache)cacheRef.get()).getUnchecked((Object)(key - 1));
                }
                return "0";
            }
        };
        LoadingCache recursiveCache = CacheBuilder.newBuilder().weakKeys().weakValues().build(recursiveLoader);
        cacheRef.set(recursiveCache);
        LocalLoadingCacheTest.assertEquals((String)"3, 2, 1, 0", (String)((String)recursiveCache.getUnchecked((Object)3)));
        recursiveLoader = new CacheLoader<Integer, String>(){

            public String load(Integer key) {
                return (String)((LoadingCache)cacheRef.get()).getUnchecked((Object)key);
            }
        };
        recursiveCache = CacheBuilder.newBuilder().weakKeys().weakValues().build(recursiveLoader);
        cacheRef.set(recursiveCache);
        final CountDownLatch doneSignal = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ((LoadingCache)cacheRef.get()).getUnchecked((Object)3);
                }
                finally {
                    doneSignal.countDown();
                }
            }
        };
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        thread.start();
        boolean done = doneSignal.await(1L, TimeUnit.SECONDS);
        if (!done) {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement trace : thread.getStackTrace()) {
                builder.append("\tat ").append(trace).append('\n');
            }
            LocalLoadingCacheTest.fail((String)builder.toString());
        }
    }
}

