/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LocalCache;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SegmentBenchmark {
    @Param(value={"16", "32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"})
    int capacity;
    private LocalCache.Segment<Object, Object> segment;

    @BeforeExperiment
    void setUp() {
        LocalCache cache = new LocalCache(CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(this.capacity), null);
        Preconditions.checkState((cache.segments.length == 1 ? 1 : 0) != 0);
        this.segment = cache.segments[0];
        Preconditions.checkState((this.segment.table.length() == this.capacity ? 1 : 0) != 0);
        for (int i = 0; i < this.segment.threshold; ++i) {
            cache.put(new Object(), new Object());
        }
        Preconditions.checkState((this.segment.table.length() == this.capacity ? 1 : 0) != 0);
    }

    @Benchmark
    int time(int reps) {
        int dummy = 0;
        AtomicReferenceArray oldTable = this.segment.table;
        for (int i = 0; i < reps; ++i) {
            this.segment.expand();
            this.segment.table = oldTable;
            dummy += this.segment.count;
        }
        return dummy;
    }
}

