/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import junit.framework.TestCase;

@GwtCompatible
public abstract class AbstractImmutableTableTest
extends TestCase {
    abstract Iterable<ImmutableTable<Character, Integer, String>> getTestInstances();

    public final void testClear() {
        for (Table table : this.getTestInstances()) {
            try {
                table.clear();
                AbstractImmutableTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public final void testPut() {
        for (Table table : this.getTestInstances()) {
            try {
                table.put((Object)Character.valueOf('a'), (Object)1, (Object)"blah");
                AbstractImmutableTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public final void testPutAll() {
        for (Table table : this.getTestInstances()) {
            try {
                table.putAll((Table)ImmutableTable.of((Object)Character.valueOf('a'), (Object)1, (Object)"blah"));
                AbstractImmutableTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public final void testRemove() {
        for (Table table : this.getTestInstances()) {
            try {
                table.remove((Object)Character.valueOf('a'), (Object)1);
                AbstractImmutableTableTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public final void testConsistentToString() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            AbstractImmutableTableTest.assertEquals((String)testInstance.rowMap().toString(), (String)testInstance.toString());
        }
    }

    public final void testConsistentHashCode() {
        for (ImmutableTable<Character, Integer, String> testInstance : this.getTestInstances()) {
            AbstractImmutableTableTest.assertEquals((int)testInstance.cellSet().hashCode(), (int)testInstance.hashCode());
        }
    }
}

