/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.MapInterfaceTest;
import java.util.Collection;
import java.util.Map;

@GwtCompatible
public abstract class AbstractMultimapAsMapImplementsMapTest
extends MapInterfaceTest<String, Collection<Integer>> {
    public AbstractMultimapAsMapImplementsMapTest(boolean modifiable, boolean allowsNulls, boolean supportsIteratorRemove) {
        super(allowsNulls, allowsNulls, false, modifiable, modifiable, supportsIteratorRemove);
    }

    protected void populate(Multimap<String, Integer> multimap) {
        multimap.put((Object)"one", (Object)1);
        multimap.put((Object)"two", (Object)2);
        multimap.put((Object)"two", (Object)22);
        multimap.put((Object)"three", (Object)3);
        multimap.put((Object)"three", (Object)33);
        multimap.put((Object)"three", (Object)333);
    }

    protected String getKeyNotInPopulatedMap() throws UnsupportedOperationException {
        return "zero";
    }

    protected Collection<Integer> getValueNotInPopulatedMap() throws UnsupportedOperationException {
        return Lists.newArrayList((Object[])new Integer[]{0});
    }

    public void testRemove() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String keyToRemove = (String)map.keySet().iterator().next();
        if (this.supportsRemove) {
            int initialSize = map.size();
            map.get(keyToRemove);
            map.remove(keyToRemove);
            AbstractMultimapAsMapImplementsMapTest.assertFalse((boolean)map.containsKey(keyToRemove));
            AbstractMultimapAsMapImplementsMapTest.assertEquals((int)(initialSize - 1), (int)map.size());
        } else {
            try {
                map.remove(keyToRemove);
                AbstractMultimapAsMapImplementsMapTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }
}

