/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public abstract class AbstractTableReadTest
extends TestCase {
    protected Table<String, Integer, Character> table;

    protected abstract Table<String, Integer, Character> create(Object ... var1);

    protected void assertSize(int expectedSize) {
        AbstractTableReadTest.assertEquals((int)expectedSize, (int)this.table.size());
    }

    public void setUp() throws Exception {
        super.setUp();
        this.table = this.create(new Object[0]);
    }

    public void testContains() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertTrue((boolean)this.table.contains((Object)"foo", (Object)1));
        AbstractTableReadTest.assertTrue((boolean)this.table.contains((Object)"bar", (Object)1));
        AbstractTableReadTest.assertTrue((boolean)this.table.contains((Object)"foo", (Object)3));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains((Object)"foo", (Object)2));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains((Object)"bar", (Object)3));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains((Object)"cat", (Object)1));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains((Object)"foo", null));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains(null, (Object)1));
        AbstractTableReadTest.assertFalse((boolean)this.table.contains(null, null));
    }

    public void testContainsRow() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsRow((Object)"foo"));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsRow((Object)"bar"));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsRow((Object)"cat"));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsRow(null));
    }

    public void testContainsColumn() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsColumn((Object)1));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsColumn((Object)3));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsColumn((Object)2));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsColumn(null));
    }

    public void testContainsValue() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('a')));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('b')));
        AbstractTableReadTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('c')));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsValue((Object)Character.valueOf('x')));
        AbstractTableReadTest.assertFalse((boolean)this.table.containsValue(null));
    }

    public void testGet() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertEquals((Object)Character.valueOf('a'), (Object)this.table.get((Object)"foo", (Object)1));
        AbstractTableReadTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.get((Object)"bar", (Object)1));
        AbstractTableReadTest.assertEquals((Object)Character.valueOf('c'), (Object)this.table.get((Object)"foo", (Object)3));
        AbstractTableReadTest.assertNull((Object)this.table.get((Object)"foo", (Object)2));
        AbstractTableReadTest.assertNull((Object)this.table.get((Object)"bar", (Object)3));
        AbstractTableReadTest.assertNull((Object)this.table.get((Object)"cat", (Object)1));
        AbstractTableReadTest.assertNull((Object)this.table.get((Object)"foo", null));
        AbstractTableReadTest.assertNull((Object)this.table.get(null, (Object)1));
        AbstractTableReadTest.assertNull((Object)this.table.get(null, null));
    }

    public void testIsEmpty() {
        AbstractTableReadTest.assertTrue((boolean)this.table.isEmpty());
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertFalse((boolean)this.table.isEmpty());
    }

    public void testSize() {
        this.assertSize(0);
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        this.assertSize(3);
    }

    public void testEquals() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable hashCopy = HashBasedTable.create(this.table);
        Table<String, Integer, Character> reordered = this.create("foo", 3, Character.valueOf('c'), "foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'));
        Table<String, Integer, Character> smaller = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'));
        Table<String, Integer, Character> swapOuter = this.create("bar", 1, Character.valueOf('a'), "foo", 1, Character.valueOf('b'), "bar", 3, Character.valueOf('c'));
        Table<String, Integer, Character> swapValues = this.create("foo", 1, Character.valueOf('c'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('a'));
        new EqualsTester().addEqualityGroup(new Object[]{this.table, hashCopy, reordered}).addEqualityGroup(new Object[]{smaller}).addEqualityGroup(new Object[]{swapOuter}).addEqualityGroup(new Object[]{swapValues}).testEquals();
    }

    public void testHashCode() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        int expected = Objects.hashCode((Object[])new Object[]{"foo", 1, Character.valueOf('a')}) + Objects.hashCode((Object[])new Object[]{"bar", 1, Character.valueOf('b')}) + Objects.hashCode((Object[])new Object[]{"foo", 3, Character.valueOf('c')});
        AbstractTableReadTest.assertEquals((int)expected, (int)this.table.hashCode());
    }

    public void testToStringSize1() {
        this.table = this.create("foo", 1, Character.valueOf('a'));
        AbstractTableReadTest.assertEquals((String)"{foo={1=a}}", (String)this.table.toString());
    }

    public void testRow() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a'), (Object)3, (Object)Character.valueOf('c')), (Object)this.table.row((Object)"foo"));
    }

    public void testRowNull() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        try {
            this.table.row(null);
            AbstractTableReadTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testColumn() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        AbstractTableReadTest.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)Character.valueOf('a'), (Object)"bar", (Object)Character.valueOf('b')), (Object)this.table.column((Object)1));
    }

    public void testColumnNull() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        try {
            this.table.column(null);
            AbstractTableReadTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testColumnSetPartialOverlap() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'), "bar", 3, Character.valueOf('d'));
        Truth.assertThat((Iterable)this.table.columnKeySet()).containsExactly(new Object[]{1, 2, 3});
    }

    @GwtIncompatible
    public void testNullPointerInstance() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'), "bar", 3, Character.valueOf('d'));
        new NullPointerTester().testAllPublicInstanceMethods(this.table);
    }
}

