/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.BiMap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.TreeRangeSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class BenchmarkHelpers {
    BenchmarkHelpers() {
    }

    public static enum ListSizeDistribution {
        UNIFORM_0_TO_2(0, 2),
        UNIFORM_0_TO_9(0, 9),
        ALWAYS_0(0, 0),
        ALWAYS_10(10, 10);

        final int min;
        final int max;

        private ListSizeDistribution(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int chooseSize(Random random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }
    }

    public static enum Value {
        INSTANCE;

    }

    public static enum InternerImpl implements InternerImplEnum
    {
        WeakInternerImpl{

            @Override
            public <E> Interner<E> create(Collection<E> contents) {
                Interner interner = Interners.newWeakInterner();
                for (E e : contents) {
                    interner.intern(e);
                }
                return interner;
            }
        }
        ,
        StrongInternerImpl{

            @Override
            public <E> Interner<E> create(Collection<E> contents) {
                Interner interner = Interners.newStrongInterner();
                for (E e : contents) {
                    interner.intern(e);
                }
                return interner;
            }
        };

    }

    static enum TableImpl {
        HashBasedTableImpl{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                return HashBasedTable.create(contents);
            }
        }
        ,
        TreeBasedTableImpl{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                TreeBasedTable table = TreeBasedTable.create();
                table.putAll(contents);
                return table;
            }
        }
        ,
        ArrayTableImpl{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                if (contents.isEmpty()) {
                    return ImmutableTable.of();
                }
                return ArrayTable.create(contents);
            }
        }
        ,
        ImmutableTableImpl{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                return ImmutableTable.copyOf(contents);
            }
        };


        abstract <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> var1);
    }

    static enum QueueImpl implements CollectionsImplEnum
    {
        MinMaxPriorityQueueImpl{

            public <E extends Comparable<E>> Queue<E> create(Collection<E> contents) {
                return MinMaxPriorityQueue.create(contents);
            }
        };

    }

    static enum SortedMultisetImpl implements CollectionsImplEnum
    {
        TreeMultisetImpl{

            public <E extends Comparable<E>> SortedMultiset<E> create(Collection<E> contents) {
                return TreeMultiset.create(contents);
            }
        }
        ,
        ImmutableSortedMultisetImpl{

            public <E extends Comparable<E>> SortedMultiset<E> create(Collection<E> contents) {
                return ImmutableSortedMultiset.copyOf(contents);
            }
        };

    }

    static enum MultisetImpl implements CollectionsImplEnum
    {
        HashMultisetImpl{

            public <E extends Comparable<E>> Multiset<E> create(Collection<E> contents) {
                return HashMultiset.create(contents);
            }
        }
        ,
        LinkedHashMultisetImpl{

            public <E extends Comparable<E>> Multiset<E> create(Collection<E> contents) {
                return LinkedHashMultiset.create(contents);
            }
        }
        ,
        ConcurrentHashMultisetImpl{

            public <E extends Comparable<E>> Multiset<E> create(Collection<E> contents) {
                return ConcurrentHashMultiset.create(contents);
            }
        }
        ,
        ImmutableMultisetImpl{

            public <E extends Comparable<E>> Multiset<E> create(Collection<E> contents) {
                return ImmutableMultiset.copyOf(contents);
            }
        };

    }

    static enum BiMapImpl implements MapsImplEnum
    {
        HashBiMapImpl{

            @Override
            public <K extends Comparable<K>, V> BiMap<K, V> create(Map<K, V> map) {
                return HashBiMap.create(map);
            }
        }
        ,
        ImmutableBiMapImpl{

            @Override
            public <K extends Comparable<K>, V> BiMap<K, V> create(Map<K, V> map) {
                return ImmutableBiMap.copyOf(map);
            }
        };


        public abstract <K extends Comparable<K>, V> BiMap<K, V> create(Map<K, V> var1);
    }

    static enum SortedMapImpl implements MapsImplEnum
    {
        TreeMapImpl{

            public <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                TreeMap result = Maps.newTreeMap();
                result.putAll(map);
                return result;
            }
        }
        ,
        ConcurrentSkipListImpl{

            public <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                return new ConcurrentSkipListMap<K, V>(map);
            }
        }
        ,
        ImmutableSortedMapImpl{

            public <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                return ImmutableSortedMap.copyOf(map);
            }
        };

    }

    public static enum MapImpl implements MapsImplEnum
    {
        HashMapImpl{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                return Maps.newHashMap(map);
            }
        }
        ,
        LinkedHashMapImpl{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                return Maps.newLinkedHashMap(map);
            }
        }
        ,
        ConcurrentHashMapImpl{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                return new ConcurrentHashMap<K, V>(map);
            }
        }
        ,
        ImmutableMapImpl{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                return ImmutableMap.copyOf(map);
            }
        }
        ,
        MapMakerStrongKeysStrongValues{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().keyEquivalence(Equivalence.equals()).makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerStrongKeysWeakValues{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakValues().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerWeakKeysStrongValues{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakKeys().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerWeakKeysWeakValues{

            @Override
            public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakKeys().weakValues().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        };

    }

    public static enum SetMultimapImpl {
        HashMultimapImpl{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return HashMultimap.create(contents);
            }
        }
        ,
        LinkedHashMultimapImpl{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return LinkedHashMultimap.create(contents);
            }
        }
        ,
        TreeMultimapImpl{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return TreeMultimap.create(contents);
            }
        }
        ,
        ImmutableSetMultimapImpl{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return ImmutableSetMultimap.copyOf(contents);
            }
        };


        abstract <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> var1);
    }

    public static enum RangeSetImpl {
        TreeRangeSetImpl{

            @Override
            <K extends Comparable<K>> RangeSet<K> create(RangeSet<K> contents) {
                return TreeRangeSet.create(contents);
            }
        }
        ,
        ImmutableRangeSetImpl{

            @Override
            <K extends Comparable<K>> RangeSet<K> create(RangeSet<K> contents) {
                return ImmutableRangeSet.copyOf(contents);
            }
        };


        abstract <K extends Comparable<K>> RangeSet<K> create(RangeSet<K> var1);
    }

    public static enum ListMultimapImpl {
        ArrayListMultimapImpl{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return ArrayListMultimap.create(contents);
            }
        }
        ,
        LinkedListMultimapImpl{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return LinkedListMultimap.create(contents);
            }
        }
        ,
        ImmutableListMultimapImpl{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return ImmutableListMultimap.copyOf(contents);
            }
        };


        abstract <K, V> ListMultimap<K, V> create(Multimap<K, V> var1);
    }

    public static enum SetImpl implements CollectionsImplEnum
    {
        HashSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new HashSet<E>(contents);
            }
        }
        ,
        LinkedHashSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new LinkedHashSet<E>(contents);
            }
        }
        ,
        TreeSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new TreeSet<E>(contents);
            }
        }
        ,
        UnmodifiableSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return Collections.unmodifiableSet(new HashSet<E>(contents));
            }
        }
        ,
        SynchronizedSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return Collections.synchronizedSet(new HashSet<E>(contents));
            }
        }
        ,
        ImmutableSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return ImmutableSet.copyOf(contents);
            }
        }
        ,
        ImmutableSortedSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return ImmutableSortedSet.copyOf(contents);
            }
        }
        ,
        ContiguousSetImpl{

            public <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return ContiguousSet.copyOf(contents);
            }
        };

    }

    public static interface InternerImplEnum {
        public <E> Interner<E> create(Collection<E> var1);

        public String name();
    }

    public static interface MapsImplEnum {
        public <K extends Comparable<K>, V> Map<K, V> create(Map<K, V> var1);

        public String name();
    }

    public static interface CollectionsImplEnum {
        public <E extends Comparable<E>> Collection<E> create(Collection<E> var1);

        public String name();
    }
}

