/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.SpliteratorTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

@GwtCompatible
public class CollectSpliteratorsTest
extends TestCase {
    public void testMap() {
        SpliteratorTester.of(() -> CollectSpliterators.map(Arrays.spliterator(new String[]{"a", "b", "c", "d", "e"}), Ascii::toUpperCase)).expect(new Object[]{"A", "B", "C", "D", "E"});
    }

    public void testFlatMap() {
        SpliteratorTester.of(() -> CollectSpliterators.flatMap(Arrays.spliterator(new String[]{"abc", "", "de", "f", "g", ""}), str -> Lists.charactersOf((String)str).spliterator(), (int)321, (long)7L)).expect(new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g')});
    }

    public void testMultisetsSpliterator() {
        TreeMultiset multiset = TreeMultiset.create();
        multiset.add((Object)"a", 3);
        multiset.add((Object)"b", 1);
        multiset.add((Object)"c", 2);
        ArrayList actualValues = Lists.newArrayList();
        multiset.spliterator().forEachRemaining(actualValues::add);
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "a", "a", "b", "c", "c"}).inOrder();
    }
}

